/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.schema.DbColumn;
import inform.agent.db.schema.DbScheme;
import inform.agent.db.schema.DbTable;
import inform.agent.mtd.MetadataNodeReader;
import java.util.Map;

public class GetNonImportedFields
extends Request {
    public static final int TAG_DESCR_FIELD_HEADER = 3;
    public static final int TAG_DESCR_FIELD_NAME = 4;

    public GetNonImportedFields(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedWriter out;
        ByteArrayOutputStream result;
        block19: {
            result = new ByteArrayOutputStream();
            out = new TaggedWriter(result);
            TableDescriptor table = TableDescriptor.get(this.rq.nodeId);
            boolean is_external = table.getKind() == TableDescriptor.Kind.EXTERNAL;
            DatabaseDescriptor database = table.getDatabaseDescriptor();
            try (DatabaseConnection connection = database.connect(this, "rq:GetNonImportedFields");){
                Map<String, DbColumn> _columns;
                DbScheme scheme = connection.openScheme();
                DbTable _table = scheme.getTable(null, table.getRawName());
                Map<String, DbColumn> map = _columns = _table != null ? _table.getColumns(null) : null;
                if (_columns == null) break block19;
                try (DatabaseConnection meta_connection = DatabaseDescriptor.getMetabase().connect(this, "rq:GetNonImportedFields");){
                    StringBuilder sql = new StringBuilder();
                    sql.append("SELECT ").append("RAW_CONTENT").append(" FROM ").append(MetadataNodeReader.mtdTreeTableName).append(" WHERE ").append("ID").append(" = ").append(this.rq.nodeId);
                    try (PreparedStatement statement = meta_connection.prepareStatement(sql.toString());
                         ResultSet resultSet = statement.executeQuery(null);){
                        while (resultSet.next()) {
                            TaggedReader reader = new TaggedReader(resultSet.getBlobStream(1));
                            while (reader.getNextTag() != 0) {
                                block4 : switch (reader.getCurrentTag()) {
                                    case 11: {
                                        String raw_name = reader.getAnsi();
                                        for (String c_name : _columns.keySet()) {
                                            if (raw_name.compareToIgnoreCase(c_name) != 0) continue;
                                            _columns.remove(c_name);
                                            break block4;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                for (Map.Entry<String, DbColumn> e : _columns.entrySet()) {
                    DbColumn c = e.getValue();
                    if (!is_external && c.name().compareToIgnoreCase("ID") == 0) continue;
                    ByteArrayOutputStream _out = new ByteArrayOutputStream();
                    LittleEndianDataOutputStream los = new LittleEndianDataOutputStream(_out);
                    los.writeInt(c.getType().getTypeId());
                    los.writeInt(c.getSize());
                    los.writeInt(c.isNullable() ? 0 : 1);
                    los.writeInt(0);
                    los.flush();
                    out.putRaw(3, _out.toByteArray());
                    out.putAnsi(4, c.name());
                }
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

