/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.request;

import inform.adt.LittleEndian;
import inform.adt.collections.DoubleList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.request.LinksLookup;
import inform.agent.db.utils.PackedRowContent;
import inform.agent.mtd.nodes.Node;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;

public class MultiLinksLookup
extends Request {
    public MultiLinksLookup(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(result);
        int links_table = in.getInt(0);
        double l_table_id = in.getDouble(2);
        double r_table_id = in.getDouble(4);
        this.checkAccess((Node)this.getNode(l_table_id), 0x4000000);
        TableDescriptor lTableDesc = new TableDescriptor(l_table_id, true);
        StringBuilder sql = new StringBuilder();
        sql.append("select L0.RECORD_ID,L0.LNK_RECORD_ID");
        List<FieldDescriptor> fields = lTableDesc.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            FieldDescriptor fd = fields.get(i);
            if (fd.isVirtual()) continue;
            sql.append(",T0.").append(fd.getRawName());
        }
        ConnectionManager connectionManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:MultiLinksLookup");
        try (DatabaseConnection connection = connectionManager.getConnection(lTableDesc.getDbId(), "rq:MultiLinksLookup");){
            if (DatabaseType.getMetabaseType().isOracle()) {
                sql.append(" from ").append(connection.getDescriptor().getScheme()).append(".").append(LinksLookup.SYSTEM_TABLES[links_table]);
                sql.append(" L0 right outer join ").append(lTableDesc.getRawName());
                sql.append(" T0 on T0.").append(lTableDesc.getPrimaryKeyFields().get(0).getRawName()).append("=L0.RECORD_ID");
                sql.append(" where L0.TABLE_ID=? and L0.LNK_TABLE_ID=? and L0.LNK_RECORD_ID in (");
            } else {
                sql.append(" from ").append(lTableDesc.getRawName()).append(" T0, ");
                sql.append(connection.getDescriptor().getScheme()).append(".").append(LinksLookup.SYSTEM_TABLES[links_table]).append(" L0");
                sql.append(" where T0.").append(lTableDesc.getPrimaryKeyFields().get(0).getRawName());
                sql.append("=L0.RECORD_ID(+) and L0.TABLE_ID=? and L0.LNK_TABLE_ID=? and L0.LNK_RECORD_ID in (");
            }
            DoubleList rowsId = new DoubleList(4);
            int sep = 32;
            while (in.getNextTag() != 0) {
                rowsId.add(in.getDouble(5));
                sql.append((char)sep).append("?");
                sep = 44;
            }
            sql.append(')');
            try (PreparedStatement stmt = connection.prepareStatement(sql.toString());){
                stmt.setDouble(1, l_table_id);
                stmt.setDouble(2, r_table_id);
                int pIndex = 3;
                for (int i = 0; i < rowsId.size(); ++i) {
                    stmt.setDouble(pIndex++, rowsId.get(i));
                }
                try (ResultSet resultSet = stmt.executeQuery(null);){
                    int i;
                    ArrayList<FieldDescriptor> recordFields = new ArrayList<FieldDescriptor>();
                    for (int i2 = 0; i2 < fields.size(); ++i2) {
                        FieldDescriptor fd = fields.get(i2);
                        if (fd.isVirtual()) continue;
                        recordFields.add(fd);
                    }
                    PackedRowContent content = new PackedRowContent(1, 0, this.rq.client.isClientLevel(3), this, this.rq.client.isClientLevel(6));
                    boolean putLinkRecordsFields = true;
                    ResultSetMetaData metadata = resultSet.getMetaData();
                    int[] columnsMap = new int[recordFields.size()];
                    block13: for (int index = 0; index < columnsMap.length; ++index) {
                        FieldDescriptor field = (FieldDescriptor)recordFields.get(index);
                        columnsMap[index] = -1;
                        for (i = 0; i < metadata.getColumnCount(); ++i) {
                            String columnName = metadata.getColumnLabel(i + 1);
                            if (!columnName.equalsIgnoreCase(field.getRawName())) continue;
                            columnsMap[index] = i + 1;
                            continue block13;
                        }
                    }
                    ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
                    while (resultSet.next()) {
                        if (!recordFields.isEmpty() && putLinkRecordsFields) {
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                            for (i = 0; i < recordFields.size(); ++i) {
                                buffer.write(LittleEndian.intToBinary(((FieldDescriptor)recordFields.get(i)).getId()));
                                buffer.write(LittleEndian.intToBinary(recordFields.get(i).getType().getTypeId()));
                            }
                            buffer.flush();
                            writer.putRaw(17, buffer);
                            putLinkRecordsFields = false;
                        }
                        double l_row_id = resultSet.getDouble(1);
                        double r_row_id = resultSet.getDouble(2);
                        data.reset();
                        content.packRecordContent(resultSet, recordFields, columnsMap, l_table_id, l_row_id, data);
                        writer.putDouble(5, r_row_id);
                        writer.putDouble(3, l_row_id);
                        writer.putRaw(2, data);
                    }
                }
            }
        }
        writer.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

