/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.schema;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.DbColumnable;
import inform.agent.db.schema.DbObject;
import inform.agent.db.schema.DbTable;
import inform.agent.db.types.DataType;
import inform.agent.scripts.SSContext;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class DbColumn
extends DbObject {
    public final DbColumnable table;
    protected boolean nullable;
    protected boolean keyable;
    protected DataType type;
    protected FieldDescriptor.BlobRawType blobRawType = FieldDescriptor.BlobRawType.BINARY;
    protected int size;
    protected boolean foreignKey;
    protected String foreignKeyName;
    protected String foreignKeyRefs;
    protected boolean hasDefValue;
    protected String defValue;
    protected String sqlTypeName;

    public DbColumn(String name, DbColumnable table) {
        super(name);
        this.table = table;
    }

    public DbColumn(String name, DataType type, FieldDescriptor.BlobRawType brt, boolean nullable, int size, DbTable table) {
        this(name, table);
        this.type = type;
        this.blobRawType = brt;
        this.nullable = nullable;
        this.size = size;
    }

    public void setForeignKey(String name, String refs) {
        this.foreignKey = true;
        this.foreignKeyName = name;
        this.foreignKeyRefs = refs;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public DataType getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isKeyable() {
        return this.keyable;
    }

    public boolean isForeignKey() {
        return this.foreignKey;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public String getForeignKeyRefs() {
        if (this.isForeignKey()) {
            return this.foreignKeyRefs;
        }
        return null;
    }

    public final void setType(SSContext ssContext, Statement statement, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, boolean keyable, FieldDescriptor fd) throws SQLException {
        String old = this.getSqlType();
        this.internal_setType(ssContext, statement, type, brt, size, nullable, keyable, fd);
        this.type = type;
        this.blobRawType = brt;
        this.size = size;
        this.nullable = nullable;
        this.keyable = keyable;
        this.log("TYPE CHANGED", "[%s] FROM [%s] -> [%s]", this.fullName(), old, this.getSqlType());
    }

    protected void internal_setType(SSContext context, Statement statement, DataType type, FieldDescriptor.BlobRawType brt, int size, boolean nullable, boolean keyable, FieldDescriptor fd) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    protected boolean isTypesCompatible(DataType type1, DataType type2) {
        switch (type1) {
            case BOOLEAN: 
            case INTEGER: {
                switch (type2) {
                    case BOOLEAN: 
                    case INTEGER: {
                        return true;
                    }
                }
            }
        }
        return type1.canHoldsIn(type2);
    }

    public boolean canHold(FieldDescriptor fd) {
        boolean result;
        boolean bl = result = this.nullable == fd.isNullable() && this.isTypesCompatible(fd.getType(), this.type);
        if (result) {
            switch (this.type) {
                case STRING: 
                case UNICODE: {
                    result = this.size >= fd.getSize();
                    break;
                }
                case BLOB: {
                    return fd.getType().getSqlType(fd.getBlobRawType()) == this.type.getSqlType(this.blobRawType);
                }
            }
        }
        return result;
    }

    public boolean isCannotConvertType(FieldDescriptor fd) {
        switch (this.type) {
            case BLOB: {
                return fd.getType().getSqlType(fd.getBlobRawType()) != this.type.getSqlType(this.blobRawType);
            }
        }
        return false;
    }

    public boolean compatibleTo(FieldDescriptor fd) {
        boolean result;
        boolean bl = result = this.nullable == fd.isNullable() && this.isTypesCompatible(fd.getType(), this.type);
        if (result) {
            switch (this.type) {
                case STRING: 
                case UNICODE: {
                    result = this.size == fd.getSize();
                    break;
                }
                case BLOB: {
                    return fd.getType().getSqlType(fd.getBlobRawType()) == this.type.getSqlType(this.blobRawType);
                }
            }
            if (result) {
                if (this.hasDefValue != fd.isHasDefValue()) {
                    result = false;
                } else if (fd.isHasDefValue()) {
                    result = this.defValue.compareToIgnoreCase(this.scheme().valueOfColumnDefValue(fd)) == 0;
                }
            }
        }
        return result;
    }

    public boolean equals(FieldDescriptor fd) {
        boolean result;
        boolean bl = result = this.nullable == fd.isNullable() && fd.getType().getSqlType(fd.getBlobRawType()) == this.type.getSqlType(this.blobRawType);
        if (result) {
            switch (this.type) {
                case STRING: 
                case UNICODE: {
                    boolean bl2 = result = this.size == fd.getSize();
                }
            }
            if (result) {
                if (this.hasDefValue != fd.isHasDefValue()) {
                    result = false;
                } else if (fd.isHasDefValue()) {
                    result = this.defValue.compareToIgnoreCase(this.scheme().valueOfColumnDefValue(fd)) == 0;
                }
            }
        }
        return result;
    }

    public void appendConvertTo(DbColumn to, StringBuilder out) {
        out.append(this.name);
    }

    @Override
    public DbColumnable getParent() {
        return this.table;
    }

    public String getSqlType() {
        return this.table.scheme.ct2sql(this.type, this.blobRawType, this.size, this.keyable);
    }

    public void setSqlTypeName(String sqlTypeName) {
        this.sqlTypeName = sqlTypeName;
    }

    public void dropForeignKey(SSContext ssContext, Statement statement) throws SQLException {
        if (this.isForeignKey() && !Strings.isVoid(this.foreignKeyName)) {
            statement.execute(ssContext, "ALTER TABLE " + this.table.fullName() + " DROP CONSTRAINT " + this.foreignKeyName);
        }
    }

    public boolean isHasDefValue() {
        return this.hasDefValue;
    }

    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
        this.hasDefValue = defValue != null;
    }
}

