/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.taggedio.TaggedReader;
import inform.agent.db.sql.engine.DataEntry;
import inform.agent.db.sql.engine.Generate;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import java.io.IOException;

public class NestedEntry
extends DataEntry {
    Search nested;
    Search cte;
    Generate.Section cteSection;
    private int cteAlias = -1;

    public NestedEntry(int entryId, Search search) {
        super(entryId, SearchEntry.Kind.Find, search.rootTableId());
        this.inplaceSearch = this.nested = search;
    }

    @Override
    public double entryNodeId() {
        return this.inplaceSearch.searchNodeId;
    }

    @Override
    public boolean isCTE() {
        return this.cte != null;
    }

    @Override
    public int initCTEAlias(int alias) {
        if (this.cte != null) {
            this.cteAlias = ++alias;
        }
        return super.initCTEAlias(alias);
    }

    @Override
    public int initNestedAlias(int alias) {
        if (this.nested != null) {
            alias = this.nested.initEntryAlias(alias);
        }
        if (this.cte != null) {
            this.cte.initEntryAlias(0);
        }
        return this.initChildNestedAlias(alias);
    }

    @Override
    public StringBuilder generateAlias(StringBuilder sql) {
        return super.generateAlias(sql);
    }

    public StringBuilder generateCTEAlias(StringBuilder sql) {
        assert (this.cte != null);
        assert (this.cteAlias >= 0);
        sql.append('W').append(this.cteAlias);
        return sql;
    }

    @Override
    public void generateTableRawName(StringBuilder sql) {
        assert (this.cte != null && this.cteAlias >= 0);
        sql.append('W').append(this.cteAlias);
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 18: {
                if (this.nested == null) break;
                this.cte = this.nested;
                this.nested = null;
                break;
            }
            case 9: {
                this.inplaceSearch.loadSearchParameterBindings(in.getSubStreamReader());
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }
}

