/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.sql.engine;

import inform.adt.LittleEndian;
import inform.adt.collections.DoubleList;
import inform.adt.collections.IntegerList;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.sql.engine.Search;
import inform.agent.db.sql.engine.SearchEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SearchSorting {
    public static final String SOURCE = "\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0435";
    public static final String LINE_NO = "\u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438";
    private ArrayList<Field> fields = null;

    public boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    public List<Field> fields() {
        return this.fields;
    }

    public void addSortField(SearchEntry entry, int fieldId, boolean ascending) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(new Field(entry, fieldId, ascending));
    }

    public void addSortField(Search search, TaggedReader in) throws IOException {
        if (search.selfSortFields()) {
            return;
        }
        byte[] raw = in.getRaw();
        int fieldId = LittleEndian.getInt(raw, 0);
        int ascending = LittleEndian.getInt(raw, 4);
        int path = LittleEndian.getInt(raw, 8);
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        if (path == 0) {
            this.fields.add(new Field(search.rootEntry, fieldId, ascending != 0));
        } else {
            DoubleList pathTable = new DoubleList(path);
            IntegerList pathField = new IntegerList(path);
            raw = in.getRaw(19);
            for (int offset = 0; offset < raw.length; offset += 4) {
                pathTable.add(LittleEndian.getDouble(raw, offset));
                pathField.add(LittleEndian.getInt(raw, offset += 8));
            }
            SearchEntry entry = search.rootEntry;
            for (int i = path - 1; i >= 0; --i) {
                entry = entry.addDirectory(search, pathTable.get(i), pathField.get(i));
            }
            this.fields.add(new Field(entry, fieldId, ascending != 0));
        }
    }

    public void load(Search search, TaggedReader in) throws IOException {
        int entryId = 0;
        int fieldId = 0;
        this.fields = new ArrayList();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    entryId = in.getInt();
                    break;
                }
                case 2: {
                    fieldId = in.getInt();
                    break;
                }
                case 3: {
                    int ascending = in.getInt();
                    SearchEntry entry = search.entries.get(entryId);
                    if (entry == null) break;
                    this.fields.add(new Field(entry, fieldId, ascending != 0));
                }
            }
        }
        if (!this.fields.isEmpty()) {
            search.selfSortFields(true);
        }
    }

    void fillUsedFields(SearchEntry entry) {
        if (this.fields != null) {
            for (Field field : this.fields) {
                if (field.entry.entryId != entry.entryId) continue;
                entry.addUsedField(field.fieldId);
            }
        }
    }

    public static class Field {
        final SearchEntry entry;
        final int fieldId;
        final boolean ascending;

        public Field(SearchEntry entry, int fieldId, boolean ascending) {
            this.entry = entry;
            this.fieldId = fieldId;
            this.ascending = ascending;
        }
    }
}

