/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.db.utils;

import inform.agent.db.TableDescriptor;

public final class DirectoryRowsetCacheKey {
    public final TableDescriptor table;
    public final boolean hasActualPoint;
    public final double actualPoint;

    public DirectoryRowsetCacheKey(TableDescriptor table) {
        this.table = table;
        this.hasActualPoint = false;
        this.actualPoint = 0.0;
    }

    public DirectoryRowsetCacheKey(double actualPoint, TableDescriptor table) {
        this.table = table;
        this.hasActualPoint = true;
        this.actualPoint = actualPoint;
    }

    public boolean isEqual(TableDescriptor table) {
        if (this.hasActualPoint) {
            return false;
        }
        return this.actualPoint == this.actualPoint && this.table.equals(table);
    }

    public boolean isEqual(double actualPoint, TableDescriptor table) {
        if (this.hasActualPoint) {
            return this.actualPoint == actualPoint && this.table.equals(table);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != DirectoryRowsetCacheKey.class) {
            return false;
        }
        DirectoryRowsetCacheKey that = (DirectoryRowsetCacheKey)obj;
        return this.hasActualPoint == that.hasActualPoint && this.actualPoint == that.actualPoint && this.table.equals(that.table);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + this.table.hashCode();
        hash = 89 * hash + (this.hasActualPoint ? 1 : 0);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.actualPoint) ^ Double.doubleToLongBits(this.actualPoint) >>> 32);
        return hash;
    }
}

