/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.document;

import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.document.CellData;
import inform.agent.document.CustomItem;
import inform.agent.document.Data;
import inform.agent.document.HyperLink;
import inform.agent.document.IObserverPicture;
import inform.agent.document.Marker;
import inform.agent.document.Picture;
import inform.agent.document.Style;
import inform.agent.document.TabItem;
import inform.agent.document.Table;
import inform.agent.document.TextItem;
import inform.agent.document.UsedStyleFinder;
import inform.agent.web.utils.Color;
import java.util.ArrayList;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class HTMLParser {
    private static HTMLParser instance;
    private Style style = null;
    private Data data = null;
    private CellData cellData = null;
    private ArrayList<Style.Text> textStack;
    private ArrayList<ParagraphProperties> paraStack;
    private ArrayList<MarkerProperties> markerStack;
    private ArrayList<TableProperties> tables;
    private int lastMarkerIndex = -1;
    private boolean preMode = false;
    private boolean pageBreakFlag = false;
    private HyperTextMode hyperTextMode = null;
    private ArrayList<PairSI> fontSizeAbsolute;
    private ArrayList<PairSI> fontStyles;
    private IObserverPicture iObserverPicture = null;
    private static final double STANDART_PIXEL_PER_INCH = 96.0;
    public static final int ATTRIBUTE_SIZE_UNIT_NONE = 0;
    public static final int ATTRIBUTE_SIZE_UNIT_PERCENT = 1;
    public static final int ATTRIBUTE_SIZE_UNIT_PIXEL = 2;
    public static final int ATTRIBUTE_SIZE_UNIT_CHARACTER = 3;
    public static final int ATTRIBUTE_SIZE_UNIT_POINT = 4;
    private static final int SUB_STYLE_SHARED = 0;
    private static final int SUB_STYLE_TABLE = 1;
    private static final int SUB_STYLE_TABLE_CELL = 2;
    final String[] STYLE_ATTRS = new String[]{"font-family", "font-size", "text-align", "color", "background-color", "font-style", "margin-left", "margin-right", "border-left-width", "border-right-width", "border-top-width", "border-bottom-width", "border-collapse", "border"};

    protected HTMLParser() {
        this.fontSizeAbsolute = new ArrayList();
        PairSI psi1 = new PairSI();
        psi1.s = "xx-small";
        psi1.value = -3;
        this.fontSizeAbsolute.add(psi1);
        PairSI psi2 = new PairSI();
        psi2.s = "x-small";
        psi2.value = -2;
        this.fontSizeAbsolute.add(psi2);
        PairSI psi3 = new PairSI();
        psi3.s = "small";
        psi3.value = -1;
        this.fontSizeAbsolute.add(psi3);
        PairSI psi4 = new PairSI();
        psi4.s = "medium";
        psi4.value = 0;
        this.fontSizeAbsolute.add(psi4);
        PairSI psi5 = new PairSI();
        psi5.s = "xxx-large";
        psi5.value = 4;
        this.fontSizeAbsolute.add(psi5);
        PairSI psi6 = new PairSI();
        psi6.s = "xx-large";
        psi6.value = 3;
        this.fontSizeAbsolute.add(psi6);
        PairSI psi7 = new PairSI();
        psi7.s = "x-large";
        psi7.value = 2;
        this.fontSizeAbsolute.add(psi7);
        PairSI psi8 = new PairSI();
        psi8.s = "large";
        psi8.value = 1;
        this.fontSizeAbsolute.add(psi8);
        this.fontStyles = new ArrayList();
        PairSI psi_fs1 = new PairSI();
        psi_fs1.s = "normal";
        psi_fs1.value = 0;
        this.fontStyles.add(psi_fs1);
        PairSI psi_fs2 = new PairSI();
        psi_fs2.s = "italic";
        psi_fs2.value = 2;
        this.fontStyles.add(psi_fs2);
        PairSI psi_fs3 = new PairSI();
        psi_fs3.s = "oblique";
        psi_fs3.value = 2;
        this.fontStyles.add(psi_fs3);
    }

    public static HTMLParser getInstance() {
        if (instance == null) {
            instance = new HTMLParser();
        }
        return instance;
    }

    private void initParser() {
        this.style = new Style();
        this.data = new Data();
        this.textStack = new ArrayList();
        this.paraStack = new ArrayList();
        this.markerStack = new ArrayList();
        this.tables = new ArrayList();
        this.pushTextStyle();
        this.pushParaStyle();
    }

    private void doneParser() {
        this.style = null;
        this.data = null;
        this.textStack = null;
        this.paraStack = null;
        this.markerStack = null;
        this.tables = null;
        this.iObserverPicture = null;
    }

    public byte[] parse(String html, IObserverPicture observer) throws Throwable {
        CustomItem item;
        Document document = Jsoup.parse((String)html);
        this.iObserverPicture = observer;
        this.initParser();
        this.readBody(document.body());
        if (this.data.itemList.size() > 1 && (item = this.data.itemList.get(this.data.itemList.size() - 1)) instanceof TextItem && ((TextItem)item).itemText().isEmpty() && !item.pageBreakBefore()) {
            this.data.itemList.remove(this.data.itemList.size() - 1);
        }
        ByteArrayOutputStream outData = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(outData);
        UsedStyleFinder finder = new UsedStyleFinder();
        writer.putEmpty(150);
        finder.prepare(this.data);
        this.style.store(writer, finder);
        this.data.store(writer, 1);
        writer.flush();
        this.doneParser();
        return outData.toByteArray();
    }

    private void readBody(Element el) throws Throwable {
        this.readNode(el);
        if (this.pageBreakFlag) {
            this.addText("");
        }
    }

    private void readNode(Element el) throws Throwable {
        for (Node n : el.childNodes()) {
            if (n instanceof TextNode) {
                TextNode textNode = (TextNode)n;
                String s = textNode.getWholeText();
                if (this.preMode) {
                    String[] strs2;
                    if (Strings.isVoid(s)) continue;
                    for (String ss : strs2 = s.split("\n")) {
                        this.currentParagraphProperties().resetPosition();
                        ss = ss.replaceAll("\r", "");
                        if (Strings.isVoid(ss)) continue;
                        this.addMultiText(ss);
                    }
                    continue;
                }
                s = s.replaceAll("\r|\n", "");
                String emptyField = s.trim();
                boolean inlineWhitespace = "span".equals(el.tagName());
                if (Strings.isVoid(emptyField) && !inlineWhitespace || Strings.isVoid(s)) continue;
                this.addMultiText(s);
                continue;
            }
            if (!(n instanceof Element)) continue;
            String attribute = null;
            Element child = (Element)n;
            switch (child.tagName()) {
                case "div": {
                    this.pushTextStyle();
                    this.pushParaStyle();
                    this.currentParagraphProperties().resetPosition();
                    this.resolveStyleAttribute(child, 0);
                    this.readNode(child);
                    this.popParaStyle();
                    this.popTextStyle();
                    if (this.paraStack.isEmpty()) break;
                    this.currentParagraphProperties().resetPosition();
                    break;
                }
                case "span": {
                    this.pushTextStyle();
                    this.resolveStyleAttribute(child, 0);
                    this.readNode(child);
                    this.popTextStyle();
                    break;
                }
                case "b": 
                case "strong": {
                    this.pushTextStyle();
                    this.currentFont().style |= 1;
                    this.resolveStyleAttribute(child, 0);
                    this.readNode(child);
                    this.popTextStyle();
                    break;
                }
                case "i": 
                case "em": {
                    this.pushTextStyle();
                    this.currentFont().style |= 2;
                    this.resolveStyleAttribute(child, 0);
                    this.readNode(child);
                    this.popTextStyle();
                    break;
                }
                case "u": {
                    this.pushTextStyle();
                    this.currentFont().style |= 4;
                    this.resolveStyleAttribute(child, 0);
                    this.readNode(child);
                    this.popTextStyle();
                    break;
                }
                case "strike": {
                    this.pushTextStyle();
                    this.currentFont().style |= 8;
                    this.resolveStyleAttribute(child, 0);
                    this.readNode(child);
                    this.popTextStyle();
                    break;
                }
                case "font": {
                    this.pushTextStyle();
                    String value = child.attr("face");
                    if (!Strings.isVoid(value)) {
                        this.executeStyleAttribute("font-family", value);
                    }
                    this.readNode(child);
                    this.popTextStyle();
                    break;
                }
                case "ul": 
                case "ol": {
                    this.pushTextStyle();
                    this.pushParaStyle();
                    this.pushMarkers(child, "ol".equals(child.tagName()));
                    this.resolveStyleAttribute(child, 0);
                    this.readNode(child);
                    this.popMarkers();
                    this.popParaStyle();
                    this.popTextStyle();
                    break;
                }
                case "li": {
                    if (this.markerStack.isEmpty()) break;
                    this.currentParagraphProperties().resetPosition();
                    this.addMarker();
                    this.readNode(child);
                    CustomItem item = this.currentData().itemList.get(this.currentData().itemList.size() - 1);
                    if (item == null || item.styleNo() != -11) break;
                    this.addText("");
                    break;
                }
                case "tbody": {
                    this.readNode(child);
                    break;
                }
                case "table": {
                    this.pushTextStyle();
                    this.pushParaStyle();
                    this.pushTables(child);
                    this.resolveStyleAttribute(child, 1);
                    this.readNode(child);
                    this.popTables();
                    this.popParaStyle();
                    this.popTextStyle();
                    break;
                }
                case "tr": {
                    this.pushDefaultTextStyle();
                    this.pushDefaultParaStyle();
                    this.pushTableRow();
                    this.readNode(child);
                    this.popTableRow();
                    this.popParaStyle();
                    this.popTextStyle();
                    break;
                }
                case "th": 
                case "td": {
                    this.pushDefaultTextStyle();
                    this.pushDefaultParaStyle();
                    this.pushTableCell(child, "th".equals(child.tagName()));
                    this.resolveStyleAttribute(child, 2);
                    this.readNode(child);
                    this.popTableCell();
                    this.popParaStyle();
                    this.popTextStyle();
                    break;
                }
                case "pre": {
                    this.pushTextStyle();
                    this.pushParaStyle();
                    this.resolveStyleAttribute(child, 0);
                    if (this.preMode) {
                        this.readNode(child);
                    } else {
                        this.preMode = true;
                        this.readNode(child);
                        this.preMode = false;
                    }
                    this.popParaStyle();
                    this.popTextStyle();
                    break;
                }
                case "a": {
                    this.pushStandartTextStyle(4);
                    if (this.hyperTextMode != null) {
                        this.resolveStyleAttribute(child, 0);
                        this.readNode(child);
                    } else {
                        this.hyperTextMode = new HyperTextMode();
                        String attrLink = child.attr("href");
                        if (!Strings.isVoid(attrLink)) {
                            this.hyperTextMode.link = attrLink;
                        }
                        this.resolveStyleAttribute(child, 0);
                        this.readNode(child);
                        this.hyperTextMode = null;
                    }
                    this.popTextStyle();
                    break;
                }
                case "h1": 
                case "h2": 
                case "h3": 
                case "h4": 
                case "h5": 
                case "h6": {
                    if ("h1".equals(child.tagName())) {
                        this.pushStandartTextStyle(1);
                    } else {
                        this.pushStandartTextStyle(2);
                    }
                    this.pushParaStyle();
                    this.resolveStyleAttribute(child, 0);
                    this.readNode(child);
                    this.popParaStyle();
                    this.popTextStyle();
                    break;
                }
                case "blockquote": {
                    this.pushTextStyle();
                    this.pushParaStyle();
                    this.currentFont().style &= 0xFFFFFFF7;
                    this.currentFont().style &= 0xFFFFFFFB;
                    this.currentFont().style |= 2;
                    this.currentParagraph().leftIndent = 40;
                    this.currentParagraph().rightIndent = 40;
                    this.readNode(child);
                    this.popParaStyle();
                    this.popTextStyle();
                    break;
                }
                case "p": 
                case "o:p": {
                    this.pushTextStyle();
                    this.pushParaStyle();
                    this.resolveStyleAttribute(child, 0);
                    attribute = child.attr("align");
                    if (!Strings.isVoid(attribute)) {
                        this.executeStyleAttribute("text-align", attribute);
                    }
                    this.readNode(child);
                    this.currentParagraphProperties().resetPosition();
                    this.addText("");
                    this.popParaStyle();
                    this.popTextStyle();
                    break;
                }
                case "hr": {
                    if (this.cellData == null) {
                        this.pageBreakFlag = true;
                    }
                    this.pushTextStyle();
                    this.pushParaStyle();
                    this.resolveStyleAttribute(child, 0);
                    this.readNode(child);
                    this.popParaStyle();
                    this.popTextStyle();
                    break;
                }
                case "br": {
                    if (this.currentData().itemList.isEmpty()) {
                        if (!this.pageBreakFlag) {
                            this.addText("");
                        }
                    } else if (this.currentParagraphProperties().position() == 2) {
                        this.currentParagraphProperties().resetPosition();
                        this.addText("");
                    }
                    if (this.paraStack.isEmpty()) break;
                    this.currentParagraphProperties().resetPosition();
                    break;
                }
                case "img": {
                    if (this.iObserverPicture == null) break;
                    this.readImage(child);
                }
            }
        }
    }

    private String getCurrentFontName(String[] list) {
        if (list.length == 0) {
            return "Times New Roman";
        }
        String res = list[0];
        return res.replaceAll("\"|'", "");
    }

    private int heightToFontSize(double height) {
        return ValueCaster.toInt(height * 72.0 / 96.0 + 0.5);
    }

    private double fontSizeToHeight(int size) {
        return (double)size * 96.0 / 72.0;
    }

    private void executeStyleAttribute(String attr, String value) {
        if (Strings.isVoid(value)) {
            return;
        }
        AttributeSizeUnit asUnit = null;
        StyleColorResult scResult = null;
        block10 : switch (attr.toLowerCase()) {
            case "font-family": {
                String[] strs = value.split(",");
                if (strs.length <= 0) break;
                this.currentFont().name = this.getCurrentFontName(strs);
                break;
            }
            case "font-size": {
                asUnit = this.getValueByUnits(value, 0.0);
                if (asUnit != null) {
                    if (asUnit.unit == 4) {
                        this.currentFont().size = ValueCaster.toInt(asUnit.value);
                        break;
                    }
                    this.currentFont().size = this.heightToFontSize(asUnit.value);
                    break;
                }
                for (PairSI psi : this.fontSizeAbsolute) {
                    if (Strings.isVoid(psi.s) || !value.endsWith(psi.s)) continue;
                    this.currentFont().size = this.style.textStyles.get((int)0).size + psi.value;
                    break block10;
                }
                break;
            }
            case "text-align": {
                switch (value) {
                    case "start": 
                    case "left": {
                        this.currentParagraph().align = 0;
                        break;
                    }
                    case "end": 
                    case "right": {
                        this.currentParagraph().align = 1;
                        break;
                    }
                    case "center": {
                        this.currentParagraph().align = 2;
                        break;
                    }
                    case "justify": {
                        this.currentParagraph().align = 3;
                    }
                }
                break;
            }
            case "color": {
                scResult = this.scanStyleColor(value);
                if (!scResult.value) break;
                this.currentFont().color = Color.toColor(scResult.r, scResult.g, scResult.b);
                break;
            }
            case "background-color": {
                scResult = this.scanStyleColor(value);
                if (!scResult.value) break;
                this.currentFont().background = Color.toColor(scResult.r, scResult.g, scResult.b);
                break;
            }
            case "font-style": {
                for (PairSI psi : this.fontStyles) {
                    if (Strings.isVoid(psi.s) || !value.startsWith(psi.s)) continue;
                    this.currentFont().style |= psi.value.intValue();
                    break block10;
                }
                break;
            }
            case "margin-left": {
                asUnit = this.getValueByUnits(value, 0.0);
                if (asUnit == null || asUnit.unit == 1) break;
                this.currentParagraph().leftIndent = ValueCaster.toInt(asUnit.value);
                break;
            }
            case "margin-right": {
                asUnit = this.getValueByUnits(value, 0.0);
                if (asUnit == null || asUnit.unit == 1) break;
                this.currentParagraph().rightIndent = ValueCaster.toInt(asUnit.value);
            }
        }
    }

    private void executeTableStyleAttribute(String attr, String value) {
        if (Strings.isVoid(value) || this.tables.isEmpty()) {
            return;
        }
        AttributeSizeUnit asUnit = null;
        StyleColorResult scResult = null;
        switch (attr.toLowerCase()) {
            case "border-left-width": {
                asUnit = this.getValueByUnits(value, 0.0);
                if (asUnit == null || asUnit.unit == 1 || !(Math.abs(asUnit.value) < 1.0E-12)) break;
                this.tables.get((int)(this.tables.size() - 1)).table.borderLeftVisible = false;
                break;
            }
            case "border-right-width": {
                asUnit = this.getValueByUnits(value, 0.0);
                if (asUnit == null || asUnit.unit == 1 || !(Math.abs(asUnit.value) < 1.0E-12)) break;
                this.tables.get((int)(this.tables.size() - 1)).table.borderRightVisible = false;
                break;
            }
            case "border-top-width": {
                asUnit = this.getValueByUnits(value, 0.0);
                if (asUnit == null || asUnit.unit == 1 || !(Math.abs(asUnit.value) < 1.0E-12)) break;
                this.tables.get((int)(this.tables.size() - 1)).table.borderTopVisible = false;
                break;
            }
            case "border-bottom-width": {
                asUnit = this.getValueByUnits(value, 0.0);
                if (asUnit == null || asUnit.unit == 1 || !(Math.abs(asUnit.value) < 1.0E-12)) break;
                this.tables.get((int)(this.tables.size() - 1)).table.borderBottomVisible = false;
                break;
            }
            case "background-color": {
                scResult = this.scanStyleColor(value);
                if (!scResult.value) break;
                this.tables.get((int)(this.tables.size() - 1)).table.color = Color.toColor(scResult.r, scResult.g, scResult.b);
                break;
            }
            case "border-collapse": {
                if (!Strings.equals(value.toLowerCase(), "collapse")) break;
                this.tables.get((int)(this.tables.size() - 1)).table.borderWidth = 0;
                this.tables.get((int)(this.tables.size() - 1)).table.cellHSpacing = 0;
                this.tables.get((int)(this.tables.size() - 1)).table.cellVSpacing = 0;
                this.tables.get((int)(this.tables.size() - 1)).inheritedBorderWidth = false;
                break;
            }
            case "border": {
                if (!Strings.equals(value.toLowerCase(), "none")) break;
                this.tables.get((int)(this.tables.size() - 1)).table.borderWidth = 0;
                this.tables.get((int)(this.tables.size() - 1)).inheritedBorderWidth = false;
            }
        }
    }

    private void executeTableCellStyleAttribute(String attr, String value) {
        if (Strings.isVoid(value) || this.tables.isEmpty()) {
            return;
        }
        switch (attr.toLowerCase()) {
            case "text-align": {
                this.executeStyleAttribute(attr, value);
            }
        }
    }

    private void resolveStyleAttribute(Element el, int subStyle) {
        String[] pairs;
        String attrValue = el.attr("style");
        if (Strings.isVoid(attrValue)) {
            return;
        }
        for (String pair : pairs = attrValue.split(";")) {
            String[] kv = pair.split(":");
            if (kv.length < 2) continue;
            String key = kv[0].trim();
            String value = kv[1].trim();
            block6: for (String s : this.STYLE_ATTRS) {
                if (s.compareToIgnoreCase(key) != 0) continue;
                switch (subStyle) {
                    case 0: {
                        this.executeStyleAttribute(key, value);
                        continue block6;
                    }
                    case 1: {
                        this.executeTableStyleAttribute(key, value);
                        continue block6;
                    }
                    case 2: {
                        this.executeTableCellStyleAttribute(key, value);
                    }
                }
            }
        }
    }

    private AttributeSizeUnit getValueByUnits(String value, double originValue) {
        if (value.endsWith("px")) {
            String v = value.replace("px", "");
            AttributeSizeUnit asUnit = new AttributeSizeUnit();
            asUnit.unit = 2;
            asUnit.value = ValueCaster.toDouble(v);
            return asUnit;
        }
        if (value.endsWith("%")) {
            String v = value.replace("%", "");
            AttributeSizeUnit asUnit = new AttributeSizeUnit();
            asUnit.unit = 1;
            asUnit.value = ValueCaster.toDouble(v);
            asUnit.value = asUnit.value / 100.0 * originValue;
            return asUnit;
        }
        if (value.endsWith("ch")) {
            double COEFF = 0.5;
            String v = value.replace("ch", "");
            AttributeSizeUnit asUnit = new AttributeSizeUnit();
            asUnit.unit = 3;
            asUnit.value = 0.5 * ValueCaster.toDouble(v) * this.fontSizeToHeight(this.currentFont().size);
            return asUnit;
        }
        if (value.endsWith("pt")) {
            String v = value.replace("pt", "");
            AttributeSizeUnit asUnit = new AttributeSizeUnit();
            asUnit.unit = 4;
            asUnit.value = ValueCaster.toDouble(v);
            return asUnit;
        }
        return null;
    }

    private TextItem createTextItem(int styleNo) {
        TextItem item = null;
        if (this.hyperTextMode != null) {
            HyperLink hl = new HyperLink();
            hl.link = this.hyperTextMode.link;
            item = hl;
        } else {
            item = new TextItem();
        }
        item.setStyleNo(styleNo);
        item.sameAsPrev(false);
        item.br(false);
        return item;
    }

    private Table createTable(int rows, int cols) {
        Table table = new Table();
        table.init(rows, cols, this.currentData());
        return table;
    }

    private void addMultiText(String s) {
        if (s.compareTo("\t") == 0) {
            this.addText(s);
            return;
        }
        String[] strs = s.split("\t");
        for (int i = 0; i < strs.length; ++i) {
            String ss = strs[i];
            if (!Strings.isVoid(ss)) {
                this.addText(ss);
            }
            if (i >= strs.length - 1) continue;
            this.addText("\t");
        }
    }

    private void addText(String s) {
        int styleNo = this.getCurrentStyleNo();
        if (s.compareTo("\t") == 0) {
            TabItem tab = new TabItem();
            tab.textStyleNo = styleNo;
            this.prepareParagraph(tab, this.currentParagraphProperties().position());
            this.addItem(tab);
        } else {
            TextItem item = this.createTextItem(styleNo);
            this.prepareParagraph(item, this.currentParagraphProperties().position());
            item.setItemText(s);
            this.addItem(item);
        }
    }

    private void addMarker() {
        if (this.markerStack.isEmpty()) {
            return;
        }
        assert (!this.paraStack.isEmpty());
        int listNo = this.getCurrentMarkerListNo();
        boolean firstMarker = this.currentMarkerProperties().first;
        this.currentMarkerProperties().first = false;
        boolean LIST_LEVEL = false;
        Marker marker = new Marker(listNo, 0, 1, firstMarker);
        this.prepareParagraph(marker, this.currentParagraphProperties().position());
        this.addItem(marker);
    }

    private void addItem(CustomItem item) {
        CustomItem marker;
        if (this.cellData == null && this.pageBreakFlag) {
            this.pageBreakFlag = false;
            if (this.currentData().itemList.isEmpty()) {
                this.currentParagraphProperties().resetPosition();
                this.addText("");
            }
            item.pageBreakBefore(true);
        }
        this.currentData().addItem(item);
        if (item.styleNo() == -11) {
            this.lastMarkerIndex = this.currentData().itemList.size() - 1;
        } else if (this.lastMarkerIndex >= 0 && this.lastMarkerIndex + 1 == this.currentData().itemList.size() - 1 && (marker = this.currentData().itemList.get(this.lastMarkerIndex)) != null && marker.styleNo() == -11) {
            marker.sameAsPrev(true);
        }
    }

    private void pushStandartTextStyle(int stdStyle) {
        int background = this.currentFont().background;
        Style.Text newTextStyle = new Style.Text();
        newTextStyle.assign(this.style.textStyles.get(stdStyle));
        newTextStyle.background = background;
        this.textStack.add(newTextStyle);
    }

    private void pushDefaultTextStyle() {
        Style.Text newTextStyle = new Style.Text();
        newTextStyle.assign(this.style.textStyles.get(0));
        this.textStack.add(newTextStyle);
    }

    private void pushTextStyle() {
        if (this.textStack.isEmpty()) {
            assert (this.style.textStyles.size() > 0);
            this.pushDefaultTextStyle();
        } else {
            Style.Text newTextStyle = new Style.Text();
            newTextStyle.assign(this.currentFont());
            this.textStack.add(newTextStyle);
        }
    }

    private Style.Text currentFont() {
        return this.textStack.get(this.textStack.size() - 1);
    }

    private void popTextStyle() {
        assert (!this.textStack.isEmpty());
        this.textStack.remove(this.textStack.size() - 1);
    }

    private int getCurrentStyleNo() {
        for (int i = 0; i < this.style.textStyles.size(); ++i) {
            if (!this.currentFont().equal(this.style.textStyles.get(i))) continue;
            return i;
        }
        Style.Text newTextStyle = new Style.Text();
        newTextStyle.assign(this.currentFont());
        this.style.textStyles.add(newTextStyle);
        return this.style.textStyles.size() - 1;
    }

    private void pushDefaultParaStyle() {
        ParagraphProperties pp = new ParagraphProperties();
        pp.p = new Style.Paragraph();
        pp.p.assign(this.style.paraStyles.get(0));
        this.paraStack.add(pp);
    }

    private void pushParaStyle() {
        if (this.paraStack.isEmpty()) {
            assert (this.style.paraStyles.size() > 0);
            this.pushDefaultParaStyle();
        } else {
            ParagraphProperties pp = new ParagraphProperties();
            pp.p = new Style.Paragraph();
            pp.p.assign(this.currentParagraph());
            this.paraStack.add(pp);
        }
    }

    private ParagraphProperties currentParagraphProperties() {
        return this.paraStack.get(this.paraStack.size() - 1);
    }

    private Style.Paragraph currentParagraph() {
        return this.paraStack.get((int)(this.paraStack.size() - 1)).p;
    }

    private void popParaStyle() {
        assert (!this.paraStack.isEmpty());
        this.paraStack.remove(this.paraStack.size() - 1);
    }

    private int getCurrentParaNo() {
        for (int i = 0; i < this.style.paraStyles.size(); ++i) {
            if (!this.currentParagraph().equal(this.style.paraStyles.get(i))) continue;
            return i;
        }
        Style.Paragraph newParaStyle = new Style.Paragraph();
        newParaStyle.assign(this.currentParagraph());
        this.style.paraStyles.add(newParaStyle);
        return this.style.paraStyles.size() - 1;
    }

    private void prepareParagraph(CustomItem item, byte position) {
        switch (position) {
            case 0: {
                item.sameAsPrev(true);
                break;
            }
        }
        item.paraNo = this.getCurrentParaNo();
    }

    private void pushTables(Element el) {
        String attrBGColor;
        String attrCellPadding;
        String attrCellSpacing;
        String attrBorder;
        String attrTextAlign;
        TableProperties oldTp = null;
        if (!this.tables.isEmpty()) {
            oldTp = this.tables.get(this.tables.size() - 1);
        }
        TableProperties tp = new TableProperties();
        tp.table = this.createTable(0, 0);
        if (oldTp != null) {
            tp.table.color = oldTp.table.color;
        }
        this.tables.add(tp);
        String attrWidth = el.attr("width");
        if (!Strings.isVoid(attrWidth)) {
            AttributeSizeUnit asUnit = this.getValueByUnits(attrWidth, 100.0);
            if (asUnit != null) {
                switch (asUnit.unit) {
                    case 2: {
                        tp.table.bestWidth = ValueCaster.toInt(asUnit.value);
                        break;
                    }
                    case 1: {
                        tp.table.bestWidth = -1 * ValueCaster.toInt(asUnit.value);
                    }
                }
            } else if (attrWidth.matches("\\d+")) {
                tp.table.bestWidth = ValueCaster.toInt(attrWidth);
            }
        }
        if (!Strings.isVoid(attrTextAlign = el.attr("align"))) {
            this.executeStyleAttribute("text-align", attrTextAlign);
        }
        if (!Strings.isVoid(attrBorder = el.attr("border")) && attrBorder.matches("\\d+")) {
            tp.table.borderWidth = ValueCaster.toInt(attrBorder);
        }
        if (!Strings.isVoid(attrCellSpacing = el.attr("cellspacing")) && attrCellSpacing.matches("\\d+")) {
            tp.table.cellHSpacing = tp.table.cellVSpacing = ValueCaster.toInt(attrCellSpacing);
        }
        if (!Strings.isVoid(attrCellPadding = el.attr("cellpadding")) && attrCellPadding.matches("\\d+")) {
            tp.table.cellHPadding = tp.table.cellVPadding = ValueCaster.toInt(attrCellPadding);
        }
        if (!Strings.isVoid(attrBGColor = el.attr("bgcolor"))) {
            StyleColorResult scResult = this.scanStyleColor(attrBGColor);
            if (scResult.value) {
                tp.table.color = Color.toColor(scResult.r, scResult.g, scResult.b);
            }
        }
    }

    private void popTables() {
        int lastIndex = this.tables.size() - 1;
        assert (lastIndex >= 0);
        Table table = this.tables.get((int)lastIndex).table;
        assert (table != null);
        if (table.rowCount() == 0 || table.getRow(0).count() == 0) {
            table = null;
            this.tables.get((int)lastIndex).table = null;
        } else {
            this.prepareParagraph(table, this.currentParagraphProperties().position());
            this.addItem(table);
        }
        this.tables.remove(lastIndex);
    }

    private void pushTableRow() {
        if (this.tables.isEmpty()) {
            return;
        }
        TableProperties lastProp = this.tables.get(this.tables.size() - 1);
        lastProp.lastRow = this.createTable(1, 1);
        lastProp.prevData = this.cellData != null ? this.cellData : null;
        ++lastProp.currentRow;
        lastProp.currentCol = 0;
        lastProp.firstCell = true;
        this.cellData = lastProp.lastRow.cells(0, 0);
        if (lastProp.table.borderWidth == 0 && lastProp.inheritedBorderWidth) {
            this.cellData.borderLeftVisible = false;
            this.cellData.borderRightVisible = false;
            this.cellData.borderTopVisible = false;
            this.cellData.borderBottomVisible = false;
        }
        this.cellData.itemList.clear();
    }

    private void popTableRow() {
        if (this.tables.isEmpty()) {
            return;
        }
        this.assignRowProperties();
        TableProperties lastTableProp = this.tables.get(this.tables.size() - 1);
        Table table = lastTableProp.table;
        Table lastRow = lastTableProp.lastRow;
        int currentRow = lastTableProp.currentRow;
        int lastRowCount = lastRow.getRow(0).count();
        for (int c = 0; c < lastRowCount; ++c) {
            CellData cell = lastRow.cells(0, c);
            if (cell == null) continue;
            table.cells((int)currentRow, (int)c).itemList.clear();
            table.cells(currentRow, c).moveFrom(cell);
            table.cells(currentRow, c).assignAttributesFrom(cell, true, 1, 1);
            if (cell.rowSpan > 1) {
                c += cell.rowSpan - 1;
            }
            if (table.cells((int)currentRow, (int)c).itemList.size() != 0) continue;
            table.cells(currentRow, c).addEmptyText();
        }
        int mainCount = table.getRow(0).count();
        if (lastRowCount < mainCount) {
            int colSpan = mainCount - lastRowCount;
            this.safeMergeCells(table, currentRow, lastRowCount - 1, colSpan + 1, 1, false);
        }
        lastRow.reset(1, 1);
        this.cellData = lastTableProp.prevData;
        lastTableProp.prevData = null;
    }

    private void pushMarkers(Element el, boolean checkType) {
        MarkerProperties markerProp = new MarkerProperties();
        if (checkType) {
            String value = el.attr("type");
            if (!Strings.isVoid(value)) {
                switch (value) {
                    case "I": {
                        markerProp.listType = 7;
                        break;
                    }
                    case "i": {
                        markerProp.listType = 6;
                        break;
                    }
                    case "A": {
                        markerProp.listType = 5;
                        break;
                    }
                    case "a": {
                        markerProp.listType = 4;
                        break;
                    }
                    default: {
                        markerProp.listType = 3;
                        break;
                    }
                }
            } else {
                markerProp.listType = 3;
            }
        }
        this.markerStack.add(markerProp);
    }

    private void popMarkers() {
        assert (!this.markerStack.isEmpty());
        this.markerStack.remove(this.markerStack.size() - 1);
        if (this.markerStack.isEmpty()) {
            this.lastMarkerIndex = -1;
        }
    }

    private MarkerProperties currentMarkerProperties() {
        return this.markerStack.get(this.markerStack.size() - 1);
    }

    private int getCurrentMarkerListNo() {
        Style.ListLevel curListLevel = new Style.ListLevel();
        curListLevel.fontName = this.currentFont().name;
        curListLevel.fontSize = this.currentFont().size;
        curListLevel.fontStyle = this.currentFont().style;
        curListLevel.fontColor = this.currentFont().color;
        curListLevel.type = this.currentMarkerProperties().listType;
        curListLevel.formatString = curListLevel.type == 0 ? "- " : "%s. ";
        for (int i = 0; i < this.style.listStyles.size(); ++i) {
            Style.ListLevel ll;
            if (this.style.listStyles.get((int)i).levels.isEmpty() || (ll = this.style.listStyles.get((int)i).levels.get(0)) == null || !ll.equal(curListLevel)) continue;
            return i;
        }
        int index = this.style.listStyles.size();
        Style.List newList = new Style.List();
        newList.styleName = "<\u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0438\u043b\u044c " + index + ">";
        newList.standart = false;
        newList.levels = new ArrayList();
        newList.levels.add(curListLevel);
        this.style.listStyles.add(newList);
        return index;
    }

    private void pushTableCell(Element el, boolean header) {
        String attrWidth;
        String attrBGColor;
        if (this.tables.isEmpty()) {
            return;
        }
        TableProperties tableProp = this.tables.get(this.tables.size() - 1);
        if (tableProp.firstCell) {
            tableProp.firstCell = false;
        } else {
            int currentCol;
            Table lastRow = tableProp.lastRow;
            if ((currentCol = ++tableProp.currentCol) == lastRow.getRow(0).count()) {
                lastRow.insertCols(currentCol, 1);
            }
            this.cellData = lastRow.cells(0, currentCol);
            if (tableProp.table.borderWidth == 0 && tableProp.inheritedBorderWidth) {
                this.cellData.borderLeftVisible = false;
                this.cellData.borderRightVisible = false;
                this.cellData.borderTopVisible = false;
                this.cellData.borderBottomVisible = false;
            }
            this.cellData.itemList.clear();
        }
        if (header) {
            this.currentParagraph().align = 2;
            this.currentFont().style = 1;
        }
        if (!Strings.isVoid(attrBGColor = el.attr("bgcolor"))) {
            StyleColorResult scResult = this.scanStyleColor(attrBGColor);
            if (scResult.value) {
                this.cellData.color = Color.toColor(scResult.r, scResult.g, scResult.b);
            }
        }
        if (!Strings.isVoid(attrWidth = el.attr("width"))) {
            AttributeSizeUnit asUnit = this.getValueByUnits(attrWidth, 100.0);
            if (asUnit != null) {
                switch (asUnit.unit) {
                    case 2: {
                        this.cellData.bestWidth = ValueCaster.toInt(asUnit.value);
                        break;
                    }
                    case 1: {
                        this.cellData.bestWidth = -1 * ValueCaster.toInt(asUnit.value);
                    }
                }
            } else if (attrWidth.matches("\\d+")) {
                this.cellData.bestWidth = ValueCaster.toInt(attrWidth);
            }
        }
    }

    private void popTableCell() {
        if (this.tables.isEmpty()) {
            return;
        }
        TableProperties tableProp = this.tables.get(this.tables.size() - 1);
        int currentCol = tableProp.currentCol;
        Table lastRow = tableProp.lastRow;
        if (lastRow.cells((int)0, (int)currentCol).itemList.size() == 0) {
            this.addText("");
        }
    }

    private Data currentData() {
        if (this.cellData != null) {
            return this.cellData;
        }
        return this.data;
    }

    private void assignRowProperties() {
        TableProperties lastTableProp = this.tables.get(this.tables.size() - 1);
        int currentRow = lastTableProp.currentRow;
        Table table = lastTableProp.table;
        Table lastRow = lastTableProp.lastRow;
        boolean firstRow = table.rowCount() == 0;
        table.insertRows(table.rowCount(), 1);
        if (!firstRow) {
            int tableCols = table.getRow(0).count();
            assert (tableCols > 0);
            int lastRowCols = lastRow.getRow(0).count();
            if (tableCols < lastRowCols) {
                int span = lastRowCols - tableCols + 1;
                table.insertCols(tableCols, span - 1);
                if (currentRow > 0) {
                    if (span > 1) {
                        this.safeMergeCells(table, 0, tableCols - 1, span, 1, false);
                    }
                    for (int r = 1; r < currentRow; ++r) {
                        if (span <= 1) continue;
                        this.safeMergeCells(table, r, tableCols - 1, span, 1, false);
                    }
                }
            }
        } else {
            table.insertCols(0, lastRow.getRow(0).count());
        }
        assert (table.rowCount() > 0);
        assert (table.getRow(0).count() > 0);
    }

    private void safeMergeCells(Table table, int topRow, int leftCol, int colSpan, int rowSpan, boolean changeBestWidth) {
        CellData cell = table.cells(topRow, leftCol);
        if (cell == null) {
            Table.MergeResult mResult = table.getMainCell(topRow, leftCol);
            cell = mResult.data;
            colSpan += leftCol - mResult.c;
            topRow = mResult.r;
            leftCol = mResult.c;
        }
        assert (cell != null);
        table.mergeCells(topRow, leftCol, colSpan, rowSpan, changeBestWidth);
    }

    private StyleColorResult scanStyleColor(String value) {
        StyleColorResult scResult = new StyleColorResult();
        scResult.value = false;
        Color.BasicColorDesc[] basicColors = Color.getBasicColorDesc();
        for (int i = 0; i < basicColors.length; ++i) {
            Color.BasicColorDesc bcd = basicColors[i];
            if (bcd.desc.compareToIgnoreCase(value) != 0) continue;
            scResult.r = (byte)(bcd.color & 0xFF);
            scResult.g = (byte)(bcd.color >> 8 & 0xFF);
            scResult.b = (byte)(bcd.color >> 16 & 0xFF);
            scResult.value = true;
            return scResult;
        }
        if (value.startsWith("rgb")) {
            int index2;
            int index1 = value.indexOf(40) + 1;
            if (index1 >= (index2 = value.indexOf(41))) {
                return scResult;
            }
            String[] strs = (value = value.substring(index1, index2)).split(",");
            if (strs.length >= 3) {
                scResult.r = (byte)ValueCaster.toInt(strs[0].trim());
                scResult.g = (byte)ValueCaster.toInt(strs[1].trim());
                scResult.b = (byte)ValueCaster.toInt(strs[2].trim());
                scResult.value = true;
            }
        } else if (value.startsWith("#")) {
            Object hex = value;
            if (((String)hex).length() >= 4 && ((String)hex).length() < 7) {
                hex = "#" + Strings.dup(value.charAt(1), 2) + Strings.dup(value.charAt(2), 2) + Strings.dup(value.charAt(3), 2);
            }
            if (((String)hex).length() >= 7) {
                int[] rgb = Color.hexToRgb((String)hex);
                scResult.r = (byte)rgb[0];
                scResult.g = (byte)rgb[1];
                scResult.b = (byte)rgb[2];
                scResult.value = true;
            }
        }
        return scResult;
    }

    private void readImage(Element el) throws Throwable {
        AttributeSizeUnit asUnit;
        String attrHeight;
        AttributeSizeUnit asUnit2;
        byte[] picContent = null;
        String attrSrc = el.attr("src");
        if (!Strings.isVoid(attrSrc)) {
            byte[] content;
            if (attrSrc.startsWith("cid:")) {
                attrSrc = attrSrc.substring(4, attrSrc.length());
            }
            if ((content = this.iObserverPicture.getImageContentById(attrSrc)) != null && content.length > 0) {
                picContent = content;
            }
        }
        if (picContent == null) {
            return;
        }
        Picture pic = new Picture();
        pic.content = picContent;
        String attrWidth = el.attr("width");
        if (!Strings.isVoid(attrWidth) && (asUnit2 = this.getValueByUnits(attrWidth, 0.0)) != null && asUnit2.unit != 1) {
            pic.width = ValueCaster.toInt(asUnit2.value);
        }
        if (!Strings.isVoid(attrHeight = el.attr("height")) && (asUnit = this.getValueByUnits(attrHeight, 0.0)) != null && asUnit.unit != 1) {
            pic.height = ValueCaster.toInt(asUnit.value);
        }
        this.addItem(pic);
    }

    private static class StyleColorResult {
        boolean value;
        byte r;
        byte g;
        byte b;

        private StyleColorResult() {
        }
    }

    private static class AttributeSizeUnit {
        int unit;
        double value;

        private AttributeSizeUnit() {
        }
    }

    private static class PairSI {
        String s;
        Integer value;

        private PairSI() {
        }
    }

    private static class TableProperties {
        Table table;
        Table lastRow;
        CellData prevData = null;
        int currentRow = -1;
        int currentCol = -1;
        boolean firstCell = false;
        boolean inheritedBorderWidth = true;

        private TableProperties() {
        }
    }

    private static class HyperTextMode {
        String link;

        private HyperTextMode() {
        }
    }

    private static class MarkerProperties {
        int listType = 0;
        boolean first = true;

        private MarkerProperties() {
        }
    }

    private static class ParagraphProperties {
        static final byte CONTINUE_PARA = 0;
        static final byte NEW_LINE = 1;
        static final byte NEW_PARA = 2;
        Style.Paragraph p;
        private byte position = (byte)2;

        private ParagraphProperties() {
        }

        byte position() {
            byte old = this.position;
            if (this.position == 2) {
                this.position = 0;
            }
            return old;
        }

        void setPosition(byte p) {
            this.position = p;
        }

        void resetPosition() {
            this.position = (byte)2;
        }
    }
}

