/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.taggedio.TaggedReader;
import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import java.io.IOException;

public class FunctionTerm
extends Term {
    protected int functionId = -1;
    protected Expression.Token token = Expression.Token.invalid;
    protected byte[] staticArgsContent = null;
    public static final int fnRoundTo = 0;
    public static final int fnMax = 1;
    public static final int fnMin = 2;
    public static final int fnTrim = 3;
    public static final int fnAbs = 4;
    public static final int fnSQLDay = 1001;
    public static final int fnSQLMonth = 1002;
    public static final int fnSQLYear = 1003;
    public static final int fnSQLHour = 1004;
    public static final int fnSQLMinute = 1005;
    public static final int fnSQLSecond = 1006;
    public static final int fnSQLDate = 1007;
    public static final int fnSQLQuarter = 1008;
    public static final int fnSQLMonthsBetween = 1009;
    public static final int fnSQLTruncDateYear = 1010;
    public static final int fnSQLTruncDateMonth = 1011;
    public static final int fnSQLTruncDateQuarter = 1012;
    public static final int fnSQLTruncDateHour = 1013;
    public static final int fnSQLToDate = 1014;
    public static final int fnSQLAddMonths = 1015;
    public static final int fnSQLDaysBetween = 1016;
    public static final int fnSQLTruncDateWeek = 1017;
    public static final int fnSQLAddDays = 1018;
    public static final int fnSQLDateValue = 1019;
    public static final int fnSQLMonthEndDate = 1020;
    public static final int fnSQLNVL = 1101;
    public static final int fnSQLBlobSize = 1102;
    public static final int fnSQLRound = 1103;
    public static final int fnSQLTrunc = 1104;
    public static final int fnSQLToNumber = 1105;
    public static final int fnSQLRegexpSubstr = 1106;
    public static final int fnSQLAddSeparators = 1107;
    public static final int fnSQLNumberToString = 1108;
    public static final int fnSQLCase = 1201;
    public static final int fnSQLExists = 1202;
    public static final int fnPrior = 1301;
    public static final int fnAgrSum = 1501;
    public static final int fnAgrAvg = 1502;
    public static final int fnAgrCount = 1503;
    public static final int fnAgrCountAll = 1504;
    public static final int fnAgrMin = 1505;
    public static final int fnAgrMax = 1506;
    public static final int fnCase = 4001;
    public static final int fnWhen = 4002;
    public static final int fnWebCase = 4001;
    public static final int fnWebWhen = 4002;
    public static final int fnWebStyle = 4003;
    public static final int fnDSIsEmpty = 4501;
    public static final int fnDSRecordIndex = 4502;
    public static final int fnDSRecordCount = 4503;

    public FunctionTerm(Expression expr) {
        super(expr);
    }

    @Override
    public final Term createClone(Expression e) {
        FunctionTerm t = new FunctionTerm(e);
        t.functionId = this.functionId;
        t.token = this.token;
        return t;
    }

    @Override
    public Expression.Token getToken() {
        return this.token;
    }

    @Override
    public Expression.Priority getPriority() {
        return Expression.Priority.FUNCTION;
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 6: {
                this.setFunctionId(in.getInt());
                break;
            }
            case 33: {
                this.staticArgsContent = in.getRaw();
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    @Override
    public void afterLoad() {
    }

    public int getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(int functionId) {
        this.functionId = functionId;
        switch (functionId) {
            case 0: {
                this.token = Expression.Token.functionRoundTo;
                break;
            }
            case 1: {
                this.token = Expression.Token.functionMax;
                break;
            }
            case 2: {
                this.token = Expression.Token.functionMin;
                break;
            }
            case 3: {
                this.token = Expression.Token.functionTrim;
                break;
            }
            case 4: {
                this.token = Expression.Token.functionAbs;
                break;
            }
            case 1001: {
                this.token = Expression.Token.functionDayOf;
                break;
            }
            case 1002: {
                this.token = Expression.Token.functionMonthOf;
                break;
            }
            case 1008: {
                this.token = Expression.Token.functionQuarterOf;
                break;
            }
            case 1003: {
                this.token = Expression.Token.functionYearOf;
                break;
            }
            case 1004: {
                this.token = Expression.Token.functionHourOf;
                break;
            }
            case 1005: {
                this.token = Expression.Token.functionMinuteOf;
                break;
            }
            case 1006: {
                this.token = Expression.Token.functionSecondOf;
                break;
            }
            case 1007: {
                this.token = Expression.Token.functionDateOf;
                break;
            }
            case 1016: {
                this.token = Expression.Token.functionDaysBetween;
                break;
            }
            case 1009: {
                this.token = Expression.Token.functionMonthsBetween;
                break;
            }
            case 1010: {
                this.token = Expression.Token.functionTruncDateYear;
                break;
            }
            case 1011: {
                this.token = Expression.Token.functionTruncDateMonth;
                break;
            }
            case 1012: {
                this.token = Expression.Token.functionTruncDateQuarter;
                break;
            }
            case 1017: {
                this.token = Expression.Token.functionTruncDateWeek;
                break;
            }
            case 1013: {
                this.token = Expression.Token.functionTruncDateHour;
                break;
            }
            case 1014: {
                this.token = Expression.Token.functionToDate;
                break;
            }
            case 1101: {
                this.token = Expression.Token.functionNVL;
                break;
            }
            case 1102: {
                this.token = Expression.Token.functionBlobSize;
                break;
            }
            case 1201: {
                this.token = Expression.Token.functionCase;
                break;
            }
            case 1202: {
                this.token = Expression.Token.functionExists;
                break;
            }
            case 1501: {
                this.token = Expression.Token.functionAgrSum;
                break;
            }
            case 1502: {
                this.token = Expression.Token.functionAgrAvg;
                break;
            }
            case 1503: {
                this.token = Expression.Token.functionAgrCount;
                break;
            }
            case 1504: {
                this.token = Expression.Token.functionAgrCountAll;
                break;
            }
            case 1505: {
                this.token = Expression.Token.functionAgrMin;
                break;
            }
            case 1506: {
                this.token = Expression.Token.functionAgrMax;
                break;
            }
            case 4001: {
                this.token = Expression.Token.functionCase;
                break;
            }
            case 4002: {
                this.token = Expression.Token.functionWhen;
                break;
            }
            case 1301: {
                this.token = Expression.Token.functionPrior;
                break;
            }
            case 1103: {
                this.token = Expression.Token.functionRoundTo;
                break;
            }
            case 1104: {
                this.token = Expression.Token.functionTrunc;
                break;
            }
            case 1105: {
                this.token = Expression.Token.functionToNumber;
                break;
            }
            case 1108: {
                this.token = Expression.Token.functionNumberToString;
                break;
            }
            case 1015: {
                this.token = Expression.Token.functionAddMonths;
                break;
            }
            case 1018: {
                this.token = Expression.Token.functionAddDays;
                break;
            }
            case 1106: {
                this.token = Expression.Token.functionRegexpSubstr;
                break;
            }
            case 1107: {
                this.token = Expression.Token.functionAddSeparators;
                break;
            }
            case 1019: {
                this.token = Expression.Token.functionDateValue;
                break;
            }
            case 1020: {
                this.token = Expression.Token.functionMonthEndDate;
                break;
            }
            default: {
                this.token = Expression.Token.invalid;
            }
        }
    }

    public byte[] getStaticArgsContent() {
        return this.staticArgsContent;
    }
}

