/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.taggedio.TaggedReader;
import inform.agent.expr.AbstractEvaluator;
import inform.agent.expr.Expression;
import inform.common.SmartScriptableObject;
import java.io.IOException;

public abstract class Term
extends SmartScriptableObject {
    protected final Expression<AbstractEvaluator> expression;
    protected int id = 0;
    protected String name = "";
    protected boolean ignored = false;
    protected static final int TAG_ELEMENT_ID = 1;
    protected static final int TAG_ELEMENT_NAME = 2;
    protected static final int TAG_ELEMENT_TAG = 3;
    protected static final int TAG_ELEMENT_OPERATION_KIND = 4;
    protected static final int TAG_ELEMENT_SYMBOL_KIND = 5;
    protected static final int TAG_ELEMENT_FUNCTION_ID = 6;
    protected static final int TAG_ELEMENT_CONSTANT_TEXT_VAL = 7;
    protected static final int TAG_ELEMENT_CONSTANT_IS_INSERT = 8;
    protected static final int TAG_ELEMENT_ARGUMENT_ASSIGN_TYPE = 9;
    protected static final int TAG_ELEMENT_ARGUMENT_GLOBAL_CONST_ID = 10;
    protected static final int TAG_ELEMENT_ARGUMENT_PARAM_ID = 11;
    protected static final int TAG_ELEMENT_ARGUMENT_DATASOURCE_ID = 12;
    protected static final int TAG_ELEMENT_ARGUMENT_FIELD_ID = 13;
    protected static final int TAG_ELEMENT_ARGUMENT_FIELD_ID_PATH = 14;
    protected static final int TAG_ELEMENT_CAPTION = 15;
    protected static final int TAG_ELEMENT_COLLAPSED = 16;
    protected static final int TAG_ELEMENT_CONSTANT_NUMBER_VAL = 17;
    protected static final int TAG_ELEMENT_CONSTANT_DATETIME_VAL = 18;
    protected static final int TAG_ELEMENT_CONSTANT_BOOL_VAL = 19;
    protected static final int TAG_ELEMENT_CONSTANT_IS_NULL = 20;
    protected static final int TAG_ELEMENT_CONSTANT_DATATYPE = 21;
    protected static final int TAG_ELEMENT_INSERT_VALUE = 25;
    protected static final int TAG_ELEMENT_OPERATION_RANGE = 26;
    protected static final int TAG_ELEMENT_OPERATION_RANGE_ANY = 27;
    protected static final int TAG_ELEMENT_CONSTANT_COLOR_VAL = 28;
    protected static final int TAG_ELEMENT_CONSTANT_FONT_STYLE = 29;
    protected static final int TAG_ELEMENT_DS_PROP_DATASOURCE_ID = 30;
    protected static final int TAG_ELEMENT_DS_PROP_PROP_ID = 31;
    protected static final int TAG_ELEMENT_ARGUMENT_SUB_ID = 32;
    protected static final int TAG_ELEMENT_FUNCTION_ARGS = 33;

    public Term(Expression expr) {
        this.setParentScope(expr);
        this.expression = expr;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public abstract Expression.Token getToken();

    public abstract Expression.Priority getPriority();

    public abstract void afterLoad();

    public abstract Term createClone(Expression var1);

    protected void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 1: {
                this.id = in.getInt();
                break;
            }
            case 2: {
                this.name = in.getString();
            }
        }
    }

    public final void load(TaggedReader in) throws IOException {
        while (in.next()) {
            this.loadTag(in);
        }
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setScriptName(String name) {
        this.name = name == null ? "" : name;
    }

    @SmartScriptableObject.PropertyTag
    public String getName() {
        return this.name;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }
}

