/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.files.request;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.files.BFS;
import java.io.File;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.util.Arrays;

public class DownloadBlobFile
extends Request {
    public static final int CHUNK_SIZE = 2000000;
    private RandomAccessFile file = null;
    private MessageDigest md;
    private TaggedWriter out;
    final ByteArrayOutputStream result = new ByteArrayOutputStream();
    private byte[] chunk = null;

    public DownloadBlobFile(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws Throwable {
        this.md = MessageDigest.getInstance("SHA-1");
        if (this.md == null) {
            throw new IllegalStateException();
        }
        TableDescriptor table = TableDescriptor.get(this.getNodeID());
        boolean recordIdValid = false;
        FieldDescriptor field = null;
        this.out = new TaggedWriter(this.result);
        try {
            TaggedReader in = this.createRequestContentReader();
            block19: while (in.next()) {
                switch (in.getCurrentTag()) {
                    case 4: {
                        int fieldId = in.getInt();
                        field = table.getExistingFieldDescriptor(fieldId);
                        BFS.checkBlobFSField(table, field);
                        break;
                    }
                    case 8: {
                        File filePath;
                        if (field == null) {
                            throw new IllegalStateException();
                        }
                        double recordId = in.getDouble();
                        recordIdValid = true;
                        DatabaseConnection connection = table.getDatabaseDescriptor().connect(this, "rq:DownloadBlobFile");
                        try {
                            String path = BFS.selectBlobPath(null, connection, table, field, recordId);
                            if (Strings.isVoid(path)) {
                                this.out.putLong(1, 0L);
                                this.out.flush();
                                this.sendResult(this.result.internalBuffer(), this.result.size());
                                return;
                            }
                            String blobPath = field.getBlobFS() + ":/" + path;
                            filePath = new File(Core.blobfs.resolvePath(blobPath));
                            if (!filePath.exists()) {
                                throw new InformException("\u0412 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0431\u043b\u043e\u0431-\u0444\u0430\u0439\u043b " + blobPath);
                            }
                            this.file = new RandomAccessFile(filePath, "r");
                            if (this.file.length() == 0L) {
                                this.out.putLong(1, 0L);
                                this.out.flush();
                                this.sendResult(this.result.internalBuffer(), this.result.size());
                                return;
                            }
                            this.file.seek(0L);
                            this.out.putLong(1, this.file.length());
                            this.out.flush();
                            this.sendChunk(this.result.internalBuffer(), this.result.size());
                            this.result.reset();
                            this.out.reset(this.result);
                            continue block19;
                        }
                        finally {
                            connection.close();
                            continue block19;
                        }
                    }
                    case 3: {
                        if (field == null) {
                            throw new IllegalStateException();
                        }
                        byte[] fileDigest = in.getRaw();
                        recordIdValid = true;
                        String path = BFS.getFullTempPath(table, field, fileDigest);
                        String blobPath = field.getBlobFS() + ":/" + path;
                        File filePath = new File(Core.blobfs.resolvePath(blobPath));
                        if (!filePath.exists()) {
                            this.out.putLong(1, 0L);
                            this.out.flush();
                            this.sendResult(this.result.internalBuffer(), this.result.size());
                            return;
                        }
                        this.file = new RandomAccessFile(filePath, "r");
                        if (this.file.length() == 0L) {
                            this.out.putLong(1, 0L);
                            this.out.flush();
                            this.sendResult(this.result.internalBuffer(), this.result.size());
                            return;
                        }
                        this.file.seek(0L);
                        this.out.putLong(1, this.file.length());
                        this.out.flush();
                        this.sendChunk(this.result.internalBuffer(), this.result.size());
                        this.result.reset();
                        this.out.reset(this.result);
                        break;
                    }
                    case 9: {
                        if (recordIdValid) break;
                        throw new IllegalStateException();
                    }
                    case 2: {
                        int chunkSize = in.getInt();
                        byte[] digest = in.getRaw(5);
                        this.processDigest(chunkSize, digest);
                        continue block19;
                    }
                }
            }
            this.processFileRest();
            if (this.file != null) return;
            throw new IllegalStateException();
        }
        finally {
            if (this.file != null) {
                this.file.close();
            }
        }
    }

    private void processDigest(int size, byte[] digest) throws Exception {
        if (this.file == null) {
            throw new IllegalStateException();
        }
        if (this.md == null) {
            throw new IllegalStateException();
        }
        if (this.chunk == null || this.chunk.length < size) {
            this.chunk = new byte[size];
        }
        long offset = this.file.getFilePointer();
        int chunkSize = this.file.read(this.chunk, 0, this.chunk.length);
        if (chunkSize < 0) {
            chunkSize = 0;
        }
        byte[] chunkDigest = null;
        if (chunkSize == size) {
            this.md.reset();
            this.md.update(this.chunk, 0, size);
            chunkDigest = this.md.digest();
        }
        if (chunkSize != size || !Arrays.equals(chunkDigest, digest)) {
            this.out.putLong(7, offset);
            this.out.putRaw(10, this.chunk, chunkSize);
            this.out.flush();
            this.sendChunk(this.result.internalBuffer(), this.result.size());
            this.result.reset();
            this.out.reset(this.result);
        } else {
            this.out.putLong(11, offset);
            this.out.flush();
            this.sendChunk(this.result.internalBuffer(), this.result.size());
            this.result.reset();
            this.out.reset(this.result);
        }
    }

    private void processFileRest() throws Exception {
        int size;
        if (this.file == null) {
            throw new IllegalStateException();
        }
        if (this.chunk == null || this.chunk.length < 2000000) {
            this.chunk = new byte[2000000];
        }
        do {
            long offset = this.file.getFilePointer();
            size = this.file.read(this.chunk, 0, this.chunk.length);
            if (size <= 0) continue;
            this.out.putLong(7, offset);
            this.out.putRaw(10, this.chunk, size);
            this.out.flush();
            this.sendChunk(this.result.internalBuffer(), this.result.size());
            this.result.reset();
            this.out.reset(this.result);
        } while (size >= 0);
    }
}

