/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.js;

import inform.adt.taggedio.TaggedWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class Serialization {
    public static final int TAG_BEGIN_OBJECT = 1;
    public static final int TAG_END_OBJECT = 2;
    public static final int TAG_BEGIN_ARRAY = 3;
    public static final int TAG_END_ARRAY = 4;
    public static final int TAG_BEGIN_FIELD = 5;
    public static final int TAG_END_FIELD = 6;
    public static final int TAG_OBJECT_ID = 7;
    public static final int TAG_STRING_VALUE = 9;
    public static final int TAG_NUMBER_VALUE = 10;
    public static final int TAG_BOOLEAN_VALUE = 11;
    public static final int TAG_DATE_VALUE = 12;
    public static final int TAG_ID = 13;
    public static final int TAG_VOID_VALUE = 14;
    public static final int TAG_NULL_VALUE = 15;
    private static final String ARRAY = "Array";
    private static final String FUNCTION = "Function";
    private static final String DATE = "Date";
    private static final String OBJECT = "Object";
    private HashMap<NativeObject, Integer> ObjectsTable = new HashMap();
    private int curIndex = 0;

    private void WriteNativeArray(NativeArray array, TaggedWriter writer) throws IOException {
        int i = 0;
        while ((long)i < array.getLength()) {
            this.Serialize(array.get(i, (Scriptable)array), writer, "", true);
            ++i;
        }
    }

    public void Serialize(String ParamName, Scriptable scope, TaggedWriter writer) throws IOException {
        this.Serialize(scope.get(ParamName, scope), writer);
    }

    public void Serialize(Object obj, TaggedWriter writer) throws IOException {
        this.Serialize(obj, writer, "", false);
    }

    public void Serialize(Object obj, TaggedWriter writer, String fieldName, boolean addNotFound) throws IOException {
        if (obj == Scriptable.NOT_FOUND) {
            if (addNotFound) {
                writer.putString(5, fieldName);
                writer.putEmpty(6);
            } else {
                return;
            }
        }
        if (obj == null) {
            writer.putString(5, fieldName);
            writer.putEmpty(15);
            writer.putEmpty(6);
        } else if (obj instanceof Scriptable) {
            Scriptable scriptObj = (Scriptable)obj;
            if (scriptObj.getClassName().equals(FUNCTION)) {
                return;
            }
            if (scriptObj.getClassName().equals(ARRAY)) {
                writer.putString(3, fieldName);
                this.WriteNativeArray((NativeArray)scriptObj, writer);
                writer.putEmpty(4);
                return;
            }
            if (scriptObj.getClassName().equals(DATE)) {
                writer.putString(5, fieldName);
                Date date = new Date((long)Context.toNumber(obj));
                writer.putDate(12, date);
                writer.putEmpty(6);
                return;
            }
            if (scriptObj.getClassName().equals(OBJECT)) {
                writer.putString(1, fieldName);
                NativeObject nativeObj = (NativeObject)scriptObj;
                Integer index = this.ObjectsTable.get(nativeObj);
                if (index == null) {
                    this.ObjectsTable.put(nativeObj, this.curIndex);
                    writer.putInt32(7, this.curIndex);
                    ++this.curIndex;
                } else {
                    writer.putInt32(7, index);
                    writer.putEmpty(2);
                    return;
                }
                Object[] ids = nativeObj.getIds();
                for (int i = 0; i < ids.length; ++i) {
                    Object o = nativeObj.get(ids[i].toString(), scriptObj);
                    this.Serialize(o, writer, ids[i].toString(), false);
                }
                writer.putEmpty(2);
                return;
            }
        } else if (obj instanceof Number) {
            writer.putString(5, fieldName);
            writer.putDouble(10, Context.toNumber(obj));
            writer.putEmpty(6);
        } else if (obj instanceof Boolean) {
            writer.putString(5, fieldName);
            writer.putBool(11, Context.toBoolean(obj));
            writer.putEmpty(6);
        } else if (obj instanceof String || obj instanceof ConsString) {
            writer.putString(5, fieldName);
            writer.putString(9, Context.toString(obj));
            writer.putEmpty(6);
        }
    }
}

