/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedWriter;
import java.security.MessageDigest;
import java.util.Arrays;

public class Security {
    public static final int MD5_HASH_LEN = 16;
    public static final int MD5_SALT_LEN = 8;
    public static final int SHA256_HASH_LEN = 32;
    public static final int SHA256_SALT_LEN = 16;
    private static final byte separator = 58;

    public static byte[] newMD5Hash() {
        return new byte[16];
    }

    public static byte[] newMD5Salt() {
        return new byte[8];
    }

    public static byte[] newSha256Hash() {
        return new byte[32];
    }

    public static byte[] newSha256Salt() {
        return new byte[16];
    }

    private static int rand() {
        return (int)Math.floor(Math.random() * 256.0);
    }

    public static byte[] generateSalt() throws InformException {
        String s = String.format("%02X%02X%02X%02X", Security.rand(), Security.rand(), Security.rand(), Security.rand());
        byte[] salt = s.getBytes(TaggedWriter.UTF8);
        assert (salt.length == 8);
        return salt;
    }

    public static byte[] calculateH1(String login, String password, byte[] salt) throws InformException {
        try {
            byte[] l = login.getBytes(TaggedWriter.ANSI);
            byte[] p = password.getBytes(TaggedWriter.ANSI);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(l);
            md.update((byte)58);
            md.update(salt);
            md.update((byte)58);
            md.update(p);
            byte[] h1 = Security.newMD5Hash();
            md.digest(h1, 0, h1.length);
            return h1;
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
    }

    public static byte[] calculateH2(byte[] h1, byte[] disposableKey) throws InformException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(h1);
            md.update((byte)58);
            md.update(disposableKey);
            byte[] h2 = Security.newMD5Hash();
            md.digest(h2, 0, h2.length);
            return h2;
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
    }

    public static boolean isHashEquals(byte[] h1, byte[] h2) {
        if (h1 == null || h2 == null) {
            return false;
        }
        return Arrays.equals(h1, h2);
    }

    public static byte[] sha256GenerateSalt() throws InformException {
        String s = String.format("%02X%02X%02X%02X%02X%02X%02X%02X", Security.rand(), Security.rand(), Security.rand(), Security.rand(), Security.rand(), Security.rand(), Security.rand(), Security.rand());
        byte[] salt = s.getBytes(TaggedWriter.UTF8);
        assert (salt.length == 16);
        return salt;
    }

    public static byte[] sha256CalculateH1(String login, String password, byte[] salt) throws InformException {
        try {
            byte[] l = login.getBytes(TaggedWriter.ANSI);
            byte[] p = password.getBytes(TaggedWriter.ANSI);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(l);
            md.update((byte)58);
            md.update(salt);
            md.update((byte)58);
            md.update(p);
            byte[] h1 = Security.newSha256Hash();
            md.digest(h1, 0, h1.length);
            return h1;
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
    }

    public static byte[] sha256CalculateH2(byte[] h1, byte[] disposableKey) throws InformException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(h1);
            md.update((byte)58);
            md.update(disposableKey);
            byte[] h2 = Security.newSha256Hash();
            md.digest(h2, 0, h2.length);
            return h2;
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
    }
}

