/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlParameter;
import java.sql.SQLException;
import java.util.BitSet;

public class SystemTable {
    protected TableDescriptor table = null;
    protected boolean enabled = false;
    protected static final int[] keyTypes = new int[]{DataType.PRIMARY_KEY.toInt(), DataType.FLOAT.toInt(), DataType.DIRECTORY.toInt(), DataType.METATREE_NODE.toInt()};
    protected static final int[] strTypes = new int[]{DataType.STRING.toInt()};
    protected static final int[] metaTypes = new int[]{DataType.METATREE_NODE.toInt()};
    protected static final int[] dblTypes = new int[]{DataType.FLOAT.toInt()};
    protected static final int[] boolTypes = new int[]{DataType.BOOLEAN.toInt()};
    protected static final int[] blobTypes = new int[]{DataType.BLOB.toInt()};
    protected static final int[] intTypes = new int[]{DataType.INTEGER.toInt(), DataType.FLOAT.toInt()};
    protected static final int[] dateTypes = new int[]{DataType.DATE_TIME.toInt()};

    public TableDescriptor table() {
        return this.table;
    }

    public boolean enabled() {
        return this.enabled && this.table != null;
    }

    protected SqlParameter[] readSelect(ResultSet fetch, FieldDescriptor[] fields) throws SQLException {
        int col = 0;
        SqlParameter[] values = new SqlParameter[fields.length];
        block7: for (int tf = 0; tf < fields.length; ++tf) {
            FieldDescriptor f = fields[tf];
            if (f == null) continue;
            ++col;
            SqlDataType type = f.getType().toSqlDataType();
            switch (type) {
                case BOOLEAN: {
                    values[tf] = new SqlParameter().setId(tf).setBoolean(fetch.getBoolean(col));
                    if (!fetch.wasNull()) continue block7;
                    values[tf].setNull();
                    continue block7;
                }
                case INTEGER: 
                case DOUBLE: {
                    values[tf] = new SqlParameter().setId(tf).setDouble(fetch.getAsDouble(col));
                    if (!fetch.wasNull()) continue block7;
                    values[tf].setNull();
                    continue block7;
                }
                case STRING: 
                case UNICODE: {
                    values[tf] = new SqlParameter().setId(tf).setString(fetch.getString(col));
                    continue block7;
                }
                case DATE_TIME: 
                case TIMESTAMP: {
                    values[tf] = new SqlParameter().setId(tf).setDateTime(fetch.getDateTime(col));
                    if (!fetch.wasNull()) continue block7;
                    values[tf].setNull();
                    continue block7;
                }
                case BLOB: 
                case GEOMETRY: {
                    values[tf] = new SqlParameter().setId(tf).setBlob(fetch.getBlobBytes(col));
                }
            }
        }
        return values;
    }

    protected static class SystemFieldDesc {
        public final String name;
        private final BitSet validTypes = new BitSet();
        private boolean pk = false;

        public SystemFieldDesc(String name, int[] types) {
            this.name = name;
            for (int type : types) {
                if (type == DataType.PRIMARY_KEY.toInt()) {
                    this.pk = true;
                    continue;
                }
                this.validTypes.set(type);
            }
        }

        public boolean isValid(int type) {
            if (type == DataType.PRIMARY_KEY.toInt()) {
                return this.pk;
            }
            return this.validTypes.get(type);
        }
    }
}

