/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Ini;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.SystemNode;
import inform.agent.mtd.request.ValidateLicense;
import inform.agent.web.HttpServer;
import java.io.IOException;
import java.sql.SQLException;

public class ServerNode
extends SystemNode {
    private Descriptor descriptor;

    public ServerNode(NodeRecord record) {
        super(record);
        assert (record.getType() == 6);
        assert (record.getId() == 2.0);
    }

    public Descriptor descriptor() {
        if (this.descriptor == null) {
            try {
                this.descriptor = new Descriptor(new TaggedReader(this.getContent()));
            }
            catch (IOException e) {
                throw InformException.wrap(e);
            }
        }
        return this.descriptor;
    }

    @Override
    public void setContent(byte[] buffer, String dslContent, Node.ModifyNodeArg arg) throws SQLException {
        Descriptor d;
        try {
            d = new Descriptor(new TaggedReader(buffer));
            new UsersTable(d);
        }
        catch (Throwable t) {
            throw InformException.wrap(t);
        }
        super.setContent(buffer, dslContent, arg);
        HttpServer.serverNodeUpdated(d);
        this.descriptor = d;
    }

    public static class Descriptor {
        private static final int TAG_PASSWORD_LENGTH_LIMIT = 2;
        private static final int TAG_PASSWORD_PERIOD = 3;
        private static final int TAG_PASSWORD_OPTIONS = 4;
        private static final int TAG_PASSWORD_REQUIRE_CHANGE_IFEMPTY = 5;
        private static final int TAG_FAILED_LOGIN_COUNT = 6;
        private static final int TAG_USER_STARTUP_SCRIPT = 7;
        private static final int TAG_ALL_USER_SINGLE_LOGIN = 8;
        private static final int TAG_REALM = 9;
        private static final int TAG_WEB_USER = 10;
        private static final int TAG_WEB_SESSION_TIMEOUT = 11;
        private static final int TAG_USERS_TABLE = 12;
        public static final int TAG_SYSTEM_TABLE_ID = 1;
        public static final int TAG_SYSTEM_TABLE_FIELD = 2;
        public static final int TAG_SYSTEM_TABLE_FIELD_ID = 3;
        public static final int TAG_SYSTEM_TABLE_USE = 4;
        private static final int TAG_WEB_DEFAULT_NODE = 13;
        private static final int TAG_WEB_EMPTY_PASSWORDS = 14;
        private static final int TAG_NTLM = 16;
        private static final int TAG_ADMIN_NOTIFY_MODULE = 17;
        private static final int TAG_REQUIRED_ROOT_NODE = 18;
        private static final int TAG_LICENCE = 24;
        private static final int TAG_SOAP_USER = 25;
        private static final int TAG_ROLES_TABLE = 26;
        private static final int TAG_LDAP_SETTING = 28;
        private static final int TAG_LDAP_SETTING_USE_LDAP = 1;
        public static final int TAG_LDAP_SETTING_USER_TEMPLATE = 2;
        public static final int TAG_LDAP_SETTING_MODULE = 3;
        public static final int TAG_LDAP_SETTING_MODULE_PARAM = 4;
        public static final int TAG_LDAP_SETTING_USER_ACTUAL_PERIOD = 5;
        private static final int TAG_RECV_NODES_TABLE = 29;
        private static final int TAG_REPLICATION_CHANNELS_TABLE = 30;
        private static final int TAG_TIME_ZONE_OFFSET_SEC = 31;
        private static final int TAG_TIME_ZONE_OFFSET_VALID = 32;
        public final int passwordPeriod;
        public final boolean requiredChangeEmptyPassword;
        public final int failedLoginCount;
        public final double userStartupScript;
        public final boolean allUserSingleLogin;
        public final String realm;
        public final boolean ntlm;
        public final double webUser;
        public final double soapUser;
        public final int webSessionTimeout;
        public final byte[] usersTable;
        public final byte[] rolesTable;
        public final byte[] channelTable;
        public final byte[] receivingTable;
        public final double webDefaultNode;
        public final boolean webAllowEmptyPasswords;
        public final boolean useUsersTable;
        public final boolean useRolesTable;
        public final double adminNotifyModule;
        public final boolean requiredRootNode;
        public final String licence;
        public final boolean useLDAP;
        public final byte[] ldap;
        public final boolean useTimeZone;
        public final int timeZoneOffsetSec;

        public Descriptor(TaggedReader reader) throws IOException, TaggedReaderException {
            int pp = Ini.authPeriodValidity;
            int flc = Ini.authFailCount;
            int wst = 0;
            boolean rcep = Ini.authPasswordNotEmpty;
            boolean ausl = false;
            boolean waep = false;
            boolean ntl = false;
            double uss = 0.0;
            double wu = 0.0;
            double su = 0.0;
            double wdn = 0.0;
            String rlm = null;
            byte[] ut = null;
            byte[] rt = null;
            byte[] ct = null;
            byte[] rnt = null;
            String l = null;
            boolean useUsersTable = false;
            boolean useRolesTable = false;
            double anm = 0.0;
            boolean requiredRootNode = false;
            boolean useLDAP = false;
            byte[] ldap = null;
            boolean useTimeZone = false;
            int timeZoneOffsetSec = 10800;
            double templateId = 0.0;
            TaggedReader stream = null;
            while (reader.next()) {
                block0 : switch (reader.getCurrentTag()) {
                    case 3: {
                        if (pp > 0) break;
                        pp = reader.getInt();
                        break;
                    }
                    case 5: {
                        rcep = true;
                        break;
                    }
                    case 6: {
                        if (flc > 0) break;
                        flc = reader.getInt();
                        break;
                    }
                    case 7: {
                        reader.skip();
                        uss = reader.getDouble(151);
                        break;
                    }
                    case 8: {
                        ausl = true;
                        break;
                    }
                    case 18: {
                        requiredRootNode = true;
                        break;
                    }
                    case 9: {
                        rlm = reader.getAnsi();
                        break;
                    }
                    case 16: {
                        ntl = true;
                        break;
                    }
                    case 10: {
                        reader.skip();
                        wu = reader.getDouble(151);
                        break;
                    }
                    case 25: {
                        reader.skip();
                        su = reader.getDouble(151);
                        break;
                    }
                    case 11: {
                        wst = reader.getInt();
                        break;
                    }
                    case 13: {
                        reader.skip();
                        wdn = reader.getDouble(151);
                        break;
                    }
                    case 14: {
                        waep = true;
                        break;
                    }
                    case 12: {
                        ut = reader.getSubStreamData();
                        useUsersTable = false;
                        stream = new TaggedReader(ut);
                        while (stream.next()) {
                            if (stream.getCurrentTag() != 4) continue;
                            useUsersTable = stream.getBoolean();
                            break block0;
                        }
                        break;
                    }
                    case 17: {
                        anm = reader.getNodeID();
                        break;
                    }
                    case 24: {
                        l = reader.getString();
                        break;
                    }
                    case 26: {
                        rt = reader.getSubStreamData();
                        useRolesTable = false;
                        stream = new TaggedReader(ut);
                        while (stream.next()) {
                            if (stream.getCurrentTag() != 4) continue;
                            useRolesTable = stream.getBoolean();
                            break block0;
                        }
                        break;
                    }
                    case 28: {
                        ldap = reader.getSubStreamData();
                        useLDAP = false;
                        stream = new TaggedReader(ldap);
                        while (stream.next()) {
                            if (stream.getCurrentTag() != 1) continue;
                            useLDAP = true;
                            break block0;
                        }
                        break;
                    }
                    case 29: {
                        rnt = reader.getSubStreamData();
                        break;
                    }
                    case 30: {
                        ct = reader.getSubStreamData();
                        break;
                    }
                    case 32: {
                        useTimeZone = true;
                        break;
                    }
                    case 31: {
                        timeZoneOffsetSec = reader.getInt();
                    }
                }
            }
            switch (Ini.httpAuth) {
                case 1: {
                    ntl = true;
                    break;
                }
                case 2: {
                    ntl = false;
                    break;
                }
            }
            this.passwordPeriod = pp;
            this.requiredChangeEmptyPassword = rcep;
            this.failedLoginCount = flc;
            this.userStartupScript = uss;
            this.allUserSingleLogin = ausl;
            this.realm = rlm;
            this.ntlm = ntl;
            this.webUser = wu;
            this.soapUser = su;
            this.webSessionTimeout = wst;
            this.webDefaultNode = wdn;
            this.usersTable = ut;
            this.rolesTable = rt;
            this.channelTable = ct;
            this.receivingTable = rnt;
            this.useUsersTable = useUsersTable;
            this.useRolesTable = useRolesTable;
            this.webAllowEmptyPasswords = waep;
            this.adminNotifyModule = anm;
            this.requiredRootNode = requiredRootNode;
            this.licence = l;
            this.useLDAP = useLDAP;
            this.ldap = ldap;
            this.useTimeZone = useTimeZone;
            this.timeZoneOffsetSec = timeZoneOffsetSec;
        }

        public int maxConnectionCount() {
            if (this.licence == null) {
                return Ini.MaxConnectionCount;
            }
            int mcc = ValidateLicense.validate(7, this.licence);
            if (Ini.MaxConnectionCount > 0 && mcc > Ini.MaxConnectionCount) {
                return Ini.MaxConnectionCount;
            }
            return mcc;
        }
    }
}

