/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DAccessRights;
import inform.agent.mtd.obj.DDatamodel;
import inform.agent.mtd.obj.DDatasources;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import inform.common.UniqueStrings;
import java.io.IOException;

public class DDatamodelNode
extends DObject
implements UniqueStrings {
    protected final DDatamodelNode parent;
    protected final DPropertyEnum nodeType = new DPropertyEnum(this, "type", 32772, DATAMODEL_NODE_TYPE_NAMES);
    protected final DPropertyInt uid = new DPropertyInt(this, "uid", 32768);
    protected final DPropertyDouble unique = new DPropertyDouble(this, "unique", 0);
    protected final DAccessRights accessRights = new DAccessRights(this, "accessRights");
    protected final DPropertyString scriptName = new DPropertyString(this, "name", 0x200002);
    protected final DPropertyString description = new DPropertyString(this, "description", 0x200002);
    protected final DDatasources datasources = new DDatasources(this);

    public DDatamodelNode(DProperty object, String name, int propOptions, DDatamodelNode parent, String dsl) {
        super(object, name, propOptions);
        this.parent = parent;
        this.dsl = dsl;
    }

    public StringBuilder storeNamedNodes(StringBuilder out) {
        for (DProperty property : this.datasources.properties) {
            if (!(property instanceof DDatamodelNode)) continue;
            ((DDatamodelNode)property).storeNamedNodes(out);
        }
        if (this.isTextNameStorable()) {
            this.storeTextContent(4, out, 0, false);
        }
        return out;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        while (in.next()) {
            this.loadTag(in);
        }
    }

    protected void internalStoreTaggedContent(TaggedWriter out) throws IOException {
        this.uid.storeTaggedContentAs(1, out);
        this.scriptName.storeTaggedContentAs(5, out);
        this.description.storeTaggedContentAs(7, out);
        this.unique.storeTaggedContentAs(8, out);
        this.accessRights.storeTaggedContentAs(154, out);
    }

    protected void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 1: {
                this.uid.loadTaggedContent(in);
                break;
            }
            case 5: {
                this.scriptName.loadScriptName(this, in);
                break;
            }
            case 7: {
                this.description.loadTaggedContent(in);
                break;
            }
            case 8: {
                this.unique.loadTaggedContent(in);
                break;
            }
            case 154: {
                this.accessRights.loadTaggedContent(in);
                break;
            }
            default: {
                this.addUnhandled().loadTaggedContent(in);
            }
        }
    }

    protected DDatamodelNode find(int uid) {
        if (this.uid.value == uid) {
            return this;
        }
        return this.datasources.find(uid);
    }

    protected DDatamodel getDatamodel() {
        if (this.parent != null) {
            return this.parent.getDatamodel();
        }
        throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043c\u043e\u0434\u0435\u043b\u044c \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430");
    }

    @Override
    public String addUniqueString(String value) {
        return this.parent != null ? this.parent.addUniqueString(value) : "";
    }

    @Override
    public boolean canAddUniqueString(String value) {
        return this.parent != null && this.parent.canAddUniqueString(value);
    }

    @Override
    public void doAssign(DItem obj) {
        if (DDatamodelNode.checkAssignType(obj, this.getClass())) {
            DDatamodelNode sourceItem = (DDatamodelNode)obj;
            for (DProperty p : sourceItem.properties) {
                if (!(p instanceof DDatamodelNode)) continue;
                DDatamodelNode sourceNode = (DDatamodelNode)p;
                DDatamodelNode node = this.getDatamodel().createNode(sourceNode.nodeType.value, this);
                node.assign(sourceNode);
            }
            if (sourceItem.scriptModifiedProperties != null && !sourceItem.scriptModifiedProperties.isEmpty()) {
                for (String n : sourceItem.scriptModifiedProperties) {
                    DProperty p = (DProperty)this.propertyByName.get(n);
                    DProperty s = (DProperty)sourceItem.propertyByName.get(n);
                    p.assign(s);
                }
            }
        }
    }
}

