/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DDatasourceSynchronizer;
import inform.agent.mtd.obj.DFormControl;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.DPropertyValues;
import java.io.IOException;
import java.util.ArrayList;

public class DFormMetaTree
extends DFormControl {
    protected final DPropertyDouble rootNodeId = new DPropertyDouble(this, "rootNodeId", 2);
    protected final DPropertyBool autoSize = new DPropertyBool(this, "autoSize", 4098, false);
    protected final DPropertyBool allowLaunchNodes = new DPropertyBool(this, "allowLaunchNodes", 4098, true);
    protected final DPropertyBool tabStop = new DPropertyBool(this, "tabStop", 4098, true);
    protected final DPropertyInt borderWidth = new DPropertyInt(this, "borderWidth", 32770);
    protected final DPropertyInt bevelWidth = new DPropertyInt(this, "bevelWidth", 32770);
    protected final DPropertyInt modalResult = new DPropertyInt(this, "modalResult", 32770);
    protected final DPropertyInt nodeTypeFilter = new DPropertyInt(this, "nodeTypeFilter", 32770);
    protected final DPropertyInt popupMenuLayout = new DPropertyInt(this, "popupMenuLayout", 32770);
    protected final DPropertyInt popupMenuItems = new DPropertyInt(this, "popupMenuItems", 32770);
    protected final DPropertyInt bevelInner = new DPropertyInt(this, "bevelInner", 131074);
    protected final DPropertyInt bevelOuter = new DPropertyInt(this, "bevelOuter", 131074);
    protected final DPropertyInt bevelKind = new DPropertyInt(this, "bevelKind", 131074);
    protected final DPropertyInt tabOrder = new DPropertyInt(this, "tabOrder", 32770);
    protected final DPropertyString onSelectNode = new DPropertyString(this, "onSelectNode", 0x200002);
    protected final DPropertyString onDoubleClick = new DPropertyString(this, "onDoubleClick", 0x200002);
    protected final DDatasourceSynchronizer datasourceSyncList = new DDatasourceSynchronizer(this, "datasourceSyncList");
    protected final DPropertyEnum dataType = new DPropertyEnum(this, "dataType", 4, 1, DATA_TYPE_VALUES, DATA_TYPE_NAMES);
    protected final DPropertyValues allowContextMenuValues = new DPropertyValues((DProperty)this, "allowContextMenuValues", this.dataType);
    protected final DPropertyValues allowDragDropValues = new DPropertyValues((DProperty)this, "allowDragDropValues", this.dataType);

    public DFormMetaTree(int id, int left, int top, int right, int bottom, int options) {
        super(17, id, left, top, right, bottom, options);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        int tag;
        block21: while ((tag = in.getNextTag()) != 0) {
            switch (tag) {
                case 41: {
                    this.autoSize.value = true;
                    continue block21;
                }
                case 42: {
                    this.borderWidth.loadTaggedContent(in);
                    continue block21;
                }
                case 44: {
                    this.tabStop.value = false;
                    continue block21;
                }
                case 45: {
                    this.tabOrder.loadTaggedContent(in);
                    continue block21;
                }
                case 46: {
                    this.bevelInner.loadTaggedContent(in);
                    continue block21;
                }
                case 47: {
                    this.bevelOuter.loadTaggedContent(in);
                    continue block21;
                }
                case 48: {
                    this.bevelWidth.loadTaggedContent(in);
                    continue block21;
                }
                case 49: {
                    this.bevelKind.loadTaggedContent(in);
                    continue block21;
                }
                case 51: {
                    this.rootNodeId.loadTaggedContent(in);
                    continue block21;
                }
                case 52: {
                    this.datasourceSyncList.loadTaggedContent(in.getSubStreamReader());
                    continue block21;
                }
                case 53: {
                    this.allowLaunchNodes.value = false;
                    continue block21;
                }
                case 54: {
                    this.modalResult.loadTaggedContent(in);
                    continue block21;
                }
                case 55: {
                    this.nodeTypeFilter.loadTaggedContent(in);
                    continue block21;
                }
                case 56: {
                    this.onSelectNode.loadTaggedContent(in);
                    continue block21;
                }
                case 57: {
                    this.onDoubleClick.loadTaggedContent(in);
                    continue block21;
                }
                case 58: {
                    this.loadValues(in.getSubStreamReader(), this.allowContextMenuValues.value);
                    continue block21;
                }
                case 59: {
                    this.loadValues(in.getSubStreamReader(), this.allowDragDropValues.value);
                    continue block21;
                }
                case 60: {
                    this.popupMenuLayout.loadTaggedContent(in);
                    continue block21;
                }
                case 61: {
                    this.popupMenuItems.loadTaggedContent(in);
                    continue block21;
                }
            }
            super.loadTag(in);
        }
    }

    @Override
    public void storeTaggedContent(int[] header, TaggedWriter out) throws IOException {
        this.getHeader(header);
        this.borderWidth.storeTaggedContentAs(42, out);
        this.bevelWidth.storeTaggedContentAs(48, out);
        this.bevelInner.storeTaggedContentAs(46, out);
        this.bevelOuter.storeTaggedContentAs(47, out);
        this.bevelKind.storeTaggedContentAs(49, out);
        this.rootNodeId.storeTaggedContentAs(51, out);
        this.modalResult.storeTaggedContentAs(54, out);
        this.nodeTypeFilter.storeTaggedContentAs(55, out);
        this.popupMenuLayout.storeTaggedContentAs(60, out);
        this.popupMenuItems.storeTaggedContentAs(61, out);
        this.tabOrder.storeTaggedContentAs(45, out);
        this.onSelectNode.storeTaggedContentAs(56, out);
        this.onDoubleClick.storeTaggedContentAs(57, out);
        this.datasourceSyncList.storeTaggedContentAs(52, out);
        this.storeValues(out, this.allowContextMenuValues.value, 58);
        this.storeValues(out, this.allowDragDropValues.value, 59);
        if (this.autoSize.value) {
            out.putEmpty(41);
        }
        if (!this.tabStop.value) {
            out.putEmpty(44);
        }
        if (!this.allowLaunchNodes.value) {
            out.putEmpty(53);
        }
    }

    private void loadValues(TaggedReader in, ArrayList<Object> values) throws IOException {
        while (in.next()) {
            if (in.getCurrentTag() != 1) continue;
            values.add(in.getInt());
        }
    }

    private void storeValues(TaggedWriter out, ArrayList<Object> values, int tag) throws IOException {
        if (!values.isEmpty()) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(data);
            for (Object obj : values) {
                stream.putInt32(1, ValueCaster.toInt(obj));
            }
            stream.flush();
            if (data.size() != 0) {
                out.putEmpty(tag);
                out.putRaw(202, data);
            }
        }
    }
}

