/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DGridFooterCell;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import java.io.IOException;

public class DGridColumnFooter
extends DArray {
    public DGridColumnFooter(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DGridFooterCell item = new DGridFooterCell(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DGridColumnFooter.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DGridColumnFooter)source).properties) {
                if (!DGridColumnFooter.checkAssignType(sourceProperty, DGridFooterCell.class)) continue;
                DGridFooterCell sourceCell = (DGridFooterCell)sourceProperty;
                DGridFooterCell footerCell = new DGridFooterCell(this);
                footerCell.assign(sourceCell);
                this.properties.add(footerCell);
            }
        }
    }

    @Override
    public DProperty getDefaultArrayItem() {
        return new DGridFooterCell(this);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        DGridFooterCell footerCell = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    footerCell = new DGridFooterCell(this);
                    this.properties.add(footerCell);
                    break;
                }
                case 2: {
                    if (footerCell == null) break;
                    footerCell.font.loadTaggedContent(in);
                    break;
                }
                case 3: {
                    if (footerCell == null) break;
                    footerCell.parentFont.value = true;
                    break;
                }
                case 4: {
                    if (footerCell == null) break;
                    footerCell.color.loadTaggedContent(in);
                    break;
                }
                case 5: {
                    if (footerCell == null) break;
                    footerCell.summaryFunction.loadTaggedContent(in);
                    break;
                }
                case 6: {
                    if (footerCell == null) break;
                    footerCell.onGetData.loadTaggedContent(in);
                }
            }
        }
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        this.storeTaggedContent(stream);
        stream.flush();
        if (data.size() != 0) {
            out.putRaw(tag, data);
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        for (DProperty p : this.properties) {
            if (!(p instanceof DGridFooterCell)) continue;
            DGridFooterCell footerCell = (DGridFooterCell)p;
            out.putEmpty(1);
            footerCell.storeTaggedContent(out);
        }
    }
}

