/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DGridColumn;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import java.io.IOException;

public class DGridColumns
extends DArray {
    public int columnsCount;

    public DGridColumns(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DGridColumn item = new DGridColumn(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DGridColumns.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DGridColumns)source).properties) {
                if (!DGridColumns.checkAssignType(sourceProperty, DGridColumn.class)) continue;
                DGridColumn sourceColumn = (DGridColumn)sourceProperty;
                DGridColumn column = new DGridColumn(this);
                column.assign(sourceColumn);
                this.properties.add(column);
            }
        }
    }

    @Override
    public DProperty getDefaultArrayItem() {
        return new DGridColumn(this);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        while (in.next() && this.properties.size() < this.columnsCount) {
            if (in.getCurrentTag() != 44) continue;
            DGridColumn column = new DGridColumn(this);
            column.loadTaggedContent(in);
            this.properties.add(column);
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        int count = this.properties.size();
        out.putInt32(41, count);
        for (DProperty p : this.properties) {
            if (!(p instanceof DGridColumn)) continue;
            out.putEmpty(44);
            DGridColumn column = (DGridColumn)p;
            column.storeTaggedContent(out);
            out.putEmpty(45);
        }
    }
}

