/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.RawObject;
import java.util.ArrayList;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptableObject;

public class DObject
extends DProperty {
    ArrayList<String> scriptModifiedProperties = null;

    public DObject(DProperty object, String name) {
        this(object, name, 0);
    }

    public DObject(DProperty object, String name, int propOptions) {
        super(object, name, propOptions);
    }

    @Override
    public boolean isEmpty() {
        return this.isArray() && this.properties.isEmpty();
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    public StringBuilder storeTextName(StringBuilder out) {
        throw new IllegalStateException();
    }

    public boolean isTextNameStorable() {
        return false;
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        StringBuilder props;
        int propCount;
        boolean textNameStorable = this.isTextNameStorable();
        if (this.isDefault() && ((textOptions & 4) == 0 || !textNameStorable)) {
            return 0;
        }
        int propLevel = level + 1;
        if (textNameStorable && (textOptions & 4) == 0) {
            propCount = 1;
            props = null;
        } else {
            props = new StringBuilder();
            propCount += this.storeTextContentProperties(((propCount = this.unhandledItems.size()) == 0 ? 1 : 0) | textOptions & 0x10, props, propLevel);
        }
        if (propCount > 1) {
            textOptions &= 0xFFFFFFFE;
        }
        if (textNameStorable) {
            DObject.addTextShiftLn(textOptions | 8, out, level);
            if ((textOptions & 4) == 0) {
                if (!Strings.isVoid(this.name)) {
                    out.append(this.name).append(": ");
                }
                DObject.addComma(this.storeTextName(out), needComma);
                return 1;
            }
            this.storeTextName(out.append("const ")).append(" = ");
        } else if (!Strings.isVoid(this.name)) {
            DObject.addTextShiftLn(textOptions, out, level);
            out.append(this.name).append(": ");
        }
        if (!this.unhandledItems.isEmpty()) {
            if ((textOptions & 2) != 0 || propCount - this.unhandledItems.size() > 0) {
                props.append(',');
            }
            DObject.addTextShiftLn(textOptions, props, propLevel);
            props.append("unknownTags:");
            DObject.addTextShiftLn(textOptions, props, propLevel).append('[');
            int lastIndex = this.unhandledItems.size() - 1;
            for (int index = 0; index <= lastIndex; ++index) {
                RawObject item = (RawObject)this.unhandledItems.get(index);
                item.storeTextContent(textOptions, props, level + 2, index != lastIndex);
            }
            DObject.addTextShiftLn(textOptions, props, propLevel).append("]");
        }
        if (this.isArray()) {
            if (propCount > 1) {
                DObject.addTextShiftLn(textOptions, out, level);
            }
            out.append('[');
        } else if (!Strings.isVoid(this.dsl)) {
            if (!textNameStorable && propCount > 1) {
                DObject.addTextShiftLn(textOptions, out, level);
            }
            out.append(this.dsl);
            if (propCount > 1) {
                DObject.addTextShiftLn(textOptions | 8, out, level);
            }
            out.append("({");
        } else {
            if (propCount > 1) {
                DObject.addTextShiftLn(textOptions | 8, out, level);
            } else {
                DObject.addTextShift(textOptions, out, level);
            }
            out.append('{');
        }
        if (propCount > 1 && props.charAt(0) != '\n') {
            out.append('\n');
        }
        out.append((CharSequence)props);
        if (propCount > 1) {
            DObject.addTextShiftLn(textOptions | 8, out, level);
        }
        if (this.isArray()) {
            out.append(']');
        } else {
            out.append('}');
            if (!Strings.isVoid(this.dsl)) {
                out.append(')');
            }
        }
        if (textNameStorable) {
            out.append(';');
            return 0;
        }
        DObject.addComma(out, needComma);
        return propCount;
    }

    @Override
    public int storeSpec(int textOptions, StringBuilder out, int level, boolean needComma) {
        if ((textOptions & 0x10) == 0) {
            DObject.addTextShiftLn(textOptions, out, level).append(this.name).append(": ");
        }
        DObject.addTextShiftLn(textOptions, out, level).append("{");
        boolean comma = false;
        for (DProperty prop : this.properties) {
            if (this.properties.isEmpty()) continue;
            if (this.object != null && this.object.getClass().isInstance(prop)) {
                DObject.addComma(out, comma);
                DObject.addTextShiftLn(textOptions, out, level + 1).append(prop.name).append(": ").append("{ ").append("... ").append("}");
                continue;
            }
            DObject.addComma(out, comma);
            prop.storeSpec(0, out, level + 1, false);
            comma = true;
        }
        DObject.addTextShiftLn(textOptions, out, level).append("}");
        return 1;
    }

    @Override
    protected void doAssign(DItem obj) {
        if (DObject.checkAssignType(obj, this.getClass())) {
            DObject source = (DObject)obj;
            if (this.isArray()) {
                throw new InformException("\u0414\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430-\u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u0442\u0438\u043f\u0430 " + this.getClass().getName() + " \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d \u043c\u0435\u0442\u043e\u0434 doAssign");
            }
            if (source.scriptModifiedProperties != null && !source.scriptModifiedProperties.isEmpty()) {
                for (String n : source.scriptModifiedProperties) {
                    DProperty p = (DProperty)this.propertyByName.get(n);
                    DProperty s = (DProperty)source.propertyByName.get(n);
                    p.assign(s);
                }
            }
        }
    }

    @Override
    public void assign(DItem obj) {
        this.doAssign(obj);
        this.scriptModifiedProperties = ((DObject)obj).scriptModifiedProperties;
    }

    @Override
    public void loadScriptContent(ScriptableObject obj) {
        block3: {
            block4: {
                block2: {
                    if (!(obj instanceof DObject)) break block2;
                    this.assign((DObject)obj);
                    break block3;
                }
                if (!this.isArray()) break block4;
                if (!(obj instanceof NativeArray)) break block3;
                NativeArray array = (NativeArray)obj;
                this.properties.clear();
                long count = array.getLength();
                for (long index = 0L; index < count; ++index) {
                    DProperty p = this.loadScriptArrayItem(array.get(index));
                    this.properties.add(p);
                }
                break block3;
            }
            this.scriptModifiedProperties = new ArrayList();
            for (DProperty p : this.properties) {
                if (Strings.isVoid(p.name) || !obj.has(p.name, null)) continue;
                p.loadScriptValue(obj.get(p.name, null));
                this.scriptModifiedProperties.add(p.name);
            }
        }
    }
}

