/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DFieldPathItem;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DParameter;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyInt;
import java.io.IOException;

public class DParameters
extends DArray {
    protected final Kind kind;
    protected final String parameterDsl;
    private int maxParamId = 0;

    public DParameters(DProperty object, Kind kind, String parameterDsl) {
        super(object, "parameters", 6);
        this.kind = kind;
        this.parameterDsl = parameterDsl;
    }

    public DParameter fineParameter(int paramId) {
        for (DProperty property : this.properties) {
            if (!(property instanceof DParameter)) continue;
            DParameter parameter = (DParameter)property;
            if (parameter.id.value != paramId) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public boolean isTextNameStorable() {
        return true;
    }

    @Override
    public StringBuilder storeTextName(StringBuilder out) {
        return out.append(this.name);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        DFieldPathItem pathItem = null;
        DFieldPathItem selItem = null;
        DParameter param = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    in.checkCurrentTag(1, 8);
                    byte[] raw = in.getRaw();
                    int offset = 0;
                    param = new DParameter(this);
                    this.properties.add(param);
                    param.id.value = LittleEndian.getInt(raw, offset);
                    param.dataType.value = LittleEndian.getInt(raw, offset += 4);
                    if (this.maxParamId >= param.id.value) break;
                    this.maxParamId = param.id.value;
                    break;
                }
                case 2: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.caption.loadTaggedContent(in);
                    break;
                }
                case 16: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.scriptName.loadTaggedContent(in);
                    break;
                }
                case 3: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.format.loadTaggedContent(in);
                    break;
                }
                case 4: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    pathItem = new DFieldPathItem(param.association);
                    param.association.properties.add(pathItem);
                    pathItem.field.loadTaggedContent(in);
                    pathItem.table.loadTaggedContent(in);
                    break;
                }
                case 36: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.associationActualPointParam.loadTaggedContent(in);
                    break;
                }
                case 19: {
                    if (in.getNextTag() != 151) {
                        in.tagback();
                        break;
                    }
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    pathItem = new DFieldPathItem(param.association);
                    param.association.properties.add(pathItem);
                    pathItem.table.loadTaggedContent(in);
                    break;
                }
                case 18: {
                    if (param == null || pathItem == null) {
                        throw new IllegalStateException();
                    }
                    pathItem.field.loadTaggedContent(in);
                    break;
                }
                case 31: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    selItem = new DFieldPathItem(param.selectedField);
                    param.selectedField.properties.add(selItem);
                    selItem.table.loadTaggedContent(in);
                    if (in.getNextTag() == 151) {
                        selItem.table.loadTaggedContent(in);
                        break;
                    }
                    in.tagback();
                    break;
                }
                case 30: {
                    if (param == null || selItem == null) {
                        throw new IllegalStateException();
                    }
                    selItem.field.loadTaggedContent(in);
                    break;
                }
                case 41: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.displayExpression.loadTaggedContent(in.getStreamReader());
                    break;
                }
                case 6: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.hidden.loadTaggedContent(in);
                    break;
                }
                case 22: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.notNull.loadTaggedContent(in);
                    break;
                }
                case 23: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.singleValue.loadTaggedContent(in);
                    break;
                }
                case 7: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.ignored.loadTaggedContent(in);
                    break;
                }
                case 8: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.group.loadTaggedContent(in);
                    break;
                }
                case 9: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.dateFunction.loadTaggedContent(in);
                    break;
                }
                case 17: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.constant.loadTaggedContent(in);
                    break;
                }
                case 21: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.param.loadTaggedContent(in);
                    break;
                }
                case 15: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.clear();
                    break;
                }
                case 14: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(null);
                    break;
                }
                case 10: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getInt());
                    break;
                }
                case 25: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.assocForm.node.loadTaggedContent(in);
                    if (in.getNextTag() == 151) {
                        param.assocForm.node.loadTaggedContent(in);
                        break;
                    }
                    in.tagback();
                    break;
                }
                case 26: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.assocForm.parameters.loadTaggedContent(in.getSubStreamReader());
                    break;
                }
                case 27: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.assocForm.datasource.loadTaggedContent(in);
                    break;
                }
                case 28: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.assocForm.field.loadTaggedContent(in);
                    break;
                }
                case 29: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.assocForm.control.loadTaggedContent(in);
                    break;
                }
                case 11: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getDouble());
                    break;
                }
                case 12: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getString());
                    break;
                }
                case 13: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getDate(Core.serverTimeZoneHost));
                    break;
                }
                case 32: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.associateDatasource.loadTaggedContent(in);
                    break;
                }
                case 33: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.associateField.loadTaggedContent(in);
                    break;
                }
                case 34: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    DPropertyInt intProp = new DPropertyInt(param.nodeTypes, null, 32800);
                    param.nodeTypes.properties.add(intProp);
                    intProp.loadTaggedContent(in);
                    break;
                }
                case 38: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getRaw());
                    break;
                }
                case 37: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.returning.loadTaggedContent(in);
                    break;
                }
                case 39: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.storeKind.value = 1;
                    break;
                }
                case 42: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.storeKind.loadTaggedContent(in);
                    break;
                }
                case 40: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.withFileDialog.loadTaggedContent(in);
                    break;
                }
                case 43: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.notes.loadTaggedContent(in);
                }
            }
        }
    }

    @Override
    protected void doAssign(DItem source) {
        if (DParameters.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DParameters)source).properties) {
                if (!DParameters.checkAssignType(sourceProperty, DParameter.class)) continue;
                DParameter sourceParameter = (DParameter)sourceProperty;
                DParameter parameter = new DParameter(this);
                parameter.assign(sourceParameter);
                this.properties.add(parameter);
            }
        }
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        if (DParameters.checkAssignType(obj, DParameter.class)) {
            return (DParameter)obj;
        }
        return null;
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        if (this.isDefault()) {
            return;
        }
        out.putEmpty(150);
        for (DProperty p : this.properties) {
            if (!(p instanceof DParameter)) continue;
            ((DParameter)p).storeTaggedContent(out);
        }
    }

    @Override
    public DProperty getDefaultArrayItem() {
        return new DParameter(null, Kind.Client, this.parameterDsl);
    }

    public static enum Kind {
        Client,
        Server;

    }
}

