/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import java.io.IOException;

public class DPropertyDouble
extends DProperty {
    protected double value;
    protected double defaultValue;

    public DPropertyDouble(DProperty object, String name, int propOptions) {
        this(object, name, propOptions, 0.0);
    }

    public DPropertyDouble(DProperty object, String name, int propOptions, double defaultValue) {
        super(object, name, propOptions);
        this.value = this.defaultValue = defaultValue;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public boolean isEmpty() {
        return this.value == 0.0;
    }

    @Override
    public boolean isDefault() {
        return this.checkPropOptions(2) && this.value == this.defaultValue;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        this.value = in.getDouble();
    }

    @Override
    protected void doAssign(DItem source) {
        if (DPropertyDouble.checkAssignType(source, this.getClass())) {
            this.value = ((DPropertyDouble)source).value;
        }
    }

    @Override
    public void loadScriptValue(Object obj) {
        this.value = ValueCaster.toDouble(obj);
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        if (!this.isStorable() || this.isDefault()) {
            return;
        }
        out.putDouble(tag, this.value);
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        DPropertyDouble.addComma(DPropertyDouble.addComment(DPropertyDouble.textContentAddProp(textOptions, out, level, this.name, this.value), this.getComment()), needComma);
        return 1;
    }

    @Override
    public int storeSpec(int textOptions, StringBuilder out, int level, boolean needComma) {
        DPropertyDouble.addComma(DPropertyDouble.textContentAddPropName(textOptions, out, level, this.name, "double"), needComma);
        return 1;
    }

    protected String getComment() {
        return null;
    }
}

