/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.Strings;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.mtd.obj.DComponentContainer;
import inform.agent.mtd.obj.DDatamodel;
import inform.agent.mtd.obj.DDatamodelNode;
import inform.agent.mtd.obj.DDatasource;
import inform.agent.mtd.obj.DParameter;
import inform.agent.mtd.obj.DParameters;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyInt;

public class DPropertyField
extends DPropertyInt {
    protected final DDatamodelNode datasource;
    protected final DPropertyInt uid;
    protected final DPropertyDouble tableNodeId;

    public DPropertyField(DProperty object, String name, int tagOption, DDatamodelNode datasource) {
        super(object, name, 0x8000 | tagOption);
        this.datasource = datasource;
        this.uid = null;
        this.tableNodeId = null;
    }

    public DPropertyField(DProperty object, String name, int tagOption, DPropertyInt uid) {
        super(object, name, 0x8000 | tagOption);
        this.datasource = null;
        this.uid = uid;
        this.tableNodeId = null;
    }

    public DPropertyField(DProperty object, String name, int tagOption, DPropertyDouble tableNodeId) {
        super(object, name, 0x8000 | tagOption);
        this.datasource = null;
        this.uid = null;
        this.tableNodeId = tableNodeId;
    }

    @Override
    protected String getComment() {
        if (this.value != 0) {
            FieldDescriptor field;
            TableDescriptor table;
            DComponentContainer componentContainer;
            double tableId = 0.0;
            if (this.tableNodeId != null) {
                tableId = this.tableNodeId.value;
            } else if (this.datasource instanceof DDatasource) {
                tableId = ((DDatasource)this.datasource).tableNode.value;
            } else if (this.datasource instanceof DDatamodel) {
                DDatamodel datamodel = (DDatamodel)this.datasource;
                for (DProperty p : datamodel.parameters.properties) {
                    if (!(p instanceof DParameters)) continue;
                    DParameter parameter = (DParameter)p;
                    if (parameter.id.value != this.value) continue;
                    String caption = parameter.caption.value;
                    String scriptMame = parameter.scriptName.value;
                    if (Strings.isVoid(caption)) {
                        return Strings.isVoid(scriptMame) ? null : "[" + scriptMame + "]";
                    }
                    if (Strings.isVoid(this.name)) {
                        return caption;
                    }
                    return caption + " [" + scriptMame + "]";
                }
            } else if (this.uid != null && this.uid.value != 0 && (componentContainer = this.getComponentContainer()) != null) {
                if (this.uid.value == -1) {
                    DParameter parameter = componentContainer.findParameter(this.value);
                    if (parameter != null) {
                        String n = parameter.scriptName.value;
                        if (!Strings.isVoid(n)) {
                            return parameter.caption.value + " [" + n + "]";
                        }
                        return parameter.caption.value;
                    }
                } else {
                    DDatasource datasource = componentContainer.findDatasource(this.uid.value);
                    if (datasource != null) {
                        tableId = datasource.tableNode.value;
                    }
                }
            }
            if (tableId != 0.0 && (table = TableDescriptor.getIfExists(tableId)) != null && (field = table.getFieldDescriptor(this.value)) != null) {
                String n = field.getIdent();
                if (!Strings.isVoid(n)) {
                    return field.getCaption() + " [" + n + "]";
                }
                return field.getCaption();
            }
            return "???";
        }
        return null;
    }
}

