/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.common.Empty;
import inform.common.UniqueStrings;
import java.io.IOException;

public class DPropertyString
extends DProperty {
    protected String value;
    protected String defaultValue;

    public DPropertyString(DProperty object, String name, int tagOption) {
        this(object, name, tagOption, "");
    }

    public DPropertyString(DProperty object, String name, int tagOption, String defaultValue) {
        super(object, name, tagOption);
        this.value = this.defaultValue = Empty.notNull(defaultValue);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = Empty.notNull(value);
    }

    public void setScriptName(UniqueStrings uniqueStrings, String value) {
        this.value = uniqueStrings.addUniqueString(value);
    }

    public void assignValue(Object value) {
        this.value = ValueCaster.toString(value);
    }

    @Override
    public boolean isEmpty() {
        return Strings.isVoid(this.value);
    }

    @Override
    public boolean isDefault() {
        if (!this.checkPropOptions(2)) {
            return false;
        }
        if (this.value == null) {
            return true;
        }
        if (this.defaultValue == null) {
            return false;
        }
        return this.value.equals(this.defaultValue);
    }

    public void loadScriptName(UniqueStrings names, TaggedReader in) throws IOException {
        String value = this.checkPropOptions(524288) ? in.getAnsi() : (this.checkPropOptions(0x100000) ? in.getUnicode() : in.getString());
        if (!Strings.isVoid(value)) {
            this.value = names.addUniqueString(value);
        }
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        this.value = this.checkPropOptions(524288) ? in.getAnsi() : (this.checkPropOptions(0x100000) ? in.getUnicode() : in.getString());
        int count = this.value.length();
        for (int index = 0; index < count; ++index) {
            char ch = this.value.charAt(index);
            if (ch != '\u0000') continue;
            StringBuilder s = new StringBuilder();
            s.append('\"');
            block11: for (int i = 0; i < count; ++i) {
                ch = this.value.charAt(i);
                switch (ch) {
                    case '\t': {
                        s.append("\\t");
                        continue block11;
                    }
                    case '\b': {
                        s.append("\\b");
                        continue block11;
                    }
                    case '\n': {
                        s.append("\\n");
                        continue block11;
                    }
                    case '\r': {
                        s.append("\\r");
                        continue block11;
                    }
                    case '\f': {
                        s.append("\\f");
                        continue block11;
                    }
                    case '\'': {
                        s.append("\\'");
                        continue block11;
                    }
                    case '\"': {
                        s.append("\\\"");
                        continue block11;
                    }
                    case '\\': {
                        s.append("\\\\");
                        continue block11;
                    }
                    default: {
                        if (ch < ' ') {
                            s.append("\\0x").append(String.format("%02x", ch));
                            continue block11;
                        }
                        s.append(ch);
                    }
                }
            }
            s.append('\"');
            this.value = s.toString();
            this.propOptions |= 0x400000;
            break;
        }
    }

    @Override
    protected void doAssign(DItem source) {
        if (DPropertyString.checkAssignType(source, this.getClass())) {
            this.value = ((DPropertyString)source).value;
        }
    }

    @Override
    public void loadScriptValue(Object obj) {
        this.value = ValueCaster.toString(obj);
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        if (!this.isStorable() || this.isDefault()) {
            return;
        }
        if (this.checkPropOptions(524288)) {
            out.putAnsi(tag, this.value);
        } else if (this.checkPropOptions(0x100000)) {
            out.putUnicode(tag, this.value);
        } else {
            out.putString(tag, this.value);
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        if (this.checkPropOptions(0x400000)) {
            DPropertyString.addComma(DPropertyString.addTextShiftLn(textOptions, out, level).append(this.name).append(": ").append(this.value), needComma);
        } else {
            DPropertyString.addComma(DPropertyString.textContentAddProp(textOptions, out, level, this.name, this.value), needComma);
        }
        return 1;
    }

    @Override
    public int storeSpec(int textOptions, StringBuilder out, int level, boolean needComma) {
        DPropertyString.addComma(DPropertyString.textContentAddPropName(textOptions, out, level, this.name, "string"), needComma);
        return 1;
    }
}

