/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.DateTime;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyValues;
import java.io.IOException;
import java.util.Date;

public class DPropertyValue
extends DProperty {
    protected Type type = Type.Null;
    protected Object value = null;

    public DPropertyValue(DProperty object, String name, int propOptions) {
        super(object, name, propOptions);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        this.value = null;
    }

    public void setDataType(DataType dataType) {
        switch (dataType.getSqlType()) {
            case 4: 
            case 16: {
                this.type = Type.Integer;
                break;
            }
            case 8: {
                this.type = Type.Double;
                break;
            }
            case 91: {
                this.type = Type.Date;
                break;
            }
            case -9: 
            case 12: {
                this.type = Type.String;
                break;
            }
            default: {
                this.type = Type.Null;
            }
        }
        this.value = null;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isDefault() {
        return this.type != null;
    }

    @Override
    public boolean isStorable() {
        return this.type != null && super.isStorable();
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        if (this.type != null) {
            switch (this.type) {
                case Null: {
                    this.value = null;
                    break;
                }
                case Integer: {
                    this.value = in.getInt();
                    break;
                }
                case Double: 
                case Date: {
                    this.value = in.getDouble();
                    break;
                }
                case String: {
                    this.value = in.getString();
                    break;
                }
            }
        }
    }

    @Override
    public void loadScriptValue(Object obj) {
        if (obj == null) {
            this.type = Type.Null;
            this.value = null;
        } else {
            switch (this.type) {
                case Null: {
                    this.value = null;
                    break;
                }
                case Integer: {
                    this.value = DPropertyValues.getCastedValue(DataType.INTEGER, obj);
                    break;
                }
                case Double: {
                    this.value = DPropertyValues.getCastedValue(DataType.FLOAT, obj);
                    break;
                }
                case Date: {
                    this.value = DPropertyValues.getCastedValue(DataType.DATE_TIME, obj);
                    break;
                }
                case String: {
                    this.value = DPropertyValues.getCastedValue(DataType.STRING, obj);
                    break;
                }
            }
        }
    }

    @Override
    protected void doAssign(DItem obj) {
        if (DPropertyValue.checkAssignType(obj, this.getClass())) {
            DPropertyValue source = (DPropertyValue)obj;
            this.value = source.value;
            this.type = source.type;
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        if (this.isStorable()) {
            switch (this.type) {
                case Integer: {
                    DPropertyValue.addComma(DPropertyValue.addComment(DPropertyValue.textContentAddProp(textOptions, out, level, this.name, ValueCaster.toInt(this.value)), this.getComment()), needComma);
                    return 1;
                }
                case Double: {
                    DPropertyValue.addComma(DPropertyValue.addComment(DPropertyValue.textContentAddProp(textOptions, out, level, this.name, ValueCaster.toDouble(this.value)), this.getComment()), needComma);
                    return 1;
                }
                case Date: {
                    Date date = ValueCaster.toDate(this.value);
                    DPropertyValue.addComma(DPropertyValue.addComment(DPropertyValue.addTextShiftLn(textOptions, out, level).append(this.name).append(": ").append('\"').append(DPropertyValues.createFormat(DateTime.fromUnixTime(date.getTime())).format(date)).append('\"'), this.getComment()), needComma);
                    return 1;
                }
                case String: {
                    DPropertyValue.addComma(DPropertyValue.addComment(DPropertyValue.textContentAddProp(textOptions, out, level, this.name, ValueCaster.toString(this.value)), this.getComment()), needComma);
                    return 1;
                }
                case Null: {
                    DPropertyValue.addComma(DPropertyValue.addComment(DPropertyValue.textContentAddProp(textOptions, out, level, this.name, "null"), this.getComment()), needComma);
                    return 1;
                }
            }
        }
        return 0;
    }

    protected String getComment() {
        return null;
    }

    public static enum Type {
        Null,
        Integer,
        Double,
        Date,
        String;

    }
}

