/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.TableDescriptor;
import inform.agent.db.sql.engine.Search;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DParameter;
import inform.agent.mtd.obj.DParameters;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.DReturnedFields;
import inform.agent.mtd.obj.search.DSearchDatabaseOptions;
import inform.agent.mtd.obj.search.DSearchEntries;
import inform.agent.mtd.obj.search.DSearchEntryContainer;
import inform.agent.mtd.obj.search.DSearchRoot;
import inform.agent.mtd.obj.search.DSearchSorting;
import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptableObject;

public class DSearch
extends DObject {
    public static final String JS_SEARCH = "search";
    public static final String SEARCH_LIB = "MtdSearch";
    public static final String DSL_SEARCH = "MtdSearch.search";
    public static final String DSL_SEARCH_PARAMETER = "MtdSearch.parameter";
    public static final String[] KIND_NAMES = new String[]{"standard", "advanced", "procedure"};
    public static final String[] GENERATION_TYPE_NAMES = new String[]{"default", "cpp", "java"};
    public static final String[] ENTRY_EXCLUSION_NAMES = new String[]{"default", "withParent"};
    public static final String[] AGGREGATE_FUNCTION_NAMES = new String[]{"sum", "count_all", "count", "min", "max", "avg", "string_agg"};
    private TableDescriptor rootTableDescriptor = null;
    protected String script = "";
    protected final DPropertyEnum kind = new DPropertyEnum((DProperty)this, "kind", 33280, Search.Kind.Standard.toInt(), KIND_NAMES);
    protected final DPropertyEnum generationType = new DPropertyEnum(this, "generationType", 32770, GENERATION_TYPE_NAMES);
    protected final DPropertyBool distinct = new DPropertyBool(this, "distinct", 4098);
    protected final DPropertyBool hierarchic = new DPropertyBool(this, "hierarchic", 4098);
    protected final DPropertyBool orderSiblings = new DPropertyBool(this, "orderSiblings", 4098);
    protected final DPropertyBool convertFieldExprArgs = new DPropertyBool(this, "convertFieldExprArgs", 8194);
    protected final DPropertyInt fetchLimit = new DPropertyInt(this, "fetchLimit", 32770, -1);
    protected final DPropertyEnum entryExclusion = new DPropertyEnum(this, "entryExclusion", 32770, ENTRY_EXCLUSION_NAMES);
    protected final DPropertyString procedure = new DPropertyString(this, "procedure", 0x200002);
    protected final DParameters parameters = new DParameters((DProperty)this, DParameters.Kind.Client, "MtdSearch.parameter");
    protected final DPropertyBool inlineParams = new DPropertyBool(this, "inlineParams", 4098);
    protected final DReturnedFields resultFields = new DReturnedFields((DProperty)this, "resultFields", null);
    protected final DSearchDatabaseOptions databaseOptions = new DSearchDatabaseOptions(this, "databaseOptions", 2);
    protected final DSearchSorting sorting = new DSearchSorting(this, "sorting");
    protected final DSearchRoot root = new DSearchRoot((DProperty)this, this, 4);

    public DSearch() {
        super(null, null);
    }

    public static DSearchEntryContainer findEntryContainer(DProperty property) {
        if (property.object instanceof DSearchEntryContainer) {
            return (DSearchEntryContainer)((Object)property.object);
        }
        if (property.object != null) {
            return DSearch.findEntryContainer(property.object);
        }
        return null;
    }

    public static DParameter findSearchParameter(DProperty property, int paramId) {
        if (property.object instanceof DSearch) {
            return ((DSearch)property.object).parameters.fineParameter(paramId);
        }
        if (property.object != null) {
            return DSearch.findSearchParameter(property.object, paramId);
        }
        return null;
    }

    public double getRootTableId() {
        return this.root.rootEntry.tableId;
    }

    public TableDescriptor getRootTableDescriptor() {
        if (this.rootTableDescriptor == null) {
            this.rootTableDescriptor = TableDescriptor.getIfExists(this.root.rootEntry.tableId);
        }
        return this.rootTableDescriptor;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        block26: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 8: {
                    this.kind.setValue(Search.Kind.Advanced.toInt());
                    continue block26;
                }
                case 15: {
                    this.kind.loadTaggedContent(in);
                    if (Search.Kind.fromInt(this.kind.getValue()) != null) continue block26;
                    this.kind.setValue(Search.Kind.Advanced.toInt());
                    continue block26;
                }
                case 16: {
                    this.procedure.loadTaggedContent(in);
                    continue block26;
                }
                case 9: {
                    this.distinct.loadTaggedContent(in);
                    continue block26;
                }
                case 2: {
                    DSearchEntries.loadEntries(this.root.rootEntry, this.root, null, null, in.getSubStreamReader());
                    continue block26;
                }
                case 11: {
                    DSearchEntries.loadEntries(null, this.root, null, this.root.subjects, in.getSubStreamReader());
                    continue block26;
                }
                case 6: {
                    this.root.fields.loadTaggedContent(in.getSubStreamReader());
                    continue block26;
                }
                case 14: {
                    this.hierarchic.loadTaggedContent(in);
                    continue block26;
                }
                case 18: {
                    this.orderSiblings.loadTaggedContent(in);
                    continue block26;
                }
                case 19: {
                    this.fetchLimit.loadTaggedContent(in);
                    continue block26;
                }
                case 20: {
                    this.sorting.loadTaggedContent(in.getSubStreamReader());
                    continue block26;
                }
                case 153: {
                    this.parameters.loadTaggedContent(in.getSubStreamReader());
                    continue block26;
                }
                case 21: {
                    this.entryExclusion.loadTaggedContent(in);
                    continue block26;
                }
                case 23: {
                    this.inlineParams.loadTaggedContent(in);
                    continue block26;
                }
                case 24: {
                    this.resultFields.loadTaggedContent(in.getSubStreamReader());
                    continue block26;
                }
                case 25: {
                    TaggedReader stream = in.getSubStreamReader();
                    while (stream.next()) {
                        switch (stream.getCurrentTag()) {
                            case 1: {
                                this.databaseOptions.oracle.indexCaching.loadTaggedContent(in);
                                break;
                            }
                            case 2: {
                                this.databaseOptions.oracle.indexCostAdj.loadTaggedContent(in);
                                break;
                            }
                            case 3: {
                                this.databaseOptions.oracle.hint.loadTaggedContent(in);
                                break;
                            }
                            case 4: {
                                this.databaseOptions.oracle.leading.loadTaggedContent(in);
                            }
                        }
                    }
                    continue block26;
                }
                case 27: {
                    this.generationType.loadTaggedContent(in);
                    continue block26;
                }
                case 26: {
                    this.convertFieldExprArgs.loadTaggedContent(in);
                    continue block26;
                }
            }
            this.addUnhandled().loadTaggedContent(in);
        }
    }

    @Override
    public void loadScriptContent(ScriptableObject obj) {
        super.loadScriptContent(obj);
        this.root.loadScriptContent(obj);
    }

    @Override
    protected void doAssign(DItem source) {
        super.doAssign(source);
        this.root.assign(((DSearch)source).root);
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        out.putEmpty(150);
        out.putEmpty(1);
        out.putDouble(151, this.root.rootEntry.tableId);
        this.inlineParams.storeTaggedContentAs(23, out);
        if (this.kind.getValue() == Search.Kind.Advanced.toInt()) {
            out.putEmpty(8);
        }
        this.kind.storeTaggedContentAs(15, out);
        if (this.kind.getValue() == Search.Kind.Standard.toInt()) {
            this.procedure.storeTaggedContentAs(16, out);
        }
        this.hierarchic.storeTaggedContentAs(14, out);
        if (this.hierarchic.getValue()) {
            this.orderSiblings.storeTaggedContentAs(18, out);
        }
        this.distinct.storeTaggedContentAs(9, out);
        this.convertFieldExprArgs.storeTaggedContentAs(26, out);
        this.root.storeTaggedContent(out);
        this.parameters.storeTaggedContentAsNonEmptyStream(153, out);
    }

    public void createParametersJavaScriptObject(Object jsParameters, ArrayList<DProperty> publicIds) {
        if (jsParameters instanceof DParameters) {
            this.parameters.assign((DParameters)jsParameters);
        } else if (jsParameters instanceof NativeArray) {
            this.parameters.loadScriptValue(jsParameters);
        }
    }

    public void createStructJavaScriptObject(Object jsSearch, String searchScript) {
        if (jsSearch instanceof DSearch) {
            this.assign((DSearch)jsSearch);
        }
        this.root.rootEntry.updateTableId();
        this.script = searchScript;
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        textOptions = 0;
        DSearch.addNewLineIfNeed(textOptions, out).append("//#region ").append("PARAMETERS").append("\n");
        this.parameters.storeTextContent(12, out, 0, false);
        DSearch.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("PARAMETERS").append("\n");
        DSearch.addNewLineIfNeed(textOptions, out).append("//#region ").append("SEARCH STRUCTURE").append("\n");
        StringBuilder props = new StringBuilder();
        int propCount = 0;
        propCount += this.storeTextContentProperties(textOptions | (propCount != 0 ? 8 : 0), props, level + 1);
        if (props.length() != 0) {
            props.append(',');
        }
        if ((propCount += this.root.storeTextContentProperties(textOptions, props, level + 1)) != 0) {
            DSearch.addNewLineIfNeed(textOptions, props);
        }
        out.append("const ").append(JS_SEARCH).append(" = ").append(DSL_SEARCH);
        if (propCount != 0) {
            out.append("\n({").append((CharSequence)props);
            DSearch.addNewLineIfNeed(textOptions, out);
            out.append("});");
        } else {
            out.append("();");
        }
        DSearch.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("SEARCH STRUCTURE").append("\n");
        DSearch.addNewLineIfNeed(textOptions, out).append("//#region ").append("SEARCH SCRIPT").append("\n");
        out.append(this.script);
        DSearch.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("SEARCH SCRIPT").append("\n");
        return 100;
    }
}

