/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.sql.engine.SearchEntry;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.FindNode;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.search.DSearchDatasourceEntry;
import inform.agent.mtd.obj.search.DSearchDirectoryEntry;
import inform.agent.mtd.obj.search.DSearchEntry;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public class DSearchEntries
extends DArray {
    protected final boolean entryBindable;

    public DSearchEntries(DProperty object, String name, boolean entryBindable) {
        super(object, name, 2);
        this.entryBindable = entryBindable;
    }

    public DSearchEntry findEntry(int entryId) {
        for (DProperty property : this.properties) {
            DSearchEntry entry;
            if (!(property instanceof DSearchEntry) || (entry = ((DSearchEntry)property).findEntry(entryId)) == null) continue;
            return entry;
        }
        return null;
    }

    public static void loadEntries(DSearchEntry entry, DObject object, DSearchEntry parent, DSearchEntries subjects, TaggedReader in) throws IOException {
        block10: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    byte[] raw = in.getRaw();
                    int id = LittleEndian.getInt(raw, 0);
                    int kind = LittleEndian.getInt(raw, 4);
                    double nodeId = in.getDouble(151);
                    if (entry != null) {
                        entry.entryId.setValue(id);
                        entry.tableId = nodeId;
                        entry.node.setValue(nodeId);
                    } else {
                        switch (SearchEntry.Kind.fromInt(kind)) {
                            case Directory: {
                                if (subjects != null) break;
                                entry = new DSearchDirectoryEntry(object, parent, id, nodeId);
                                break;
                            }
                            case Find: {
                                entry = new DSearchDatasourceEntry(object, parent, id, nodeId, new FindNode.Descriptor(MtdEngine.getNodeContent(nodeId)), subjects != null);
                                break;
                            }
                            default: {
                                if (subjects != null) break;
                                entry = new DSearchDatasourceEntry(object, parent, id, nodeId);
                            }
                        }
                    }
                    if (entry == null) continue block10;
                    if (parent != null) {
                        parent.entries.properties.add(entry);
                        continue block10;
                    }
                    if (subjects == null) continue block10;
                    subjects.properties.add(entry);
                    continue block10;
                }
                case 5: {
                    if (subjects != null) continue block10;
                    DSearchEntries.loadEntries(null, object, entry, null, in);
                    continue block10;
                }
                case 6: {
                    if (subjects != null) continue block10;
                    return;
                }
                case 2: {
                    if (subjects == null) continue block10;
                    entry = null;
                    continue block10;
                }
            }
            if (subjects == null) {
                assert (entry != null);
                entry.loadTaggedContent(in);
                continue;
            }
            if (entry == null) continue;
            entry.loadTaggedContent(in);
        }
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        if (obj instanceof ScriptableObject && this.object instanceof DSearchEntry) {
            ScriptableObject item = (ScriptableObject)obj;
            DSearchEntry entry = item.has("referenceFieldId", null) ? new DSearchDirectoryEntry(this.object, (DSearchEntry)this.object) : new DSearchDatasourceEntry(this.object, (DSearchEntry)this.object, this.entryBindable);
            entry.loadScriptContent(item);
            return entry;
        }
        return super.loadScriptArrayItem(obj);
    }

    @Override
    protected void doAssign(DItem source) {
        if (DSearchEntries.checkAssignType(source, this.getClass())) {
            DSearchEntry parent = this.object instanceof DSearchEntry ? (DSearchEntry)this.object : null;
            for (DProperty sourceProperty : ((DSearchEntries)source).properties) {
                if (!(sourceProperty instanceof DSearchEntry)) continue;
                DSearchEntry sourceEntry = (DSearchEntry)sourceProperty;
                DSearchEntry entry = SearchEntry.Kind.Directory.typeId == sourceEntry.entryKind() ? new DSearchDirectoryEntry(this.object, parent) : new DSearchDatasourceEntry(this.object, parent, this.entryBindable);
                entry.assign(sourceEntry);
                entry.updateTableId();
                this.properties.add(entry);
            }
        }
    }

    protected void store(TaggedWriter out) throws IOException {
        if (this.isDefault()) {
            return;
        }
        out.putEmpty(5);
        for (DProperty property : this.properties) {
            if (!(property instanceof DSearchEntry)) continue;
            ((DSearchEntry)property).store(out);
        }
        out.putEmpty(6);
    }

    protected void storeSubjectsAs(int tag, TaggedWriter out) throws IOException {
        if (this.isDefault()) {
            return;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        for (DProperty property : this.properties) {
            if (!(property instanceof DSearchEntry)) continue;
            ((DSearchEntry)property).store(stream);
        }
        stream.flush();
        if (data.size() == 0) {
            return;
        }
        out.putEmpty(tag);
        out.putRaw(202, data);
    }
}

