/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DParameter;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyValues;
import inform.agent.mtd.obj.search.DPropertySearchEntry;
import inform.agent.mtd.obj.search.DPropertySearchField;
import inform.agent.mtd.obj.search.DSearchDatasourceEntry;
import inform.agent.mtd.obj.search.DSearchEntryParameters;
import inform.agent.scripts.Parameter;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public class DSearchEntryParameter
extends DObject {
    protected boolean singleValue = false;
    protected final boolean entryBindable;
    protected final DPropertyInt id = new DPropertyInt(this, "id", 32768);
    protected final DPropertyEnum dataType = new DPropertyEnum(this, "dataType", 32772, 0, DATA_TYPE_VALUES, DATA_TYPE_NAMES);
    protected final DPropertyBool ignored = new DPropertyBool(this, "ignored", 4098, false);
    protected final DPropertyInt constant = new DPropertyInt(this, "constant", 32770);
    protected final DPropertyEnum dateFunction = new DPropertyEnum(this, "dateFunction", 32770, DATE_TIME_FUNCTION_NAMES);
    protected final DPropertySearchField parameterBind = new DPropertySearchField((DProperty)this, "parameterBind", 2, DPropertySearchField.Kind.Parameter);
    protected final DPropertySearchEntry entryBind = new DPropertySearchEntry(this, "entryBind", 2);
    protected final DPropertySearchField fieldBind = new DPropertySearchField((DProperty)this, "fieldBind", 2, this.entryBind);
    protected final DPropertyValues values = new DPropertyValues((DProperty)this, "values", this.dataType);

    public DSearchEntryParameter(DSearchEntryParameters parameters) {
        super(parameters, null, 32);
        this.entryBindable = parameters.entryBindable;
    }

    @Override
    protected void doAssign(DItem source) {
        if (source instanceof DSearchEntryParameter) {
            DSearchEntryParameter p = (DSearchEntryParameter)source;
            this.singleValue = p.singleValue;
            this.id.assign(p.id);
            this.dataType.assign(p.dataType);
            this.ignored.assign(p.ignored);
            this.constant.assign(p.constant);
            this.dateFunction.assign(p.dateFunction);
            this.parameterBind.assign(p.parameterBind);
            this.entryBind.assign(p.entryBind);
            this.fieldBind.assign(p.fieldBind);
            this.values.assign(p.values);
        } else {
            super.doAssign(source);
        }
    }

    @Override
    public void loadScriptContent(ScriptableObject obj) {
        if (this.object instanceof DSearchEntryParameters) {
            DSearchEntryParameters parameters = (DSearchEntryParameters)this.object;
            if (parameters.object instanceof DSearchDatasourceEntry) {
                Object scriptValue;
                int id;
                Parameter parameter;
                DSearchDatasourceEntry entry = (DSearchDatasourceEntry)parameters.object;
                if (obj.has("id", null) && entry.updateParametersList() && (parameter = entry.searchParameters.get(id = (int)ValueCaster.toNumber(scriptValue = obj.get("id", null)).longValue())) != null) {
                    this.dataType.setValue(parameter.getDataType().toInt());
                }
            }
        }
        super.loadScriptContent(obj);
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        if (this.ignored.getValue()) {
            this.dateFunction.setValue(0);
            this.constant.setValue(0);
            this.values.clear();
        } else if (this.dateFunction.getValue() != 0) {
            this.constant.setValue(0);
            this.values.clear();
        } else if (this.constant.getValue() != 0) {
            this.dateFunction.setValue(0);
            this.values.clear();
        }
        int offset = 0;
        byte[] raw = new byte[8];
        LittleEndian.setInteger(this.id.getValue(), raw, offset);
        LittleEndian.setInteger(this.dataType.getValue(), raw, offset += 4);
        out.putRaw(1, raw);
        if (this.entryBindable && !this.entryBind.isDefault() && !this.fieldBind.isDefault()) {
            this.entryBind.storeTaggedContentAs(32, out);
            this.fieldBind.storeTaggedContentAs(33, out);
        } else if (!this.parameterBind.isDefault()) {
            this.parameterBind.storeTaggedContentAs(21, out);
        } else {
            this.ignored.storeTaggedContentAs(7, out);
            if (this.dateFunction.getValue() != 0) {
                this.dateFunction.storeTaggedContentAs(9, out);
            } else if (this.constant.getValue() != 0) {
                this.constant.storeTaggedContentAs(17, out);
            } else if (this.values.value.size() > 1) {
                if (this.singleValue) {
                    DParameter.storeTaggedValue(out, this.values.value, 0, this.dataType.getValue());
                } else {
                    out.putInt32(15, this.values.value.size());
                    int count = this.values.value.size();
                    for (int index = 0; index < count; ++index) {
                        DParameter.storeTaggedValue(out, this.values.value, index, this.dataType.getValue());
                    }
                }
            } else {
                DParameter.storeTaggedValue(out, this.values.value, 0, this.dataType.getValue());
            }
        }
    }

    private void setValueStorable(boolean storable) {
        this.ignored.setStorable(storable);
        this.constant.setStorable(storable);
        this.dateFunction.setScriptable(storable);
        this.values.setStorable(storable);
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        if (this.entryBindable && !this.entryBind.isDefault() && !this.fieldBind.isDefault()) {
            this.setValueStorable(false);
            this.parameterBind.setStorable(false);
        } else if (!this.parameterBind.isDefault()) {
            this.setValueStorable(false);
            this.entryBind.setStorable(false);
            this.fieldBind.setStorable(false);
        } else {
            this.parameterBind.setStorable(false);
            this.entryBind.setStorable(false);
            this.fieldBind.setStorable(false);
        }
        return super.storeTextContent(textOptions, out, level, needComma);
    }
}

