/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.search.DSearchEntryParameter;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import java.io.IOException;

public class DSearchEntryParameters
extends DArray {
    protected boolean entryBindable = false;

    public DSearchEntryParameters(DProperty object) {
        super(object, "parameters", 2);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        DSearchEntryParameter param = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    in.checkCurrentTag(1, 8);
                    byte[] raw = in.getRaw();
                    int offset = 0;
                    param = new DSearchEntryParameter(this);
                    this.properties.add(param);
                    param.id.setValue(LittleEndian.getInt(raw, offset));
                    param.dataType.setValue(LittleEndian.getInt(raw, offset += 4));
                    break;
                }
                case 7: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.ignored.loadTaggedContent(in);
                    break;
                }
                case 9: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.dateFunction.loadTaggedContent(in);
                    break;
                }
                case 17: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.constant.loadTaggedContent(in);
                    break;
                }
                case 15: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.clear();
                    break;
                }
                case 14: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(null);
                    break;
                }
                case 21: {
                    param.parameterBind.loadTaggedContent(in);
                    break;
                }
                case 32: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.entryBind.loadTaggedContent(in);
                    break;
                }
                case 33: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.fieldBind.loadTaggedContent(in);
                    break;
                }
                case 10: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getInt());
                    break;
                }
                case 11: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getDouble());
                    break;
                }
                case 12: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getString());
                    break;
                }
                case 13: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getDate(Core.serverTimeZoneHost));
                    break;
                }
                case 38: {
                    if (param == null) {
                        throw new IllegalStateException();
                    }
                    param.values.value.add(in.getRaw());
                }
            }
        }
    }

    @Override
    protected void doAssign(DItem source) {
        if (DSearchEntryParameters.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DSearchEntryParameters)source).properties) {
                if (!DSearchEntryParameters.checkAssignType(sourceProperty, DSearchEntryParameter.class)) continue;
                DSearchEntryParameter sourceParameter = (DSearchEntryParameter)sourceProperty;
                DSearchEntryParameter parameter = new DSearchEntryParameter(this);
                parameter.assign(sourceParameter);
                this.properties.add(parameter);
            }
        }
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DSearchEntryParameter parameter = new DSearchEntryParameter(this);
        parameter.loadScriptValue(obj);
        return parameter;
    }

    protected void update(ParametersList parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            for (DProperty property : this.properties) {
                if (!(property instanceof DSearchEntryParameter)) continue;
                DSearchEntryParameter bind = (DSearchEntryParameter)property;
                Parameter parameter = parameters.get(bind.id.getValue());
                if (parameter == null) continue;
                bind.dataType.setValue(parameter.getDataType().toInt());
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        if (this.isDefault()) {
            return;
        }
        out.putEmpty(150);
        for (DProperty p : this.properties) {
            if (!(p instanceof DSearchEntryParameter)) continue;
            p.storeTaggedContent(out);
        }
    }

    @Override
    public DProperty getDefaultArrayItem() {
        return new DSearchEntryParameter(null);
    }
}

