/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.sql.engine.Function;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyDateTime;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.search.DPropertySearchEntry;
import inform.agent.mtd.obj.search.DPropertySearchField;
import java.io.IOException;

public class DSearchFieldExprItem
extends DObject {
    public static final String[] KIND_NAMES = new String[]{"field", "function", "value", "parameter", "systemField", "typedValue"};
    public static final String[] TYPE_CAST_NAMES = new String[]{"", "bool", "number"};
    public static final String[] FUNCTION_NAMES = new String[]{"", "add", "div", "mul", "sub", "day", "month", "year", "roundTo", "notNullValue", "abs", "hour", "minute", "second", "extractDate", "firstValue", "blobSize", "mod", "inline", "quarter", "trunc", "monthsBetween", "truncDateYear", "truncDateMonth", "truncDateQuarter", "truncDateHour", "toDate", "toNumber", "addMonths", "regexpSubstr", "addSeparators", "daysBetween", "numberToString", "truncDateWeek", "addDays", "dateValue", "pramValues", "delimiter", "monthEndDate"};
    protected final DPropertyEnum kind = new DPropertyEnum(this, "kind", 32772, KIND_NAMES);
    protected final DPropertyInt braceCount = new DPropertyInt(this, "braceCount", 32770);
    protected final DPropertySearchEntry entry = new DPropertySearchEntry(this, "entry", 2);
    protected final DPropertySearchField field = new DPropertySearchField((DProperty)this, "field", 2, this.entry);
    protected final DPropertySearchField parameter = new DPropertySearchField((DProperty)this, "parameter", 2, DPropertySearchField.Kind.Parameter);
    protected final DPropertyEnum typeCast = new DPropertyEnum(this, "typeCast", 32770, TYPE_CAST_NAMES);
    protected final DPropertyEnum function = new DPropertyEnum(this, "func", 32770, FUNCTION_NAMES);
    protected final DPropertyInt scale = new DPropertyInt(this, "scale", 32776);
    protected final DPropertyEnum dataType = new DPropertyEnum((DProperty)this, "dataType", 32774, DATA_TYPE_VALUES, DATA_TYPE_NAMES);
    protected final DPropertyBool valueBool = new DPropertyBool(this, "valueBool", 32776);
    protected final DPropertyInt valueInt = new DPropertyInt(this, "valueInt", 32776);
    protected final DPropertyDouble valueDouble = new DPropertyDouble(this, "valueDouble", 8);
    protected final DPropertyDateTime valueDateTime = new DPropertyDateTime(this, "valueDateTime", 8);
    protected final DPropertyString valueString = new DPropertyString(this, "valueString", 8);
    protected final DPropertyString value = new DPropertyString(this, "value", 8);

    public DSearchFieldExprItem(DProperty object) {
        super(object, null, 288);
    }

    @Override
    protected void doAssign(DItem obj) {
        super.doAssign(obj);
        DSearchFieldExprItem source = (DSearchFieldExprItem)obj;
        this.kind.assign(source.kind);
        this.dataType.assign(source.dataType);
        this.scale.setStorable(true);
        this.value.setStorable(source.value.isStorable());
        this.valueInt.setStorable(source.valueInt.isStorable());
        this.valueBool.setStorable(source.valueBool.isStorable());
        this.valueDouble.setStorable(source.valueDouble.isStorable());
        this.valueDateTime.setStorable(source.valueDateTime.isStorable());
        this.valueString.setStorable(source.valueString.isStorable());
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        this.kind.storeTaggedContentAs(7, out);
        this.braceCount.storeTaggedContentAs(3, out);
        this.entry.storeTaggedContentAs(4, out);
        this.field.storeTaggedContentAs(5, out);
        this.function.storeTaggedContentAs(6, out);
        this.parameter.storeTaggedContentAs(16, out);
        this.typeCast.storeTaggedContentAs(17, out);
        this.dataType.storeTaggedContentAs(18, out);
        if (this.function.getValue() == Function.Trunc.toInt() || this.function.getValue() == Function.RoundTo.toInt()) {
            this.scale.storeTaggedContentAs(15, out);
        }
        if (this.valueInt.isStorable()) {
            this.valueInt.storeTaggedContentAs(10, out);
        } else if (this.valueBool.isStorable()) {
            out.putInt32(10, this.valueBool.getValue() ? 1 : 10);
        } else if (this.valueDouble.isStorable()) {
            this.valueDouble.storeTaggedContentAs(11, out);
        } else if (this.valueDateTime.isStorable()) {
            this.valueDateTime.storeTaggedContentAs(13, out);
        } else if (this.valueString.isStorable()) {
            this.valueString.storeTaggedContentAs(12, out);
        } else if (this.value.isStorable()) {
            this.value.storeTaggedContentAs(12, out);
        }
    }
}

