/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj.search;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.TableDescriptor;
import inform.agent.db.sql.engine.FieldExpression;
import inform.agent.db.types.DataType;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.search.DSearch;
import inform.agent.mtd.obj.search.DSearchFieldExprItem;
import inform.agent.mtd.obj.search.DSearchRoot;
import java.io.IOException;
import org.mozilla.javascript.ScriptableObject;

public class DSearchFieldExpression
extends DArray {
    public DSearchFieldExpression(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        ScriptableObject source = (ScriptableObject)obj;
        DSearchFieldExprItem item = new DSearchFieldExprItem(this.object);
        if (source.has(item.entry.getPropName(), null)) {
            item.kind.setValue(FieldExpression.Kind.Field.toInt());
        } else if (source.has(item.parameter.getPropName(), null)) {
            item.kind.setValue(FieldExpression.Kind.Parameter.toInt());
        } else if (source.has(item.function.getPropName(), null)) {
            item.kind.setValue(FieldExpression.Kind.Function.toInt());
        } else if (source.has(item.valueInt.getPropName(), null)) {
            item.kind.setValue(FieldExpression.Kind.TypedValue.toInt());
            item.dataType.setValue(DataType.INTEGER.toInt());
            item.valueInt.setStorable(true);
        } else if (source.has(item.valueBool.getPropName(), null)) {
            item.kind.setValue(FieldExpression.Kind.TypedValue.toInt());
            item.dataType.setValue(DataType.BOOLEAN.toInt());
            item.valueBool.setStorable(true);
        } else if (source.has(item.valueDouble.getPropName(), null)) {
            item.kind.setValue(FieldExpression.Kind.TypedValue.toInt());
            item.dataType.setValue(DataType.FLOAT.toInt());
            item.valueDouble.setStorable(true);
        } else if (source.has(item.valueDateTime.getPropName(), null)) {
            item.kind.setValue(FieldExpression.Kind.TypedValue.toInt());
            item.dataType.setValue(DataType.DATE_TIME.toInt());
            item.valueDateTime.setStorable(true);
        } else if (source.has(item.valueString.getPropName(), null)) {
            item.kind.setValue(FieldExpression.Kind.TypedValue.toInt());
            item.dataType.setValue(DataType.STRING.toInt());
            item.valueString.setStorable(true);
        } else {
            item.kind.setValue(FieldExpression.Kind.Value.toInt());
            item.dataType.setValue(0);
            item.value.setStorable(true);
        }
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    public void loadScriptContent(ScriptableObject obj) {
        super.loadScriptContent(obj);
        DSearch search = ((DSearchRoot)this.object.object.object).search;
        TableDescriptor table = search.getRootTableDescriptor();
    }

    @Override
    protected void doAssign(DItem source) {
        if (DSearchFieldExpression.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DSearchFieldExpression)source).properties) {
                if (!(sourceProperty instanceof DSearchFieldExprItem)) continue;
                DSearchFieldExprItem sourceItem = (DSearchFieldExprItem)sourceProperty;
                DSearchFieldExprItem item = new DSearchFieldExprItem(this.object);
                item.assign(sourceItem);
                this.properties.add(item);
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        for (DProperty p : this.properties) {
            if (!(p instanceof DSearchFieldExprItem)) continue;
            p.storeTaggedContent(out);
        }
    }
}

