/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.DateTime;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;

public class AuditImport
extends Request {
    private final double serverTime = DateTime.currentDateTime();
    private double minServerTime = 0.0;
    private static final int TAG_IMPORT_AUDIT_SUCCESSFUL = 1;
    private static final int TAG_IMPORT_AUDIT_BEGIN_TIME = 2;
    private static final int TAG_IMPORT_AUDIT_END_TIME = 3;
    private static final int TAG_IMPORT_AUDIT_FILENAME = 4;
    private static final int TAG_IMPORT_AUDIT_FILEID = 5;
    private static final int TAG_IMPORT_AUDIT_FILECOMMENT = 6;
    private static final int TAG_IMPORT_AUDIT_MIN_SERVER_TIME = 7;
    private static final int TAG_IMPORT_AUDIT_FILE_SIZE = 8;
    private static final int TAG_IMPORT_AUDIT_FILE_NAME = 9;
    private static final int TAG_IMPORT_AUDIT_NOTE = 10;

    public AuditImport(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        AuditJournal.ReplicationParams params = new AuditJournal.ReplicationParams();
        TaggedReader in = this.createRequestContentReader();
        String file_name = null;
        String comment = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    params.successfullyResult = true;
                    break;
                }
                case 2: {
                    params.timeBeginOperation = DateTime.toServerTime(in.getDouble(), this);
                    break;
                }
                case 3: {
                    params.timeEndOperation = DateTime.toServerTime(in.getDouble(), this);
                    break;
                }
                case 4: {
                    file_name = in.getString();
                    break;
                }
                case 5: {
                    params.replicaId = in.getDouble();
                    break;
                }
                case 6: {
                    comment = in.getString();
                    break;
                }
                case 7: {
                    double minTime = in.getDouble();
                    if (!(minTime < this.serverTime)) break;
                    this.minServerTime = minTime;
                    break;
                }
                case 8: {
                    params.replicaSize = in.getLong();
                    break;
                }
                case 9: {
                    params.fileName = in.getString();
                    break;
                }
                case 10: {
                    params.note = in.getString();
                }
            }
        }
        if (this.minServerTime != 0.0) {
            params.timeBeginOperation = this.minServerTime;
            params.timeEndOperation = this.serverTime;
        } else if (params.timeBeginOperation != 0.0 && params.timeEndOperation != 0.0) {
            double delta = this.serverTime - params.timeEndOperation - 5.787037037037037E-6;
            params.timeBeginOperation += delta;
            params.timeEndOperation = this.serverTime;
        }
        params.opCode = 3;
        params.replNodeId = 2.0;
        StringBuilder msg = new StringBuilder();
        if (params.successfullyResult) {
            msg.append("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 ");
        } else {
            msg.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0444\u0430\u0439\u043b\u0430 ");
        }
        msg.append(file_name);
        if (!comment.isEmpty()) {
            msg.append("\n").append(comment);
        }
        params.resultMessage = msg.toString();
        params.userNodeId = this.getUserID();
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.REPLICATION);
        journal.registerReplication(this.ssContext, params);
    }
}

