/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.ClosableResult;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.UsersTable;

public class CheckTableUser
extends Request {
    public static final int TAG_CHECK_UT_ID = 1;
    public static final int TAG_CHECK_UT_LOGIN = 2;

    public CheckTableUser(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        double userId = 0.0;
        String login = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    userId = in.getDouble();
                    break;
                }
                case 2: {
                    login = in.getAnsi();
                }
            }
        }
        if (login != null) {
            StringBuilder conflictUsers = null;
            int count = 0;
            UsersTable usersTable = new UsersTable();
            ClosableResult closableResult = usersTable.selectLoginConflicts(this.ssContext, login, userId);
            if (closableResult != null) {
                try {
                    ResultSet r = closableResult.getResultSet();
                    while (r.next()) {
                        if (conflictUsers == null) {
                            conflictUsers = new StringBuilder();
                            conflictUsers.append(NumberConverter.doubleToString(r.getAsDouble(1)));
                        } else {
                            conflictUsers.append(", ").append(NumberConverter.doubleToString(r.getAsDouble(1)));
                        }
                        ++count;
                    }
                }
                finally {
                    closableResult.close();
                }
            }
            StringBuilder error = null;
            switch (count) {
                case 0: {
                    break;
                }
                case 1: {
                    error = new StringBuilder();
                    error.append("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\nID \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f ").append((CharSequence)conflictUsers).append('.');
                    break;
                }
                default: {
                    error = new StringBuilder();
                    error.append("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\nID \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439: ").append((CharSequence)conflictUsers).append('.');
                }
            }
            if (error != null) {
                throw new InformException(error.toString());
            }
        }
    }
}

