/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.net.Security;

public class GetRecordHistory
extends Request {
    private static final int TAG_RHISTORY_TABLE_ID = 1;
    private static final int TAG_RHISTORY_REC_ID = 2;
    private static final int TAG_RHISTORY_OPERATION = 3;
    private static final int TAG_RHISTORY_OPERATION_TIME = 4;
    private static final int TAG_RHISTORY_USER = 5;
    private static final int TAG_RHISTORY_TABLE_NAME = 6;
    private static final int TAG_RHISTORY_FIELDS = 7;
    private static final int TAG_RHISTORY_FIELD_NAME = 8;
    private static final int TAG_RHISTORY_MASTER_TABLE = 9;
    private static final int TAG_RHISTORY_TRANS_ID = 10;
    private static final int TAG_RHISTORY_EVENT_ID = 11;
    private static final int TAG_RHISTORY_SESSION_ID = 12;
    private static final int TAG_RHISTORY_REPL_NODE_ID = 13;
    private static final int TAG_RHISTORY_REPLICA_ID = 14;

    public GetRecordHistory(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        Security security = this.security();
        if (security.role() != UserRole.ADMIN && !security.getUserInterface().canViewDataHistory) {
            return;
        }
        double recordId = -1.0;
        double tableId = -1.0;
        TaggedReader reader = this.createRequestContentReader();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    tableId = reader.getDouble();
                    break;
                }
                case 2: {
                    recordId = reader.getDouble();
                }
            }
        }
        if (tableId == -1.0 || recordId == -1.0) {
            return;
        }
        TableDescriptor tDesc = new TableDescriptor(tableId, false);
        DatabaseDescriptor databaseDescriptor = tDesc.getDatabaseDescriptor();
        DatabaseConnection conn = databaseDescriptor.connect(this, "rq:GetRecordHistory");
        StringBuilder rawTableName = new StringBuilder();
        conn.getDescriptor().appendAuditTableRawName("PHX_CHANGELOG", rawTableName);
        try {
            String sql = "SELECT OP_CODE, OP_TIME, USER_ID, FLDS, MASTER_TABLE_ID, TRANS_ID, EVENT_ID, SESSION_ID, REPL_NODE_ID, MASTER_RECORD_ID, RECORD_ID FROM " + rawTableName + " WHERE TABLE_ID = ? AND RECORD_ID = ? ORDER BY OP_TIME DESC";
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setDouble(1, tableId);
            stmt.setDouble(2, recordId);
            try (ResultSet result = stmt.executeQuery(null);){
                ByteArrayOutputStream ar = new ByteArrayOutputStream();
                TaggedWriter writer = new TaggedWriter(ar);
                writer.putString(6, tDesc.getCaption());
                while (result.next()) {
                    int col;
                    int n = col = 1;
                    col = (byte)(col + 1);
                    writer.putInt32(3, result.getInt(n));
                    int n2 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(4, result.getDateTime(n2));
                    int n3 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(5, result.getDouble(n3));
                    int n4 = col;
                    col = (byte)(col + 1);
                    String str = result.getString(n4);
                    int n5 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(9, result.getDouble(n5));
                    int n6 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(10, result.getDouble(n6));
                    int n7 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(11, result.getDouble(n7));
                    int n8 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(12, result.getDouble(n8));
                    int n9 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(13, result.getDouble(n9));
                    int n10 = col;
                    col = (byte)(col + 1);
                    writer.putDouble(14, result.getDouble(n10));
                    if (str == null) continue;
                    ByteArrayOutputStream subAr = new ByteArrayOutputStream();
                    TaggedWriter subWriter = new TaggedWriter(subAr);
                    String[] hexFields = str.split(";");
                    for (int i = 0; i < hexFields.length; ++i) {
                        String caption;
                        FieldDescriptor fDesc = tDesc.getFieldDescriptor((int)Long.parseLong(hexFields[i], 16));
                        if (fDesc == null || (caption = fDesc.getCaption()) == null) continue;
                        subWriter.putString(8, fDesc.getCaption());
                    }
                    subWriter.flush();
                    writer.putRaw(7, subAr);
                }
                writer.flush();
                this.sendResult(ar.internalBuffer(), ar.size());
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                }
            }
        }
        finally {
            conn.close();
        }
    }
}

