/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.TableDescriptor;

public class GetTableDirectoryDependencis
extends Request {
    private static final int TAG_DIR_TABLE_ID = 1;
    private static final int TAG_TABLE_ID = 2;

    public GetTableDirectoryDependencis(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    @Override
    public void execute() throws Throwable {
        double tableId = -1.0;
        double[] refTables = null;
        TaggedReader in = this.createRequestContentReader();
        while (in.getNextTag() != 0) {
            if (in.getCurrentTag() != 1) continue;
            tableId = in.getDouble();
            break;
        }
        if (tableId != -1.0) {
            TableDescriptor tDesc = new TableDescriptor(tableId, false);
            refTables = tDesc.getReferences(this);
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        if (refTables != null && refTables.length > 0) {
            for (double refNodeId : refTables) {
                this.idle();
                TableDescriptor refTable = TableDescriptor.getIfExists(refNodeId);
                if (refTable == null || refTable.getKind() == TableDescriptor.Kind.VIRTUAL) continue;
                out.putDouble(2, refNodeId);
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

