/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.mtd.LockEngine;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import java.io.IOException;

public class LockNode
extends Request {
    public static final int TAG_LOCK_ID_OLD = 1;
    public static final int TAG_LOCK_ID = 2;
    public static final int TAG_LOCK_NO_ERROR = 3;
    public static final int TAG_LOCK_FAIL = 4;
    public static final int TAG_LOCKING_USER_ID = 5;
    public static final int TAG_LOCKING_CLIENT_ID = 6;
    public static final int TAG_LOCKING_USER_NAME = 7;
    public static final int TAG_LOCKING_SESSION_ID = 8;
    private boolean doError = true;

    public LockNode(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    @Override
    public void execute() throws Throwable {
        LockEngine.Locker locker = LockEngine.lockNode(this.getNodeID(), this.getLockId(), this.client());
        if (locker == null) {
            this.sendResult();
        } else if (!this.doError) {
            RequestResult result = new RequestResult(this);
            TaggedWriter out = result.getWriter();
            out.putEmpty(4);
            out.putDouble(5, locker.getUserId());
            out.putAnsi(7, locker.getUserName());
            out.putInt32(6, -1);
            out.putDouble(8, locker.getSessionId());
            out.flush();
            result.sendResult();
        } else {
            Node node = MtdEngine.getValidNode(locker.getNodeId());
            locker.throwNode(node);
        }
    }

    private double getLockId() throws IOException, TaggedReaderException {
        TaggedReader in = this.createRequestContentReader();
        double id = 0.0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    id = in.getInt();
                    break;
                }
                case 2: {
                    id = in.getDouble();
                    break;
                }
                case 3: {
                    this.doError = false;
                }
            }
        }
        return id;
    }
}

