/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.net.ClientSession;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.jboss.netty.util.CharsetUtil;

public class WebSocketSession
extends ClientSession {
    private static final WebSocketServerHandshakerFactory serverHandshakerFactory = new WebSocketServerHandshakerFactory("", "binary", false);
    private WebSocketServerHandshaker handshaker;

    public WebSocketSession() {
        this.allowAuthorizedKeys = false;
    }

    @Override
    public TaggedWriter createWriter() {
        return new TaggedWriter((OutputStream)new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((int)8092)){

            public void flush() throws IOException {
                BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame(this.buffer().copy());
                WebSocketSession.this.channel.write((Object)binaryFrame);
                WebSocketSession.this.pendingWritedBytes.reduce(this.buffer().writerIndex());
                this.buffer().clear();
            }
        });
    }

    @Override
    public TaggedWriter createSyncedWriter() {
        return new TaggedWriter((OutputStream)new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((int)8092)){

            public void flush() throws IOException {
                BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame(this.buffer());
                ChannelFuture f = WebSocketSession.this.channel.write((Object)binaryFrame);
                WebSocketSession.this.pendingWritedBytes.reduce(this.buffer().writerIndex());
                f.awaitUninterruptibly();
                this.buffer().clear();
            }
        });
    }

    @Override
    public TaggedWriter createMemoryAwareWriter() {
        return new TaggedWriter((OutputStream)new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((int)8092)){

            public void flush() throws IOException {
                BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame(this.buffer());
                WebSocketSession.this.channel.write((Object)binaryFrame);
                try {
                    WebSocketSession.this.pendingWritedBytes.acquire(this.buffer().writerIndex());
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        });
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.checkConnection();
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            super.messageReceived(ctx, e);
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.getChannel(), (CloseWebSocketFrame)frame);
            return;
        }
        if (frame instanceof BinaryWebSocketFrame || frame instanceof ContinuationWebSocketFrame) {
            this.processChanelBuffer(frame.getBinaryData());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.getChannel().write((Object)new PongWebSocketFrame(frame.getBinaryData()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
        String request = ((TextWebSocketFrame)frame).getText();
        ctx.getChannel().write((Object)new TextWebSocketFrame(request.toUpperCase()));
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        if (req.getMethod() != HttpMethod.GET) {
            WebSocketSession.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        this.handshaker = serverHandshakerFactory.newHandshaker(req);
        if (this.handshaker == null) {
            serverHandshakerFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
        } else {
            this.handshaker.handshake(ctx.getChannel(), req).addListener(WebSocketServerHandshaker.HANDSHAKE_LISTENER);
        }
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }
}

