/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.net.request;

import inform.adt.IO;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.web.IconServlet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GetIcons
extends Request {
    private static final int TAG_ICON_ID = 1;
    private static final int TAG_ICON_CONTENT = 2;
    private static final int TAG_ICON_SVG_CONTENT = 3;

    public GetIcons(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader reader = this.createRequestContentReader();
        inform.adt.taggedio.ByteArrayOutputStream result = new inform.adt.taggedio.ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    int iconId = reader.getInt();
                    this.putIconContent(iconId, out);
                }
            }
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIconContent(int iconId, TaggedWriter out) throws IOException {
        if (iconId <= 0) {
            return;
        }
        String icoName = "/WEB-ROOT/images/icons/img" + iconId + ".ico";
        String svgName = "/WEB-ROOT/images/icons/img" + iconId + ".svg";
        InputStream icoIn = IconServlet.class.getResourceAsStream(icoName);
        InputStream svgIn = IconServlet.class.getResourceAsStream(svgName);
        if (icoIn == null && svgIn == null) {
            return;
        }
        try {
            ByteArrayOutputStream data;
            out.putInt32(1, iconId);
            if (icoIn != null) {
                data = new ByteArrayOutputStream();
                IO.transfer(icoIn, data);
                out.putRaw(2, data.toByteArray());
            }
            if (svgIn != null) {
                data = new ByteArrayOutputStream();
                IO.transfer(svgIn, data);
                out.putRaw(3, data.toByteArray());
            }
        }
        finally {
            if (svgIn != null) {
                svgIn.close();
            }
            if (icoIn != null) {
                icoIn.close();
            }
        }
    }
}

