/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.PhenixLinks;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.sql.ParserStringReader;
import inform.agent.db.types.Geometry;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlParameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class ReplicationRecord {
    private final ServerSideHost host;
    private double recordId = 0.0;
    private boolean loaded = false;
    private IntegerSet fieldFilter = new IntegerSet();
    private double userId = 0.0;
    private double dataLogOwnerId = 0.0;
    private double dataLogEventId = 0.0;
    private boolean allFields = false;
    private final TableDescriptor tableInfo;
    private PhenixLinks.Record linkKey;
    private PhenixLinks.LinkRecord element = null;
    final ByteArrayOutputStream linkedData = new ByteArrayOutputStream();
    final ByteArrayOutputStream recordData = new ByteArrayOutputStream();
    private final ArrayList<Value> values = new ArrayList();
    MessageDigest messageDigest = null;
    public static final int TAG_FIELD = 1;
    public static final int TAG_NULL = 2;
    public static final int TAG_INTEGER = 3;
    public static final int TAG_DOUBLE = 4;
    public static final int TAG_STRING = 5;
    public static final int TAG_DATEIME = 6;
    public static final int TAG_BLOB = 7;
    public static final int TAG_UNICODE = 8;
    public static final int TAG_GEOMETRY = 9;
    public static final int TAG_ALT_KEY = 10;
    public static final int TAG_CHANGES = 11;
    public static final int TAG_FILE = 12;

    public ReplicationRecord(ServerSideHost ssHost, DatabaseConnection connection, TableDescriptor tableInfo) {
        this.host = ssHost;
        this.tableInfo = tableInfo;
        double tableId = tableInfo.getNodeId();
        this.linkKey = new PhenixLinks.Record();
        this.linkKey.table = tableId;
    }

    public void add(FieldDescriptor field, int columnIndex) {
        this.values.add(new Value(field, columnIndex));
    }

    public void clear() {
        this.recordId = 0.0;
        this.loaded = false;
        this.fieldFilter = new IntegerSet();
        this.allFields = false;
        this.element = null;
        this.userId = 0.0;
        this.dataLogOwnerId = 0.0;
        this.dataLogEventId = 0.0;
        this.recordData.reset();
        this.linkedData.reset();
        for (Value v : this.values) {
            v.setNull();
        }
    }

    public int size() {
        return this.values.size();
    }

    public void flush(IntegerSet topFilter, TaggedWriter out) throws Exception {
        if (!this.loaded) {
            return;
        }
        if (!this.allFields && !topFilter.empty()) {
            boolean isAll = true;
            for (Cursor.Integer c : topFilter) {
                if (this.fieldFilter.contains(c.value)) continue;
                isAll = false;
                break;
            }
            if (isAll) {
                this.allFields = true;
            }
        }
        this.generateContent(this.recordData, out);
        out.putDouble(4, this.recordId);
        if (this.userId != 0.0) {
            out.putDouble(9, this.userId);
        }
        if (this.dataLogOwnerId != 0.0) {
            out.putDouble(14, this.dataLogOwnerId);
        }
        if (this.dataLogEventId != 0.0) {
            out.putDouble(15, this.dataLogEventId);
        }
        if (this.element != null) {
            out.putDouble(21, this.element.left.table);
            out.putDouble(22, this.element.left.row);
        }
        if (this.linkedData.size() != 0) {
            out.putRaw(23, this.linkedData);
        }
        out.putRaw(10, this.recordData);
        out.notifyReady();
    }

    public boolean getRecordContent(ResultSet resultSet, double recordId, boolean useFieldFilter, boolean useUser, IntegerSet topFilter, TaggedWriter out, PhenixLinks linked, PhenixLinks elements) throws Exception {
        boolean result = false;
        if (this.loaded && this.recordId != recordId) {
            this.flush(topFilter, out);
            this.clear();
            result = true;
        }
        if (useUser) {
            this.userId = resultSet.getAsDouble(3);
            this.dataLogOwnerId = resultSet.getAsDouble(4);
            this.dataLogEventId = resultSet.getAsDouble(5);
        }
        if (this.allFields) {
            return result;
        }
        this.recordId = recordId;
        if (useFieldFilter) {
            this.loadFieldFilter(resultSet, 1);
            int opCode = resultSet.getInt(2);
            if (opCode == AuditModification.APPEND.toInt()) {
                this.allFields = true;
            }
            if (this.loaded) {
                return result;
            }
        } else {
            this.allFields = true;
        }
        this.loadContent(resultSet, linked, elements);
        return result;
    }

    private void loadContent(ResultSet resultSet, PhenixLinks linked, PhenixLinks elements) throws SQLException, IOException {
        this.loaded = true;
        this.linkKey.row = this.recordId;
        this.element = elements.get(this.linkKey);
        this.linkedData.reset();
        TaggedWriter linkedWriter = new TaggedWriter(this.linkedData);
        Iterator<PhenixLinks.LinkRecord> it = linked.iterator();
        while (it.hasNext()) {
            PhenixLinks.LinkRecord li = it.next();
            if (li.right.table != this.tableInfo.getNodeId() || li.right.row != this.recordId) continue;
            linkedWriter.putDouble(21, li.left.table);
            linkedWriter.putDouble(22, li.left.row);
        }
        linkedWriter.flush();
        for (Value value : this.values) {
            boolean isNull = false;
            if (value.field.isVirtual()) {
                isNull = true;
            } else {
                switch (value.field.getType()) {
                    case BOOLEAN: {
                        boolean boolVal = resultSet.getAsInteger(value.columnIndex) != 0;
                        isNull = resultSet.wasNull();
                        if (isNull) break;
                        value.setBoolean(boolVal);
                        break;
                    }
                    case INTEGER: {
                        int intVal = resultSet.getAsInteger(value.columnIndex);
                        isNull = resultSet.wasNull();
                        if (isNull) break;
                        value.setInteger(intVal);
                        break;
                    }
                    case PRIMARY_KEY: 
                    case FLOAT: 
                    case INTERVAL: 
                    case DIRECTORY: 
                    case METATREE_NODE: {
                        double number = resultSet.getDouble(value.columnIndex);
                        isNull = resultSet.wasNull();
                        if (isNull) break;
                        value.setDouble(number);
                        break;
                    }
                    case DATE_TIME: {
                        double number = resultSet.getDateTime(value.columnIndex);
                        isNull = resultSet.wasNull();
                        if (isNull) break;
                        value.setDateTime(number);
                        break;
                    }
                    case STRING: 
                    case BIG_NUMBER: {
                        String str = resultSet.getString(value.columnIndex);
                        if (str == null || resultSet.wasNull()) {
                            isNull = true;
                            break;
                        }
                        value.setString(str);
                        break;
                    }
                    case UNICODE: {
                        String str = resultSet.getString(value.columnIndex);
                        if (str == null || resultSet.wasNull()) {
                            isNull = true;
                            break;
                        }
                        value.setUnicode(str);
                        break;
                    }
                    case BLOB: {
                        byte[] blobContent = resultSet.getBlobBytes(value.columnIndex);
                        if (blobContent == null || blobContent.length == 0) {
                            isNull = true;
                            break;
                        }
                        value.setBlob(blobContent);
                        break;
                    }
                    case FILE: {
                        String blobfs = resultSet.getString(value.columnIndex);
                        if (blobfs == null || resultSet.wasNull()) {
                            isNull = true;
                            break;
                        }
                        value.setFile(blobfs);
                        break;
                    }
                    case GEOMETRY: {
                        Geometry g = resultSet.getGeometry(value.columnIndex);
                        if (g == null) {
                            isNull = true;
                            break;
                        }
                        value.setGeom(g);
                        break;
                    }
                    default: {
                        isNull = true;
                    }
                }
            }
            if (!isNull) continue;
            value.setNull();
        }
    }

    private void loadFieldFilter(ResultSet resultSet, int colIndex) throws SQLException, IOException {
        String flds = resultSet.getString(colIndex);
        if (resultSet.wasNull() || flds == null || flds.isEmpty()) {
            this.allFields = true;
        } else if (!this.allFields) {
            String str = flds;
            ParserStringReader reader = new ParserStringReader(str);
            StreamTokenizer parser = new StreamTokenizer(reader);
            parser.resetSyntax();
            parser.whitespaceChars(0, 47);
            parser.whitespaceChars(58, 64);
            parser.whitespaceChars(91, 96);
            parser.whitespaceChars(123, 255);
            parser.wordChars(97, 102);
            parser.wordChars(65, 70);
            parser.wordChars(48, 57);
            int fieldCount = 0;
            int tokenType = 0;
            while (tokenType != -1) {
                tokenType = parser.nextToken();
                if (tokenType != -3) continue;
                ++fieldCount;
                int filteredField = (int)(Long.parseLong(parser.sval, 16) & 0xFFFFFFFFFFFFFFFFL);
                this.fieldFilter.add(filteredField);
            }
            if (fieldCount == 0) {
                this.allFields = true;
            }
        }
    }

    private void putValue(Value v, TaggedWriter out) throws IOException {
        if (v.isNull()) {
            out.putEmpty(2);
        } else {
            switch (v.getType()) {
                case BLOB: {
                    out.putRaw(7, v.getBlob());
                    break;
                }
                case DATE_TIME: {
                    out.putDouble(6, v.getDateTime());
                    break;
                }
                case DOUBLE: {
                    out.putDouble(4, v.getDouble());
                    break;
                }
                case BOOLEAN: {
                    out.putInt32(3, v.getBoolean() ? 1 : 0);
                    break;
                }
                case INTEGER: {
                    out.putInt32(3, v.getInteger());
                    break;
                }
                case STRING: {
                    out.putAnsi(5, v.getString());
                    break;
                }
                case UNICODE: {
                    out.putString(8, v.getString());
                    break;
                }
                case GEOMETRY: {
                    Geometry g = v.getGeom();
                    if (g == null) {
                        out.putEmpty(2);
                        break;
                    }
                    ByteArrayOutputStream buff = new ByteArrayOutputStream();
                    g.serialize(buff);
                    out.putRaw(9, buff);
                    break;
                }
                case FILE: {
                    out.putAnsi(12, v.getFile());
                    break;
                }
                default: {
                    out.putEmpty(2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBlobFile(Value value, TaggedWriter out) throws Exception {
        if (value.isNull()) {
            return;
        }
        String blobPath = value.getFile();
        if (Strings.isVoid(blobPath)) {
            return;
        }
        String filePath = Core.blobfs.resolvePath(value.field.getBlobFS() + ":/" + value.getFile());
        if (blobPath.equals(filePath)) {
            return;
        }
        File file = new File(filePath);
        if (!file.exists() || file.length() == 0L) {
            return;
        }
        if (this.messageDigest == null) {
            try {
                this.messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw InformException.wrap(e);
            }
        }
        this.messageDigest.reset();
        try (FileInputStream in = new FileInputStream(file);){
            int size;
            double[] blobFile = new double[]{this.tableInfo.getNodeId(), value.field.getId(), this.recordId};
            out.putRaw(11, LittleEndian.doubleArrayToBinary(blobFile));
            byte[] chunk = new byte[2000000];
            do {
                if (this.host != null) {
                    this.host.idle();
                }
                if ((size = in.read(chunk, 0, chunk.length)) <= 0) continue;
                this.messageDigest.update(chunk, 0, size);
                out.putRaw(12, chunk, size);
                out.flush();
                out.notifyReady();
            } while (size >= 0);
            byte[] digest = this.messageDigest.digest();
            out.putRaw(13, digest);
            out.notifyReady();
        }
    }

    private void generateContent(ByteArrayOutputStream recordBuffer, TaggedWriter out) throws Exception {
        this.loaded = false;
        if (this.fieldFilter == null || this.fieldFilter.empty()) {
            this.allFields = true;
        }
        recordBuffer.reset();
        TaggedWriter recordOut = new TaggedWriter(recordBuffer);
        if (!this.allFields) {
            recordOut.putEmpty(11);
        }
        for (Value v : this.values) {
            if (this.allFields || this.fieldFilter.contains(v.field.getId())) {
                recordOut.putInt32(1, v.field.getId());
                if (v.getType() == SqlDataType.FILE) {
                    recordOut.putEmpty(2);
                    this.writeBlobFile(v, out);
                } else {
                    this.putValue(v, recordOut);
                }
            }
            if (!v.field.isAlternativeKey()) continue;
            recordOut.putInt32(10, v.field.getId());
            this.putValue(v, recordOut);
        }
        recordOut.flush();
    }

    public static class Value
    extends SqlParameter {
        public final FieldDescriptor field;
        public final int columnIndex;

        public Value(FieldDescriptor field, int columnIndex) {
            super(field.getType().toSqlDataType());
            this.field = field;
            this.columnIndex = columnIndex;
        }
    }
}

