/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.TimeZoneHost;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.PhenixLinks;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.DataType;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.files.BFS;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.replication.DataReplicationApplyEngine;
import inform.agent.replication.DownloadParams;
import inform.agent.replication.Replication;
import inform.agent.replication.ReplicationRecord;
import inform.agent.replication.UploadParams;
import inform.agent.scripts.Constants;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class TableDataIO {
    public static final int TAG_TABLE_METADATA = 1;
    public static final int TAG_DELETED_ROW_ID = 2;
    public static final int TAG_MODIFIED_ROW_ID = 4;
    public static final int TAG_ROW_PACKED_CONTENT = 5;
    public static final int TAG_CHANGED_ROW_PRI_KEY = 6;
    public static final int TAG_ROW_PREV_ID = 7;
    public static final int TAG_CHANGED_LINK = 8;
    public static final int TAG_MODIFICATION_USER_ID = 9;
    public static final int TAG_REPLICA_ROW_CONTENT = 10;
    public static final int TAG_BLOB_FILE = 11;
    public static final int TAG_BLOB_FILE_CHUNK = 12;
    public static final int TAG_BLOB_FILE_END = 13;
    public static final int TAG_DATALOG_OWNER_ID = 14;
    public static final int TAG_DATALOG_EVENT_ID = 15;
    public static final int TAG_MASTER_TABLE_ID = 21;
    public static final int TAG_MASTER_ROW_ID = 22;
    public static final int TAG_LINKED_LINKS = 23;
    public static final int TAG_LINK_L_TABLE = 31;
    public static final int TAG_LINK_L_ROW = 32;
    public static final int TAG_LINK_R_TABLE = 33;
    public static final int TAG_LINK_R_ROW = 34;
    public static final int TAG_SLICE_PERIODS = 40;
    public static final int TAG_SLICE_PERIODS_MIN_CHANGE_TIME = 1;
    public static final int TAG_SLICE_PERIODS_MIN_TRANS_TIME = 2;
    public static final int TAG_SLICE_PERIODS_MAX_TRANS_TIME = 3;
    public static final int TAG_SLICE_PERIODS_SAMPLE_MODE = 4;
    public static final int TAG_TIME_ZONE_OFFSET_MS = 5;
    public static final int TAG_LAST_TAG = 90;
    public static final double EMPTY_USER_ID = -1.0;
    private final ServerSideHost ssHost;
    private final TimeZoneHost timeZoneHost;
    private final SSContext ssContext;
    private Idler idler = null;
    private BFS bfs = new BFS();
    private BFS.Replica bfsReplica = new BFS.Replica();
    private double loadLinkedTable = 0.0;
    private double loadElementTable = 0.0;
    private PhenixLinks linked;
    private PhenixLinks elements;

    public TableDataIO(SSContext context, ServerSideHost ssHost, TimeZoneHost timeZoneHost) {
        this.ssHost = ssHost;
        this.timeZoneHost = timeZoneHost;
        this.ssContext = context;
    }

    public void setIdler(Idler idler) {
        this.idler = idler;
    }

    public void idle() {
        if (this.idler != null) {
            this.idler.idle();
        } else if (this.ssHost != null) {
            this.ssHost.idle();
        }
    }

    private GeneratedSql getFilteredSql(boolean generateSubject, TableDescriptor tableInfo, double searchId, Constants constants) throws InformException, IOException {
        GeneratedSql sql;
        this.idle();
        BasicNode node = MtdEngine.getValidTranslatedNode(searchId);
        if (node.getType() != 19) {
            MtdEngine.throwError(searchId, "\u0422\u0438\u043f \u0443\u0437\u043b\u0430 \u0434\u043b\u043e\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u041f\u043e\u0438\u0441\u043a");
        }
        byte[] searchContent = node.getContent();
        SqlGenerator.Method generationMethod = SqlGenerator.extractSearchGenerationMethod(searchContent);
        SqlGenerator sqlGenerator = new SqlGenerator(this.ssHost, Core.serverTimeZoneHost);
        sqlGenerator.setTableId(tableInfo.getNodeId());
        sqlGenerator.setSearchId(searchId);
        sqlGenerator.setSearchContent(searchContent);
        sqlGenerator.setBlobReceiving(2);
        sqlGenerator.setConstants(constants);
        if (generateSubject) {
            sqlGenerator.setCustomSubjectFieldId(-1);
        }
        if (!((sql = sqlGenerator.getGeneratedSql(generationMethod, -500)).isSubject() || sql.isValidForSelectBlob() && !TableDataIO.isFindDendriticOrUnionAndNotDistinct(searchContent))) {
            sqlGenerator = new SqlGenerator(this.ssHost, Core.serverTimeZoneHost);
            sqlGenerator.setTableId(tableInfo.getNodeId());
            sqlGenerator.setSearchId(searchId);
            sqlGenerator.setSearchContent(searchContent);
            sqlGenerator.setConstants(constants);
            sqlGenerator.setCustomSubjectFieldId(-1);
            sql = sqlGenerator.getGeneratedSql(generationMethod, -500);
        }
        if (sql.isHasError()) {
            throw new InformException(sql.getError()).detail(sql.getErrorDetailing());
        }
        return sql;
    }

    private GeneratedSql getParametrizedFilteredSql(TableDescriptor tableInfo, double searchId, byte[] parameters) throws InformException, IOException {
        this.idle();
        BasicNode node = MtdEngine.getValidTranslatedNode(searchId);
        if (node.getType() != 19) {
            MtdEngine.throwError(searchId, "\u0422\u0438\u043f \u0443\u0437\u043b\u0430 \u0434\u043b\u043e\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u041f\u043e\u0438\u0441\u043a");
        }
        byte[] searchContent = node.getContent();
        SqlGenerator.Method generationMethod = SqlGenerator.extractSearchGenerationMethod(searchContent);
        SqlGenerator sqlGenerator = new SqlGenerator(this.ssHost, this.ssHost);
        sqlGenerator.setTableId(tableInfo.getNodeId());
        sqlGenerator.setSearchId(searchId);
        sqlGenerator.setSearchContent(searchContent);
        sqlGenerator.setClientSideParamContent(parameters);
        sqlGenerator.setBlobReceiving(2);
        GeneratedSql sql = sqlGenerator.getGeneratedSql(generationMethod, -500);
        if (!(sql.isSubject() || sql.isValidForSelectBlob() && !TableDataIO.isFindDendriticOrUnionAndNotDistinct(searchContent))) {
            sqlGenerator = new SqlGenerator(this.ssHost, this.ssHost);
            sqlGenerator.setTableId(tableInfo.getNodeId());
            sqlGenerator.setSearchId(searchId);
            sqlGenerator.setSearchContent(searchContent);
            sqlGenerator.setClientSideParamContent(parameters);
            sqlGenerator.setCustomSubjectFieldId(-1);
            sql = sqlGenerator.getGeneratedSql(generationMethod, -500);
        }
        if (sql.isHasError()) {
            throw new InformException(sql.getError()).detail(sql.getErrorDetailing());
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowStats download(double tableId, DownloadParams params, TaggedWriter out) throws Exception {
        TableDescriptor tableInfo = TableDescriptor.get(tableId);
        if (!tableInfo.isRealTable()) {
            return null;
        }
        WriteParams writeParams = new WriteParams(tableInfo);
        writeParams.useDataSlice = false;
        writeParams.useFieldChanges = false;
        IntegerSet fieldFilter = null;
        int[] ff = params.getFieldFilter();
        if (ff != null) {
            fieldFilter = new IntegerSet();
            for (int f : ff) {
                fieldFilter.add(f);
            }
        }
        if (fieldFilter == null) {
            fieldFilter = IntegerSet.EMPTY;
        }
        RowStats rowStats = new RowStats();
        try (DatabaseConnection connection = tableInfo.getDatabaseDescriptor().connect(this.ssHost, "TableDataIO::download", true);){
            switch (params.getProcessData()) {
                case 1: {
                    break;
                }
                case 2: {
                    throw new IllegalStateException();
                }
                case 3: {
                    if (!params.hasIncludeFilter()) break;
                    writeParams.filter = this.getParametrizedFilteredSql(tableInfo, params.getIncludeSearchId(), params.getIncludeSearchParams());
                }
            }
            this.writeReplica(out, writeParams, fieldFilter, connection, rowStats);
        }
        this.idle();
        return rowStats;
    }

    public RowStats replicate(ReplicationItem conf, Replication.DataParam param, AbstractConnectionManager connectionManager, TaggedWriter out) throws Exception {
        TableDescriptor tableInfo = TableDescriptor.get(conf.tableId);
        if (conf.useDataSlice && !tableInfo.isOperableTable()) {
            return null;
        }
        if (!tableInfo.isRealTable()) {
            return null;
        }
        WriteParams writeParams = new WriteParams(tableInfo);
        writeParams.minChangesTime = param.minChangesTime;
        writeParams.minTransTime = param.minTransEndTime;
        writeParams.maxTransTime = param.maxTransEndTime;
        writeParams.useDataSlice = conf.useDataSlice;
        writeParams.backReceivingId = param.backReceivingId;
        writeParams.useFieldChanges = param.useFieldChanges && tableInfo.getPrimaryKeyFields().size() == 1;
        IntegerSet fieldFilter = conf.fieldFilter;
        if (fieldFilter == null) {
            fieldFilter = IntegerSet.EMPTY;
        }
        RowStats rowStats = new RowStats();
        DatabaseConnection connection = connectionManager.getConnection(tableInfo.getDbId(), "TableDataIO::replicate");
        if (conf.includeFilter != 0.0) {
            writeParams.filter = this.getFilteredSql(writeParams.useDataSlice, tableInfo, conf.includeFilter, param.constants);
        }
        out.putDouble(91, tableInfo.getNodeId());
        if (!fieldFilter.empty()) {
            double[] tmp = new double[fieldFilter.size()];
            int i = 0;
            for (Cursor.Integer c : fieldFilter) {
                tmp[i++] = c.value;
            }
            out.putRaw(93, LittleEndian.doubleArrayToBinary(tmp));
        }
        this.writeReplica(out, writeParams, fieldFilter, connection, rowStats);
        out.putEmpty(92);
        out.notifyReady();
        connection.commitForReleaseSelectLocks();
        this.idle();
        return rowStats;
    }

    private PhenixLinks getLinked(TableDescriptor tableInfo, DatabaseConnection connection) {
        if (tableInfo.getNodeId() != this.loadLinkedTable || this.linked == null) {
            this.loadLinkedTable = tableInfo.getNodeId();
            this.linked = new PhenixLinks(this.ssHost);
            this.linked.load(this.ssContext, this.loadLinkedTable, connection, 2);
        }
        return this.linked;
    }

    private PhenixLinks getElements(TableDescriptor tableInfo, DatabaseConnection connection) {
        if (tableInfo.getNodeId() != this.loadElementTable || this.elements == null) {
            this.loadElementTable = tableInfo.getNodeId();
            this.elements = new PhenixLinks(this.ssHost);
            this.elements.load(this.ssContext, this.loadElementTable, connection, 1);
        }
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReplica(TaggedWriter out, WriteParams writeParams, IntegerSet fieldFilter, DatabaseConnection connection, RowStats stats) throws Exception {
        block72: {
            stats.clear();
            assert (writeParams.tableInfo != null);
            TableDescriptor tableInfo = writeParams.tableInfo;
            if (writeParams.useDataSlice && !tableInfo.isOperableTable()) {
                return;
            }
            if (!tableInfo.isRealTable()) {
                return;
            }
            FieldDescriptor pkField = writeParams.useDataSlice || writeParams.filter != null && writeParams.filter.isSubject() ? tableInfo.getValidRecordIdField() : tableInfo.getRecordIdField();
            DoubleSet deletedRows = new DoubleSet();
            if (writeParams.useDataSlice) {
                DatabaseDescriptor databaseDescriptor = connection.getDescriptor();
                SqlStringBuilder sqlText = new SqlStringBuilder();
                if (Ini.ReplSample == 0) {
                    sqlText.append("select ").append("PHX_CHANGELOG").append('.').append("RECORD_ID").append(',').append("PHX_CHANGELOG").append('.').append("USER_ID").append(',').append("PHX_CHANGELOG").append('.').append("MASTER_TABLE_ID").append(',').append("PHX_CHANGELOG").append('.').append("EVENT_ID").append(" from ");
                    databaseDescriptor.appendAuditTableRawName("PHX_CHANGELOG", sqlText.getBuilder());
                    sqlText.append(' ').append("PHX_CHANGELOG").append(" INNER JOIN ");
                    databaseDescriptor.appendAuditTableRawName("PHX_CHANGELOG_TRANS", sqlText.getBuilder());
                    sqlText.append(' ').append("PHX_CHANGELOG_TRANS").append(" ON ").append("PHX_CHANGELOG_TRANS").append('.').append("ID").append("=").append("PHX_CHANGELOG").append('.').append("TRANS_ID").append(" LEFT OUTER JOIN ").appendFull(tableInfo).append(" T ON (").append("PHX_CHANGELOG").append('.').append("RECORD_ID").append("=T.").append(pkField).append(") where ");
                    TableDataAudit.dataSliceConditionSql(sqlText, writeParams.backReceivingId);
                    sqlText.append(" and ").append("PHX_CHANGELOG").append('.').append("OP_CODE").append("=").append(AuditModification.DELETE.toInt()).append(" and T.").append(pkField).append(" is null and ").append("PHX_CHANGELOG_TRANS").append('.').append("T_END").append(">=? and ").append("PHX_CHANGELOG_TRANS").append('.').append("T_END").append("<=?");
                } else {
                    sqlText.append("select CL.RECORD_ID, CL.USER_ID, CL.MASTER_TABLE_ID,CL.EVENT_ID from\n  ");
                    databaseDescriptor.appendAuditTableRawName("PHX_CHANGELOG_TRANS", sqlText.getBuilder());
                    sqlText.append(" TL \n  INNER JOIN ");
                    databaseDescriptor.appendAuditTableRawName("PHX_CHANGELOG", sqlText.getBuilder());
                    sqlText.append(" CL ON ").append("TL.ID = CL.TRANS_ID\n  LEFT OUTER JOIN ");
                    sqlText.appendFull(tableInfo).append(" T ON (CL.RECORD_ID=T.").append(pkField);
                    sqlText.append(") \nwhere \n  TL.T_END >= ? and TL.T_END <= ?");
                    if (writeParams.backReceivingId == 0.0) {
                        sqlText.append(" and \n  TL.REPL_NODE_ID is null");
                    } else {
                        sqlText.append(" and \n  (TL.REPL_NODE_ID <> ? or TL.REPL_NODE_ID is null)");
                    }
                    sqlText.append(" and \n  CL.TABLE_ID = ?");
                    sqlText.append(" and \n  CL.OP_CODE=2 and \n  T.").append(pkField).append(" is null");
                }
                try (PreparedStatement statement = connection.prepareStatement("replicate deleted records", sqlText.toString());){
                    ByteArrayOutputStream slicePeriodsData = new ByteArrayOutputStream(40);
                    TaggedWriter slicePeriodsOut = new TaggedWriter(slicePeriodsData);
                    statement.setQueryTimeout();
                    int index = 0;
                    if (Ini.ReplSample == 0) {
                        statement.setDouble(++index, writeParams.tableInfo.getNodeId());
                        statement.setDateTime(++index, writeParams.minChangesTime);
                        statement.setDateTime(++index, writeParams.maxTransTime);
                        if (writeParams.backReceivingId != 0.0) {
                            statement.setDouble(++index, writeParams.backReceivingId);
                        }
                        statement.setDateTime(++index, writeParams.minTransTime);
                        statement.setDateTime(++index, writeParams.maxTransTime);
                        slicePeriodsOut.putDouble(1, writeParams.minChangesTime);
                        slicePeriodsOut.putDouble(2, writeParams.minTransTime);
                        slicePeriodsOut.putDouble(3, writeParams.maxTransTime);
                    } else {
                        statement.setDateTime(++index, writeParams.minTransTime);
                        statement.setDateTime(++index, writeParams.maxTransTime);
                        if (writeParams.backReceivingId != 0.0) {
                            statement.setDouble(++index, writeParams.backReceivingId);
                        }
                        statement.setDouble(++index, writeParams.tableInfo.getNodeId());
                        slicePeriodsOut.putDouble(2, writeParams.minTransTime);
                        slicePeriodsOut.putDouble(3, writeParams.maxTransTime);
                    }
                    slicePeriodsOut.putInt32(4, Ini.ReplSample);
                    boolean hasDataLogProp = false;
                    try (ResultSet resultSet = statement.executeQuery(this.ssContext);){
                        slicePeriodsOut.flush();
                        out.putRaw(40, slicePeriodsData.internalBuffer(), slicePeriodsData.size());
                        out.putInt32(5, DateTime.serverZoneOffset());
                        while (resultSet.next()) {
                            this.idle();
                            double recordId = resultSet.getDouble(1);
                            double userId = resultSet.getDouble(2);
                            if (resultSet.wasNull()) {
                                userId = -1.0;
                            }
                            double ownerId = resultSet.getDouble(3);
                            if (resultSet.wasNull()) {
                                ownerId = 0.0;
                            }
                            double eventId = resultSet.getDouble(4);
                            if (resultSet.wasNull()) {
                                eventId = 0.0;
                            }
                            if (ownerId != 0.0 || eventId != 0.0) {
                                hasDataLogProp = true;
                            }
                            ++stats.deleted;
                            deletedRows.add(recordId);
                            out.putDouble(14, ownerId);
                            out.putDouble(15, eventId);
                            out.putDouble(2, recordId);
                            out.putDouble(9, userId);
                            this.idle();
                        }
                    }
                    if (hasDataLogProp) {
                        out.putDouble(14, 0.0);
                        out.putDouble(15, 0.0);
                    }
                }
            }
            if (writeParams.filter != null && !writeParams.filter.isSubject()) {
                try (PreparedStatement statement = connection.prepareStatement(writeParams.filter.getSqlText());){
                    writeParams.filter.appendParametersTo(statement);
                    try (ResultSet resultSet = statement.executeQuery(this.ssContext);){
                        int pkFieldIndex = pkField != null ? resultSet.findColumn(pkField.getRawName()) : -1;
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        ReplicationRecord recordFields = new ReplicationRecord(this.ssHost, connection, tableInfo);
                        ByteArrayOutputStream metaData = new ByteArrayOutputStream();
                        TaggedWriter metaWriter = new TaggedWriter(metaData);
                        metaWriter.putInt32(27, tableInfo.getKind().toInt());
                        int columnCount = resultSetMetaData.getColumnCount();
                        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                            String rawName = resultSetMetaData.getColumnName(columnIndex);
                            FieldDescriptor f = tableInfo.getField(rawName);
                            if (f == null || f.getId() == -1 || f.isVirtual()) continue;
                            int fieldId = f.getId();
                            DataType fieldType = f.getType();
                            if (fieldType == DataType.BLOB && f.getBlobRawType() == FieldDescriptor.BlobRawType.BINARY && f.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) continue;
                            metaWriter.putInt32(10, fieldId);
                            metaWriter.putInt32(12, fieldType.toInt());
                            metaWriter.putInt32(14, f.getSize());
                            if (f.isAlternativeKey()) {
                                metaWriter.putEmpty(56);
                            }
                            recordFields.add(f, columnIndex);
                        }
                        metaWriter.flush();
                        this.idle();
                        out.putRaw(1, metaData);
                        PhenixLinks pllinked = null;
                        PhenixLinks plelements = null;
                        while (resultSet.next()) {
                            this.idle();
                            double recordId = 0.0;
                            if (pkField != null && pkField.getType().isNumberPresentation()) {
                                recordId = resultSet.getDouble(pkFieldIndex);
                            }
                            ++stats.modified;
                            if (pllinked == null) {
                                pllinked = this.getLinked(tableInfo, connection);
                            }
                            if (plelements == null) {
                                plelements = this.getElements(tableInfo, connection);
                            }
                            recordFields.getRecordContent(resultSet, recordId, writeParams.useDataSlice && writeParams.useFieldChanges, false, fieldFilter, out, pllinked, plelements);
                            if (pkField != null && pkField.getType().isNumberPresentation()) continue;
                            recordFields.flush(fieldFilter, out);
                            recordFields.clear();
                        }
                        recordFields.flush(fieldFilter, out);
                        break block72;
                    }
                }
            }
            SqlStringBuilder sqlText = new SqlStringBuilder();
            sqlText.append("select ");
            int columnIndex = 0;
            int comma = 32;
            if (writeParams.useDataSlice) {
                if (Ini.ReplSample == 0) {
                    sqlText.append("PHX_CHANGELOG").append('.').append("FLDS");
                    comma = 44;
                    sqlText.append((char)comma).append("PHX_CHANGELOG").append('.').append("OP_CODE");
                    sqlText.append((char)comma).append("PHX_CHANGELOG").append('.').append("USER_ID");
                    sqlText.append((char)comma).append("PHX_CHANGELOG").append('.').append("MASTER_TABLE_ID");
                    sqlText.append((char)comma).append("PHX_CHANGELOG").append('.').append("EVENT_ID");
                } else {
                    sqlText.append("CL.FLDS, CL.OP_CODE, CL.USER_ID, CL.MASTER_TABLE_ID, CL.EVENT_ID");
                    comma = 44;
                }
                columnIndex += 5;
            }
            if (tableInfo.getKind() == TableDescriptor.Kind.INTERNAL) {
                sqlText.append((char)comma).append("T.").append("ID");
                comma = 44;
                ++columnIndex;
            }
            ByteArrayOutputStream metaData = new ByteArrayOutputStream();
            TaggedWriter metaWriter = new TaggedWriter(metaData);
            metaWriter.putInt32(27, tableInfo.getKind().toInt());
            ReplicationRecord recordFields = new ReplicationRecord(this.ssHost, connection, tableInfo);
            for (FieldDescriptor f : tableInfo.getFields()) {
                if (!f.isAlternativeKey() && (f.isVirtual() || !fieldFilter.empty() && !fieldFilter.contains(f.getId())) || f.isAutoFill()) continue;
                int fieldId = f.getId();
                DataType fieldType = f.getType();
                if (fieldType == DataType.BLOB && f.getBlobRawType() == FieldDescriptor.BlobRawType.BINARY && f.getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) continue;
                metaWriter.putInt32(10, fieldId);
                metaWriter.putInt32(12, fieldType.toInt());
                metaWriter.putInt32(14, f.getSize());
                if (f.isAlternativeKey()) {
                    metaWriter.putEmpty(56);
                }
                sqlText.append((char)comma).append("T.").append(f.getRawName());
                comma = 44;
                recordFields.add(f, ++columnIndex);
            }
            metaWriter.flush();
            this.idle();
            out.putRaw(1, metaData);
            sqlText.append(" from ");
            if (writeParams.useDataSlice) {
                DatabaseDescriptor databaseDescriptor = connection.getDescriptor();
                if (Ini.ReplSample == 0) {
                    sqlText.appendFull(tableInfo).append(" T");
                    TableDataAudit.dataSliceSql(connection, sqlText, writeParams.backReceivingId);
                    sqlText.append(" and T.").append(pkField.getRawName()).append('=').append("PHX_CHANGELOG").append('.').append("RECORD_ID").append(" INNER JOIN ");
                    databaseDescriptor.appendAuditTableRawName("PHX_CHANGELOG_TRANS", sqlText.getBuilder());
                    sqlText.append(" ").append("PHX_CHANGELOG_TRANS").append(" ON ");
                    sqlText.append("PHX_CHANGELOG_TRANS").append('.').append("ID");
                    sqlText.append('=').append("PHX_CHANGELOG").append('.').append("TRANS_ID");
                    sqlText.append(" AND ").append("PHX_CHANGELOG_TRANS").append('.').append("T_END");
                    sqlText.append(">=? AND ").append("PHX_CHANGELOG_TRANS").append('.').append("T_END");
                    sqlText.append("<=?");
                    if (writeParams.filter != null) {
                        sqlText.append(" WHERE T.").append(pkField).append(" in (").append(writeParams.filter.getSqlText()).append(")");
                    }
                    sqlText.append(" ORDER BY T.").append(pkField.getRawName()).append(',').append("PHX_CHANGELOG").append('.').append("OP_TIME").append(" ASC");
                } else {
                    databaseDescriptor.appendAuditTableRawName("PHX_CHANGELOG_TRANS", sqlText.getBuilder());
                    sqlText.append(" TL \n  INNER JOIN ");
                    databaseDescriptor.appendAuditTableRawName("PHX_CHANGELOG", sqlText.getBuilder());
                    sqlText.append(" CL ON ").append("TL.ID = CL.TRANS_ID\n  INNER JOIN ");
                    sqlText.appendFull(tableInfo).append(" T ON (CL.RECORD_ID=T.").append(pkField);
                    sqlText.append(") \nwhere \n  TL.T_END >= ? and TL.T_END <= ?");
                    if (writeParams.backReceivingId == 0.0) {
                        sqlText.append(" and \n  TL.REPL_NODE_ID is null");
                    } else {
                        sqlText.append(" and \n  (TL.REPL_NODE_ID <> ? or TL.REPL_NODE_ID is null)");
                    }
                    sqlText.append(" and \n  CL.TABLE_ID = ?");
                    if (writeParams.filter != null) {
                        sqlText.append("\nand T.").append(pkField).append(" in (").append(writeParams.filter.getSqlText()).append(")");
                    }
                    sqlText.append(" \nORDER BY CL.RECORD_ID ASC, CL.OP_TIME ASC");
                }
            } else {
                sqlText.appendFull(tableInfo).append(" T");
                if (writeParams.filter != null) {
                    sqlText.append(" WHERE T.").append(pkField).append(" in (").append(writeParams.filter.getSqlText()).append(")");
                }
            }
            try (PreparedStatement statement = connection.prepareStatement(sqlText.toString());){
                this.idle();
                if (writeParams.useDataSlice) {
                    int index = 0;
                    if (Ini.ReplSample == 0) {
                        statement.setDouble(++index, writeParams.tableInfo.getNodeId());
                        statement.setDateTime(++index, writeParams.minChangesTime);
                        statement.setDateTime(++index, writeParams.maxTransTime);
                        if (writeParams.backReceivingId != 0.0) {
                            statement.setDouble(++index, writeParams.backReceivingId);
                        }
                        statement.setDateTime(++index, writeParams.minTransTime);
                        statement.setDateTime(++index, writeParams.maxTransTime);
                    } else {
                        statement.setDateTime(++index, writeParams.minTransTime);
                        statement.setDateTime(++index, writeParams.maxTransTime);
                        if (writeParams.backReceivingId != 0.0) {
                            statement.setDouble(++index, writeParams.backReceivingId);
                        }
                        statement.setDouble(++index, writeParams.tableInfo.getNodeId());
                    }
                }
                if (writeParams.filter != null) {
                    writeParams.filter.appendParametersTo(statement);
                }
                try (ResultSet resultSet = statement.executeQuery(this.ssContext);){
                    int pkFieldIndex = pkField != null ? resultSet.findColumn(pkField.getRawName()) : -1;
                    PhenixLinks pllinked = null;
                    PhenixLinks plelements = null;
                    while (resultSet.next()) {
                        this.idle();
                        double recordId = 0.0;
                        if (pkField != null && pkField.getType().isNumberPresentation()) {
                            recordId = resultSet.getDouble(pkFieldIndex);
                        }
                        ++stats.modified;
                        if (pllinked == null) {
                            pllinked = this.getLinked(tableInfo, connection);
                        }
                        if (plelements == null) {
                            plelements = this.getElements(tableInfo, connection);
                        }
                        recordFields.getRecordContent(resultSet, recordId, writeParams.useDataSlice && writeParams.useFieldChanges, writeParams.useDataSlice, fieldFilter, out, pllinked, plelements);
                        if (pkField != null && pkField.getType().isNumberPresentation()) continue;
                        recordFields.flush(fieldFilter, out);
                        recordFields.clear();
                    }
                    recordFields.flush(fieldFilter, out);
                }
            }
        }
    }

    public Upload beginUpload(BasicNode table, UploadParams params, IntegerSet fields) throws InformException, SQLException {
        return this.beginUpload(table.getId(), table.getContent(), params, fields);
    }

    public Upload beginUpload(double tableId, byte[] tableContent, UploadParams params, IntegerSet fields) throws InformException, SQLException {
        Upload result = new Upload();
        result.params = params;
        result.tableId = tableId;
        result.fields = fields;
        result.tableInfo = new TableDescriptor(tableId, tableContent, true);
        result.applyEngine = new DataReplicationApplyEngine(this.ssContext, params.receivingId, params.replicaId, this.ssHost, this.timeZoneHost, params.applyAccount);
        result.applyEngine.setVerbose(params.verbose);
        result.applyEngine.setDeferredCheckConstraints(params.deferredCheckConstraints);
        result.applyEngine.setReplaceData(params.replaceData);
        result.applyEngine.setInsertData(params.insertData);
        result.applyEngine.setAutoCommit(params.replaceData);
        result.applyEngine.setDatalogEnabled(params.auditData);
        result.applyEngine.setAuditAutoDetectFieldChangesEnabled(params.detailedAuditData);
        result.applyEngine.beginUploadTableData(result.tableInfo);
        result.applyEngine.setBfs(this.bfs);
        result.applyEngine.setBfsReplica(this.bfsReplica);
        return result;
    }

    public void processUpload(Upload upload, TaggedReader in) throws InformException, SQLException, IOException, NoSuchAlgorithmException {
        upload.applyEngine.updateTableData(upload.fields, in, upload.detailing);
    }

    public void processUploadTag(Upload upload, TaggedReader in) throws InformException, SQLException, IOException, NoSuchAlgorithmException {
        upload.applyEngine.updateTableDataTag(upload.fields, in, upload.detailing);
    }

    public void finalizeUpload(Upload upload) throws InformException, SQLException, IOException {
        this.idle();
        if (!upload.applyEngine.isRealCurrentTable()) {
            return;
        }
        upload.applyEngine.endUploadTableData();
        upload.applyEngine.commit();
        this.idle();
    }

    public void closeUpload(Upload upload) {
        upload.applyEngine.close();
    }

    private static boolean isFindDendriticOrUnionAndNotDistinct(byte[] content) throws IOException {
        boolean hierarchicOrUnion = false;
        TaggedReader reader = new TaggedReader(content);
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 10: 
                case 14: {
                    hierarchicOrUnion = true;
                    break;
                }
                case 9: {
                    return false;
                }
            }
        }
        return hierarchicOrUnion;
    }

    public static class Upload {
        TableDescriptor tableInfo;
        UploadParams params;
        double tableId;
        IntegerSet fields;
        public DataReplicationApplyEngine applyEngine;
        public String detailing = null;

        public boolean isRealCurrentTable() {
            return this.applyEngine != null && this.applyEngine.isRealCurrentTable();
        }
    }

    public static class RowStats {
        public int modified = 0;
        public int deleted = 0;

        void clear() {
            this.deleted = 0;
            this.modified = 0;
        }
    }

    static class WriteParams {
        final TableDescriptor tableInfo;
        double minChangesTime = 0.0;
        double minTransTime = 0.0;
        double maxTransTime = 0.0;
        boolean useDataSlice = true;
        double backReceivingId = 0.0;
        boolean useFieldChanges = false;
        GeneratedSql filter = null;

        public WriteParams(TableDescriptor tableInfo) {
            this.tableInfo = tableInfo;
        }
    }

    public static interface Idler {
        public void idle();
    }

    public static class ReplicationItem {
        double tableId = 0.0;
        IntegerSet fieldFilter = null;
        double includeFilter = 0.0;
        double excludeFilter = 0.0;
        public boolean useDataSlice = true;

        boolean isEqual(ReplicationItem p) {
            return this.tableId == p.tableId && this.includeFilter == p.includeFilter && this.excludeFilter == p.excludeFilter;
        }
    }

    public static class FieldMetadata {
        public int id;
        public SqlDataType type;
        public boolean used;
        public boolean alternativeKey;
    }
}

