/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication.request;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.SendReadyResponse;
import inform.adt.taggedio.SendReadyTaggedWriter;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.replication.BlobChannel;
import inform.agent.replication.NetChannel;
import inform.agent.replication.Replication;
import inform.agent.replication.ReplicationChannel;
import inform.agent.replication.RequestResultChannel;
import java.util.zip.DeflaterOutputStream;
import org.slf4j.impl.AsmoLogger;

public class ExecuteReplication
extends Request
implements SendReadyResponse {
    public static final int TAG_ER_CHANEL_ID = 1;
    public static final int TAG_ER_REPL_ID = 2;
    public static final int TAG_ER_GET_REPLICA = 3;
    public static final int TAG_ER_FULL_REPLICA = 4;
    public static final int TAG_ER_CHANEL_CONSTANTS = 5;
    public static final int TAG_ER_SLICEDATE_BEGIN = 6;
    public static final int TAG_ER_SLICEDATE_END = 7;
    public static final int TAG_ER_SERVER_NAME = 8;
    public static final int TAG_ER_AGENT_NAME = 9;
    public static final int TAG_ER_CANCEL_IF_DATA_ABSENT = 10;
    public static final int TAG_ER_REPLACE_DATA = 11;
    public static final int TAG_ER_DISABLE_DATA_AUDIT = 12;
    public static final int TAG_ER_SYNC_METADATA = 13;
    public static final int TAG_ER_USE_FIELDCHANGES = 14;
    public static final int TAG_ER_HIDE_LOG = 15;
    public static final int TAG_ER_BLOB_REPLICATION = 16;
    public static final int TAG_ER_CREATE_START_REPLICA = 17;
    public static final int TAG_ER_IGNORE_NONE_AUDIT_TABLES = 18;
    public static final int TAG_ER_MAX_RANGE = 19;
    private static final int TAG_ER_OWNER_NODE = 20;
    private static final int TAG_ER_DEFERRED_CHK_CONSTR = 21;
    private final ByteArrayOutputStream result = new ByteArrayOutputStream();
    private DeflaterOutputStream compression = null;
    private final SendReadyTaggedWriter out;
    private int chunkCount = 0;
    private long dataSize = 0L;
    private long sendedSize = 0L;

    public ExecuteReplication(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX, AsmoLogger.Level.INFO);
        this.rq.contentPacked = true;
        this.compression = new DeflaterOutputStream(this.result);
        this.out = new SendReadyTaggedWriter(this.compression, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        Node replNode;
        Node chanelNode;
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        TaggedReader in = this.createRequestContentReader();
        double chanelId = 0.0;
        double replId = 0.0;
        boolean getReplica = false;
        boolean blobReplica = false;
        boolean fullReplica = false;
        boolean syncMetadata = false;
        byte[] constants = null;
        double sliceBegin = 0.0;
        double sliceEnd = 0.0;
        String serverName = null;
        String agentName = null;
        boolean cancelIfNoData = false;
        boolean replaceData = false;
        boolean disableAudit = false;
        boolean useFieldChanges = false;
        boolean hideLog = false;
        boolean createStartReplica = false;
        double startReplicaDate = DateTime.currentDateTime();
        boolean ignoreNoneAuditTables = false;
        boolean deferredCheckConstraints = false;
        double maxRange = 0.0;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.rqstat.nodeId = chanelId = in.getDouble();
                    break;
                }
                case 2: {
                    replId = in.getDouble();
                    break;
                }
                case 3: {
                    getReplica = true;
                    break;
                }
                case 4: {
                    fullReplica = true;
                    break;
                }
                case 13: {
                    syncMetadata = true;
                    break;
                }
                case 5: {
                    constants = in.getRaw();
                    break;
                }
                case 6: {
                    sliceBegin = DateTime.toServerTime(in.getDouble(), this);
                    break;
                }
                case 7: {
                    sliceEnd = DateTime.toServerTime(in.getDouble(), this);
                    break;
                }
                case 8: {
                    serverName = in.getString();
                    break;
                }
                case 9: {
                    agentName = in.getString();
                    break;
                }
                case 10: {
                    cancelIfNoData = true;
                    break;
                }
                case 11: {
                    replaceData = true;
                    break;
                }
                case 12: {
                    disableAudit = true;
                    break;
                }
                case 14: {
                    useFieldChanges = true;
                    break;
                }
                case 15: {
                    hideLog = true;
                    break;
                }
                case 17: {
                    createStartReplica = true;
                    startReplicaDate = DateTime.toServerTime(in.getDouble(), this);
                    break;
                }
                case 16: {
                    blobReplica = true;
                    break;
                }
                case 18: {
                    ignoreNoneAuditTables = true;
                    break;
                }
                case 19: {
                    maxRange = in.getDouble();
                    break;
                }
                case 20: {
                    this.rqstat.ownerId = in.getDouble();
                    break;
                }
                case 21: {
                    deferredCheckConstraints = true;
                }
            }
        }
        if (!getReplica) {
            cancelIfNoData = false;
        }
        if ((chanelNode = MtdEngine.getNode(chanelId)) == null || chanelNode.getType() != 53) {
            if (chanelId == 0.0) {
                throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u0430\u043d\u0430\u043b \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439");
            }
            MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043a\u0430\u043d\u0430\u043b\u0430 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439", chanelId);
        }
        if ((replNode = MtdEngine.getNode(replId)) == null || replNode.getType() != 22) {
            if (replId == 0.0) {
                throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0443\u0437\u0435\u043b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439");
            }
            MtdEngine.throwDetailError("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0439", replId);
        }
        ReplicationChannel chanel = null;
        chanel = getReplica ? new RequestResultChannel(chanelId, this, this.out) : (blobReplica ? new BlobChannel(chanelId, this) : new NetChannel(chanelId, this));
        chanel.load();
        if (constants != null) {
            chanel.setConstantsContent(constants);
        }
        if ((serverName != null || agentName != null) && chanel instanceof NetChannel) {
            if (serverName != null) {
                ((NetChannel)chanel).setServer(serverName);
            }
            if (agentName != null) {
                ((NetChannel)chanel).setAgent(agentName);
            }
        }
        Replication replication = new Replication(this.ssContext, this, replId, chanel);
        if (fullReplica || syncMetadata) {
            replication.setFullReplica();
        }
        if (syncMetadata) {
            replication.setSyncMetadata();
        }
        if (cancelIfNoData) {
            replication.setCancelIfNoData();
        }
        if (disableAudit) {
            replication.setDisableAudit();
        }
        if (replaceData) {
            replication.setReplaceData();
        }
        if (useFieldChanges) {
            replication.setUseFieldChanges(2);
        }
        if (createStartReplica) {
            replication.setStartReplicaDate(startReplicaDate);
        }
        if (ignoreNoneAuditTables) {
            replication.setIgnoreNoneAuditTables();
        }
        replication.setDeferrableCheckConstraints(deferredCheckConstraints);
        if (maxRange > 0.0) {
            replication.setMaxRange(maxRange);
        }
        replication.setRequestStateLogEnabled(!hideLog);
        try {
            replication.execute(sliceBegin, sliceEnd);
        }
        finally {
            replication.close();
        }
    }

    public void finalizeSend(byte[] info, int infoSize) throws Exception {
        this.sendResult(null, 0, info, infoSize);
    }

    @Override
    public void notifyReadyToSend() throws Exception {
        this.idle();
        if (this.out == null) {
            return;
        }
        if (this.out.getInputSize() == 0L) {
            return;
        }
        this.out.flush();
        this.compression.close();
        this.idle();
        ++this.chunkCount;
        this.dataSize += this.out.getInputSize();
        this.sendedSize += (long)this.result.size();
        Core.logger.info("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0447\u0430\u0441\u0442\u0438 \u0440\u0435\u043f\u043b\u0438\u043a\u0438(\u043d\u043e\u043c\u0435\u0440 {}, \u0440\u0430\u0437\u043c\u0435\u0440 {}, \u0432\u0441\u0435\u0433\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e {})", this.chunkCount, this.result.size(), this.sendedSize);
        this.sendChunk(this.result.internalBuffer(), this.result.size());
        this.result.reset();
        this.compression = new DeflaterOutputStream(this.result);
        this.out.reset(this.compression);
        this.idle();
    }

    public int getChunkCount() {
        return this.chunkCount;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getSendedSize() {
        return this.sendedSize;
    }

    public long getTransferSize() {
        if (this.out != null) {
            return this.dataSize + this.out.getInputSize();
        }
        return this.dataSize;
    }
}

