/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.replication.request;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.ServerSideHost;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.Restructure;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.AlertingEngine;
import inform.agent.replication.TableDataIO;
import inform.agent.replication.UploadParams;
import inform.agent.replication.request.UploadNodeSet;
import inform.agent.scripts.SSContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.zip.InflaterInputStream;

public class UploadNode
extends Request {
    private final double serverTime = DateTime.currentDateTime();
    public static final int TAG_RQ_UPLOADNODE_SERVER_TIME = 1;
    private UploadNodeSet _upParams = null;

    public UploadNode(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    @Override
    protected void processInputChunk(byte[] chunk) throws InformException, SQLException, IOException, NoSuchAlgorithmException {
        ByteArrayInputStream input = new ByteArrayInputStream(chunk);
        InflaterInputStream compression = new InflaterInputStream(input);
        if (this._upParams != null) {
            this._upParams.upload(new TaggedReader(compression));
        }
    }

    public void proxyProcessInputChunk(byte[] chunk) throws InformException, SQLException, IOException, NoSuchAlgorithmException {
        this.processInputChunk(chunk);
    }

    public void proxyProcessChunkedInput() throws Throwable {
        this.processChunkedInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void uploadNode(double requestNodeId, UploadNodeSet upParams, SSContext context, ServerSideHost host, TaggedReader in) throws SQLException, IOException, Throwable {
        block38: {
            upParams.moveNodes = true;
            upParams.node = MtdEngine.getValidNode(requestNodeId);
            if (upParams.node.isInTrashRecursive()) {
                MtdEngine.throwDetailError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0443\u0437\u0435\u043b, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u043a\u043e\u0440\u0437\u0438\u043d\u0435", upParams.node.getId());
            }
            try (Connector.Metabase connector = new Connector.Metabase();){
                upParams.arg = new Node.ModifyNodeArg(host, connector, NodeStatus.MODIFIED, host.security());
                upParams.arg.userId = host.getUserID();
                upParams.arg.sessionId = host.getSessionID();
                upParams.params = new UploadParams(0.0, null);
                upParams.params.verbose = true;
                upParams.tableData = new TableDataIO(null, host, host);
                try {
                    try {
                        block29: while (in.next()) {
                            switch (in.getCurrentTag()) {
                                case 16: {
                                    upParams.replicaId = upParams.params.replicaId = in.getDouble();
                                    upParams.arg.auditComment = "pex-\u0444\u0430\u0439\u043b " + NumberConverter.doubleToString(upParams.replicaId);
                                    break;
                                }
                                case 20: {
                                    upParams.arg.auditComment = in.getString();
                                    break;
                                }
                                case 8: {
                                    upParams.params.replaceData = true;
                                    break;
                                }
                                case 2: {
                                    upParams.applyAttribute(upParams.arg);
                                    upParams.attributes = in.getRaw();
                                    break;
                                }
                                case 14: {
                                    upParams.params.auditData = true;
                                    break;
                                }
                                case 21: {
                                    upParams.params.detailedAuditData = true;
                                    break;
                                }
                                case 7: {
                                    int[] ids;
                                    byte[] tagContent = in.getRaw();
                                    for (int id : ids = LittleEndian.toIntArray(tagContent)) {
                                        upParams.fields.add(id);
                                    }
                                    continue block29;
                                }
                                case 3: {
                                    upParams.applyAttribute(upParams.arg);
                                    upParams.upload(in.getStreamReader());
                                    break;
                                }
                                case 11: {
                                    upParams.applyAttribute(upParams.arg);
                                    if (host instanceof UploadNode) {
                                        ((UploadNode)host).proxyProcessInputChunk(in.getRaw());
                                        break;
                                    }
                                    ByteArrayInputStream input = new ByteArrayInputStream(in.getRaw());
                                    InflaterInputStream compression = new InflaterInputStream(input);
                                    upParams.upload(new TaggedReader(compression));
                                    break;
                                }
                                case 17: {
                                    upParams.applyAttribute(upParams.arg);
                                    if (!(host instanceof Request)) break;
                                    ((Request)host).setChunkedInput();
                                    break;
                                }
                                case 18: {
                                    upParams.moveNodes = false;
                                    continue block29;
                                }
                            }
                        }
                        upParams.applyAttribute(upParams.arg);
                        if (host instanceof UploadNode) {
                            ((UploadNode)host).proxyProcessChunkedInput();
                        }
                        if (upParams.upload != null) {
                            upParams.tableData.finalizeUpload(upParams.upload);
                        }
                        if (!upParams.params.recreateIndexes) break block38;
                        TableDescriptor td = ((TableNode)upParams.arg.getNode(requestNodeId)).getDescriptor();
                        boolean mtdConnection = td.getDbId() == 2.0;
                        DatabaseConnection connection = mtdConnection ? connector.connection() : td.getDatabaseDescriptor().connect(host, "UploadNode");
                        try (Statement statement = connection.createStatement();){
                            Restructure.restructureIndices(context, connection.openScheme(), statement, td, td, Restructure.DDL_LOGGER, Restructure.Strategy.UPDATE, null, new Restructure.Progress.FromSSHost(host));
                            connection.commit();
                        }
                        finally {
                            if (!mtdConnection) {
                                connection.close();
                            }
                        }
                    }
                    catch (Throwable e) {
                        if (upParams.upload == null) throw e;
                        try {
                            upParams.upload.applyEngine.rollback();
                            throw e;
                        }
                        catch (Throwable ex) {
                            Core.logger.error(null, ex);
                        }
                        throw e;
                    }
                }
                finally {
                    if (upParams.upload != null) {
                        upParams.tableData.closeUpload(upParams.upload);
                    }
                }
            }
        }
        if (upParams.securityChanged) {
            AccountNode.invalidateSecurity();
        }
        ByteArrayOutputStream notification = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(notification);
        stream.putDouble(3, requestNodeId);
        stream.flush();
        AlertingEngine.sendChangeNotification(null, notification.internalBuffer(), notification.size(), 0L);
    }

    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        if (this.security().role() != UserRole.ADMIN) {
            AccountNode.UserInterface ui = this.security().getUserInterface();
            if (!ui.canUploadPex) {
                double userId = this.getUserID();
                String userName = MtdEngine.tryGetUserName(userId);
                throw new InformException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e " + userName + " [" + NumberConverter.doubleToString(userId) + "] \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u043f\u0435\u043a\u0441");
            }
        }
        this.checkNodeAccess(MtdEngine.getValidNode(this.getNodeID()), Integer.MIN_VALUE, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0443\u0437\u043b\u0430");
        TaggedReader in = this.createRequestContentReader();
        this._upParams = new UploadNodeSet(this.ssContext, this, false);
        UploadNode.uploadNode(this.getNodeID(), this._upParams, this.ssContext, this, in);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        out.putDouble(1, this.serverTime);
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

