/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.schemes.ModificationCommand;
import inform.agent.schemes.ObjectExistsException;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeObject;
import java.util.Date;

class AddObjectCommand
extends ModificationCommand {
    AddObjectCommand() {
    }

    @Override
    public void run(Scheme scheme, Request request) throws InformException {
        SchemeObject so = this.getLockedObject();
        assert (so != null);
        so.setAdded(true);
        Core.logger.debug("Placing {} last because client did not specified position.", so.toString());
        scheme.placeLast(so);
        so.setRevision(this.getSessionSchemeRevision());
        so.setLastModTime(DateTime.fromUnixTime(new Date().getTime()));
        so.setLastModUser(request.getUserID());
    }

    @Override
    boolean isModificationAllowed(Scheme scheme) {
        boolean allowed;
        SchemeObject so = this.getLockedObject();
        boolean bl = allowed = so != null;
        if (!allowed) {
            Core.logger.debug("Denial reason: object doesn't exist");
            return false;
        }
        boolean bl2 = allowed = allowed && so.getRevision() == -1;
        if (!allowed) {
            Core.logger.debug("Denial reason: revisions mismatch, server {}, client {}", so.getRevision(), -1);
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockObject(Scheme scheme, long handle) throws InterruptedException {
        if (this.getLockedObject() == null) {
            SchemeObject so = this.getSubjectDescriptor();
            so.setRevision(-1);
            so.lock(handle);
            try {
                block11: {
                    try {
                        scheme.placeUnlinked(so);
                    }
                    catch (ObjectExistsException ex) {
                        Core.logger.error(null, ex);
                        so = scheme.getObjectSilent(this.getSubjectDescriptor().getType(), this.getSubjectDescriptor().getID());
                        if (so == null || !so.isDeleted()) break block11;
                        so.setRevision(-1);
                        so.setDeleted(false);
                    }
                }
                super.lockObject(scheme, handle);
            }
            finally {
                try {
                    if (so != null) {
                        so.unlock(handle);
                    }
                }
                catch (Throwable ex) {
                    Core.logger.error(null, ex);
                }
            }
        }
    }
}

