/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;

public class BindingNode
implements DoubleHash.Entry {
    private double id = 0.0;
    private double infoTable = 0.0;
    private double bindTable = 0.0;
    private int scheme = 0;
    private int layer = 0;
    private int shape = 0;
    private int convertStyle = 0;
    private int fkField = 0;
    private int infoKeyField = 0;
    private DoubleHash<DBObject> dbObjects = new DoubleHash();

    @Override
    public double key() {
        return this.id;
    }

    public BindingNode(double id) {
        this.id = id;
    }

    protected void parse(SSContext ssContext, ConnectionManager dbMgr, double schemeID) throws IOException, TaggedReaderException, InformException, SQLException {
        BasicNode node = null;
        Node n = null;
        if (!Ini.libraryMode) {
            n = MtdEngine.getNode(this.id);
        }
        if (n != null) {
            node = n.getRealNode();
        }
        if (node == null) {
            Core.logger.info("\u0427\u0442\u0435\u043d\u0438\u0435 \u0443\u0437\u043b\u0430 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 {}: \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0443\u0437\u0435\u043b \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445", (Object)NumberConverter.doubleToString(this.id));
        } else if (node.getType() != 29) {
            Core.logger.info("\u0427\u0442\u0435\u043d\u0438\u0435 \u0443\u0437\u043b\u0430 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 {}: \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 {}", (Object)NumberConverter.doubleToString(this.id), (Object)node.getType());
        } else {
            byte[] content = node.getContent();
            if (content.length > 0) {
                TaggedReader reader = new TaggedReader(content);
                while (reader.getNextTag() != 0) {
                    switch (reader.getCurrentTag()) {
                        case 1: {
                            this.infoTable = reader.getNodeID();
                            break;
                        }
                        case 20: {
                            this.bindTable = reader.getNodeID();
                            break;
                        }
                        case 21: {
                            this.scheme = reader.getFieldID();
                            break;
                        }
                        case 22: {
                            this.layer = reader.getFieldID();
                            break;
                        }
                        case 23: {
                            this.shape = reader.getFieldID();
                            break;
                        }
                        case 24: {
                            this.convertStyle = reader.getFieldID();
                            break;
                        }
                        case 25: {
                            this.fkField = reader.getFieldID();
                            break;
                        }
                        case 26: {
                            this.infoKeyField = reader.getFieldID();
                        }
                    }
                }
                this.loadDBObjects(ssContext, dbMgr, schemeID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDBObjects(SSContext ssContext, ConnectionManager dbMgr, double schemeID) throws IOException, TaggedReaderException, InformException, SQLException {
        if (this.bindTable == 0.0 || this.scheme == 0 || this.fkField == 0) {
            return;
        }
        TableDescriptor tableDesc = TableDescriptor.getIfExists(this.bindTable);
        if (tableDesc == null) {
            return;
        }
        DatabaseDescriptor dbDesc = tableDesc.getDatabaseDescriptor();
        if (dbDesc == null) {
            return;
        }
        FieldDescriptor schemeFieldDesc = tableDesc.getFieldDescriptor(this.scheme);
        if (schemeFieldDesc == null) {
            return;
        }
        FieldDescriptor shapeFieldDesc = tableDesc.getFieldDescriptor(this.shape);
        if (shapeFieldDesc == null) {
            return;
        }
        FieldDescriptor fkFieldFieldDesc = tableDesc.getFieldDescriptor(this.fkField);
        if (fkFieldFieldDesc == null) {
            return;
        }
        Object schemeStr = "";
        if (dbDesc.getScheme() != null) {
            schemeStr = dbDesc.getScheme() + ".";
        }
        long t1 = System.currentTimeMillis();
        try (DatabaseConnection conn = tableDesc.getDatabaseDescriptor().connect(dbMgr.getSSHost(), "BindingNode::LoadDBObjects");){
            block17: {
                String sql = String.format("SELECT %s, %s, %s FROM %s%s WHERE %s = %s", schemeFieldDesc.getRawName(), shapeFieldDesc.getRawName(), fkFieldFieldDesc.getRawName(), schemeStr, tableDesc.getRawName(), schemeFieldDesc.getRawName(), schemeID);
                try (PreparedStatement stmt = conn.prepareStatement(sql);){
                    ResultSet result = stmt.executeQuery(ssContext);
                    if (result == null) break block17;
                    try {
                        double shapeID = 0.0;
                        double objID = 0.0;
                        while (result.next()) {
                            shapeID = result.getDouble(2);
                            objID = result.getDouble(3);
                            if (shapeID == 0.0 || objID == 0.0 || this.dbObjects.get(shapeID) != null) continue;
                            this.dbObjects.add(new DBObject(shapeID, objID));
                        }
                    }
                    finally {
                        result.close();
                    }
                }
            }
            conn.commit();
        }
        long t2 = System.currentTimeMillis();
        Core.logger.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0411\u0414 ({}) \u0443\u0437\u043b\u0430 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 {}: {}ms", this.dbObjects.size(), NumberConverter.doubleToString(this.id), t2 - t1);
    }

    public double getInfoTable() {
        return this.infoTable;
    }

    public double getBindTable() {
        return this.bindTable;
    }

    public int getScheme() {
        return this.scheme;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getShape() {
        return this.shape;
    }

    public int getConvertStyle() {
        return this.convertStyle;
    }

    public int getFKField() {
        return this.fkField;
    }

    public int getInfoKeyField() {
        return this.infoKeyField;
    }

    public double getDBObject(double shapeID) {
        DBObject obj = this.dbObjects.get(shapeID);
        if (obj != null) {
            return obj.objID;
        }
        return 0.0;
    }

    private static class DBObject
    implements DoubleHash.Entry {
        private double shapeID;
        private double objID;

        public DBObject(double shapeID, double objID) {
            this.shapeID = shapeID;
            this.objID = objID;
        }

        @Override
        public double key() {
            return this.shapeID;
        }
    }
}

