/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.SchemeParser;
import java.io.IOException;
import java.util.ArrayList;

public class Diagram
extends Rectangle {
    private static final int TAG_DIAGRAM_SERIES = 1;
    private static final int TAG_SERIE_TABLE_ID = 1;
    private static final int TAG_SERIE_TYPE = 2;
    private static final int TAG_SERIE_X_FIELD_IDX = 3;
    private static final int TAG_SERIE_Y_FIELD_IDX = 4;
    private static final int TAG_SERIE_T_FIELD_IDX = 5;
    public ArrayList<Serie> SeriesList = new ArrayList();

    private void loadSerieTags(TaggedReader reader, Serie serie) throws IOException {
        byte type = 0;
        double indx = 0.0;
        block7: while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    indx = reader.getDouble();
                    continue block7;
                }
                case 2: {
                    type = reader.getByte();
                    continue block7;
                }
                case 3: {
                    serie.XFieldIndex = reader.getInt();
                    continue block7;
                }
                case 4: {
                    serie.YFieldIndex = reader.getInt();
                    continue block7;
                }
                case 5: {
                    serie.StrFieldIndex = reader.getInt();
                    continue block7;
                }
            }
        }
        serie.SType = type;
        serie.TableId = indx;
    }

    @Override
    protected synchronized void readExtraTagged(SchemeParser parser, TaggedReader reader, int tag) throws IOException {
        switch (tag) {
            case 27: {
                this.SeriesList.clear();
                TaggedReader subReader = reader.getStreamReader();
                block6: while (subReader.next()) {
                    switch (subReader.getCurrentTag()) {
                        case 1: {
                            subReader.skip();
                            TaggedReader in = subReader.getStreamReader(202);
                            Serie s = new Serie();
                            this.SeriesList.add(s);
                            this.loadSerieTags(in, s);
                            continue block6;
                        }
                    }
                }
                break;
            }
            default: {
                super.readExtraTagged(parser, reader, tag);
            }
        }
    }

    @Override
    protected synchronized void writeExtraTagged(TaggedWriter writer) throws IOException {
        super.writeExtraTagged(writer);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        for (Serie serie : this.SeriesList) {
            ByteArrayOutputStream subOs = new ByteArrayOutputStream();
            TaggedWriter sub = new TaggedWriter(subOs);
            sub.putDouble(1, serie.TableId);
            sub.putInt08(2, serie.SType);
            sub.putInt32(3, serie.XFieldIndex);
            sub.putInt32(4, serie.YFieldIndex);
            sub.putInt32(5, serie.StrFieldIndex);
            sub.flush();
            w.putEmpty(1);
            w.putRaw(202, subOs);
        }
        w.flush();
        if (os.size() > 0) {
            writer.putRaw(27, os);
        }
    }

    @Override
    public int shapeType() {
        return 235;
    }

    public static class Serie {
        public static final byte SERIE_TYPE_NONE = 0;
        public static final byte SERIE_TYPE_LINE = 1;
        public static final byte SERIE_TYPE_AREA = 2;
        public static final byte SERIE_TYPE_POINT = 3;
        public static final byte SERIE_TYPE_BAR = 4;
        public static final byte SERIE_TYPE_HBAR = 5;
        public static final byte SERIE_TYPE_FASTLINE = 6;
        public double TableId = 0.0;
        public byte SType = 0;
        public int XFieldIndex = 0;
        public int YFieldIndex = 1;
        public int StrFieldIndex = 0;
    }
}

