/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.AttributeDef;
import inform.agent.schemes.AttributeRef;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.Ellipse;
import inform.agent.schemes.EmbeddedText;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.Image;
import inform.agent.schemes.Paragraph;
import inform.agent.schemes.PhxGraphicInsert;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.PhxLayer;
import inform.agent.schemes.Pie;
import inform.agent.schemes.Polygon;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.RectTextLine;
import inform.agent.schemes.Rectangle;
import inform.agent.schemes.Region;
import inform.agent.schemes.Scheme;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeObject;
import inform.agent.schemes.SchemeObjectsTypes;
import inform.agent.schemes.SchemePage;
import inform.agent.schemes.SchemePageLayout;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.Spline;
import inform.agent.schemes.TransformProps;
import inform.agent.web.utils.ImageInfo;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.image4j.codec.ico.ICODecoder;
import net.sf.image4j.codec.ico.ICOImage;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPatternContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType2;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;

public class PdfWriter {
    private static final double PAGE_MAX_SIZE = 5080.0;
    private static final float POINTS_PER_MM = 2.8346457f;
    private static final float[] PEN_PATTERN_SOLID = new float[]{15.0f, 0.0f};
    private static final float[] PEN_PATTERN_DASH = new float[]{21.0f, 9.0f};
    private static final float[] PEN_PATTERN_DOT = new float[]{6.0f, 6.0f};
    private static final float[] PEN_PATTERN_DASH_DOT = new float[]{18.0f, 9.0f, 6.0f, 9.0f};
    private static final float[] PEN_PATTERN_DASH_DOT2 = new float[]{18.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f};
    private double originX = 0.0;
    private double originY = 0.0;
    private double PAGE_MARGIN = 10.0;
    private final Scheme s;
    private final SchemeEngine engine;
    private SchemePage page;
    private double schemeScale = 1.0;
    private double pageScale = 1.0;
    private double schemeLeft = 0.0;
    private double schemeBottom = 0.0;
    private boolean insertMode = false;
    private boolean backPageShapes = false;
    private PhxGraphicInsert curInsert;
    private PDPage pdPage;
    private final PDDocument pdf;
    PDPageContentStream contentStream = null;
    private final HashMap<String, PDFont> fontMap = new HashMap();
    private final HashMap<PhxLayer, PDOptionalContentGroup> layers = new HashMap();
    private ServerSideHost stateHost;
    private static final int PATTERN_SIZE = 16;
    private static final String horizImage = "                                                                                                XXXXXXXXXXXXXXXX                                                                                                                XXXXXXXXXXXXXXXX                ";
    private static final String vertImage = "     X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X  ";
    private static final String diagRevertImage = "X       X        X       X        X       X        X       X        X       X        X       X        X       X        X       XX       X        X       X        X       X        X       X        X       X        X       X        X       X        X       X";
    private static final String diagImage = "   X       X      X       X      X       X      X       X              X       X      X       X      X       X      X       X      X       X      X       X      X       X      X       X              X       X      X       X      X       X      X       X   ";
    private static final String cellImage = "     X       X       X       X       X       X       X       X       X       X       X       X  XXXXXXXXXXXXXXXX     X       X       X       X       X       X       X       X       X       X       X       X       X       X  XXXXXXXXXXXXXXXX     X       X  ";
    private static final String diagCellImage = "X  X    X  X     XX      XX      XX      XX     X  X    X  X        X  X    X  X     XX      XX      XX      XX     X  X    X  XX  X    X  X     XX      XX      XX      XX     X  X    X  X        X  X    X  X     XX      XX      XX      XX     X  X    X  X";
    private static final String dotImage = "XXXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXX XXXXXXX";
    private static final String dot2Image = "XXXXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXXXXXX XXX XXX XXX XXXXXXXXXXXXXXXXX XXX XXX XXX XX";
    private static final String dot3Image = "XX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXXXX XXX XXX XXX X XXX XXX XXX XXX";
    private static final String dot4Image = "X X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X XX X X X X X X X  X X X X X X X X";
    private static final String dot5Image = "  X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X     X   X   X   X X   X   X   X   ";
    private static final String dot6Image = "                 X   X   X   X                     X   X   X   X                 X   X   X   X                     X   X   X   X                 X   X   X   X                     X   X   X   X                 X   X   X   X                     X   X   X   X";
    private static final String dot7Image = "                  X       X                           X       X                   X       X                           X       X                   X       X                           X       X                   X       X                           X       X ";
    private static final String horiz2Image = "                                                                                XXXXXXXXXXXXXXXX                                                                                                                XXXXXXXXXXXXXXXX                                ";
    private static final String doubleHorizImage = "                                                                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                                                                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                ";
    private static final String horiz3Image = "                                XXXXXXXXXXXXXXXX                                                XXXXXXXXXXXXXXXX                                                XXXXXXXXXXXXXXXX                                                XXXXXXXXXXXXXXXX                ";
    private static final String doubleHoriz2Image = "                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                ";
    private static final String horiz4Image = "XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                XXXXXXXXXXXXXXXX                ";
    private static final String vert2Image = "X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       X       ";
    private static final String doubleVertImage = "XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      ";
    private static final String vert3Image = "  X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X ";
    private static final String doubleVert2Image = "  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX  XX";
    private static final String vert4Image = "X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X ";
    private static final String diag2Image = "     X       X      X       X      X       X      X       X      X       X      X       X              X       X      X       X      X       X      X       X      X       X      X       X      X       X      X       X              X       X      X       X ";
    private static final String doubleDiagImage = "      XX      XX     XX      XX     XX      XX     XX      XX     XX      XX     XX      XX     XX      XX      X      XX      X      XX      XX     XX      XX     XX      XX     XX      XX     XX      XX     XX      XX     XX      XX      X      XX      X";
    private static final String diag3Image = "   X   X   X   X  X   X   X   X  X   X   X   X  X   X   X   X      X   X   X   X  X   X   X   X  X   X   X   X  X   X   X   X      X   X   X   X  X   X   X   X  X   X   X   X  X   X   X   X      X   X   X   X  X   X   X   X  X   X   X   X  X   X   X   X   ";
    private static final String doubleDiag2Image = "XX  XX  XX  XX  X  XX  XX  XX  X  XX  XX  XX  XX XX  XX  XX  XX XX  XX  XX  XX  X  XX  XX  XX  X  XX  XX  XX  XX XX  XX  XX  XX XX  XX  XX  XX  X  XX  XX  XX  X  XX  XX  XX  XX XX  XX  XX  XX XX  XX  XX  XX  X  XX  XX  XX  X  XX  XX  XX  XX XX  XX  XX  XX ";
    private static final String tripleDiagImage = "X XXX XXX XXX XX XXX XXX XXX XXXXXX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XXXXXX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XXXXXX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XX XXX XXX XXX XXXXXX XXX XXX XXX XX XXX XXX XXX X";
    private static final String diagRevert2Image = "   X       X        X       X        X       X        X       X        X       XX       X        X       X        X       X        X       X        X       X        X       X        X       X        X       XX       X        X       X        X       X     ";
    private static final String doubleDiagRevertImage = "   XX      XX       XX      XX       XX      XX       XX      XXX      XX      XXX      XX       XX      XX       XX      XX       XX      XX       XX      XX       XX      XX       XX      XXX      XX      XXX      XX       XX      XX       XX      XX    ";
    private static final String diagRevert3Image = "X   X   X   X    X   X   X   X    X   X   X   X    X   X   X   XX   X   X   X    X   X   X   X    X   X   X   X    X   X   X   XX   X   X   X    X   X   X   X    X   X   X   X    X   X   X   XX   X   X   X    X   X   X   X    X   X   X   X    X   X   X   X";
    private static final String doubleDiagRevert2Image = "XX  XX  XX  XX   XX  XX  XX  XX   XX  XX  XX  XXX  XX  XX  XX  XXX  XX  XX  XX   XX  XX  XX  XX   XX  XX  XX  XXX  XX  XX  XX  XXX  XX  XX  XX   XX  XX  XX  XX   XX  XX  XX  XXX  XX  XX  XX  XXX  XX  XX  XX   XX  XX  XX  XX   XX  XX  XX  XXX  XX  XX  XX  X";
    private static final String tripleDiagRevertImage = "XX XXX XXX XXX XXXX XXX XXX XXX  XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX  XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX  XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX XXXX XXX XXX XXX  XXX XXX XXX XXXX XXX XXX XXX XX";
    private static final String cell2Image = "XXXXXXXXXXXXXXXX       X       X       X       X       X       X       X       X       X       X       X       X       X       XXXXXXXXXXXXXXXXX       X       X       X       X       X       X       X       X       X       X       X       X       X       X";
    private static final String doubleCellImage = "XXXXXXXXXXXXXXXXX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XX      XXXXXXXXXXXXXXXXX";
    private static final String cell3Image = "  X   X   X   X   X   X   X   X   X   X   X   X XXXXXXXXXXXXXXXX  X   X   X   X   X   X   X   X   X   X   X   X XXXXXXXXXXXXXXXX  X   X   X   X   X   X   X   X   X   X   X   X XXXXXXXXXXXXXXXX  X   X   X   X   X   X   X   X   X   X   X   X XXXXXXXXXXXXXXXX";
    private static final String doubleCell2Image = "XXXXXXXXXXXXXXXX XX  XX  XX  XX  XX  XX  XX  XX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XX  XX  XX  XX  XX  XX  XX  XX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XX  XX  XX  XX  XX  XX  XX  XX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XX  XX  XX  XX  XX  XX  XX  XX XXXXXXXXXXXXXXXX";
    private static final String cell4Image = "XXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X XXXXXXXXXXXXXXXXX X X X X X X X X";
    private static final String diagCell2Image = "   X   X   X   X    X X     X X      X       X      X X     X X    X   X   X   XX X     X X      X       X      X X     X X        X   X   X   X    X X     X X      X       X      X X     X X    X   X   X   XX X     X X      X       X      X X     X X     ";
    private static final String doubleDiagCellImage = "X  XX  XX  XX  X    XXXX    XXXX     XX      XX     XXXX    XXXXX  XX  XX  XX  XXXXX    XXXX     XX      XX     XXXX    XXXX    X  XX  XX  XX  X    XXXX    XXXX     XX      XX     XXXX    XXXX   XX  XX  XX  XX XX    XXXX     XX      XX     XXXX    XXXX    ";
    private static final String diagCell3Image = " X   X   X   X  X X X X X X X X    X   X   X   XX X X X X X X X  X   X   X   X  X X X X X X X X    X   X   X   XX X X X X X X X  X   X   X   X  X X X X X X X X    X   X   X   XX X X X X X X X  X   X   X   X  X X X X X X X X    X   X   X   XX X X X X X X X ";
    private static final String doubleDiagCell2Image = "  XX  XX  XX  XX  XX  XX  XX  XXXX  XX  XX  XX  XX  XX  XX  XX    XX  XX  XX  XX  XX  XX  XX  XXXX  XX  XX  XX  XX  XX  XX  XX    XX  XX  XX  XX  XX  XX  XX  XXXX  XX  XX  XX  XX  XX  XX  XX    XX  XX  XX  XX  XX  XX  XX  XXXX  XX  XX  XX  XX  XX  XX  XX  ";
    private static final String pattern1Image = "     XX      XX XX   XX XX   XX XX XX   XX XX      XX      XX   X      XX      XX   XX XX   XX X XX XX   XX XX   XX      XX          XX      XX XX   XX XX   XX XX XX   XX XX      XX      XX   X      XX      XX   XX XX   XX X XX XX   XX XX   XX      XX     ";
    private static final String pattern2Image = "      X       X  X       X          X       X   X       X            X       X    X       X            X       X   X       X          X       X  X       X          X       X   X       X            X       X    X       X            X       X   X       X    ";
    private static final String pattern3Image = "                X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X                 X X X X X X X X ";
    private static final String pattern4Image = "  X       X        X       X                           X       X      X       X      X       X                   X       X        X       X        X       X                           X       X      X       X      X       X                   X       X      ";
    private static final String pattern5Image = "                                    X       X                                                   X       X                                                           X       X                                                   X       X                       ";
    private static final String pattern6Image = "                                     X       X                                                                                                                       X       X                                                                                  ";
    private static final String pattern7Image = "X  XXX  X  XXX    X   X   X   X  X     X X     XX       X       X       X       X       X        X     X X     X  X   X   X   X X  XXX  X  XXX    X   X   X   X  X     X X     XX       X       X       X       X       X        X     X X     X  X   X   X   X ";
    private static final String pattern8Image = " X   X   X   X    X XXX   X XXX    XXXXX   XXXXXX   XXX X   XXX  X   X   X   X  XXX X   XXX X   XXXX   XXXXX   XXXX   X XXX   X  X   X   X   X    X XXX   X XXX    XXXXX   XXXXXX   XXX X   XXX  X   X   X   X  XXX X   XXX X   XXXX   XXXXX   XXXX     XXX   X ";
    private static final String pattern9Image = " X       X       X       X       X X X X X X X X    X X     X X      X       X       X       X   X X X X X X X XX X     X X      X       X       X       X       X X X X X X X X    X X     X X      X       X       X       X   X X X X X X X XX X     X X     ";
    private static final String pattern10Image = "   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X    X X     X X      X       X   X       X      X X     X X        X   X   X   X   X   X   X   X   X   X   X   X   X   X   X   X    X X     X X      X       X   X       X      X X     X X     ";
    private static final String pattern11Image = "XXXXXXX XXXXXXX XXXXXXX XXXXXXX XX    X XX    X XX    X XX    X XX    X XX    X XX    X XX    X XXXXXXX XXXXXXX                 XXXXXXX XXXXXXX XXXXXXX XXXXXXX XX    X XX    X XX    X XX    X XX    X XX    X XX    X XX    X XXXXXXX XXXXXXX                 ";
    private static final String pattern12Image = "     X       X       X       X  XXXXXXXXXXXXXXXX X       X       X       X       X       X      XXXXXXXXXXXXXXXX     X       X       X       X       X       X  XXXXXXXXXXXXXXXX X       X       X       X       X       X      XXXXXXXXXXXXXXXX     X       X  ";
    private static final String pattern13Image = "                X   X   X   X                       X       X                   X X X X X X X X                     X       X                   X   X   X   X                       X       X                   X X X X X X X X                     X       X   ";
    private static final String pattern14Image = "  XXX     XXX      X       X      X       X      X       X      X       X              X       XX     XXX     XX X   X   X   X    XXX     XXX      X       X      X       X      X       X      X       X              X       XX     XXX     XX X   X   X   X  ";
    private static final String pattern15Image = " X X     X X      X   X   X   X                 X X X X X X X X                   X   X   X   X      X X     X XX   X   X   X    X X     X X      X   X   X   X                 X X X X X X X X                   X   X   X   X      X X     X XX   X   X   X   ";
    private static final String pattern16Image = "                      X       X      X X     X X                                  X       X      X X     X X                                          X       X      X X     X X                                  X       X      X X     X X                    ";
    private static final String pattern17Image = "  XX      XX        XX      XX        X       X        X       X       X       X      XX      XXX    X  X    X   X  X    X  X     XX      XX        XX      XX        X       X        X       X       X       X      XX      XXX    X  X    X   X  X    X  X   ";
    private static final String pattern18Image = " XXXXX   XXXXX     X       X       X       X      X X     X X   XX   XXXXX   XXX       X       X       X       XX     X X     X  XXXXX   XXXXX     X       X       X       X      X X     X X   XX   XXXXX   XXX       X       X       X       XX     X X     X ";
    private static final String pattern19Image = "X X X X X X X X XXXXXXXXXXXXXXXX    X       X      X       X      X       X      X       X      X       X        X X   X X X   XX X X X X X X X XXXXXXXXXXXXXXXX    X       X      X       X      X       X      X       X      X       X        X X   X X X   X";
    private static final String pattern20Image = " XXXXX   XXXXX  X XXX XXX XXX XXXX   X XXX   X  XX   XXXXX   XXXXX   XXXXX   XXXX XXX XXX XXX XX X  XX   X  XX   XXXXX   XXXXX   XXXXX   XXXXX  X XXX XXX XXX XXXX   X XXX   X  XX   XXXXX   XXXXX   XXXXX   XXXX XXX XXX XXX XX X  XX   X  XX   XXXXX   XXXXX  ";
    private static final String pattern21Image = " X X X X X X X XX X   X X X   X  X     X X     XX       X                       X       X        X     X X     XX X   X X X   X  X X X X X X X XX X   X X X   X  X     X X     XX       X                       X       X        X     X X     XX X   X X X   X ";
    private static final String pattern22Image = "X  X  XXX  X  XX  X  XXX  X  XXX X X  X  X X  X X   X   X   X        X X     X XX     X X     X  X   X   X   X    X X  X  X X  XX  X  XXX  X  XX  X  XXX  X  XXX X X  X  X X  X X   X   X   X        X X     X XX     X X     X  X   X   X   X    X X  X  X X  X";
    private static final String pattern23Image = "   XX      XX      XX      XX      XX      XX                   X      XX      XX      XX      XX      XX      X                   XX      XX      XX      XX      XX      XX                   X      XX      XX      XX      XX      XX      X                ";
    private static final String pattern24Image = "X   X   X   X   X   X   X   X   X   X   X   X   XXXXX   XXXXX   X   X   X   X   X   X   X   X   X   X   X   X   X   XXXXX   XXXXX   X   X   X   X   X   X   X   X   X   X   X   XXXXX   XXXXX   X   X   X   X   X   X   X   X   X   X   X   X   X   XXXXX   XXXX";

    public PdfWriter(Scheme scheme) {
        this.s = scheme;
        this.engine = new SchemeEngine(this.s);
        this.engine.InitTmpProps();
        this.pdf = new PDDocument();
    }

    private static double mmTo1_72inch(double mm) {
        return mm * 2.8346457481384277;
    }

    private double fx(double v) {
        if (this.PAGE_MARGIN == 0.0) {
            return PdfWriter.mmTo1_72inch(this.schemeScale * (v - this.originX));
        }
        return PdfWriter.mmTo1_72inch(this.schemeScale * (v - this.originX) + this.PAGE_MARGIN);
    }

    private double fy(double v) {
        if (this.PAGE_MARGIN == 0.0) {
            return PdfWriter.mmTo1_72inch(this.schemeScale * (this.schemeBottom - Math.abs(v - this.originY)));
        }
        return PdfWriter.mmTo1_72inch(this.schemeScale * (this.schemeBottom - v) - this.PAGE_MARGIN);
    }

    private double fs(double v) {
        return PdfWriter.mmTo1_72inch(this.schemeScale * v);
    }

    private double getPageScaleByPageLayout(SchemePageLayout pageLayout) {
        if (pageLayout == null || pageLayout.getScalePageType() == 0) {
            return 1.0;
        }
        if (pageLayout.getScalePageType() == 1) {
            switch (pageLayout.getScalePage()) {
                case 0: {
                    return 0.001;
                }
                case 1: {
                    return 0.002;
                }
                case 2: {
                    return 0.005;
                }
                case 3: {
                    return 0.01;
                }
                case 4: {
                    return 0.02;
                }
                case 5: {
                    return 0.04;
                }
                case 6: {
                    return 0.05;
                }
                case 7: {
                    return 0.1;
                }
                case 8: {
                    return 0.2;
                }
                case 9: {
                    return 0.4;
                }
                case 10: {
                    return 0.5;
                }
                case 12: {
                    return 10.0;
                }
                case 13: {
                    return 20.0;
                }
                case 14: {
                    return 50.0;
                }
            }
            return 1.0;
        }
        double scaleFloat = pageLayout.getScaleFloat();
        if (scaleFloat < 0.001) {
            scaleFloat = 0.001;
        }
        return 1.0 / scaleFloat;
    }

    private void addPage(SchemePage schemePage) throws Exception {
        Color BkColor;
        SchemePage backPage;
        SchemePageLayout pageLayout = schemePage == null || schemePage.pageLayout == null ? this.s.getPageLayout() : schemePage.pageLayout;
        double sw = this.s.getSchemeWidth();
        double sh = this.s.getSchemeHeight();
        double maxPageSpace = 5080.0;
        this.schemeScale = 1.0;
        if (schemePage != null) {
            if (pageLayout.getActive()) {
                this.schemeScale /= this.getPageScaleByPageLayout(pageLayout);
                schemePage.calcPageDimensions(pageLayout, this.schemeScale);
                sw = schemePage.getPageWidth();
                sh = this.schemeBottom = (double)schemePage.getPageHeight();
                if (!schemePage.noShapes()) {
                    this.originX = (double)(pageLayout.getWidth() * schemePage.i1x) * this.schemeScale;
                    this.originY = (double)(pageLayout.getHeight() * schemePage.i1y) * this.schemeScale;
                    double fieldsX = (double)(pageLayout.getLeftField() + pageLayout.getRightField()) * this.schemeScale;
                    double fieldsY = (double)(pageLayout.getTopField() + pageLayout.getBottomField()) * this.schemeScale;
                    if (schemePage.i1x != 0) {
                        this.originX -= fieldsX * (double)schemePage.i1x;
                    }
                    this.originY -= (double)(pageLayout.getTopField() * 2) * this.schemeScale;
                    if (schemePage.i1y != 0) {
                        this.originY -= fieldsY * (double)schemePage.i1y;
                    }
                } else {
                    schemePage.i1x = 0;
                    schemePage.i1y = 0;
                    schemePage.i2x = 0;
                    schemePage.i2y = 0;
                }
                this.PAGE_MARGIN = 0.0;
            } else {
                sw = schemePage.SchemePageWidth;
                sh = schemePage.SchemePageHeight;
                maxPageSpace = 5080.0 - 2.0 * this.PAGE_MARGIN;
                this.originX = this.schemeLeft;
            }
            if (schemePage.backPageId >= 0.0) {
                SchemePageLayout backPageLayout;
                SchemePage backPage2 = this.s.getPageById(schemePage.backPageId, true);
                SchemePageLayout schemePageLayout = backPageLayout = backPage2.pageLayout == null ? this.s.getPageLayout() : backPage2.pageLayout;
                if (backPageLayout.getActive()) {
                    double backPageScale = 1.0 / this.getPageScaleByPageLayout(backPageLayout);
                    double tmpScale = this.schemeScale;
                    this.schemeScale = backPageScale / this.schemeScale;
                    backPage2.calcPageDimensions(backPageLayout, backPageScale);
                    double backOriginX = (double)(pageLayout.getWidth() * backPage2.i1x) * tmpScale;
                    double backOriginY = (double)(pageLayout.getHeight() * backPage2.i1y) * tmpScale;
                    this.originX = Math.min(this.originX, backOriginX) * this.schemeScale;
                    this.originY = Math.min(this.originY, backOriginY) * this.schemeScale;
                    if (backPage2.noShapes()) {
                        backPage2.i1x = schemePage.i1x;
                        backPage2.i1y = schemePage.i1y;
                        backPage2.i2x = schemePage.i2x;
                        backPage2.i2y = schemePage.i2y;
                    } else if (schemePage.noShapes()) {
                        this.originX = backOriginX;
                        this.originY = backOriginY;
                    } else {
                        backPage2.i1x = Math.min(schemePage.i1x, backPage2.i1x);
                        backPage2.i1y = Math.min(schemePage.i1y, backPage2.i1y);
                        backPage2.i2x = Math.max(schemePage.i2x, backPage2.i2x);
                        backPage2.i2y = Math.max(schemePage.i2y, backPage2.i2y);
                    }
                    this.schemeBottom = backPage2.getPageHeight();
                    this.schemeScale = tmpScale / backPageScale;
                    sw = (double)backPage2.getPageWidth() * this.schemeScale;
                    sh = (double)backPage2.getPageHeight() * this.schemeScale;
                    double fieldsX = pageLayout.getLeftField() + pageLayout.getRightField();
                    double fieldsY = pageLayout.getTopField() + pageLayout.getBottomField();
                    if (backPage2.i1x != 0) {
                        this.originX -= fieldsX * (double)backPage2.i1x;
                    }
                    this.originY -= (double)(pageLayout.getTopField() * 2);
                    if (backPage2.i1y != 0) {
                        this.originY -= fieldsY * (double)backPage2.i1y;
                    }
                }
            } else {
                this.schemeScale = 1.0;
            }
        }
        if (sw > maxPageSpace || sh > maxPageSpace) {
            this.pageScale = sw > sh ? maxPageSpace / sw : maxPageSpace / sh;
            sw *= this.pageScale;
            sh *= this.pageScale;
            this.schemeScale *= this.pageScale;
        }
        int margin = (int)PdfWriter.mmTo1_72inch(this.PAGE_MARGIN);
        int contentWidth = (int)PdfWriter.mmTo1_72inch(sw);
        int contentHeight = (int)PdfWriter.mmTo1_72inch(sh);
        int pw = contentWidth + 2 * margin;
        int ph = contentHeight + 2 * margin;
        this.pdPage = new PDPage(new PDRectangle((float)pw, (float)ph));
        this.pdf.addPage(this.pdPage);
        this.pdPage.setResources(new PDResources());
        this.contentStream = new PDPageContentStream(this.pdf, this.pdPage);
        SchemePage schemePage2 = schemePage == null ? null : (backPage = schemePage.backPageId >= 0.0 ? this.s.getPageById(schemePage.backPageId, true) : null);
        Color color = schemePage == null ? this.s.BkColor : (BkColor = backPage == null ? schemePage.BkColor : backPage.BkColor);
        if (BkColor != null && !BkColor.equals(Color.WHITE)) {
            this.contentStream.setNonStrokingColor(BkColor);
            this.contentStream.addRect(0.0f, 0.0f, (float)contentWidth, (float)contentHeight);
            this.contentStream.fill();
        }
    }

    public void saveToStream(ConnectionManager dbMgr, OutputStream out) throws Exception {
        this.putStateCaption("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0441\u0445\u0435\u043c\u044b");
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0443 \u0432 PDF-\u0444\u0430\u0439\u043b");
        this.s.parse(dbMgr, true);
        this.s.sortObjects();
        if (this.s.SortLayers.isEmpty()) {
            return;
        }
        this.s.calcSchemeBounds();
        this.writeLayers();
        this.schemeLeft = this.s.getSchemeLeft();
        this.schemeBottom = this.s.getSchemeTop() + this.s.getSchemeHeight();
        this.putStateProgressMax(this.s.SortShapes.size());
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u044e\u0442\u0441\u044f \u0444\u0438\u0433\u0443\u0440\u044b");
        if (this.s.Pages.empty()) {
            this.addPage(null);
            this.writeShapes(null);
            this.contentStream.close();
        } else {
            int size = this.s.Pages.size();
            block0: for (int idx = 0; idx < size; ++idx) {
                for (SchemePage page : this.s.Pages) {
                    SchemePage backPage;
                    if (idx != page.getOrder() || page.isBackPage) continue;
                    this.page = page;
                    this.addPage(page);
                    if (page.backPageId >= 0.0 && (backPage = this.s.getPageById(page.backPageId, true)) != null) {
                        this.backPageShapes = true;
                        this.writeShapes(backPage);
                        this.backPageShapes = false;
                        this.refreshPageOnBack(page);
                        this.schemeScale = this.pageScale;
                        if (this.schemeScale != 1.0) {
                            this.originX /= this.pageScale;
                            this.originY /= this.pageScale;
                        }
                    }
                    this.writeShapes(page);
                    this.contentStream.close();
                    continue block0;
                }
            }
        }
        this.pdf.save(out);
        this.pdf.close();
        this.putStateProgressPosition(this.s.SortShapes.size());
        this.putStateText("\u0421\u0442\u0430\u0442\u0443\u0441: PDF-\u0444\u0430\u0439\u043b \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d");
    }

    private void writePenPattern(int pPattern) throws Exception {
        switch (pPattern) {
            case 1: {
                this.contentStream.setLineDashPattern(PEN_PATTERN_DASH, 0.0f);
                break;
            }
            case 2: {
                this.contentStream.setLineDashPattern(PEN_PATTERN_DOT, 0.0f);
                break;
            }
            case 3: {
                this.contentStream.setLineDashPattern(PEN_PATTERN_DASH_DOT, 0.0f);
                break;
            }
            case 4: {
                this.contentStream.setLineDashPattern(PEN_PATTERN_DASH_DOT2, 0.0f);
                break;
            }
            default: {
                this.contentStream.setLineDashPattern(PEN_PATTERN_SOLID, 0.0f);
            }
        }
    }

    private void writeCurveSections(double[] pts, int[] counts) throws Exception {
        int pCount;
        int n = pCount = pts != null ? pts.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        int sectCount = counts != null ? counts.length : 1;
        int vCount = pCount;
        int counter = 0;
        for (int i = 0; i < sectCount; ++i) {
            if (sectCount > 1) {
                int n2 = vCount = counter + counts[i] <= pCount ? counts[i] : pCount - counter;
            }
            if (vCount > 0 && (vCount - 4) % 3 == 0) {
                this.writeCurvePoints(pts, counter, vCount);
                this.contentStream.closePath();
            }
            counter += vCount;
        }
    }

    private void writeSections(double[] pts, int[] counts) throws Exception {
        int pCount;
        int n = pCount = pts != null ? pts.length / 2 : 0;
        if (pCount < 2) {
            return;
        }
        int sectCount = counts != null ? counts.length : 1;
        int vCount = pCount;
        int counter = 0;
        for (int i = 0; i < sectCount; ++i) {
            if (sectCount > 1) {
                vCount = counter + counts[i] <= pCount ? counts[i] : pCount - counter;
            }
            this.writePoints(pts, counter, vCount);
            this.contentStream.closePath();
            counter += vCount;
        }
    }

    private void writePoints(double[] pts, int index, int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            int idx = 2 * (index + i);
            if (i == 0) {
                this.contentStream.moveTo((float)this.fx(pts[idx]), (float)this.fy(pts[idx + 1]));
                continue;
            }
            this.contentStream.lineTo((float)this.fx(pts[idx]), (float)this.fy(pts[idx + 1]));
        }
    }

    private void writeCurvePoints(double[] pts, int index, int count) throws Exception {
        int ns = (count - 1) / 3;
        for (int i = 0; i < ns; ++i) {
            int i0 = 2 * (index + i * 3);
            int i1 = i0 + 2;
            int i2 = i0 + 4;
            int i3 = i0 + 6;
            if (i == 0) {
                this.contentStream.moveTo((float)this.fx(pts[i0]), (float)this.fy(pts[i0 + 1]));
            }
            this.contentStream.curveTo((float)this.fx(pts[i1]), (float)this.fy(pts[i1 + 1]), (float)this.fx(pts[i2]), (float)this.fy(pts[i2 + 1]), (float)this.fx(pts[i3]), (float)this.fy(pts[i3 + 1]));
        }
    }

    private void writeLayers() {
        PDDocumentCatalog catalog = this.pdf.getDocumentCatalog();
        PDOptionalContentProperties ocprops = catalog.getOCProperties();
        if (ocprops == null) {
            ocprops = new PDOptionalContentProperties();
            catalog.setOCProperties(ocprops);
        }
        int cnt = this.s.SortLayers.size();
        for (int i = 0; i < cnt; ++i) {
            PhxLayer layer = (PhxLayer)this.s.SortLayers.get((int)i).BG;
            if (!layer.Exportable) continue;
            String layerName = layer.StringProps.Caption;
            PDOptionalContentGroup pdfLayer = new PDOptionalContentGroup(layerName);
            ocprops.addGroup(pdfLayer);
            ocprops.setGroupEnabled(layerName, layer.Visible);
            this.layers.put(layer, pdfLayer);
        }
    }

    private void writeShapes(SchemePage schemePage) throws Exception {
        this.putStateText(String.format("\u0421\u0442\u0430\u0442\u0443\u0441: \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 '%s'", schemePage == null ? "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 1" : schemePage.getCaption()));
        int shapesCount = this.s.SortShapes.size();
        for (int i = 0; i < shapesCount; ++i) {
            SchemeObject o = this.s.SortShapes.get(i);
            if (!this.isValidObject(i, o)) continue;
            BaseGraphic bg = o.BG;
            SchemeObject layerObj = this.s.layerById(bg.LayerID);
            if (layerObj == null || !(layerObj.BG instanceof PhxLayer)) continue;
            if (this.engine.tmpLayer == null || this.engine.tmpLayer.ID != bg.LayerID) {
                this.engine.setTmpLayer(bg.LayerID);
            }
            if (this.engine.tmpLayer == null || !this.engine.tmpLayer.Exportable || schemePage != null && schemePage.getNormalizeId() != this.engine.tmpLayer.PageId) continue;
            this.writeShape(bg);
            this.putStateProgressPosition(i);
        }
    }

    private void refreshPageOnBack(SchemePage page) {
        SchemePage backPage = this.s.getPageById(page.backPageId, true);
        if (!page.noShapes()) {
            page.i1x = Math.min(page.i1x, backPage.i1x);
            page.i1y = Math.min(page.i1y, backPage.i1y);
            page.i2x = Math.max(page.i2x, backPage.i2x);
            page.i2y = Math.max(page.i2y, backPage.i2y);
        }
        this.schemeBottom = page.getPageHeight();
        this.originX *= this.schemeScale;
        this.originY *= this.schemeScale;
    }

    private boolean isValidObject(int index, SchemeObject obj) {
        if (obj == null) {
            Core.logger.info("PdfWriter.writeShapes: not found object by index {}. saveToStream(scheme:{}).", (Object)index, (Object)this.s.getSchemeId());
            return false;
        }
        if (obj.BG == null) {
            Core.logger.info("PdfWriter.writeShapes: object {} not parsed. saveToStream(scheme:{}).", (Object)obj.getID(), (Object)this.s.getSchemeId());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeShape(BaseGraphic bg) throws Exception {
        if (bg.Hidden) {
            return;
        }
        AffineTransform OldGTM = new AffineTransform();
        OldGTM.setTransform(this.engine.GTM);
        double oldAngle = this.engine.tmpAngle;
        if (bg.TransProps != null && bg.TransProps.Angle != 0.0) {
            this.engine.tmpAngle += bg.TransProps.Angle;
        }
        if (bg.ParentGB != null && bg.TransProps != null && !SchemeObjectsTypes.ObjTypeIsText(bg.shapeType())) {
            boolean inInsert;
            boolean bl = inInsert = bg.ParentGB.ParentGB != null && bg.ParentGB.ParentGB.shapeType() == 207;
            if (inInsert || bg.ParentGB.ParentGB == null) {
                double parentScaleX = 1.0;
                double parentScaleY = 1.0;
                double a = bg.TransProps.Angle;
                if (Math.abs(a - 90.0 * (double)((int)(a / 90.0))) <= 0.5) {
                    boolean vert;
                    BaseGraphic parent = inInsert ? bg.ParentGB.ParentGB : bg.ParentGB;
                    boolean bl2 = vert = Math.abs(a - 180.0 * (double)((int)(a / 180.0))) > 0.5;
                    if (!vert) {
                        if (bg.FixScaleX && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleX;
                        }
                        if (bg.FixScaleY && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleY;
                        }
                    } else {
                        if (bg.FixScaleX && parent.TransProps != null) {
                            parentScaleY = parent.TransProps.ScaleX;
                        }
                        if (bg.FixScaleY && parent.TransProps != null) {
                            parentScaleX = parent.TransProps.ScaleY;
                        }
                    }
                    bg.TransProps.ScaleX /= parentScaleX;
                    bg.TransProps.ScaleY /= parentScaleY;
                }
            }
        }
        try {
            boolean isInscribeEm;
            SchemeObject layerObj = this.s.layerById(bg.LayerID);
            if (layerObj == null && this.curInsert != null) {
                layerObj = this.s.layerById(this.curInsert.LayerID);
            }
            if (layerObj == null) {
                return;
            }
            PhxLayer layer = (PhxLayer)layerObj.BG;
            PDOptionalContentGroup pdfLayer = this.layers.get(layer);
            this.contentStream.beginMarkedContent(COSName.OC, (PDPropertyList)pdfLayer);
            boolean isInscribeAttrRef = bg instanceof AttributeRef && ((AttributeRef)bg).Inscribe;
            boolean bl = isInscribeEm = bg instanceof EmbeddedText && ((EmbeddedText)bg).Inscribe;
            if (bg.ParentGB == null || !isInscribeEm && !isInscribeAttrRef) {
                this.engine.GTM.concatenate(SchemeEngine.GenTransform(bg));
            }
            if (bg instanceof PhxGraphicInsert) {
                this.writeInsert((PhxGraphicInsert)bg);
            } else if (bg instanceof GraphicBlock) {
                this.writeBlock((GraphicBlock)bg);
            } else if (bg instanceof Polygon) {
                this.writePolygon((Polygon)bg);
            } else if (bg instanceof Region) {
                this.writeRegion((Region)bg);
            } else if (bg instanceof Spline) {
                this.writeSpline((Spline)bg);
            } else if (bg instanceof Polyline) {
                this.writePolyline((Polyline)bg);
            } else if (bg instanceof Pie) {
                this.writePie((Pie)bg);
            } else if (bg instanceof Ellipse) {
                this.writeEllipse((Ellipse)bg);
            } else if (bg instanceof Attribute) {
                this.writeAttribute((Attribute)bg);
            } else if (bg instanceof Paragraph) {
                this.writeParagraph((Paragraph)bg);
            } else if (bg instanceof Image) {
                this.writeImage((Image)bg);
            } else if (bg instanceof Rectangle) {
                this.writeRectangle((Rectangle)bg);
            }
            if (bg.emText()) {
                this.writeShape(bg.EmbeddedText);
            }
            this.contentStream.endMarkedContent();
        }
        finally {
            this.engine.GTM.setTransform(OldGTM);
            this.engine.tmpAngle = oldAngle;
        }
    }

    private void writePolyline(Polyline bg) throws Exception {
        if (bg.Points == null || bg.Points.length < 4) {
            return;
        }
        double[] transformedPoints = this.engine.MulPoints(bg.Points);
        int penPattern = !this.insertMode || bg.PenPattern != -1 ? bg.PenPattern : 0;
        boolean isSpecialPrimitive = !this.insertMode && this.engine.getActualPrimID(penPattern, bg.PrimID) > 0.0;
        int n = penPattern = isSpecialPrimitive ? 0 : this.engine.getActualPenPattern(penPattern);
        if (bg.PointsCounts != null && bg.PointsCounts.length > 0 && penPattern == 0) {
            this.writeArrow(bg, transformedPoints, penPattern);
            double[] allPoints = bg.PointsWithJump;
            int segmentOffset = 0;
            for (int i = 0; i < bg.PointsCounts.length; ++i) {
                int segmentPointCount = bg.PointsCounts[i];
                if (segmentPointCount == 0) continue;
                double[] segmentPoints = new double[segmentPointCount * 2];
                System.arraycopy(allPoints, segmentOffset, segmentPoints, 0, segmentPointCount * 2);
                if (i % 2 != 0) {
                    this.writeCurvePoints(segmentPoints, 0, segmentPointCount);
                    this.contentStream.stroke();
                } else {
                    this.writeAsPolyline(bg, segmentPoints, 0, segmentPointCount, penPattern);
                }
                segmentOffset += segmentPointCount * 2;
            }
        } else {
            double[] pointsToRender = bg.PointsWithJump != null ? bg.PointsWithJump : transformedPoints;
            int renderPointCount = pointsToRender.length / 2;
            this.writeArrow(bg, (double[])pointsToRender.clone(), penPattern);
            this.writeAsPolyline(bg, pointsToRender, 0, renderPointCount, penPattern);
        }
    }

    private void writeArrow(BaseShape bg, double[] pts, int pPattern) throws Exception {
        if (pPattern == 5) {
            return;
        }
        Color pColor = this.engine.getActualPColor(bg.pColor);
        double lWidth = this.engine.getActualLWidth(bg.lWidth);
        if (bg.shapeType() == 210) {
            double[] arrowPts;
            Polyline poly = (Polyline)bg;
            if (poly.StartVisArrowType != 0 && poly.StartArrowPoints != null) {
                this.contentStream.setLineWidth((float)this.fs(lWidth));
                arrowPts = this.engine.MulPoints(poly.StartArrowPoints);
                BaseGraphic.RealPoint np = poly.trimSegmentByArrow(pts, 1, 0, true);
                pts[0] = np.X;
                pts[1] = np.Y;
                this.paintArrow(poly.StartVisArrowType, poly.StartVisArrowSize, arrowPts, pColor);
            }
            if (poly.EndVisArrowType != 0 && poly.EndArrowPoints != null) {
                this.contentStream.setLineWidth((float)this.fs(lWidth));
                arrowPts = this.engine.MulPoints(poly.EndArrowPoints);
                int len = poly.Points.length / 2;
                BaseGraphic.RealPoint np = poly.trimSegmentByArrow(pts, len - 2, len - 1, false);
                pts[len * 2 - 2] = np.X;
                pts[len * 2 - 1] = np.Y;
                this.paintArrow(poly.EndVisArrowType, poly.EndVisArrowSize, arrowPts, pColor);
            }
        }
    }

    private void writeAsPolyline(BaseShape bg, double[] pts, int index, int count, int pPattern) throws Exception {
        if (pPattern == 5) {
            return;
        }
        if (bg.TransparentBorder != 0) {
            PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
            if (bg.TransparentBorder != 0) {
                graphicsState.setStrokingAlphaConstant(Float.valueOf((float)((256.0 - (double)bg.TransparentBorder) / 255.0)));
            }
            this.contentStream.saveGraphicsState();
            this.contentStream.setGraphicsStateParameters(graphicsState);
        }
        Color pColor = this.engine.getActualPColor(bg.pColor);
        double lWidth = this.engine.getActualLWidth(bg.lWidth);
        this.contentStream.setStrokingColor(pColor);
        this.contentStream.setLineWidth((float)this.fs(lWidth));
        this.contentStream.setLineJoinStyle(2);
        this.contentStream.setLineCapStyle(bg.LineCap);
        this.writePenPattern(pPattern);
        this.writePoints(pts, index, count);
        this.contentStream.stroke();
        if (bg.TransparentBorder != 0) {
            this.contentStream.restoreGraphicsState();
        }
    }

    private void paintArrow(int arrowType, double size, double[] pts, Color color) throws Exception {
        this.contentStream.setLineDashPattern(PEN_PATTERN_SOLID, 0.0f);
        if (arrowType == 0 || arrowType == 1) {
            this.paintArrowDef(pts);
            return;
        }
        if (size <= 1.0E-12) {
            return;
        }
        switch (arrowType) {
            case 2: 
            case 5: 
            case 6: {
                this.paintArrowOpened(pts);
                break;
            }
            case 3: {
                this.paintArrowClosed(pts, color, true);
                break;
            }
            case 4: {
                this.paintArrowClosed(pts, color, false);
                break;
            }
            case 7: {
                this.paintArrowCircle(size, pts, color, true);
                break;
            }
            case 8: {
                this.paintArrowCircle(size, pts, color, false);
                break;
            }
            case 9: {
                this.paintArrowCut(pts);
                break;
            }
            case 10: {
                this.paintArrowSquare(pts, color, true);
                break;
            }
            case 11: {
                this.paintArrowSquare(pts, color, false);
                break;
            }
            case 21: {
                this.paintArrowDiamond(pts, color, true);
                break;
            }
            case 22: {
                this.paintArrowDiamond(pts, color, false);
                break;
            }
            case 12: {
                this.paintArrowTriangle(pts, color, true);
                break;
            }
            case 13: {
                this.paintArrowTriangle(pts, color, false);
                break;
            }
            case 14: {
                this.paintArrowOpenedExtra(pts, color, true);
                break;
            }
            case 15: {
                this.paintArrowOpenedExtra(pts, color, false);
                break;
            }
            case 16: {
                this.paintArrowTriangle2Opened(pts);
                break;
            }
            case 17: {
                this.paintArrowTriangle2(pts, color, true);
                break;
            }
            case 18: {
                this.paintArrowTriangle2(pts, color, false);
                break;
            }
            case 19: {
                this.paintArrowBar(pts);
                break;
            }
            case 20: {
                this.paintArrowFork(pts);
                break;
            }
            case 23: {
                this.paintArrowDiamondCircle(size, pts, color, true);
                break;
            }
            case 24: {
                this.paintArrowDiamondCircle(size, pts, color, false);
                break;
            }
            case 25: {
                this.paintArrowDoubleBar(pts);
                break;
            }
            case 26: {
                this.paintArrowCircleBar(size, pts, color);
                break;
            }
            case 27: {
                this.paintArrowCircleFork(size, pts, color);
                break;
            }
            case 28: {
                this.paintArrowBarFrok(pts);
                break;
            }
            case 29: {
                this.paintArrowDoubleTriangle2Opened(pts);
                break;
            }
            case 30: {
                this.paintArrowDoubleTriangle2(pts, color, true);
                break;
            }
            case 31: {
                this.paintArrowDoubleTriangle2(pts, color, false);
                break;
            }
            case 32: {
                this.paintArrowSemiCircle(pts);
                break;
            }
        }
    }

    private void paintArrowDef(double[] pts) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.stroke();
    }

    private void paintArrowOpened(double[] pts) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.stroke();
    }

    private void paintArrowClosed(double[] pts, Color color, boolean full) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        if (full) {
            this.contentStream.setLineWidth(0.0f);
            this.contentStream.fillAndStrokeEvenOdd();
        } else {
            this.contentStream.stroke();
        }
    }

    private void paintArrowDiamond(double[] pts, Color color, boolean full) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        if (full) {
            this.contentStream.setLineWidth(0.0f);
            this.contentStream.fillAndStrokeEvenOdd();
        } else {
            this.contentStream.stroke();
        }
    }

    private void paintArrowCircle(double size, double[] pts, Color color, boolean full) throws Exception {
        float k = 0.5522848f;
        float cx = (float)this.fx(pts[0]);
        float cy = (float)this.fy(pts[1]);
        float r = (float)this.fs(size / 2.0);
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo(cx - r, cy);
        this.contentStream.curveTo(cx - r, cy + 0.5522848f * r, cx - 0.5522848f * r, cy + r, cx, cy + r);
        this.contentStream.curveTo(cx + 0.5522848f * r, cy + r, cx + r, cy + 0.5522848f * r, cx + r, cy);
        this.contentStream.curveTo(cx + r, cy - 0.5522848f * r, cx + 0.5522848f * r, cy - r, cx, cy - r);
        this.contentStream.curveTo(cx - 0.5522848f * r, cy - r, cx - r, cy - 0.5522848f * r, cx - r, cy);
        if (full) {
            this.contentStream.setLineWidth(0.0f);
            this.contentStream.fillAndStrokeEvenOdd();
        } else {
            this.contentStream.stroke();
        }
    }

    private void paintArrowCircleBar(double size, double[] pts, Color color) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.stroke();
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.stroke();
        float k = 0.5522848f;
        float cx = (float)this.fx(pts[8]);
        float cy = (float)this.fy(pts[9]);
        float r = (float)this.fs(size / 2.0);
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo(cx - r, cy);
        this.contentStream.curveTo(cx - r, cy + 0.5522848f * r, cx - 0.5522848f * r, cy + r, cx, cy + r);
        this.contentStream.curveTo(cx + 0.5522848f * r, cy + r, cx + r, cy + 0.5522848f * r, cx + r, cy);
        this.contentStream.curveTo(cx + r, cy - 0.5522848f * r, cx + 0.5522848f * r, cy - r, cx, cy - r);
        this.contentStream.curveTo(cx - 0.5522848f * r, cy - r, cx - r, cy - 0.5522848f * r, cx - r, cy);
        this.contentStream.stroke();
    }

    private void paintArrowSemiCircle(double[] pts) throws Exception {
        if (pts == null || pts.length < 8) {
            return;
        }
        this.writeCurvePoints(pts, 0, pts.length / 2);
        this.contentStream.stroke();
    }

    private void paintArrowCircleFork(double size, double[] pts, Color color) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.moveTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[8]), (float)this.fy(pts[9]));
        this.contentStream.stroke();
        float k = 0.5522848f;
        float cx = (float)this.fx(pts[10]);
        float cy = (float)this.fy(pts[11]);
        float r = (float)this.fs(size / 2.0);
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo(cx - r, cy);
        this.contentStream.curveTo(cx - r, cy + 0.5522848f * r, cx - 0.5522848f * r, cy + r, cx, cy + r);
        this.contentStream.curveTo(cx + 0.5522848f * r, cy + r, cx + r, cy + 0.5522848f * r, cx + r, cy);
        this.contentStream.curveTo(cx + r, cy - 0.5522848f * r, cx + 0.5522848f * r, cy - r, cx, cy - r);
        this.contentStream.curveTo(cx - 0.5522848f * r, cy - r, cx - r, cy - 0.5522848f * r, cx - r, cy);
        this.contentStream.stroke();
    }

    private void paintArrowDiamondCircle(double size, double[] pts, Color color, boolean full) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[8]), (float)this.fy(pts[9]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.stroke();
        float k = 0.5522848f;
        float cx = (float)this.fx(pts[0]);
        float cy = (float)this.fy(pts[1]);
        float r = (float)this.fs(size / 2.0);
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo(cx - r, cy);
        this.contentStream.curveTo(cx - r, cy + 0.5522848f * r, cx - 0.5522848f * r, cy + r, cx, cy + r);
        this.contentStream.curveTo(cx + 0.5522848f * r, cy + r, cx + r, cy + 0.5522848f * r, cx + r, cy);
        this.contentStream.curveTo(cx + r, cy - 0.5522848f * r, cx + 0.5522848f * r, cy - r, cx, cy - r);
        this.contentStream.curveTo(cx - 0.5522848f * r, cy - r, cx - r, cy - 0.5522848f * r, cx - r, cy);
        if (full) {
            this.contentStream.setLineWidth(0.0f);
            this.contentStream.fillAndStrokeEvenOdd();
        } else {
            this.contentStream.stroke();
        }
    }

    private void paintArrowCut(double[] pts) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.stroke();
    }

    private void paintArrowSquare(double[] pts, Color color, boolean full) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        if (full) {
            this.contentStream.setLineWidth(0.0f);
            this.contentStream.fillAndStrokeEvenOdd();
        } else {
            this.contentStream.stroke();
        }
    }

    private void paintArrowTriangle(double[] pts, Color color, boolean full) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        if (full) {
            this.contentStream.setLineWidth(0.0f);
            this.contentStream.fillAndStrokeEvenOdd();
        } else {
            this.contentStream.stroke();
        }
    }

    private void paintArrowTriangle2(double[] pts, Color color, boolean full) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        if (full) {
            this.contentStream.setLineWidth(0.0f);
            this.contentStream.fillAndStrokeEvenOdd();
        } else {
            this.contentStream.stroke();
        }
    }

    private void paintArrowDoubleTriangle2(double[] pts, Color color, boolean full) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.moveTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[8]), (float)this.fy(pts[9]));
        this.contentStream.lineTo((float)this.fx(pts[10]), (float)this.fy(pts[11]));
        this.contentStream.lineTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        if (full) {
            this.contentStream.setLineWidth(0.0f);
            this.contentStream.fillAndStrokeEvenOdd();
        } else {
            this.contentStream.stroke();
        }
    }

    private void paintArrowOpenedExtra(double[] pts, Color color, boolean full) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        if (full) {
            this.contentStream.setLineWidth(0.0f);
            this.contentStream.fillAndStrokeEvenOdd();
        } else {
            this.contentStream.stroke();
        }
    }

    private void paintArrowTriangle2Opened(double[] pts) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.stroke();
    }

    private void paintArrowDoubleTriangle2Opened(double[] pts) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.moveTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[8]), (float)this.fy(pts[9]));
        this.contentStream.lineTo((float)this.fx(pts[10]), (float)this.fy(pts[11]));
        this.contentStream.stroke();
    }

    private void paintArrowBar(double[] pts) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.stroke();
    }

    private void paintArrowDoubleBar(double[] pts) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.moveTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.lineTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.stroke();
    }

    private void paintArrowFork(double[] pts) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.moveTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[8]), (float)this.fy(pts[9]));
        this.contentStream.stroke();
    }

    private void paintArrowBarFrok(double[] pts) throws Exception {
        this.contentStream.moveTo((float)this.fx(pts[0]), (float)this.fy(pts[1]));
        this.contentStream.lineTo((float)this.fx(pts[2]), (float)this.fy(pts[3]));
        this.contentStream.moveTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[4]), (float)this.fy(pts[5]));
        this.contentStream.moveTo((float)this.fx(pts[6]), (float)this.fy(pts[7]));
        this.contentStream.lineTo((float)this.fx(pts[8]), (float)this.fy(pts[9]));
        this.contentStream.stroke();
    }

    private void writeAsPolyline(BaseShape bg, double[] pts, int index, int count) throws Exception {
        int pPattern = this.engine.getActualPenPattern(bg.PenPattern);
        this.writeAsPolyline(bg, pts, index, count, pPattern);
    }

    private void writeSpline(Spline bg) throws Exception {
        int pCount;
        int n = pCount = bg.Points != null ? bg.Points.length / 2 : 0;
        if (pCount < 2 || (pCount - 4) % 3 != 0) {
            return;
        }
        int pPattern = this.engine.getActualPenPattern(bg.PenPattern);
        if (pPattern == 5) {
            return;
        }
        if (bg.TransparentBorder != 0) {
            PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
            if (bg.TransparentBorder != 0) {
                graphicsState.setStrokingAlphaConstant(Float.valueOf((float)((256.0 - (double)bg.TransparentBorder) / 255.0)));
            }
            this.contentStream.saveGraphicsState();
            this.contentStream.setGraphicsStateParameters(graphicsState);
        }
        Color pColor = this.engine.getActualPColor(bg.pColor);
        double lWidth = this.engine.getActualLWidth(bg.lWidth);
        this.contentStream.setStrokingColor(pColor);
        this.contentStream.setLineWidth((float)this.fs(lWidth));
        this.writePenPattern(pPattern);
        double[] pts = this.engine.MulPoints(bg.Points);
        this.writeCurvePoints(pts, 0, pCount);
        this.contentStream.stroke();
        if (bg.shapeType() == 212) {
            double[] arrowPts;
            if (bg.StartVisArrowType != 0 && bg.StartArrowPoints != null) {
                arrowPts = this.engine.MulPoints(bg.StartArrowPoints);
                this.paintArrow(bg.StartVisArrowType, bg.StartVisArrowSize, arrowPts, pColor);
            }
            if (bg.EndVisArrowType != 0 && bg.EndArrowPoints != null) {
                arrowPts = this.engine.MulPoints(bg.EndArrowPoints);
                this.paintArrow(bg.EndVisArrowType, bg.EndVisArrowSize, arrowPts, pColor);
            }
        }
        if (bg.TransparentBorder != 0) {
            this.contentStream.restoreGraphicsState();
        }
    }

    private void writePolygon(Polygon bg) throws Exception {
        this.writeAsPolygon(bg, this.engine.MulPoints(bg.Points), bg.Counts);
    }

    private void writeRegion(Region bg) throws Exception {
        this.writeAsPolygon(bg, this.engine.MulPoints(bg.Points), bg.Counts);
    }

    private PDColor getTilingPatternColor(int pattern, Color bColor, Color bkColor) {
        PDPattern patternCS1 = new PDPattern(null, (PDColorSpace)PDDeviceRGB.INSTANCE);
        PDTilingPattern tilingPattern1 = new PDTilingPattern();
        tilingPattern1.setBBox(new PDRectangle(0.0f, 0.0f, 16.0f, 16.0f));
        tilingPattern1.setPaintType(1);
        tilingPattern1.setTilingType(1);
        tilingPattern1.setXStep(16.0f);
        tilingPattern1.setYStep(16.0f);
        if (this.pdPage.getResources() == null) {
            return null;
        }
        PDStream stream = tilingPattern1.getContentStream();
        if (stream == null) {
            return null;
        }
        COSName patternName1 = this.pdPage.getResources().add((PDAbstractPattern)tilingPattern1);
        try (PDPatternContentStream cs1 = new PDPatternContentStream(tilingPattern1);){
            cs1.setNonStrokingColor(bkColor);
            cs1.moveTo(0.0f, 0.0f);
            cs1.lineTo(0.0f, 16.0f);
            cs1.lineTo(16.0f, 16.0f);
            cs1.lineTo(16.0f, 0.0f);
            cs1.lineTo(0.0f, 0.0f);
            cs1.closePath();
            cs1.fill();
            cs1.setNonStrokingColor(bColor);
            String buffStr = PdfWriter.getPatternStringById(pattern);
            if (buffStr != null) {
                int idx = 0;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        if (buffStr.charAt(idx) == 'X') {
                            cs1.addRect((float)x, (float)(15 - y), 1.0f, 1.0f);
                        }
                        ++idx;
                    }
                }
            }
            cs1.fill();
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
        return new PDColor(patternName1, (PDColorSpace)patternCS1);
    }

    private PDShading getRadialShadingById(int pattern, Color bColor, Color bkColor, BaseGraphic.RealRect rect) throws Exception {
        Color color1 = pattern == 10019 ? bColor : bkColor;
        Color color2 = pattern == 10019 ? bkColor : bColor;
        COSDictionary fdict = new COSDictionary();
        fdict.setInt(COSName.FUNCTION_TYPE, 2);
        COSArray domain = new COSArray();
        domain.add((COSBase)COSInteger.get((long)0L));
        domain.add((COSBase)COSInteger.get((long)1L));
        COSArray c0 = new COSArray();
        c0.add((COSBase)COSFloat.get((String)String.valueOf((float)color1.getRed() / 255.0f)));
        c0.add((COSBase)COSFloat.get((String)String.valueOf((float)color1.getGreen() / 255.0f)));
        c0.add((COSBase)COSFloat.get((String)String.valueOf((float)color1.getBlue() / 255.0f)));
        COSArray c1 = new COSArray();
        c1.add((COSBase)COSFloat.get((String)String.valueOf((float)color2.getRed() / 255.0f)));
        c1.add((COSBase)COSFloat.get((String)String.valueOf((float)color2.getGreen() / 255.0f)));
        c1.add((COSBase)COSFloat.get((String)String.valueOf((float)color2.getBlue() / 255.0f)));
        fdict.setItem(COSName.DOMAIN, (COSBase)domain);
        fdict.setItem(COSName.C0, (COSBase)c0);
        fdict.setItem(COSName.C1, (COSBase)c1);
        fdict.setInt(COSName.N, 1);
        PDFunctionType2 func = new PDFunctionType2((COSBase)fdict);
        COSArray ext = new COSArray();
        ext.add((COSBase)COSBoolean.getBoolean((boolean)true));
        ext.add((COSBase)COSBoolean.getBoolean((boolean)false));
        PDShadingType3 radialShading = new PDShadingType3(new COSDictionary());
        radialShading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
        radialShading.setShadingType(3);
        int x = (int)this.fx((rect.Right + rect.Left) / 2.0);
        int y = (int)this.fy((rect.Top + rect.Bottom) / 2.0);
        int r = (int)this.fs(Math.sqrt((rect.Right - rect.Left) * (rect.Right - rect.Left) + (rect.Top - rect.Bottom) * (rect.Top - rect.Bottom)));
        COSArray coords2 = new COSArray();
        coords2.add((COSBase)COSInteger.get((long)x));
        coords2.add((COSBase)COSInteger.get((long)y));
        coords2.add((COSBase)COSInteger.get((long)(r / 100)));
        coords2.add((COSBase)COSInteger.get((long)x));
        coords2.add((COSBase)COSInteger.get((long)y));
        coords2.add((COSBase)COSInteger.get((long)r));
        radialShading.setCoords(coords2);
        radialShading.setFunction((PDFunction)func);
        radialShading.setExtend(ext);
        return radialShading;
    }

    private PDShading getAxialShadingById(int pattern, Color bColor, Color bkColor, BaseGraphic.RealRect rect) throws Exception {
        Color color1 = pattern == 10001 || pattern == 10003 || pattern == 10005 || pattern == 10008 ? bColor : bkColor;
        Color color2 = pattern == 10001 || pattern == 10003 || pattern == 10005 || pattern == 10008 ? bkColor : bColor;
        int x1 = (int)this.fx(rect.Left);
        int y1 = (int)this.fy(rect.Top);
        int x2 = (int)this.fx(rect.Right);
        int y2 = (int)this.fy(rect.Bottom);
        switch (pattern) {
            case 10001: 
            case 10002: 
            case 10011: 
            case 10012: {
                y1 = y2 = (int)this.fy((rect.Top + rect.Bottom) / 2.0);
                break;
            }
            case 10003: 
            case 10004: 
            case 10013: 
            case 10014: {
                x1 = x2 = (int)this.fx((rect.Right + rect.Left) / 2.0);
                break;
            }
            case 10005: 
            case 10006: {
                x1 = (int)this.fx(rect.Right);
                x2 = (int)this.fx(rect.Left);
            }
        }
        COSDictionary fdict = new COSDictionary();
        fdict.setInt(COSName.FUNCTION_TYPE, 2);
        COSArray domain = new COSArray();
        domain.add((COSBase)COSInteger.get((long)0L));
        domain.add((COSBase)COSInteger.get((long)1L));
        COSArray c0 = new COSArray();
        c0.add((COSBase)COSFloat.get((String)String.valueOf((float)color1.getRed() / 255.0f)));
        c0.add((COSBase)COSFloat.get((String)String.valueOf((float)color1.getGreen() / 255.0f)));
        c0.add((COSBase)COSFloat.get((String)String.valueOf((float)color1.getBlue() / 255.0f)));
        COSArray c1 = new COSArray();
        c1.add((COSBase)COSFloat.get((String)String.valueOf((float)color2.getRed() / 255.0f)));
        c1.add((COSBase)COSFloat.get((String)String.valueOf((float)color2.getGreen() / 255.0f)));
        c1.add((COSBase)COSFloat.get((String)String.valueOf((float)color2.getBlue() / 255.0f)));
        fdict.setItem(COSName.DOMAIN, (COSBase)domain);
        fdict.setItem(COSName.C0, (COSBase)c0);
        fdict.setItem(COSName.C1, (COSBase)c1);
        fdict.setInt(COSName.N, 1);
        PDFunctionType2 func = new PDFunctionType2((COSBase)fdict);
        PDShadingType2 axialShading = new PDShadingType2(new COSDictionary());
        axialShading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
        axialShading.setShadingType(2);
        COSArray coords1 = new COSArray();
        coords1.add((COSBase)COSInteger.get((long)x1));
        coords1.add((COSBase)COSInteger.get((long)y1));
        coords1.add((COSBase)COSInteger.get((long)x2));
        coords1.add((COSBase)COSInteger.get((long)y2));
        axialShading.setCoords(coords1);
        axialShading.setFunction((PDFunction)func);
        return axialShading;
    }

    private void writeAsPolygon(BaseShape bg, double[] pts, int[] counts) throws Exception {
        int pPattern;
        boolean isPen;
        boolean isFill;
        PDShading shading = null;
        int bPattern = this.engine.getActualBrushPattern(bg.BrushPattern);
        boolean bl = isFill = bPattern != 1;
        if (isFill) {
            Color bkColor;
            Color bColor = this.engine.getActualBColor(bg.bColor);
            if (bPattern < 1) {
                this.contentStream.setNonStrokingColor(bColor);
            }
            if (bPattern > 1 && bPattern < 10000) {
                bkColor = this.engine.getActualBkColor(bg.BkColor);
                this.contentStream.setNonStrokingColor(this.getTilingPatternColor(bPattern, bColor, bkColor));
            }
            if (bPattern > 10000) {
                bkColor = this.engine.getActualBkColor(bg.BkColor);
                BaseGraphic.RealRect rect = bg.ptArrToRect(pts, pts.length / 2);
                shading = bPattern == 10019 || bPattern == 10020 ? this.getRadialShadingById(bPattern, bColor, bkColor, rect) : this.getAxialShadingById(bPattern, bColor, bkColor, rect);
            }
        }
        boolean bl2 = isPen = (pPattern = this.engine.getActualPenPattern(bg.PenPattern)) != 5;
        if (isPen) {
            Color pColor = this.engine.getActualPColor(bg.pColor);
            double lWidth = this.engine.getActualLWidth(bg.lWidth);
            this.contentStream.setStrokingColor(pColor);
            this.contentStream.setLineWidth((float)this.fs(lWidth));
            this.writePenPattern(pPattern);
        }
        if (!isFill && !isPen) {
            return;
        }
        if (bg.Transparent != 0 || bg.TransparentBorder != 0 || shading != null) {
            PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
            if (bg.Transparent != 0) {
                graphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)((256.0 - (double)bg.Transparent) / 255.0)));
            }
            if (bg.TransparentBorder != 0) {
                graphicsState.setStrokingAlphaConstant(Float.valueOf((float)((256.0 - (double)bg.TransparentBorder) / 255.0)));
            }
            this.contentStream.saveGraphicsState();
            this.contentStream.setGraphicsStateParameters(graphicsState);
        }
        if (bg instanceof Region) {
            this.writeCurveSections(pts, counts);
        } else {
            this.writeSections(pts, counts);
        }
        if (isFill && isPen && shading == null) {
            this.contentStream.fillAndStrokeEvenOdd();
        } else if (isFill && shading == null) {
            this.contentStream.fillEvenOdd();
        } else if (shading != null) {
            this.contentStream.appendRawCommands("W* ");
            this.contentStream.stroke();
            this.contentStream.shadingFill(shading);
        } else {
            this.contentStream.stroke();
        }
        if (bg.Transparent != 0 || bg.TransparentBorder != 0 || shading != null) {
            this.contentStream.restoreGraphicsState();
        }
    }

    private void writeRectangle(Rectangle bg) throws Exception {
        double[] points = bg.getRectPoints();
        double[] pts = this.engine.MulPoints(points);
        this.writeAsPolygon(bg, pts, null);
    }

    private int getShortLittleEndian(byte[] a, int offs) {
        return a[offs] & 0xFF | (a[offs + 1] & 0xFF) << 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImage(Image bg) throws Exception {
        byte[] content = bg instanceof PhxImage ? ((PhxImage)bg).Content : bg.Bmp;
        if (content == null || content.length <= 22) {
            this.writeRectangle(bg);
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageInfo ii = new ImageInfo();
        ii.setInput(in);
        if (ii.check()) {
            out.write(content);
        } else {
            ByteArrayInputStream bis;
            List images;
            boolean isICO = false;
            int idReserved = this.getShortLittleEndian(content, 0);
            int idType = this.getShortLittleEndian(content, 2);
            if (idReserved == 0 && idType == 1 && !(images = ICODecoder.readExt((InputStream)(bis = new ByteArrayInputStream(content)))).isEmpty()) {
                ICOImage img = (ICOImage)images.get(0);
                if (!img.isPngCompressed()) {
                    img.setPngCompressed(true);
                }
                ImageIO.write((RenderedImage)img.getImage(), "png", out);
                isICO = true;
            }
            if (!isICO) {
                bg.saveBitmapToStream(out);
            }
        }
        String fileFormat = ii.getFormatName().toLowerCase();
        if (SchemeUtils.hasCrop(bg)) {
            out = SchemeUtils.cropImage(out.toByteArray(), bg, fileFormat);
        }
        if (SchemeUtils.hasBrightnessContrast(bg)) {
            out = SchemeUtils.adjustBrightnessContrast(out.toByteArray(), (PhxImage)bg, fileFormat);
        }
        if (SchemeUtils.hasGamma(bg)) {
            out = SchemeUtils.adjustGamma(out.toByteArray(), (PhxImage)bg, fileFormat);
        }
        content = out.toByteArray();
        PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)this.pdf, (byte[])content, null);
        double[] points = bg.getRectPoints();
        double[] pts = this.engine.MulPoints(points);
        double dx = pts[2] - pts[0];
        double dy = pts[3] - pts[1];
        double dstW = Math.sqrt(dx * dx + dy * dy);
        dx = pts[6] - pts[0];
        dy = pts[7] - pts[1];
        double dstH = Math.sqrt(dx * dx + dy * dy);
        boolean isAngle = this.engine.tmpAngle != 0.0;
        try {
            if (bg.Transparent != 0 || isAngle) {
                PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
                if (bg.Transparent != 0) {
                    graphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)((256.0 - (double)bg.Transparent) / 255.0)));
                }
                this.contentStream.saveGraphicsState();
                this.contentStream.setGraphicsStateParameters(graphicsState);
            }
            if (isAngle) {
                Matrix pm = new Matrix();
                double tx = this.fx(pts[6]);
                double ty = this.fy(pts[7]);
                pm.translate((float)tx, (float)ty);
                pm.rotate(-this.engine.tmpAngle * Math.PI / 180.0);
                pm.translate((float)(-tx), (float)(-ty));
                this.contentStream.transform(pm);
            }
            this.contentStream.drawImage(pdImage, (float)this.fx(pts[6]), (float)this.fy(pts[7]), (float)this.fs(dstW), (float)this.fs(dstH));
        }
        finally {
            if (bg.Transparent != 0 || isAngle) {
                this.contentStream.restoreGraphicsState();
            }
        }
    }

    private void writeEllipse(Ellipse bg) throws Exception {
        double[] points = SchemeEngine.SidesToEllipse(bg.SideX, bg.SideY, bg.Slices);
        double[] pts = this.engine.MulPoints(points);
        this.writeAsPolygon(bg, pts, null);
    }

    private void writePie(Pie bg) throws Exception {
        byte pieType = bg.PieType;
        double sideX = Math.abs(bg.SideX);
        double sideY = Math.abs(bg.SideY);
        double[] points = SchemeEngine.SidesToPie(sideX, sideY, bg.Slices + 1, pieType, bg.StartAngle, bg.EndAngle);
        int pCount = points.length / 2;
        for (int i = 0; i < pCount; ++i) {
            int idx = 2 * i + 1;
            points[idx] = -points[idx];
        }
        double[] pts = this.engine.MulPoints(points);
        if (pieType == 0) {
            this.writeAsPolyline(bg, pts, 0, pCount);
        } else {
            this.writeAsPolygon(bg, pts, null);
        }
    }

    private void writeParagraph(Paragraph bg) throws Exception {
        if (!this.engine.tmpLayer.ShowTexts) {
            return;
        }
        if (bg.ShowBackground) {
            this.writeRectangle(bg);
        }
        if (bg.Lines == null || bg.Lines.isEmpty()) {
            return;
        }
        if (this.page.backPageId >= -1.0 && this.backPageShapes) {
            double scale = this.getBackPageRelScale(this.page);
            bg.exportSidesX /= scale;
            bg.exportSidesY /= scale;
        }
        this.prepareTextLines(bg.Lines);
        int a = (int)(this.engine.tmpAngle + 0.5);
        double angle = (double)(-a) * Math.PI / 180.0;
        double tabStopPosition = this.fs(bg.TabStopPosition) * 0.9;
        if (bg.Transparent != 0) {
            PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
            float tranparent = (float)((double)bg.Transparent / 255.0);
            graphicsState.setNonStrokingAlphaConstant(Float.valueOf(tranparent));
            this.contentStream.saveGraphicsState();
            this.contentStream.setGraphicsStateParameters(graphicsState);
        }
        double totalFontSize = 0.0;
        double lineSpacingX = 0.0;
        double lineSpacingY = 0.0;
        double lineSpacing = bg.LineSpacing;
        if (lineSpacing > 1.0) {
            lineSpacingX -= Math.sin(angle) * this.fs(bg.lfHeight) * (lineSpacing - 1.0);
            lineSpacingY += Math.cos(angle) * this.fs(bg.lfHeight) * (lineSpacing - 1.0);
        }
        int cnt = bg.Lines.size();
        for (int i = 0; i < cnt; ++i) {
            double fontSize;
            RectTextLine tl = (RectTextLine)bg.Lines.get(i);
            if (tl == null) continue;
            tl.parentParagraph = bg;
            double height = Math.abs(bg.SideY);
            BaseGraphic.RealPoint translate = new BaseGraphic.RealPoint();
            translate.X = PdfWriter.getTranslateX(tl);
            translate.Y = PdfWriter.getTranslateY(bg, height);
            double[] pts = new double[]{translate.X, translate.Y};
            pts = SchemeEngine.MulPointsTM(this.engine.GTM, pts);
            RectTextLine.ParagraphLine pl = tl.paragraphLine;
            if (pl != null) {
                double interval = pl.spaceAfter + pl.spaceBefore;
                lineSpacing = this.fs(interval) / this.fs(bg.lfHeight) + pl.lineSpacing;
            }
            double sx = this.fx(pts[0]) + lineSpacingX;
            double sy = this.fy(pts[1]) + lineSpacingY;
            sx -= Math.sin(angle) * (0.1 * totalFontSize);
            sy += Math.cos(angle) * (0.1 * totalFontSize);
            if (!tl.Parts.isEmpty()) {
                RectTextLine.PartTextLine ptl = tl.Parts.get(0);
                fontSize = this.fs(ptl.fontHeight == 0.0 ? bg.lfHeight : ptl.fontHeight);
            } else {
                double lineH = tl.SideY;
                fontSize = this.fs(bg.lfHeight < 1.0E-12 ? 2.0 * lineH / 3.0 : bg.lfHeight);
            }
            totalFontSize += fontSize;
            String fontName = "Arial";
            byte fontStyle = tl.FontStyle;
            Color fontColor = this.engine.getActualFontColor(Color.BLACK);
            if (tl != null) {
                fontColor = this.engine.getActualFontColor(tl.FontColor);
                if (!Strings.isVoid(tl.FontName)) {
                    fontName = tl.FontName.trim();
                }
            }
            PDFont font = this.getPDFont(fontName, fontStyle);
            this.contentStream.setFont(font, (float)fontSize);
            this.contentStream.setNonStrokingColor(fontColor);
            tl.Text = this.replaceBadSymbols(tl.Text, font);
            double stringW = this.getStringWidth(tl.Text, font, fontSize);
            double planeXheight = Math.sin(angle) * totalFontSize;
            double planeYheight = Math.cos(angle) * totalFontSize;
            double planeXwidth = PdfWriter.getShiftAlign(tl, Math.cos(angle) * stringW);
            double planeYwidth = PdfWriter.getShiftAlign(tl, Math.sin(angle) * stringW);
            double tx = sx + planeXheight - planeXwidth;
            double ty = sy - planeYheight - planeYwidth;
            if (tl.Parts.isEmpty()) {
                Matrix matrix = new Matrix();
                matrix.translate((float)tx, (float)ty);
                matrix.rotate(angle);
                boolean isUnderline = (tl.FontStyle & 4) != 0;
                boolean isStrikeOut = (tl.FontStyle & 8) != 0;
                double xBias = Math.cos(angle) * stringW;
                double yBias = Math.sin(angle) * stringW;
                if (isUnderline || isStrikeOut) {
                    RealPoint start = new RealPoint(tx, ty);
                    double endX = tx + xBias;
                    double endY = ty + yBias;
                    RealPoint end = new RealPoint(endX, endY);
                    this.checkTransparent(bg, false);
                    if (isUnderline) {
                        this.setUnderLine(fontColor, start, end, fontSize, angle);
                    }
                    if (isStrikeOut) {
                        this.setStrikeOut(fontColor, start, end, fontSize, angle);
                    }
                }
                this.checkTransparent(bg, true);
                this.contentStream.beginText();
                this.contentStream.setTextMatrix(matrix);
                this.contentStream.showText(tl.Text);
                this.contentStream.endText();
            } else {
                double startX = tx;
                double startY = ty;
                int cntj = tl.Parts.size();
                for (int k = 0; k < cntj; ++k) {
                    boolean isStrikeOut;
                    RectTextLine.PartTextLine ptl = tl.Parts.get(k);
                    PDFont partFont = this.getPDFont(ptl.fontName, ptl.fontStyle);
                    Color partColor = this.engine.getActualFontColor(ptl.fontColor);
                    double partFontSize = this.fs(ptl.fontHeight);
                    if (ptl.text.equals("\t")) {
                        double tabBiasX = Math.cos(angle) * tabStopPosition;
                        double tabBiasY = Math.sin(angle) * tabStopPosition;
                        startX += tabBiasX;
                        startY += tabBiasY;
                        continue;
                    }
                    ptl.text = this.replaceBadSymbols(ptl.text, partFont);
                    if (ptl.ssScript != 0) {
                        float reduce = (float)(partFontSize * 0.25);
                        switch (ptl.ssScript) {
                            case 1: {
                                this.contentStream.setTextRise(-reduce);
                                break;
                            }
                            case 2: {
                                this.contentStream.setTextRise(reduce);
                                break;
                            }
                        }
                        partFontSize -= (double)reduce;
                    }
                    double fixPartFontSize = this.fs(ptl.fontHeight);
                    double partStringWidth = this.getStringWidth(ptl.text, font, fixPartFontSize);
                    double space = this.getCharacterSpacing(font, ptl.text, fixPartFontSize);
                    double xBias = Math.cos(angle) * (partStringWidth + space);
                    double yBias = Math.sin(angle) * (partStringWidth + space);
                    boolean isUnderline = (ptl.fontStyle & 4) != 0;
                    boolean bl = isStrikeOut = (ptl.fontStyle & 8) != 0;
                    if (isUnderline || isStrikeOut) {
                        RealPoint start = new RealPoint(startX, startY);
                        double endX = startX + xBias;
                        double endY = startY + yBias;
                        RealPoint end = new RealPoint(endX, endY);
                        this.checkTransparent(bg, false);
                        if (isUnderline) {
                            this.setUnderLine(partColor, start, end, partFontSize, angle);
                        }
                        if (isStrikeOut) {
                            this.setStrikeOut(partColor, start, end, partFontSize, angle);
                        }
                    }
                    if (ptl.fontBgColor != null) {
                        double lowerRightX = startX + xBias;
                        double lowerRightY = startY + yBias;
                        double upperLeftX = startX + Math.sin(angle) * fontSize;
                        double upperLeftY = startY + Math.cos(angle) * fontSize;
                        double[] arr = new double[]{startX, startY, lowerRightX, lowerRightY, lowerRightX, upperLeftY, upperLeftX, upperLeftY};
                        this.writeRectangle(ptl.fontBgColor, arr);
                    }
                    this.checkTransparent(bg, true);
                    this.contentStream.beginText();
                    this.contentStream.setNonStrokingColor(partColor);
                    this.contentStream.setFont(partFont, (float)partFontSize);
                    Matrix matrix = new Matrix();
                    matrix.translate((float)startX, (float)startY);
                    matrix.rotate(angle);
                    this.contentStream.setTextMatrix(matrix);
                    this.contentStream.showText(ptl.text);
                    this.contentStream.endText();
                    this.contentStream.setTextRise(0.0f);
                    startX += xBias;
                    startY += yBias;
                }
            }
            double adaptiveLineSpacing = -Math.abs(lineSpacing) * fontSize;
            lineSpacingX -= Math.sin(angle) * (adaptiveLineSpacing + fontSize);
            lineSpacingY += Math.cos(angle) * (adaptiveLineSpacing + fontSize);
        }
        if (bg.Transparent != 0) {
            this.contentStream.restoreGraphicsState();
        }
    }

    public double getBackPageRelScale(SchemePage page) {
        double res = 1.0;
        if (page.backPageId >= -1.0) {
            double backPageId = page.backPageId;
            SchemePage backPage = this.s.getPageById(backPageId, true);
            double backPageScale = this.getPageScaleByPageLayout(backPage.pageLayout);
            double pageScale = this.getPageScaleByPageLayout(page.pageLayout);
            assert (pageScale != 0.0);
            return backPageScale / pageScale;
        }
        return res;
    }

    private void prepareTextLines(Paragraph.Lines lines) {
        for (BaseGraphic bg : lines) {
            assert (bg instanceof RectTextLine);
            RectTextLine rtl = (RectTextLine)bg;
            if (rtl.Parts.isEmpty()) continue;
            rtl.Text = "";
            for (RectTextLine.PartTextLine ptl : rtl.Parts) {
                rtl.Text = rtl.Text + ptl.text;
            }
        }
    }

    private void checkTransparent(Paragraph paragraph, boolean isText) throws IOException {
        PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
        float tranparent = (float)((double)(256 - paragraph.TransparentText) / 255.0);
        if (isText) {
            graphicsState.setNonStrokingAlphaConstant(Float.valueOf(tranparent));
        } else {
            graphicsState.setStrokingAlphaConstant(Float.valueOf(tranparent));
        }
        this.contentStream.setGraphicsStateParameters(graphicsState);
    }

    public static double getShiftAlign(RectTextLine rtl, double stringW) {
        Paragraph paragraph = rtl.parentParagraph;
        RectTextLine.ParagraphLine pl = rtl.paragraphLine;
        byte align = pl == null ? paragraph.Align : pl.align;
        switch (align) {
            case 1: {
                return stringW;
            }
            case 2: {
                return stringW / 2.0;
            }
        }
        return 0.0;
    }

    private void writeRectangle(Color color, double[] arr) throws Exception {
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.moveTo((float)arr[0], (float)arr[1]);
        for (int i = 1; i < arr.length / 2; ++i) {
            int idx = 2 * i;
            this.contentStream.lineTo((float)arr[idx], (float)arr[idx + 1]);
        }
        this.contentStream.closePath();
        this.contentStream.fill();
    }

    private void setUnderLine(Color partColor, RealPoint start, RealPoint end, double partFontSize, double angle) throws IOException {
        double moveX = partFontSize * 0.15 * Math.sin(angle);
        double moveY = partFontSize * 0.15 * Math.cos(angle);
        this.contentStream.setStrokingColor(partColor);
        this.contentStream.setLineJoinStyle(2);
        this.contentStream.setLineWidth((float)partFontSize / 20.0f);
        this.contentStream.moveTo((float)(start.x + moveX), (float)(start.y - moveY));
        this.contentStream.lineTo((float)(end.x + moveX), (float)(end.y - moveY));
        this.contentStream.stroke();
    }

    private void setStrikeOut(Color partColor, RealPoint start, RealPoint end, double partFontSize, double angle) throws IOException {
        double moveX = partFontSize * 0.3 * Math.sin(angle);
        double moveY = partFontSize * 0.3 * Math.cos(angle);
        this.contentStream.setStrokingColor(partColor);
        this.contentStream.setLineJoinStyle(2);
        this.contentStream.setLineWidth((float)partFontSize / 20.0f);
        this.contentStream.moveTo((float)(start.x - moveX), (float)(start.y + moveY));
        this.contentStream.lineTo((float)(end.x - moveX), (float)(end.y + moveY));
        this.contentStream.stroke();
    }

    public static double getTranslateX(RectTextLine rtl) {
        Paragraph paragraph = rtl.parentParagraph;
        RectTextLine.ParagraphLine pl = rtl.paragraphLine;
        byte align = pl == null ? paragraph.Align : pl.align;
        double leftMargin = paragraph.LeftMargin;
        double rightMargin = paragraph.RightMargin;
        double diff = leftMargin - rightMargin;
        switch (align) {
            case 0: 
            case 3: {
                return -0.5 * paragraph.SideX + leftMargin;
            }
            case 1: {
                return 0.5 * paragraph.SideX - rightMargin;
            }
        }
        return diff;
    }

    public static double getTranslateY(Paragraph paragraph, double height) {
        double bottomMargin = paragraph.BottomMargin;
        double topMargin = paragraph.TopMargin;
        double diff = topMargin - bottomMargin;
        if (paragraph.AutoSize) {
            paragraph.VertAlign = 0;
        }
        if (paragraph instanceof Attribute) {
            Attribute attr = (Attribute)paragraph;
            if (attr.Inscribe && attr.AutoSize) {
                paragraph.VertAlign = 2;
            }
        }
        switch (paragraph.VertAlign) {
            case 0: {
                return -0.5 * height + topMargin;
            }
            case 1: {
                return 0.5 * height - paragraph.exportSidesY - bottomMargin;
            }
        }
        return -0.5 * paragraph.exportSidesY + diff;
    }

    private double getCharacterSpacing(PDFont font, String str, double fontSize) throws IOException {
        double sumLength = 0.0;
        for (char ch : str.toCharArray()) {
            String s = String.valueOf(ch);
            sumLength += (double)this.getStringWidth(s, font, fontSize);
        }
        return sumLength / (double)str.length() / 7.0;
    }

    private PDFont getPDFont(String fontName, int fontStyle) throws Exception {
        boolean isBold = (fontStyle & 1) != 0;
        boolean isItalic = (fontStyle & 2) != 0;
        String[] supportedFormat = new String[]{"Times New Roman", "Arial", "Calibri", "Courier New"};
        String path = "/resources/ttf/%s/%s.ttf";
        String fileName = this.getFileName(fontName, isBold, isItalic);
        String filePath = String.format(path, fontName, fileName);
        if (this.fontMap.containsKey(filePath)) {
            return this.fontMap.get(filePath);
        }
        if (!this.contain(supportedFormat, fontName)) {
            String standardFileName = "LiberationSans-Regular.ttf";
            filePath = "/org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf";
            if (this.fontMap.containsKey(filePath)) {
                return this.fontMap.get(filePath);
            }
        }
        try (InputStream is = this.pdf.getClass().getResourceAsStream(filePath);){
            PDType0Font font = PDType0Font.load((PDDocument)this.pdf, (InputStream)is);
            this.fontMap.put(filePath, (PDFont)font);
            if (font.isDamaged()) {
                throw new IOException("\u0424\u0430\u0439\u043b \u0448\u0440\u0438\u0444\u0442\u0430 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0451\u043d");
            }
            PDType0Font pDType0Font = font;
            return pDType0Font;
        }
    }

    private boolean contain(String[] supportedFormat, String fileName) {
        for (String format : supportedFormat) {
            if (!fileName.equals(format)) continue;
            return true;
        }
        return false;
    }

    private String getFileName(String fontName, boolean isBold, boolean isItalic) {
        String fileName = fontName.concat("-");
        if (isBold && isItalic) {
            return fileName.concat("ItalicBold");
        }
        if (!isBold && isItalic) {
            return fileName.concat("Italic");
        }
        if (isBold && !isItalic) {
            return fileName.concat("Bold");
        }
        return fileName.concat("Regular");
    }

    private float getStringWidth(String text, PDFont font, double fontSize) throws IOException {
        return (float)((double)font.getStringWidth(text) * fontSize / 1000.0);
    }

    private String replaceBadSymbols(String text, PDFont font) throws IOException {
        if (Strings.isVoid(text)) {
            return " ";
        }
        if (text.contains("\t")) {
            text = text.replaceAll("\t", "    ");
        }
        char[] letters = text.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char ch : letters) {
            try {
                font.getStringWidth(String.valueOf(ch));
                sb.append(ch);
            }
            catch (IllegalArgumentException ignored) {
                sb.append("");
            }
        }
        return sb.toString();
    }

    private void writeAttribute(Attribute bg) throws Exception {
        if (bg.invisible()) {
            return;
        }
        if (bg.ParentGB != null && bg.Inscribe) {
            this.correctAttributes(bg);
        }
        this.writeParagraph(bg);
    }

    private void correctAttributes(Attribute attr) {
        double scaleX = 1.0;
        double scaleY = 1.0;
        BaseGraphic tmpBG = attr;
        while (tmpBG.ParentGB != null) {
            tmpBG = tmpBG.ParentGB;
            if (tmpBG.TransProps == null) {
                tmpBG.TransProps = new TransformProps();
            }
            scaleX *= tmpBG.TransProps.ScaleX;
            scaleY *= tmpBG.TransProps.ScaleY;
        }
        BaseGraphic parentGB = attr.ParentGB;
        if (parentGB instanceof GraphicBlock) {
            GraphicBlock gb = (GraphicBlock)parentGB;
            attr.SideX = (gb.MaxPtX - gb.MinPtX) * scaleX;
            attr.SideY = (gb.MaxPtY - gb.MinPtY) * scaleY;
        } else if (parentGB instanceof Rectangle) {
            Rectangle rect = (Rectangle)parentGB;
            attr.SideX = rect.SideX * scaleX;
            attr.SideY = rect.SideY * scaleY;
        } else {
            BaseGraphic.RealRect rr = parentGB.getMinMaxRect();
            if (parentGB instanceof Spline) {
                Spline spline = (Spline)parentGB;
                double[] pts = SchemeEngine.MulPointsTM(this.engine.GTM, spline.calcPoints());
                rr = SchemeUtils.getMinMaxPts(pts);
            }
            attr.SideX = (rr.Right - rr.Left) * scaleX;
            attr.SideY = (rr.Bottom - rr.Top) * scaleY;
        }
        AffineTransform tm = new AffineTransform();
        tm.setToScale(1.0 / scaleX, 1.0 / scaleY);
        this.engine.GTM.concatenate(tm);
    }

    private void writeBlock(GraphicBlock block) throws Exception {
        if (block.Objects == null || block.Objects.isEmpty()) {
            return;
        }
        int count = block.Objects.size();
        for (int i = 0; i < count; ++i) {
            BaseGraphic bg = block.Objects.get(i);
            if (bg == null || this.insertMode && (block.Objects.get(i) instanceof AttributeRef || block.Objects.get(i) instanceof AttributeDef)) continue;
            if (bg instanceof AttributeDef) {
                Attribute attr = (Attribute)bg;
                if (attr.invisible() || attr.getText().isEmpty()) continue;
                RectTextLine line = (RectTextLine)attr.Lines.get(0);
                if (line.FontName.equalsIgnoreCase("symbol")) continue;
                if (attr.Inscribe && !attr.AutoSize) {
                    if (attr.getEngine() == null) {
                        attr.setEngine(this.engine);
                    }
                    attr.setInscribeExt(block, true, true, false);
                }
            }
            this.writeShape(bg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInsert(PhxGraphicInsert insert) throws Exception {
        Primitive prim = this.s.findPrimInLibsById(insert.SourceID, insert.LibID);
        if (prim == null || prim.BG == null) {
            return;
        }
        this.curInsert = insert;
        GraphicBlock block = (GraphicBlock)prim.BG;
        if (insert.getInternalPrimGraphicBlock() != null) {
            block = insert.getInternalPrimGraphicBlock();
        }
        if (block == null || block.Objects == null || block.Objects.isEmpty()) {
            return;
        }
        this.insertMode = true;
        try {
            this.writeBlock(block);
            int attCount = insert.Attributes != null ? insert.Attributes.size() : 0;
            for (int i = 0; i < attCount; ++i) {
                Attribute att = (Attribute)insert.Attributes.get(i);
                if (att == null || att.invisible()) continue;
                att.ParentGB = insert;
                if (att.Inscribe) {
                    if (att.getEngine() == null) {
                        att.setEngine(this.engine);
                    }
                    double oldSideX = att.SideX;
                    att.setInscribeExt(block, true, false, false);
                    if (oldSideX < att.SideX) {
                        double scaleX = insert.TransProps == null ? 1.0 : insert.TransProps.ScaleX;
                        double scaleY = insert.TransProps == null ? 1.0 : insert.TransProps.ScaleY;
                        double attCenterX = att.SideX * 0.5;
                        double attCenterY = att.SideY * 0.5;
                        if (att.TransProps != null) {
                            att.TransProps.CenterX = attCenterX;
                            att.TransProps.CenterY = attCenterY;
                        }
                        att.OrgX = -attCenterX / scaleX;
                        att.OrgY = -attCenterY / scaleY;
                    }
                }
                this.writeShape(att);
            }
        }
        finally {
            this.insertMode = false;
        }
    }

    public void setStateHost(ServerSideHost host) {
        this.stateHost = host;
    }

    private void putStateCaption(String caption) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateCaption(caption);
    }

    private void putStateText(String value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateText(value);
    }

    private void putStateProgressMax(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressMax(value);
    }

    private void putStateProgressPosition(int value) throws Exception {
        if (this.stateHost == null) {
            return;
        }
        this.stateHost.putRequestStateProgressPosition(value);
    }

    private static String getPatternStringById(int patternId) {
        switch (patternId) {
            case 2: {
                return diagCellImage;
            }
            case 3: {
                return cellImage;
            }
            case 4: {
                return diagImage;
            }
            case 5: {
                return diagRevertImage;
            }
            case 6: {
                return vertImage;
            }
            case 7: {
                return horizImage;
            }
            case 8: {
                return dotImage;
            }
            case 9: {
                return dot2Image;
            }
            case 10: {
                return dot3Image;
            }
            case 11: {
                return dot4Image;
            }
            case 12: {
                return dot5Image;
            }
            case 13: {
                return dot6Image;
            }
            case 14: {
                return dot7Image;
            }
            case 15: {
                return horiz2Image;
            }
            case 16: {
                return doubleHorizImage;
            }
            case 17: {
                return horiz3Image;
            }
            case 18: {
                return doubleHoriz2Image;
            }
            case 19: {
                return horiz4Image;
            }
            case 20: {
                return vert2Image;
            }
            case 21: {
                return doubleVertImage;
            }
            case 22: {
                return vert3Image;
            }
            case 23: {
                return doubleVert2Image;
            }
            case 24: {
                return vert4Image;
            }
            case 25: {
                return diag2Image;
            }
            case 26: {
                return doubleDiagImage;
            }
            case 27: {
                return diag3Image;
            }
            case 28: {
                return doubleDiag2Image;
            }
            case 29: {
                return tripleDiagImage;
            }
            case 30: {
                return diagRevert2Image;
            }
            case 31: {
                return doubleDiagRevertImage;
            }
            case 32: {
                return diagRevert3Image;
            }
            case 33: {
                return doubleDiagRevert2Image;
            }
            case 34: {
                return tripleDiagRevertImage;
            }
            case 35: {
                return cell2Image;
            }
            case 36: {
                return doubleCellImage;
            }
            case 37: {
                return cell3Image;
            }
            case 38: {
                return doubleCell2Image;
            }
            case 39: {
                return cell4Image;
            }
            case 40: {
                return diagCell2Image;
            }
            case 41: {
                return doubleDiagCellImage;
            }
            case 42: {
                return diagCell3Image;
            }
            case 43: {
                return doubleDiagCell2Image;
            }
            case 44: {
                return pattern1Image;
            }
            case 45: {
                return pattern2Image;
            }
            case 46: {
                return pattern3Image;
            }
            case 47: {
                return pattern4Image;
            }
            case 48: {
                return pattern5Image;
            }
            case 49: {
                return pattern6Image;
            }
            case 50: {
                return pattern7Image;
            }
            case 51: {
                return pattern8Image;
            }
            case 52: {
                return pattern9Image;
            }
            case 53: {
                return pattern10Image;
            }
            case 54: {
                return pattern11Image;
            }
            case 55: {
                return pattern12Image;
            }
            case 56: {
                return pattern13Image;
            }
            case 57: {
                return pattern14Image;
            }
            case 58: {
                return pattern15Image;
            }
            case 59: {
                return pattern16Image;
            }
            case 60: {
                return pattern17Image;
            }
            case 61: {
                return pattern18Image;
            }
            case 62: {
                return pattern19Image;
            }
            case 63: {
                return pattern20Image;
            }
            case 64: {
                return pattern21Image;
            }
            case 65: {
                return pattern22Image;
            }
            case 66: {
                return pattern23Image;
            }
            case 67: {
                return pattern24Image;
            }
        }
        return null;
    }

    public static class RealPoint {
        private double x;
        private double y;

        public RealPoint(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public void assign(RealPoint source) {
            this.x = source.x;
            this.y = source.y;
        }
    }
}

