/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.Attribute;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.GraphicInsert;
import inform.agent.schemes.PrimLibrary;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.TransformProps;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;

public class PhxGraphicInsert
extends GraphicInsert {
    private GraphicBlock internalPrimGraphicBlock = null;
    public ArrayList<BaseGraphic> Attributes = null;
    private boolean scaleAttrs = false;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        PhxGraphicInsert shape = (PhxGraphicInsert)Dest;
        shape.LibID = this.LibID;
        shape.SourceID = this.SourceID;
        int ccount = this.Attributes.size();
        BaseGraphic Child = null;
        BaseGraphic tmpBG = null;
        shape.Attributes = null;
        for (int i = 0; i < ccount; ++i) {
            Child = this.Attributes.get(i);
            if (Child == null || (tmpBG = (BaseGraphic)Child.getClass().newInstance()) == null) continue;
            Child.assign(tmpBG);
            if (shape.Attributes == null) {
                shape.Attributes = new ArrayList();
            }
            shape.Attributes.add(tmpBG);
        }
    }

    public void setLibID(double LibraryID) {
        this.LibID = LibraryID;
    }

    public GraphicBlock getInternalPrimGraphicBlock() {
        return this.internalPrimGraphicBlock;
    }

    @Override
    protected void afterParse() {
        super.afterParse();
        if (this.Attributes == null) {
            return;
        }
        for (int i = 0; i < this.Attributes.size(); ++i) {
            BaseGraphic Child = this.Attributes.get(i);
            if (Child == null) continue;
            Child.afterParse();
        }
    }

    @Override
    protected synchronized void readExtraTagged(SchemeParser parser, TaggedReader reader, int tag) throws IOException {
        switch (tag) {
            case 6: {
                BaseGraphic bg;
                TaggedReader subReader = reader.getStreamReader();
                if (subReader == null || (bg = parser.createObject(202)) == null) break;
                this.internalPrimGraphicBlock = (GraphicBlock)bg;
                this.internalPrimGraphicBlock.parse(parser, subReader);
                this.internalPrimGraphicBlock.afterParse();
            }
        }
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        boolean NeedCorrectBounds = false;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    TaggedReader StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 97: {
                    this.LibID = reader.getDouble();
                    break;
                }
                case 98: {
                    this.SourceID = reader.getDouble();
                    break;
                }
                case 147: {
                    this.scaleAttrs = reader.getBoolean();
                    break;
                }
                case 100: {
                    TaggedReader StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    while (StreamReader.getNextTag() != 0) {
                        switch (StreamReader.getCurrentTag()) {
                            case 1: {
                                TaggedReader StreamReader1 = StreamReader.getStreamReader();
                                if (StreamReader1 == null) break;
                                while (StreamReader1.getNextTag() != 0) {
                                    switch (StreamReader1.getCurrentTag()) {
                                        case 2: {
                                            byte[] tmpBytes = StreamReader1.getRaw();
                                            int tmpInt = LittleEndian.getInt(tmpBytes, 0);
                                            BaseGraphic tmpBG = Parser2.createObject(tmpInt);
                                            if (tmpBG == null) break;
                                            tmpBG.parse(Parser2, StreamReader1);
                                            if (this.Attributes == null) {
                                                this.Attributes = new ArrayList();
                                            }
                                            tmpBG.ParentGB = this;
                                            this.Attributes.add(tmpBG);
                                            if ((((Attribute)tmpBG).Flags & 1) != 0) break;
                                            NeedCorrectBounds = true;
                                        }
                                    }
                                }
                                break;
                            }
                        }
                    }
                    break;
                }
            }
        }
        if (NeedCorrectBounds) {
            this.CorrectBounds(Parser2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void CorrectBounds(SchemeParser Parser2) {
        if (this.Attributes != null) {
            AffineTransform OldGTM = new AffineTransform();
            AffineTransform OldGTM1 = new AffineTransform();
            OldGTM.setTransform(Parser2.tmpGTM);
            try {
                int ccount = this.Attributes.size();
                int pcount = 4;
                double[] Pts = new double[2 * pcount];
                Attribute Child = null;
                Parser2.tmpGTM.concatenate(SchemeEngine.GenTransform(this));
                for (int i = 0; i < ccount; ++i) {
                    Child = (Attribute)this.Attributes.get(i);
                    if (Child == null || (Child.Flags & 1) != 0) continue;
                    Pts[0] = -0.5 * Child.SideX;
                    Pts[1] = -0.5 * Child.SideY;
                    Pts[2] = 0.5 * Child.SideX;
                    Pts[3] = -0.5 * Child.SideY;
                    Pts[4] = 0.5 * Child.SideX;
                    Pts[5] = 0.5 * Child.SideY;
                    Pts[6] = -0.5 * Child.SideX;
                    Pts[7] = 0.5 * Child.SideY;
                    OldGTM1.setTransform(Parser2.tmpGTM);
                    try {
                        Parser2.tmpGTM.concatenate(SchemeEngine.GenTransform(Child));
                        Pts = SchemeEngine.MulPointsTM(Parser2.tmpGTM, Pts);
                    }
                    finally {
                        Parser2.tmpGTM.setTransform(OldGTM1);
                    }
                    Child.Left = Pts[0];
                    Child.Right = Pts[1];
                    Child.Top = Pts[0];
                    Child.Bottom = Pts[1];
                    for (int j = 1; j < pcount; ++j) {
                        if (Child.Left > Pts[2 * j]) {
                            Child.Left = Pts[2 * j];
                        }
                        if (Child.Top > Pts[2 * j + 1]) {
                            Child.Top = Pts[2 * j + 1];
                        }
                        if (Child.Right < Pts[2 * j]) {
                            Child.Right = Pts[2 * j];
                        }
                        if (!(Child.Bottom < Pts[2 * j + 1])) continue;
                        Child.Bottom = Pts[2 * j + 1];
                    }
                    if (this.Left > Child.Left) {
                        this.Left = Child.Left;
                    }
                    if (this.Top > Child.Top) {
                        this.Top = Child.Top;
                    }
                    if (this.Right < Child.Right) {
                        this.Right = Child.Right;
                    }
                    if (!(this.Bottom < Child.Bottom)) continue;
                    this.Bottom = Child.Bottom;
                }
            }
            finally {
                Parser2.tmpGTM.setTransform(OldGTM);
            }
        }
    }

    @Override
    protected void paint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        Primitive Prim;
        PrimLibrary Lib;
        if (this.LibID != 0.0 && this.SourceID != 0.0 && (Lib = Engine2.s.PrimLibraries.get(this.LibID)) != null && (Prim = Lib.Primitives.get(this.SourceID)) != null && Prim.BG != null) {
            if (Prim.BG.TransProps != null) {
                if (this.TransProps == null) {
                    this.TransProps = new TransformProps();
                }
                this.TransProps.CenterX = Prim.BG.TransProps.CenterX;
                this.TransProps.CenterY = Prim.BG.TransProps.CenterY;
            }
            super.paint(g2d, Engine2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        block15: {
            Primitive Prim;
            PrimLibrary Lib;
            if (this.LibID != 0.0 && this.SourceID != 0.0 && (Lib = Engine2.s.PrimLibraries.get(this.LibID)) != null && (Prim = Lib.Primitives.get(this.SourceID)) != null && Prim.BG != null) {
                try {
                    Engine2.tmpInsertPaint = true;
                    GraphicBlock GB = (GraphicBlock)Prim.BG;
                    if (GB.Objects != null) {
                        int ccount = GB.Objects.size();
                        BaseGraphic Child = null;
                        for (int i = 0; i < ccount; ++i) {
                            Child = GB.Objects.get(i);
                            if (Child == null || Attribute.class.isAssignableFrom(Child.getClass())) continue;
                            Child.paint(g2d, Engine2);
                        }
                    }
                    if (this.Attributes == null) break block15;
                    if (Engine2.UseGTM) {
                        AffineTransform OldGTM = new AffineTransform();
                        OldGTM.setTransform(Engine2.GTM);
                        try {
                            int ccount = this.Attributes.size();
                            Attribute Child = null;
                            for (int i = 0; i < ccount; ++i) {
                                Child = (Attribute)this.Attributes.get(i);
                                if (Child == null) continue;
                                Child.paint(g2d, Engine2);
                            }
                            break block15;
                        }
                        finally {
                            Engine2.GTM.setTransform(OldGTM);
                        }
                    }
                    AffineTransform OldGTM = new AffineTransform();
                    OldGTM.setTransform(g2d.getTransform());
                    try {
                        SchemeEngine.Transform(g2d, this);
                        int ccount = this.Attributes.size();
                        Attribute Child = null;
                        for (int i = 0; i < ccount; ++i) {
                            Child = (Attribute)this.Attributes.get(i);
                            if (Child == null) continue;
                            Child.paint(g2d, Engine2);
                        }
                    }
                    finally {
                        g2d.setTransform(OldGTM);
                    }
                }
                finally {
                    Engine2.tmpInsertPaint = false;
                }
            }
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        writer.putDouble(97, this.LibID);
        writer.putDouble(98, this.SourceID);
        writer.putBool(147, this.scaleAttrs);
        this.writeTaggedBounds(writer);
        this.writeTaggedAttribRefs(writer, clipboard, simult);
    }

    synchronized void writeTaggedAttribRefs(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null || this.Attributes == null || this.Attributes.isEmpty()) {
            return;
        }
        BaseGraphic.ShapeClassInfo classInfo = new BaseGraphic.ShapeClassInfo();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        int count = this.Attributes.size();
        for (int i = 0; i < count; ++i) {
            BaseGraphic attr = this.Attributes.get(i);
            ByteArrayOutputStream os1 = new ByteArrayOutputStream();
            TaggedWriter w1 = new TaggedWriter(os1);
            classInfo.shapeType = 226;
            classInfo.version = attr.getShapeClassInfo().version;
            SchemeUtils.writeShapeClassInfo(w1, classInfo);
            attr.writeTaggedData(w1, clipboard, simult);
            w1.flush();
            w.putRaw(1, os1);
        }
        w.flush();
        writer.putRaw(100, os);
    }

    @Override
    public int shapeType() {
        return 207;
    }

    @Override
    public int shapeVersion() {
        return version;
    }
}

