/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import java.awt.Color;
import java.io.IOException;

public class PhxLayer
extends GraphicBlock {
    public byte Flags = 0;
    public Color bColor = null;
    public Color pColor = null;
    public Color BkColor = null;
    public Color FontColor = null;
    public int PenPattern = 0;
    public int BrushPattern = 0;
    public double lWidth = 0.0;
    public double PrimID = 0.0;
    public String Description = null;
    public boolean Cosmetic = false;
    public double CornerRadius = 0.0;
    public double PageId;
    public int Transparent = 0;
    public int TransparentBorder = 0;
    public boolean Visible = true;
    public boolean Selectable = true;
    public boolean ShowTexts = true;
    public boolean Exportable = true;
    public int SortIndex = -1;
    private static final Color DEF_LA_COLOR = Color.WHITE;
    private static final Color DEF_LA_BK_COLOR = Color.WHITE;
    private static final Color DEF_LA_P_COLOR = Color.BLACK;
    private static final Color DEF_LA_FONT_COLOR = Color.BLACK;
    private static final int DEF_LA_PEN_PATTERN = 0;
    private static final double DEF_LA_PRIM_ID = 0.0;
    private static final int DEF_LA_BRUSH_PATTERN = 0;
    private static final double DEF_LA_L_WIDTH = 0.0;
    private static final int DEF_LA_PAGE_ID = 0;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 0}, 0);

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        PhxLayer shape = (PhxLayer)Dest;
        shape.Flags = this.Flags;
        shape.bColor = this.bColor;
        shape.pColor = this.pColor;
        shape.BkColor = this.BkColor;
        shape.FontColor = this.FontColor;
        shape.PenPattern = this.PenPattern;
        shape.BrushPattern = this.BrushPattern;
        shape.lWidth = this.lWidth;
        shape.PrimID = this.PrimID;
        shape.Description = this.Description;
        shape.Cosmetic = this.Cosmetic;
        shape.CornerRadius = this.CornerRadius;
        shape.Visible = this.Visible;
        shape.Selectable = this.Selectable;
        shape.ShowTexts = this.ShowTexts;
        shape.Exportable = this.Exportable;
        shape.PageId = this.PageId;
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        TaggedReader StreamReader = null;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 101: {
                    this.Flags = reader.getByte();
                    this.Visible = (this.Flags & 1) != 0;
                    this.Selectable = (this.Flags & 2) != 0;
                    this.ShowTexts = (this.Flags & 4) != 0;
                    this.Exportable = (this.Flags & 8) != 0;
                    break;
                }
                case 102: {
                    this.bColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 103: {
                    this.pColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 104: {
                    this.BkColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 105: {
                    this.FontColor = SchemeParser.parseColor(reader.getInt());
                    break;
                }
                case 106: {
                    this.PenPattern = reader.getInt();
                    break;
                }
                case 107: {
                    this.BrushPattern = reader.getInt();
                    break;
                }
                case 108: {
                    this.lWidth = reader.getDouble();
                    break;
                }
                case 109: {
                    this.PrimID = reader.getDouble();
                    break;
                }
                case 110: {
                    this.Description = reader.getUnicode();
                    break;
                }
                case 111: {
                    this.Cosmetic = reader.getBoolean();
                    break;
                }
                case 142: {
                    this.PageId = reader.getDouble();
                    break;
                }
                case 3: {
                    StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 145: {
                    this.Transparent = Byte.toUnsignedInt(reader.getByte());
                    break;
                }
                case 146: {
                    this.TransparentBorder = Byte.toUnsignedInt(reader.getByte());
                }
            }
        }
    }

    public boolean getConfigVisible(String config) {
        int i;
        boolean res = this.Visible;
        if (!config.isEmpty() && this.SortIndex >= 0 && (i = this.SortIndex / 4) < config.length()) {
            int v = Integer.parseInt(String.valueOf(config.charAt(i)), 16);
            int m = this.SortIndex % 4;
            switch (m) {
                case 0: {
                    res = (v & 1) != 0;
                    break;
                }
                case 1: {
                    res = (v & 2) != 0;
                    break;
                }
                case 2: {
                    res = (v & 4) != 0;
                    break;
                }
                case 3: {
                    res = (v & 8) != 0;
                }
            }
        }
        return res;
    }

    @Override
    public int shapeType() {
        return 204;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        if (!(this.Visible && this.Selectable && this.ShowTexts && this.Exportable)) {
            byte flag = 0;
            if (this.Visible) {
                flag = (byte)(flag | 1);
            }
            if (this.Selectable) {
                flag = (byte)(flag | 2);
            }
            if (this.ShowTexts) {
                flag = (byte)(flag | 4);
            }
            if (this.Exportable) {
                flag = (byte)(flag | 8);
            }
            writer.putInt08(101, flag);
        }
        if (this.bColor != null && this.bColor != DEF_LA_COLOR) {
            SchemeUtils.writeColor(writer, 102, this.bColor);
        }
        if (this.pColor != null && this.pColor != DEF_LA_P_COLOR) {
            SchemeUtils.writeColor(writer, 103, this.pColor);
        }
        if (this.BkColor != null && this.BkColor != DEF_LA_BK_COLOR) {
            SchemeUtils.writeColor(writer, 104, this.BkColor);
        }
        if (this.FontColor != null && this.FontColor != DEF_LA_FONT_COLOR) {
            SchemeUtils.writeColor(writer, 105, this.FontColor);
        }
        if (this.PenPattern != 0) {
            writer.putInt32(106, this.PenPattern);
        }
        if (this.BrushPattern != 0) {
            writer.putInt32(107, this.BrushPattern);
        }
        if (this.lWidth != 0.0) {
            writer.putDouble(108, this.lWidth);
        }
        if (this.PrimID != 0.0) {
            writer.putDouble(109, this.PrimID);
        }
        if (this.Description != null && !this.Description.isEmpty()) {
            writer.putUnicode(110, this.Description);
        }
        if (this.Cosmetic) {
            writer.putEmpty(111);
        }
        if (this.PageId != 0.0) {
            writer.putDouble(142, this.PageId);
        }
        if (this.Transparent != 0) {
            writer.putInt08(145, (byte)this.Transparent);
        }
        if (this.TransparentBorder != 0) {
            writer.putInt08(146, (byte)this.TransparentBorder);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(stream);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (stream.size() > 0) {
            writer.putRaw(3, stream);
        }
    }
}

