/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.BaseShape;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.PrimLibrary;
import inform.agent.schemes.Primitive;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.SchemeParser;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.TransformProps;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.io.IOException;

public class Polyline
extends BaseShape {
    public double[] Points = null;
    public double[] PointsWithJump = null;
    public int[] PointsCounts = null;
    public double[] StartArrowPoints = null;
    public double[] EndArrowPoints = null;
    public double[] PointsPikets = null;
    public double PrimID = 0.0;
    public double StartPattern = 0.0;
    public double EndPattern = 0.0;
    public int StartVisArrowType;
    public int EndVisArrowType;
    public double StartVisArrowSize;
    public double EndVisArrowSize;
    public int ConnectorView = 0;
    private static final int version = LittleEndian.getInt(new byte[]{0, 0, 29, 4}, 0);

    @Override
    public int shapeType() {
        return 210;
    }

    @Override
    public int shapeVersion() {
        return version;
    }

    @Override
    public void assign(BaseGraphic Dest) throws IllegalAccessException, InstantiationException {
        super.assign(Dest);
        Polyline shape = (Polyline)Dest;
        shape.PrimID = this.PrimID;
        shape.StartPattern = this.StartPattern;
        shape.EndPattern = this.EndPattern;
        shape.StartVisArrowType = this.StartVisArrowType;
        shape.EndVisArrowType = this.EndVisArrowType;
        shape.StartVisArrowSize = this.StartVisArrowSize;
        shape.EndVisArrowSize = this.EndVisArrowSize;
        shape.ConnectorView = this.ConnectorView;
        int pointsCount = this.Points.length;
        int pointsWithJumpCount = this.PointsWithJump.length;
        int plotCount = this.PointsCounts.length;
        shape.Points = new double[pointsCount];
        shape.PointsWithJump = new double[pointsWithJumpCount];
        shape.PointsCounts = new int[plotCount];
        System.arraycopy(this.PointsCounts, 0, shape.PointsCounts, 0, plotCount);
        System.arraycopy(this.Points, 0, shape.Points, 0, pointsCount);
        System.arraycopy(this.PointsWithJump, 0, shape.PointsWithJump, 0, pointsWithJumpCount);
    }

    private static boolean isBadPoints(double[] pts) {
        if (pts == null) {
            return true;
        }
        for (double pt : pts) {
            if (!Double.isNaN(pt)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void parse(SchemeParser Parser2, TaggedReader reader) throws IOException, TaggedReaderException {
        boolean isStartArrow = true;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 3: {
                    TaggedReader StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    super.parse(Parser2, StreamReader);
                    break;
                }
                case 74: {
                    TaggedReader StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    while (StreamReader.getNextTag() != 0) {
                        if (StreamReader.getCurrentTag() != 76) continue;
                        this.Points = LittleEndian.toDoubleArray(StreamReader.getRaw());
                        if (!Polyline.isBadPoints(this.Points)) continue;
                        this.isBadObject = true;
                    }
                    break;
                }
                case 77: {
                    this.PrimID = reader.getDouble();
                    break;
                }
                case 117: {
                    this.StartPattern = reader.getDouble();
                    break;
                }
                case 118: {
                    this.EndPattern = reader.getDouble();
                    break;
                }
                case 137: {
                    this.StartVisArrowType = reader.getInt();
                    isStartArrow = true;
                    break;
                }
                case 138: {
                    this.EndVisArrowType = reader.getInt();
                    isStartArrow = false;
                    break;
                }
                case 139: {
                    this.StartVisArrowSize = reader.getDouble();
                    break;
                }
                case 140: {
                    this.EndVisArrowSize = reader.getDouble();
                    break;
                }
                case 148: {
                    this.ConnectorView = reader.getInt();
                    break;
                }
                case 150: {
                    TaggedReader StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    while (StreamReader.getNextTag() != 0) {
                        if (StreamReader.getCurrentTag() != 76) continue;
                        if (isStartArrow) {
                            this.StartArrowPoints = LittleEndian.toDoubleArray(StreamReader.getRaw());
                            continue;
                        }
                        this.EndArrowPoints = LittleEndian.toDoubleArray(StreamReader.getRaw());
                    }
                    break;
                }
                case 23: {
                    TaggedReader StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    while (StreamReader.getNextTag() != 0) {
                        if (StreamReader.getCurrentTag() != 76) continue;
                        this.PointsWithJump = LittleEndian.toDoubleArray(StreamReader.getRaw());
                        if (!Polyline.isBadPoints(this.PointsWithJump)) continue;
                        this.isBadObject = true;
                    }
                    break;
                }
                case 24: {
                    TaggedReader StreamReader = reader.getStreamReader();
                    if (StreamReader == null) break;
                    while (StreamReader.getNextTag() != 0) {
                        if (StreamReader.getCurrentTag() != 25) continue;
                        this.PointsCounts = LittleEndian.toIntArray(StreamReader.getRaw());
                    }
                    break;
                }
            }
        }
    }

    @Override
    public synchronized void writeTaggedData(TaggedWriter writer, boolean clipboard, boolean simult) throws IOException {
        if (writer == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(os);
        super.writeTaggedData(subWriter, clipboard, simult);
        subWriter.flush();
        if (os.size() > 0) {
            writer.putRaw(3, os);
        }
        this.writeTaggedPoints(writer);
        if (this.shapeType() != 210 && this.shapeType() != 212) {
            return;
        }
        if (this.PrimID > FloatTolerance) {
            writer.putDouble(77, this.PrimID);
        }
        if (this.StartPattern > FloatTolerance) {
            writer.putDouble(117, this.StartPattern);
        }
        if (this.EndPattern > FloatTolerance) {
            writer.putDouble(118, this.EndPattern);
        }
        if (this.StartVisArrowType != 0) {
            writer.putInt32(137, this.StartVisArrowType);
        }
        if (this.EndVisArrowType != 0) {
            writer.putInt32(138, this.EndVisArrowType);
        }
        if (this.StartVisArrowSize != 0.0) {
            writer.putDouble(139, this.StartVisArrowSize);
        }
        if (this.EndVisArrowSize != 0.0) {
            writer.putDouble(140, this.EndVisArrowSize);
        }
        if (this.ConnectorView > 0) {
            writer.putInt32(148, this.ConnectorView);
        }
    }

    synchronized void writeTaggedPoints(TaggedWriter writer) throws IOException {
        if (this.Points == null || this.Points.length == 0) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter w = new TaggedWriter(os);
        if (this.Points.length != 4) {
            w.putInt32(75, this.Points.length / 2);
        }
        w.putRaw(76, LittleEndian.doubleArrayToBinary(this.Points, this.Points.length));
        w.flush();
        writer.putRaw(74, os);
        if (this.PointsPikets != null && this.PointsPikets.length > 0) {
            writer.putRaw(120, LittleEndian.doubleArrayToBinary(this.PointsPikets));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void actualPaint(Graphics2D g2d, SchemeEngine Engine2) throws IllegalAccessException, InstantiationException {
        int pPattern = this.PenPattern;
        double lPrimID = Engine2.getActualPrimID(pPattern, this.PrimID);
        if (lPrimID != 0.0 && Engine2.tmpPrimPolylinePaint) {
            lPrimID = 0.0;
            pPattern = 0;
        }
        if (lPrimID != 0.0) {
            Primitive Prim = null;
            for (PrimLibrary Lib : Engine2.s.PrimLibraries) {
                assert (Lib != null);
                PrimLibrary primLibrary = Lib;
                synchronized (primLibrary) {
                    Prim = Lib.Primitives.get(lPrimID);
                    if (Prim != null) {
                        break;
                    }
                }
            }
            if (Prim == null || Prim.BG == null) return;
            try {
                Engine2.tmpPrimPolylinePaint = true;
                GraphicBlock Block = new GraphicBlock();
                Prim.BG.assign(Block);
                Block.LayerID = this.LayerID;
                double PrimWidth = Block.MaxPtX - Block.MinPtX;
                if (!(PrimWidth > 0.0)) return;
                double PrimCenterX = 0.0;
                if (Block.TransProps == null) {
                    Block.TransProps = new TransformProps();
                }
                PrimCenterX = Block.TransProps.CenterX;
                double CenterShift = 0.5 * PrimWidth - PrimCenterX;
                int p_idx = 0;
                double StartPointX = 0.0;
                double StartPointY = 0.0;
                double EndPointX = 0.0;
                double EndPointY = 0.0;
                double SegmWidth = 0.0;
                double SegmHeight = 0.0;
                double SegmLength = 0.0;
                int CountInSegm = 0;
                double k = 0.0;
                double k1 = 0.0;
                double dx = 0.0;
                double dy = 0.0;
                int pcount = this.Points.length / 2;
                for (int i = 0; i < pcount - 1; ++i) {
                    p_idx = 2 * i;
                    EndPointX = this.Points[p_idx + 2];
                    StartPointX = this.Points[p_idx];
                    SegmWidth = EndPointX - StartPointX;
                    EndPointY = this.Points[p_idx + 3];
                    StartPointY = this.Points[p_idx + 1];
                    SegmHeight = EndPointY - StartPointY;
                    SegmLength = Math.sqrt(SegmWidth * SegmWidth + SegmHeight * SegmHeight);
                    if (!(SegmLength > 0.0)) continue;
                    CountInSegm = (int)Math.ceil((SegmLength + CenterShift) / PrimWidth);
                    k = SegmLength / ((double)CountInSegm * PrimWidth);
                    k1 = (double)CountInSegm * k;
                    dx = SegmWidth / k1;
                    dy = SegmHeight / k1;
                    Block.TransProps.Angle = Math.atan2(EndPointY - StartPointY, EndPointX - StartPointX) / Math.PI * 180.0;
                    for (int j = 0; j < CountInSegm; ++j) {
                        Block.OrgX = StartPointX + (double)j * dx;
                        Block.OrgY = StartPointY + (double)j * dy;
                        Block.paint(g2d, Engine2);
                    }
                }
                return;
            }
            finally {
                Engine2.tmpPrimPolylinePaint = false;
            }
        } else {
            if (!Engine2.isNeedPen(pPattern)) return;
            Engine2.setActualPColor(g2d, this.pColor);
            Engine2.setActualPenStyle(g2d, pPattern, this.lWidth);
            double[] Pts = null;
            Pts = Engine2.UseGTM ? Engine2.MulPoints(this.Points) : this.Points;
            int pcount = Pts.length / 2;
            if (Engine2.UseJavaShapes && pcount > 2) {
                Path2D.Double shape = new Path2D.Double();
                ((Path2D)shape).moveTo(Pts[0], Pts[1]);
                int idx = 0;
                for (int i = 1; i < pcount; ++i) {
                    idx = 2 * i;
                    ((Path2D)shape).lineTo(Pts[idx], Pts[idx + 1]);
                }
                g2d.draw(shape);
                return;
            } else {
                int[] x = new int[pcount];
                int[] y = new int[pcount];
                int idx = 0;
                for (int i = 0; i < pcount; ++i) {
                    idx = 2 * i;
                    x[i] = (int)Math.round(Pts[idx]);
                    y[i] = (int)Math.round(Pts[idx + 1]);
                }
                g2d.drawPolyline(x, y, pcount);
            }
        }
    }

    @Override
    protected int getVerticesCount() {
        return this.Points == null ? 0 : this.Points.length / 2;
    }

    @Override
    protected double getVertexX(int index) {
        int cnt;
        int n = cnt = this.Points == null ? 0 : this.Points.length / 2;
        assert (index >= 0 && index < cnt);
        return this.Points[index * 2];
    }

    @Override
    protected double getVertexY(int index) {
        int cnt;
        int n = cnt = this.Points == null ? 0 : this.Points.length / 2;
        assert (index >= 0 && index < cnt);
        return this.Points[index * 2 + 1];
    }

    @Override
    protected void setVertex(int index, double x, double y) {
        int cnt;
        int n = cnt = this.Points == null ? 0 : this.Points.length / 2;
        assert (index >= 0 && index < cnt);
        this.Points[index * 2] = x;
        this.Points[index * 2 + 1] = y;
    }

    public boolean addGluePointToVertex(double x, double y, int idx) {
        int gluePointsCount;
        boolean result = super.addGluePoint(x, y);
        int verticesCount = this.getVerticesCount();
        int n = gluePointsCount = this.GluePoints == null ? 0 : this.GluePoints.size();
        if (result && idx >= 0 && idx < verticesCount && gluePointsCount > 0) {
            ((BaseGraphic.GluePoint)this.GluePoints.get((int)(gluePointsCount - 1))).vertIdx = idx;
        }
        this.smartRevertexNearGlueds();
        return result;
    }

    @Override
    public boolean addGluePoint(double x, double y) {
        boolean result = super.addGluePoint(x, y);
        this.smartRevertexNearGlueds();
        return result;
    }

    private void smartRevertexNearGlueds() {
        int gluePointsCount = this.GluePoints == null ? 0 : this.GluePoints.size();
        double[] gluePt = new double[2];
        double[] pt = new double[2];
        AffineTransform tm = SchemeEngine.GenTransform(this);
        for (int j = 0; j < gluePointsCount; ++j) {
            BaseGraphic.GluePoint gp = (BaseGraphic.GluePoint)this.GluePoints.get(j);
            if (gp.vertIdx != -1) continue;
            gluePt[0] = gp.ptX;
            gluePt[1] = gp.ptY;
            gluePt = SchemeEngine.MulPointsTM(tm, gluePt);
            int cnti = this.getVerticesCount();
            for (int i = 0; i < cnti; ++i) {
                pt[0] = this.getVertexX(i);
                pt[1] = this.getVertexY(i);
                double mag2D = Math.sqrt(((pt = SchemeEngine.MulPointsTM(tm, pt))[0] - gluePt[0]) * (pt[0] - gluePt[0]) + (pt[1] - gluePt[1]) * (pt[1] - gluePt[1]));
                if (!(mag2D <= FloatTolerance) || this.glueByVertIdx(i) != null || !this.isVertexGluable(i)) continue;
                gp.vertIdx = i;
                gp.ptX = this.getVertexX(i);
                gp.ptY = this.getVertexY(i);
            }
        }
    }

    public boolean checkIfFirstArrowNeeded() {
        BaseGraphic.GluePoint gp;
        if (this.StartVisArrowType != 0) {
            return true;
        }
        return this.getVerticesCount() > 1 && this.GluePoints != null && this.GluePoints.size() > 0 && (gp = this.glueByVertIdx(0)) != null && gp.contactNumber == 2 && (gp.flags & 4) != 0;
    }

    public boolean checkIfLastArrowNeeded() {
        BaseGraphic.GluePoint gp;
        if (this.EndVisArrowType != 0) {
            return true;
        }
        return this.getVerticesCount() > 1 && this.GluePoints != null && this.GluePoints.size() > 0 && (gp = this.glueByVertIdx(this.getVerticesCount() - 1)) != null && gp.contactNumber == 2 && (gp.flags & 4) != 0;
    }

    public BaseGraphic.RealPoint trimSegmentByArrow(double[] pts, int beginIndex, int endIndex, boolean started) {
        double arrowLength;
        double arrowWidth = this.lWidth;
        double arrowSize = started ? this.StartVisArrowSize : this.EndVisArrowSize;
        int arrowType = started ? this.StartVisArrowType : this.EndVisArrowType;
        BaseGraphic.RealPoint rpBegin = new BaseGraphic.RealPoint(pts[beginIndex * 2], pts[beginIndex * 2 + 1]);
        BaseGraphic.RealPoint rpEnd = new BaseGraphic.RealPoint(pts[endIndex * 2], pts[endIndex * 2 + 1]);
        if (arrowType != 0) {
            if (arrowType != 0 && arrowSize <= 1.0E-12) {
                return rpEnd;
            }
            switch (arrowType) {
                case 19: 
                case 25: 
                case 28: {
                    return rpEnd;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 16: 
                case 29: {
                    if (arrowWidth <= 0.0 || this.LineCap != 2) {
                        return rpEnd;
                    }
                    arrowSize = 0.0;
                    break;
                }
                case 8: 
                case 10: 
                case 11: 
                case 32: {
                    arrowSize /= 2.0;
                    break;
                }
                case 21: 
                case 22: {
                    arrowSize *= 1.95;
                    break;
                }
                case 26: 
                case 27: 
                case 30: 
                case 31: {
                    arrowSize *= 2.0;
                    break;
                }
                case 23: 
                case 24: {
                    arrowSize *= 2.5;
                    break;
                }
            }
            if (arrowWidth > 0.0 && this.LineCap == 2) {
                arrowSize += arrowWidth / 2.0;
            }
            arrowWidth = arrowSize / 6.0;
        }
        double d = arrowLength = arrowWidth <= 1.0E-12 ? 6.0 : 6.0 * arrowWidth;
        if (arrowLength < 1.0E-12 && arrowLength > -1.0E-12) {
            return rpEnd;
        }
        double lambda = Math.abs(SchemeUtils.mag2d(rpBegin, rpEnd) - arrowLength) / arrowLength;
        if (1.0 + lambda <= 1.0E-12 || lambda <= 0.0) {
            return rpEnd;
        }
        return new BaseGraphic.RealPoint((rpBegin.X + lambda * rpEnd.X) / (1.0 + lambda), (rpBegin.Y + lambda * rpEnd.Y) / (1.0 + lambda));
    }
}

