/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.SchemeUtils;
import java.io.IOException;
import java.util.ArrayList;

public class SchemePageNotes {
    private ArrayList<SchemeNote> notes;

    public void load(TaggedReader reader) throws IOException {
        this.notes = new ArrayList();
        SchemeNote note = null;
        block6: while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    note = new SchemeNote();
                    this.notes.add(note);
                    note.text = reader.getString();
                    continue block6;
                }
                case 2: {
                    assert (note != null);
                    note.userName = reader.getString();
                    continue block6;
                }
                case 3: {
                    assert (note != null);
                    note.dateTime = reader.getDouble();
                    continue block6;
                }
                case 4: {
                    assert (note != null);
                    note.isOpen = reader.getBoolean();
                    continue block6;
                }
            }
        }
    }

    public synchronized void store(TaggedWriter writer) throws IOException {
        if (this.notes == null) {
            return;
        }
        for (SchemeNote note : this.notes) {
            if (SchemeUtils.isEmpty(note.text)) continue;
            writer.putString(1, note.text);
            if (!SchemeUtils.isEmpty(note.userName)) {
                writer.putString(2, note.userName);
            }
            writer.putDouble(3, note.dateTime);
            writer.putBool(4, note.isOpen);
        }
        writer.flush();
    }

    public synchronized byte[] asBinary() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(os);
        this.store(writer);
        return os.toByteArray();
    }

    public ArrayList<SchemeNote> getNotes() {
        return this.notes;
    }

    public void setNotes(ArrayList<SchemeNote> value) {
        this.notes = value;
    }

    static class SchemeNote {
        public String userName;
        public double dateTime;
        public String text;
        public boolean isOpen = true;

        SchemeNote() {
        }

        public boolean isDefaultValue() {
            return this.isOpen && this.text == null && this.userName == null && this.dateTime == 0.0;
        }
    }
}

