/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.GraphicBlock;
import inform.agent.schemes.GraphicInsert;
import inform.agent.schemes.Image;
import inform.agent.schemes.PhxImage;
import inform.agent.schemes.Polyline;
import inform.agent.schemes.SchemeEngine;
import inform.agent.schemes.Spline;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemeUtils {
    public static final double MIN_TOLERANCE = 1.0E-6;
    public static final double PATH_TOLERANCE = 0.001;
    public static final double MAX_ANGLE = Math.PI * 2;

    public static void writeDoubles(TaggedWriter writer, int tag, double ... values) throws IOException {
        if (writer == null || tag == 0 || values == null || values.length == 0) {
            return;
        }
        boolean hasValues = false;
        for (int i = 0; !hasValues && i < values.length; ++i) {
            hasValues = values[i] != 0.0;
        }
        if (!hasValues) {
            return;
        }
        byte[] tmpBytes = new byte[8 * values.length];
        for (int i = 0; i < values.length; ++i) {
            LittleEndian.setDouble(values[i], tmpBytes, i * 8);
        }
        writer.putRaw(tag, tmpBytes);
    }

    public static void writeInts(TaggedWriter writer, int tag, int ... values) throws IOException {
        if (writer == null || tag == 0 || values == null || values.length == 0) {
            return;
        }
        boolean hasValues = false;
        for (int i = 0; !hasValues && i < values.length; ++i) {
            hasValues = values[i] != 0;
        }
        if (!hasValues) {
            return;
        }
        byte[] tmpBytes = new byte[4 * values.length];
        for (int i = 0; i < values.length; ++i) {
            LittleEndian.setInteger(values[i], tmpBytes, i * 4);
        }
        writer.putRaw(tag, tmpBytes);
    }

    public static void writeShapeClassInfo(TaggedWriter writer, BaseGraphic.ShapeClassInfo shapeInfo) throws IOException {
        if (writer == null || shapeInfo == null) {
            return;
        }
        SchemeUtils.writeInts(writer, 2, shapeInfo.shapeType, shapeInfo.version);
    }

    public static void writeColor(TaggedWriter writer, int tag, Color color) throws IOException {
        if (writer == null || color == null) {
            return;
        }
        writer.putInt32(tag, color.getBlue() << 16 | color.getGreen() << 8 | color.getRed());
    }

    private static void intToBytes(int i, byte[] b) {
        assert (b != null && b.length == 4);
        b[0] = (byte)(i >> 24);
        b[1] = (byte)(i >> 16);
        b[2] = (byte)(i >> 8);
        b[3] = (byte)i;
    }

    public static byte[] getImagePixels24(BufferedImage image) {
        if (image == null) {
            return null;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int empty = w * 3 % 4;
        if (empty > 0) {
            empty = 4 - empty;
        }
        int[] pixels = image.getRGB(0, 0, w, h, null, 0, w);
        byte[] bytes = new byte[(w * 3 + empty) * h];
        byte[] b = new byte[4];
        int idx = 0;
        for (int y = h - 1; y >= 0; --y) {
            for (int x = 0; x < w; ++x) {
                int pixel = pixels[y * w + x];
                SchemeUtils.intToBytes(pixel, b);
                if (b[0] == 0) {
                    bytes[idx++] = -1;
                    bytes[idx++] = -1;
                    bytes[idx++] = -1;
                    continue;
                }
                bytes[idx++] = b[3];
                bytes[idx++] = b[2];
                bytes[idx++] = b[1];
            }
            idx += empty;
        }
        return bytes;
    }

    public static BufferedImage transformImageToABGR(BufferedImage image) {
        if (image.getType() != 6) {
            int w = image.getWidth();
            int h = image.getHeight();
            int[] pixels = image.getRGB(0, 0, w, h, null, 0, w);
            BufferedImage result = new BufferedImage(w, h, 6);
            result.setRGB(0, 0, w, h, pixels, 0, w);
            return result;
        }
        return image;
    }

    public static double inchToMM(double value) {
        return value * 25.4;
    }

    public static double mmToInch(double value) {
        return value / 25.4;
    }

    public static int inchToPT(double value) {
        return (int)Math.round(value * 72.0);
    }

    public static int convertInt(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(s.trim());
    }

    public static double convertAngle(double rad) {
        double result = -rad * 180.0 / Math.PI;
        if ((result = SchemeEngine.NormAngle(result)) >= 360.0) {
            result -= 360.0;
        }
        return result;
    }

    public static boolean isRect(BaseGraphic.RealPoints points, BaseGraphic.RealPoint size) {
        boolean result = false;
        if (points == null || size == null || points.size() != 5) {
            return result;
        }
        double SizeTolerance = 0.001;
        double dx1 = ((BaseGraphic.RealPoint)points.get((int)0)).X - ((BaseGraphic.RealPoint)points.get((int)2)).X;
        double dy1 = ((BaseGraphic.RealPoint)points.get((int)0)).Y - ((BaseGraphic.RealPoint)points.get((int)2)).Y;
        double dx2 = ((BaseGraphic.RealPoint)points.get((int)1)).X - ((BaseGraphic.RealPoint)points.get((int)3)).X;
        double dy2 = ((BaseGraphic.RealPoint)points.get((int)1)).Y - ((BaseGraphic.RealPoint)points.get((int)3)).Y;
        double d1 = dx1 * dx1 + dy1 * dy1;
        double d2 = dx2 * dx2 + dy2 * dy2;
        double s = SizeTolerance * d1;
        boolean bl = result = Math.abs(d1 - d2) < s * s;
        if (result) {
            dx1 = ((BaseGraphic.RealPoint)points.get((int)0)).X - ((BaseGraphic.RealPoint)points.get((int)1)).X;
            dy1 = ((BaseGraphic.RealPoint)points.get((int)0)).Y - ((BaseGraphic.RealPoint)points.get((int)1)).Y;
            dx2 = ((BaseGraphic.RealPoint)points.get((int)0)).X - ((BaseGraphic.RealPoint)points.get((int)3)).X;
            dy2 = ((BaseGraphic.RealPoint)points.get((int)0)).Y - ((BaseGraphic.RealPoint)points.get((int)3)).Y;
            double calcSizeX = Math.sqrt(dx1 * dx1 + dy1 * dy1);
            double calcSizeY = Math.sqrt(dx2 * dx2 + dy2 * dy2);
            result = Math.abs(calcSizeX - size.X) < SizeTolerance * size.X && Math.abs(calcSizeY - size.Y) < SizeTolerance * size.Y || Math.abs(calcSizeY - size.X) < SizeTolerance * size.X && Math.abs(calcSizeX - size.Y) < SizeTolerance * size.Y;
        }
        return result;
    }

    private static void addGPOnBlock(GraphicBlock topBlock, GraphicBlock currBlock, AffineTransform TM) {
        int cnt;
        assert (currBlock != null && topBlock != null && TM != null);
        AffineTransform lTM = SchemeEngine.GenTransform(currBlock);
        if (currBlock.equals(topBlock)) {
            lTM.setToIdentity();
        } else {
            lTM.concatenate(TM);
        }
        int n = cnt = currBlock.Objects == null ? 0 : currBlock.Objects.size();
        for (int i = 0; i < cnt; ++i) {
            int cntj;
            BaseGraphic child = currBlock.Objects.get(i);
            assert (child != null);
            AffineTransform lTM1 = SchemeEngine.GenTransform(child);
            lTM1.concatenate(lTM);
            double[] lPt = new double[2];
            int n2 = cntj = child.GluePoints == null ? 0 : child.GluePoints.size();
            for (int j = 0; j < cntj; ++j) {
                int gluePointsCount;
                BaseGraphic.GluePoint point = child.GluePoints.get(j);
                assert (point != null);
                lPt[0] = point.ptX;
                lPt[1] = point.ptY;
                lPt = SchemeEngine.MulPointsTM(lTM1, lPt);
                topBlock.addGluePoint(lPt[0], lPt[1]);
                int n3 = gluePointsCount = topBlock.GluePoints == null ? 0 : topBlock.GluePoints.size();
                if (gluePointsCount <= 0) continue;
                BaseGraphic.GluePoint topBlockPoint = (BaseGraphic.GluePoint)topBlock.GluePoints.get(gluePointsCount - 1);
                BaseGraphic.GluePoint currBlockPoint = child.GluePoints.get(j);
                topBlockPoint.contactNumber = currBlockPoint.contactNumber;
                topBlockPoint.flags = currBlockPoint.flags;
            }
            if (!(child instanceof GraphicBlock)) continue;
            SchemeUtils.addGPOnBlock(topBlock, (GraphicBlock)child, lTM);
        }
    }

    public static void liftGluePoints(GraphicBlock block) {
        BaseGraphic child0;
        if (block == null || block.Objects == null || block.Objects.isEmpty()) {
            return;
        }
        boolean isUnGroup = false;
        if (!(block instanceof GraphicInsert) && block.Objects.size() == 1 && (child0 = block.Objects.get(0)) != null && child0.GluePoints != null && child0.GluePoints.size() > 0 && (child0.getClass().equals(Polyline.class) || child0.getClass().equals(Spline.class))) {
            isUnGroup = true;
        }
        if (!isUnGroup) {
            AffineTransform tm = SchemeEngine.GenTransform(block);
            tm.setToIdentity();
            SchemeUtils.addGPOnBlock(block, block, tm);
        }
    }

    public static double calcAngle(double dx, double dy) {
        if (dx == 0.0) {
            return 1.5707963267948966 + (dy > 0.0 ? 0.0 : Math.PI);
        }
        double result = Math.atan(dy / dx);
        if (dx < 0.0) {
            result += Math.PI;
        } else if (dy < 0.0 && result < 0.0) {
            result = Math.PI * 2 + result;
        }
        return result;
    }

    public static double mag2d(BaseGraphic.RealPoint pt1, BaseGraphic.RealPoint pt2) {
        double dx = Math.abs(pt2.X - pt1.X);
        double dy = Math.abs(pt2.Y - pt1.Y);
        if (dx == 0.0) {
            return dy;
        }
        if (dy == 0.0) {
            return dx;
        }
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static double infanityPtLineMag2D(BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2, BaseGraphic.RealPoint p) {
        double A = p2.Y - p1.Y;
        double B = p1.X - p2.X;
        if (A == 0.0 && B == 0.0) {
            return Double.MAX_VALUE;
        }
        double C = p2.X * p1.Y - p1.X * p2.Y;
        return Math.abs((A * p.X + B * p.Y + C) / Math.sqrt(A * A + B * B));
    }

    public static boolean isPointOnLine(double x1, double y1, double x2, double y2, double x, double y) {
        double tol = 0.001;
        if (SchemeUtils.isEqual(x1, x, tol) && SchemeUtils.isEqual(y1, y, tol)) {
            return true;
        }
        if (SchemeUtils.isEqual(x2, x, tol) && SchemeUtils.isEqual(y2, y, tol)) {
            return true;
        }
        if (SchemeUtils.isEqual(x1, x2, tol) && SchemeUtils.isEqual(y1, y2, tol)) {
            return SchemeUtils.isEqual(x1, x, tol) && SchemeUtils.isEqual(y1, y, tol);
        }
        if (!SchemeUtils.isEqual((x - x1) * (y2 - y1) - (y - y1) * (x2 - x1), 0.0, tol)) {
            return false;
        }
        return SchemeUtils.isEqualOrMore(x, x1, tol) && SchemeUtils.isEqualOrMore(x2, x, tol) || SchemeUtils.isEqualOrMore(x, x2, tol) && SchemeUtils.isEqualOrMore(x1, x, tol);
    }

    public static boolean checkEllipseOnLine(BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2, BaseGraphic.RealPoint p3) {
        double r1 = SchemeUtils.infanityPtLineMag2D(p2, p3, p1);
        if (r1 > 1.0E-6) {
            return false;
        }
        double r2 = SchemeUtils.infanityPtLineMag2D(p1, p3, p2);
        if (r2 > 1.0E-6) {
            return false;
        }
        double r3 = SchemeUtils.infanityPtLineMag2D(p1, p2, p3);
        return r3 < 1.0E-6;
    }

    private static boolean checkReverse(BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2, BaseGraphic.RealPoint controlPoint) {
        double angle1 = SchemeUtils.calcAngle(controlPoint.X - p1.X, controlPoint.Y - p1.Y);
        double angle2 = SchemeUtils.calcAngle(p2.X - p1.X, p2.Y - p1.Y);
        if (angle1 == 0.0 || angle2 == 0.0) {
            angle2 = SchemeUtils.calcAngle(controlPoint.X - p2.X, controlPoint.Y - p2.Y);
            angle1 = SchemeUtils.calcAngle(p1.X - p2.X, p1.Y - p2.Y);
        }
        angle1 -= angle2;
        while (angle1 < 0.0) {
            angle1 += Math.PI * 2;
        }
        while (angle1 >= Math.PI * 2) {
            angle1 -= Math.PI * 2;
        }
        return angle1 <= Math.PI;
    }

    public static BaseGraphic.RealPoints removeDuplicatePoints(BaseGraphic.RealPoints src) {
        if (src == null || src.isEmpty()) {
            return src;
        }
        BaseGraphic.RealPoints dest = new BaseGraphic.RealPoints();
        BaseGraphic.RealPoint lastP = new BaseGraphic.RealPoint((BaseGraphic.RealPoint)src.get(0));
        dest.add(lastP);
        int cnt = src.size();
        for (int i = 1; i < cnt; ++i) {
            BaseGraphic.RealPoint p = (BaseGraphic.RealPoint)src.get(i);
            if (SchemeUtils.isEqual(lastP, p)) continue;
            lastP = new BaseGraphic.RealPoint(p);
            dest.add(lastP);
        }
        return dest;
    }

    public static boolean calcCircle(BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2, double a, BaseGraphic.RealPoint center) {
        if (Math.abs(a) <= BaseGraphic.FloatTolerance) {
            return false;
        }
        double x1 = p1.X;
        double y1 = p1.Y;
        double x2 = p2.X;
        double y2 = p2.Y;
        double dx = (x2 - x1) / 2.0;
        double dy = (y2 - y1) / 2.0;
        double angle = SchemeUtils.calcAngle(dx, dy);
        dx += x1;
        dy += y1;
        if ((angle += 1.5707963267948966) < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle >= Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        double x3 = dx - a * Math.cos(angle);
        double y3 = dy - a * Math.sin(angle);
        double A = x2 - x1;
        double B = y2 - y1;
        double C = x3 - x1;
        double D = y3 - y1;
        double E = A * (x1 + x2) + B * (y1 + y2);
        double F = C * (x1 + x3) + D * (y1 + y3);
        double G = 2.0 * (A * (y3 - y2) - B * (x3 - x2));
        if (G == 0.0) {
            return false;
        }
        center.X = (D * E - B * F) / G;
        center.Y = (A * F - C * E) / G;
        return true;
    }

    public static boolean calcEllipse(BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2, BaseGraphic.RealPoint p3, double d, double angle, BaseGraphic.RealPoint center, BaseGraphic.RealPoint radius) {
        double x1 = p1.X;
        double y1 = p1.Y;
        double x2 = p2.X;
        double y2 = p2.Y;
        double x3 = p3.X;
        double y3 = p3.Y;
        double C = Math.cos(angle);
        double S = Math.sin(angle);
        double A = C * C + d * d * S * S;
        double B = 2.0 * C * S - 2.0 * d * d * C * S;
        double E = S * S + d * d * C * C;
        double a11 = 2.0 * A * (x2 - x1) + B * (y2 - y1);
        double a21 = 2.0 * A * (x2 - x3) + B * (y2 - y3);
        double a12 = B * (x2 - x1) + 2.0 * E * (y2 - y1);
        double a22 = B * (x2 - x3) + 2.0 * E * (y2 - y3);
        double b1 = A * (x2 * x2 - x1 * x1) + B * (x2 * y2 - x1 * y1) + E * (y2 * y2 - y1 * y1);
        double b2 = A * (x2 * x2 - x3 * x3) + B * (x2 * y2 - x3 * y3) + E * (y2 * y2 - y3 * y3);
        double d0 = a11 * a22 - a12 * a21;
        if (SchemeUtils.isEqual(d0, 0.0)) {
            return false;
        }
        double dx = b1 * a22 - b2 * a12;
        double dy = a11 * b2 - b1 * a21;
        double cx = dx / d0;
        double cy = dy / d0;
        center.X = cx;
        center.Y = cy;
        double xx = x1 - cx;
        double yy = y1 - cy;
        if (d == 0.0) {
            return false;
        }
        double b = Math.sqrt(A * xx * xx + B * xx * yy + E * yy * yy) / d;
        radius.X = b * d;
        radius.Y = b;
        return true;
    }

    public static BaseGraphic.RealPoints sidesToEllipse(double sidesX, double sidesY, int slices) {
        if (slices <= 0) {
            slices = 10;
        }
        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
        double sliceAngle = Math.PI * 2 / (double)slices;
        sidesX = Math.abs(sidesX / 2.0);
        sidesY = Math.abs(sidesY / 2.0);
        double Axe = Math.max(sidesX, sidesY);
        if (sidesX > BaseGraphic.FloatTolerance && sidesY > BaseGraphic.FloatTolerance) {
            double lDx;
            double lDy;
            if (sidesX > sidesY) {
                lDy = sidesY / sidesX;
                lDx = 1.0;
            } else {
                lDx = sidesX / sidesY;
                lDy = 1.0;
            }
            for (int i = 0; i < slices; ++i) {
                double x = Axe * Math.cos(sliceAngle * (double)i);
                double y = Axe * Math.sin(sliceAngle * (double)i);
                result.add(new BaseGraphic.RealPoint(x * lDx, y * lDy));
            }
        } else {
            for (int i = 0; i < slices; ++i) {
                double x = 0.0;
                double y = 0.0;
                if (sidesY > BaseGraphic.FloatTolerance) {
                    x = 0.0;
                    y = i == slices - 1 ? sidesY : -sidesY + (double)(i * 2) * sidesY / (double)slices;
                } else if (sidesX > BaseGraphic.FloatTolerance) {
                    x = i == slices - 1 ? sidesX : -sidesX + (double)(i * 2) * sidesX / (double)slices;
                    y = 0.0;
                }
                result.add(new BaseGraphic.RealPoint(x, y));
            }
        }
        return result;
    }

    public static BaseGraphic.RealPoints sidesToQuadBezArc(BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2, BaseGraphic.RealPoint p3, int sides) {
        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
        if (SchemeUtils.isEqual(p1, p2)) {
            return result;
        }
        assert (p1 != null);
        assert (p2 != null);
        assert (p3 != null);
        if (sides < 10) {
            sides = 10;
        }
        double x1 = p1.X;
        double y1 = p1.Y;
        double x2 = p2.X;
        double y2 = p2.Y;
        double x3 = p3.X;
        double y3 = p3.Y;
        double dt = 1.0 / (double)sides;
        double t = 0.0;
        for (int i = 0; i < sides; ++i) {
            double k = 1.0 - t;
            double x = k * k * x1 + 2.0 * k * t * x2 + t * t * x3;
            double y = k * k * y1 + 2.0 * k * t * y2 + t * t * y3;
            result.add(new BaseGraphic.RealPoint(x, y));
            t += dt;
        }
        if (result.isEmpty()) {
            return result;
        }
        BaseGraphic.RealPoint p = (BaseGraphic.RealPoint)result.get(0);
        if (!SchemeUtils.isEqual(p, p1)) {
            result.add(0, p1);
        }
        if (!SchemeUtils.isEqual(p = (BaseGraphic.RealPoint)result.get(result.size() - 1), p3)) {
            result.add(p3);
        }
        return result;
    }

    public static BaseGraphic.RealPoints sidesToCubeBezArc(BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2, BaseGraphic.RealPoint p3, BaseGraphic.RealPoint p4, int sides) {
        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
        assert (p1 != null);
        assert (p2 != null);
        assert (p3 != null);
        assert (p4 != null);
        if (sides < 12) {
            sides = 12;
        }
        double x1 = p1.X;
        double y1 = p1.Y;
        double x2 = p2.X;
        double y2 = p2.Y;
        double x3 = p3.X;
        double y3 = p3.Y;
        double x4 = p4.X;
        double y4 = p4.Y;
        double dt = 1.0 / (double)sides;
        double t = 0.0;
        for (int i = 0; i < sides; ++i) {
            double k = 1.0 - t;
            double x = k * k * k * x1 + 3.0 * k * k * t * x2 + 3.0 * k * t * t * x3 + t * t * t * x4;
            double y = k * k * k * y1 + 3.0 * k * k * t * y2 + 3.0 * k * t * t * y3 + t * t * t * y4;
            result.add(new BaseGraphic.RealPoint(x, y));
            t += dt;
        }
        if (result.isEmpty()) {
            return result;
        }
        BaseGraphic.RealPoint p = (BaseGraphic.RealPoint)result.get(0);
        if (!SchemeUtils.isEqual(p, p1)) {
            result.add(0, p1);
        }
        if (!SchemeUtils.isEqual(p = (BaseGraphic.RealPoint)result.get(result.size() - 1), p4)) {
            result.add(p4);
        }
        return result;
    }

    public static BaseGraphic.RealPoints sidesToEllipseArc(BaseGraphic.RealPoint center, BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2, BaseGraphic.RealPoint controlPoint, BaseGraphic.RealPoint raduis, double angle, int slices) {
        int cnt;
        boolean flag;
        if (slices <= 0) {
            slices = 10;
        }
        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
        BaseGraphic.RealPoints sidesToEllipse = SchemeUtils.sidesToEllipse(raduis.X * 2.0, raduis.Y * 2.0, slices);
        if (sidesToEllipse.isEmpty()) {
            return result;
        }
        sidesToEllipse.add(new BaseGraphic.RealPoint((BaseGraphic.RealPoint)sidesToEllipse.get(0)));
        boolean reverse = SchemeUtils.checkReverse(p1, p2, controlPoint);
        double angle1 = SchemeUtils.calcAngle(p1.X - center.X, p1.Y - center.Y) - angle;
        double angle2 = SchemeUtils.calcAngle(p2.X - center.X, p2.Y - center.Y) - angle;
        if (angle1 < 0.0) {
            angle1 += Math.PI * 2;
        }
        if (angle2 < 0.0) {
            angle2 += Math.PI * 2;
        }
        if (angle1 >= Math.PI * 2) {
            angle1 -= Math.PI * 2;
        }
        if (angle2 >= Math.PI * 2) {
            angle2 -= Math.PI * 2;
        }
        if (reverse) {
            double t;
            BaseGraphic.RealPoint p3;
            int i;
            if (angle1 == 0.0) {
                angle1 = Math.PI * 2;
            }
            flag = angle1 < angle2;
            Collections.reverse(sidesToEllipse);
            cnt = sidesToEllipse.size();
            for (i = 0; i < cnt; ++i) {
                p3 = (BaseGraphic.RealPoint)sidesToEllipse.get(i);
                double d = t = i == 0 ? Math.PI * 2 : SchemeUtils.calcAngle(p3.X, p3.Y);
                if (t > angle1) continue;
                if (!flag && t < angle2) break;
                result.add(new BaseGraphic.RealPoint(p3.X, p3.Y));
            }
            if (flag) {
                cnt = sidesToEllipse.size();
                for (i = 0; i < cnt; ++i) {
                    p3 = (BaseGraphic.RealPoint)sidesToEllipse.get(i);
                    double d = t = i == 0 ? Math.PI * 2 : SchemeUtils.calcAngle(p3.X, p3.Y);
                    if (!(t < angle2)) {
                        result.add(new BaseGraphic.RealPoint(p3.X, p3.Y));
                        continue;
                    }
                    break;
                }
            }
        } else {
            double t;
            BaseGraphic.RealPoint p4;
            int i;
            if (angle2 == 0.0) {
                angle2 = Math.PI * 2;
            }
            flag = angle1 > angle2;
            cnt = sidesToEllipse.size();
            int last = cnt - 1;
            for (i = 0; i < cnt; ++i) {
                p4 = (BaseGraphic.RealPoint)sidesToEllipse.get(i);
                double d = t = i == last ? Math.PI * 2 : SchemeUtils.calcAngle(p4.X, p4.Y);
                if (t < angle1) continue;
                if (!flag && t > angle2) break;
                result.add(new BaseGraphic.RealPoint(p4.X, p4.Y));
            }
            if (flag) {
                cnt = sidesToEllipse.size();
                last = cnt - 1;
                for (i = 0; i < cnt; ++i) {
                    p4 = (BaseGraphic.RealPoint)sidesToEllipse.get(i);
                    double d = t = i == last ? Math.PI * 2 : SchemeUtils.calcAngle(p4.X, p4.Y);
                    if (!(t > angle2)) {
                        result.add(new BaseGraphic.RealPoint(p4.X, p4.Y));
                        continue;
                    }
                    break;
                }
            }
        }
        if (!result.isEmpty()) {
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            result.forEach(p -> {
                double dx = p.X;
                double dy = p.Y;
                if (angle != 0.0) {
                    p.X = dx * cos - dy * sin;
                    p.Y = dx * sin + dy * cos;
                }
                p.X += center.X;
                p.Y += center.Y;
            });
            BaseGraphic.RealPoint p5 = (BaseGraphic.RealPoint)result.get(0);
            if (!SchemeUtils.isEqual(p1, p5)) {
                result.add(0, p1);
            }
            if (!SchemeUtils.isEqual(p2, p5 = (BaseGraphic.RealPoint)result.get(result.size() - 1))) {
                result.add(p2);
            }
        }
        return result;
    }

    public static BaseGraphic.RealPoints sidesToArc(BaseGraphic.RealPoint center, BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2, boolean reverse, int slices) {
        double arcLen;
        if (slices <= 0) {
            slices = 10;
        }
        BaseGraphic.RealPoints result = new BaseGraphic.RealPoints();
        double dx1 = p1.X - center.X;
        double dy1 = p1.Y - center.Y;
        double angle1 = SchemeUtils.calcAngle(dx1, dy1);
        double angle2 = SchemeUtils.calcAngle(p2.X - center.X, p2.Y - center.Y);
        double R = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double sliceAngle = Math.PI * 2 / (double)slices;
        double d = arcLen = reverse ? angle1 - angle2 : angle2 - angle1;
        if (arcLen < 0.0) {
            arcLen += Math.PI * 2;
        }
        int cntSlices = (int)(arcLen / sliceAngle);
        if (arcLen % sliceAngle != 0.0) {
            ++cntSlices;
        }
        if (cntSlices == 0) {
            return result;
        }
        sliceAngle = arcLen / (double)cntSlices;
        if (reverse) {
            sliceAngle = -sliceAngle;
        }
        result.add(p1);
        double angle = angle1;
        for (int i = 0; i < cntSlices; ++i) {
            double x = R * Math.cos(angle += sliceAngle);
            double y = R * Math.sin(angle);
            result.add(new BaseGraphic.RealPoint(x + center.X, y + center.Y));
        }
        BaseGraphic.RealPoint p = (BaseGraphic.RealPoint)result.get(result.size() - 1);
        if (!SchemeUtils.isEqual(p, p2)) {
            result.add(p2);
        }
        return result;
    }

    public static double distance(BaseGraphic.RealPoint p1, BaseGraphic.RealPoint p2) {
        assert (p1 != null);
        assert (p2 != null);
        return SchemeUtils.distance(p1.X, p1.Y, p2.X, p2.Y);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static BaseGraphic.RealPoint rotatePoint(double x, double y, double angle) {
        double rad = Math.toRadians(angle);
        double sin = Math.sin(rad);
        double cos = Math.cos(rad);
        return new BaseGraphic.RealPoint(x * cos - y * sin, x * sin + y * cos);
    }

    public static double shiftSkew(double v, double angle) {
        if (SchemeUtils.isEqual(angle, 0.0)) {
            return 0.0;
        }
        double rad = Math.toRadians(angle);
        double tan = Math.tan(rad);
        if (Double.isInfinite(tan) || Double.isNaN(tan)) {
            return 0.0;
        }
        return v * tan;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isEqual(double v1, double v2) {
        return Math.abs(v1 - v2) <= BaseGraphic.FloatTolerance;
    }

    public static boolean isEqual(double v1, double v2, double tolerance) {
        return Math.abs(v1 - v2) <= tolerance;
    }

    public static boolean isEqualOrMore(double v1, double v2, double tolerance) {
        return Math.abs(v1 - v2) <= tolerance || v1 > v2;
    }

    public static boolean isEqual(BaseGraphic.RealPoint v1, BaseGraphic.RealPoint v2) {
        return SchemeUtils.isEqual(v1, v2, BaseGraphic.FloatTolerance);
    }

    public static boolean isEqual(BaseGraphic.RealPoint v1, BaseGraphic.RealPoint v2, double tolerance) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return SchemeUtils.isEqual(v1.X, v2.X, tolerance) && SchemeUtils.isEqual(v1.Y, v2.Y, tolerance);
    }

    public static boolean isEqual(String v1, String v2) {
        if (v1 == null || v1.isEmpty()) {
            return v2 == null || v2.isEmpty();
        }
        return v1.equals(v2);
    }

    public static boolean isEqual(Color c1, Color c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        return c1.getRGB() == c2.getRGB();
    }

    public static boolean isEqualAsDouble(String v1, String v2) {
        if (v1 == null || v1.isEmpty()) {
            return v2 == null || v2.isEmpty();
        }
        return SchemeUtils.isEqual(VsdxUtils.convertDouble(v1, null), VsdxUtils.convertDouble(v2, null));
    }

    public static Element getFirstElement(NodeList nodes) {
        if (nodes == null) {
            return null;
        }
        int cnt = nodes.getLength();
        for (int i = 0; i < cnt; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> getStrings(String text) {
        if (text == null) {
            return new ArrayList<String>();
        }
        try (StringReader textReader = new StringReader(text);){
            List<String> list;
            try (BufferedReader reader = new BufferedReader(textReader);){
                list = reader.lines().collect(Collectors.toList());
            }
            return list;
        }
        catch (IOException ex) {
            Core.logger.error("getStrings() error", ex);
            return new ArrayList<String>();
        }
    }

    public static String correctText(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder correctedText = new StringBuilder();
        for (char symbol : text.toCharArray()) {
            if (symbol == '\u2028') {
                correctedText.append('\n');
                continue;
            }
            correctedText.append(symbol);
        }
        return correctedText.toString();
    }

    public static ByteArrayOutputStream cropImage(byte[] imageData, Image image, String format) throws IOException {
        BufferedImage bi = SchemeUtils.createImageFromBytes(imageData);
        int left = (int)((double)bi.getWidth() * image.LeftCropPercentage);
        int right = (int)((double)bi.getWidth() * image.RightCropPercentage);
        int top = (int)((double)bi.getHeight() * image.TopCropPercentage);
        int bottom = (int)((double)bi.getHeight() * image.BottomCropPercentage);
        int width = bi.getWidth() - (left + right);
        int height = bi.getHeight() - (top + bottom);
        BufferedImage sub = bi.getSubimage(left, top, width, height);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)sub, format, baos);
        return baos;
    }

    public static ByteArrayOutputStream adjustBrightnessContrast(byte[] imageData, PhxImage image, String format) throws IOException {
        float brightness = (float)(image.Brightness - 50.0) / 50.0f;
        float contrast = (float)(image.Contrast / 50.0);
        float contrastFactor = (float)Math.tan((double)contrast * Math.PI / 4.0);
        float brightnessOffset = brightness * 255.0f;
        BufferedImage src = SchemeUtils.createImageFromBytes(imageData);
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                int rgb = src.getRGB(x, y);
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                r = (int)(128.0f + contrastFactor * (float)(r - 128));
                g = (int)(128.0f + contrastFactor * (float)(g - 128));
                b = (int)(128.0f + contrastFactor * (float)(b - 128));
                r = (int)((float)r + brightnessOffset);
                g = (int)((float)g + brightnessOffset);
                b = (int)((float)b + brightnessOffset);
                r = Math.max(0, Math.min(255, r));
                g = Math.max(0, Math.min(255, g));
                b = Math.max(0, Math.min(255, b));
                int newRgb = a << 24 | r << 16 | g << 8 | b;
                dest.setRGB(x, y, newRgb);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)dest, format, baos);
        return baos;
    }

    public static ByteArrayOutputStream adjustGamma(byte[] imageData, PhxImage image, String format) throws IOException {
        BufferedImage src = SchemeUtils.createImageFromBytes(imageData);
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        WritableRaster srcRaster = src.getRaster();
        WritableRaster destRaster = dest.getRaster();
        int[] gammaLUT = new int[256];
        for (int i = 0; i < 256; ++i) {
            double normalized = (double)i / 255.0;
            double corrected = Math.pow(normalized, 1.0 / image.Gamma);
            gammaLUT[i] = (int)Math.round(corrected * 255.0);
            if (gammaLUT[i] < 0) {
                gammaLUT[i] = 0;
            }
            if (gammaLUT[i] <= 255) continue;
            gammaLUT[i] = 255;
        }
        int[] pixel = new int[srcRaster.getNumBands()];
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                srcRaster.getPixel(x, y, pixel);
                for (int b = 0; b < pixel.length; ++b) {
                    pixel[b] = gammaLUT[pixel[b]];
                }
                destRaster.setPixel(x, y, pixel);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)dest, format, baos);
        return baos;
    }

    private static BufferedImage createImageFromBytes(byte[] imageData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
        try {
            return ImageIO.read(bais);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasCrop(Image image) {
        return image.BottomCropPercentage != 0.0 || image.LeftCropPercentage != 0.0 || image.RightCropPercentage != 0.0 || image.TopCropPercentage != 0.0;
    }

    public static boolean hasBrightnessContrast(Image image) {
        if (image instanceof PhxImage) {
            PhxImage phxImage = (PhxImage)image;
            return phxImage.Brightness != 50.0 || phxImage.Contrast != 50.0;
        }
        return false;
    }

    public static boolean hasGamma(Image image) {
        if (image instanceof PhxImage) {
            PhxImage phxImage = (PhxImage)image;
            return phxImage.Gamma != 1.0;
        }
        return false;
    }

    public static double lineToAngle(BaseGraphic.RealPoint pt1, BaseGraphic.RealPoint pt2) {
        if (pt1.X == pt2.X && pt1.Y <= pt2.Y) {
            return 0.0;
        }
        if (pt1.X == pt2.X && pt1.Y > pt2.Y) {
            return 180.0;
        }
        if (pt1.Y == pt2.Y && pt1.X < pt2.X) {
            return 90.0;
        }
        if (pt1.Y == pt2.Y && pt1.X > pt2.X) {
            return 270.0;
        }
        double res = Math.atan((pt2.X - pt1.X) / (pt2.Y - pt1.Y)) / Math.PI * 180.0;
        if (pt1.Y > pt2.Y && pt1.X > pt2.X) {
            res += 180.0;
        } else if (pt1.Y > pt2.Y && pt1.X < pt2.X) {
            res -= 180.0;
        }
        return res;
    }

    public static BaseGraphic.RealPoint getMinPts(double[] points) {
        BaseGraphic.RealPoint realPoint = new BaseGraphic.RealPoint(2.147483647E9, 2.147483647E9);
        for (int i = 0; i < points.length - 1; i += 2) {
            if (realPoint.X >= points[i]) {
                realPoint.X = points[i];
            }
            if (!(realPoint.Y >= points[i + 1])) continue;
            realPoint.Y = points[i + 1];
        }
        return realPoint;
    }

    public static BaseGraphic.RealRect getMinMaxPts(double[] points) {
        BaseGraphic.RealPoint minPoint = new BaseGraphic.RealPoint(Double.MAX_VALUE, Double.MAX_VALUE);
        BaseGraphic.RealPoint maxPoint = new BaseGraphic.RealPoint(Double.MIN_VALUE, Double.MIN_VALUE);
        for (int i = 0; i < points.length - 1; i += 2) {
            if (minPoint.X >= points[i]) {
                minPoint.X = points[i];
            }
            if (minPoint.Y >= points[i + 1]) {
                minPoint.Y = points[i + 1];
            }
            if (maxPoint.X <= points[i]) {
                maxPoint.X = points[i];
            }
            if (!(maxPoint.Y <= points[i + 1])) continue;
            maxPoint.Y = points[i + 1];
        }
        BaseGraphic.RealRect rect = new BaseGraphic.RealRect();
        rect.Left = minPoint.X;
        rect.Right = maxPoint.X;
        rect.Top = minPoint.Y;
        rect.Bottom = maxPoint.Y;
        return rect;
    }

    public static boolean isShapeInheritingThemeIdx(String idx) {
        return idx == null || "65534".equals(idx);
    }

    public static Color getColorFromInt(int color) {
        int RED_BITS = 255;
        int GREEN_BITS = 65280;
        int BLUE_BITS = 0xFF0000;
        int ALPHA_BITS = -16777216;
        int r = color & 0xFF;
        int g = (color & 0xFF00) >> 8;
        int b = (color & 0xFF0000) >> 16;
        int a = (color & 0xFF000000) >> 24;
        return new Color(r, g, b, a);
    }

    public static class Colors {
        public static final Color NONE = SchemeUtils.getColorFromInt(0x1FFFFFFF);
        public static final Color WHITE = SchemeUtils.getColorFromInt(0xFFFFFF);
        public static final Color BLACK = SchemeUtils.getColorFromInt(0);
    }
}

